/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request object with information to create a contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactDataRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactDataRequest.Builder, ContactDataRequest> {
    private static final SdkField<Endpoint> SYSTEM_ENDPOINT_FIELD = SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
            .memberName("SystemEndpoint").getter(getter(ContactDataRequest::systemEndpoint))
            .setter(setter(Builder::systemEndpoint)).constructor(Endpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SystemEndpoint").build()).build();

    private static final SdkField<Endpoint> CUSTOMER_ENDPOINT_FIELD = SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
            .memberName("CustomerEndpoint").getter(getter(ContactDataRequest::customerEndpoint))
            .setter(setter(Builder::customerEndpoint)).constructor(Endpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerEndpoint").build()).build();

    private static final SdkField<String> REQUEST_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestIdentifier").getter(getter(ContactDataRequest::requestIdentifier))
            .setter(setter(Builder::requestIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestIdentifier").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueueId").getter(getter(ContactDataRequest::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueId").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(ContactDataRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Campaign> CAMPAIGN_FIELD = SdkField.<Campaign> builder(MarshallingType.SDK_POJO)
            .memberName("Campaign").getter(getter(ContactDataRequest::campaign)).setter(setter(Builder::campaign))
            .constructor(Campaign::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Campaign").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYSTEM_ENDPOINT_FIELD,
            CUSTOMER_ENDPOINT_FIELD, REQUEST_IDENTIFIER_FIELD, QUEUE_ID_FIELD, ATTRIBUTES_FIELD, CAMPAIGN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Endpoint systemEndpoint;

    private final Endpoint customerEndpoint;

    private final String requestIdentifier;

    private final String queueId;

    private final Map<String, String> attributes;

    private final Campaign campaign;

    private ContactDataRequest(BuilderImpl builder) {
        this.systemEndpoint = builder.systemEndpoint;
        this.customerEndpoint = builder.customerEndpoint;
        this.requestIdentifier = builder.requestIdentifier;
        this.queueId = builder.queueId;
        this.attributes = builder.attributes;
        this.campaign = builder.campaign;
    }

    /**
     * <p>
     * Endpoint associated with the Amazon Connect instance from which outbound contact will be initiated for the
     * campaign.
     * </p>
     * 
     * @return Endpoint associated with the Amazon Connect instance from which outbound contact will be initiated for
     *         the campaign.
     */
    public final Endpoint systemEndpoint() {
        return systemEndpoint;
    }

    /**
     * <p>
     * Endpoint of the customer for which contact will be initiated.
     * </p>
     * 
     * @return Endpoint of the customer for which contact will be initiated.
     */
    public final Endpoint customerEndpoint() {
        return customerEndpoint;
    }

    /**
     * <p>
     * Identifier to uniquely identify individual requests in the batch.
     * </p>
     * 
     * @return Identifier to uniquely identify individual requests in the batch.
     */
    public final String requestIdentifier() {
        return requestIdentifier;
    }

    /**
     * <p>
     * The identifier of the queue associated with the Amazon Connect instance in which contacts that are created will
     * be queued.
     * </p>
     * 
     * @return The identifier of the queue associated with the Amazon Connect instance in which contacts that are
     *         created will be queued.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * List of attributes to be stored in a contact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return List of attributes to be stored in a contact.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * Structure to store information associated with a campaign.
     * </p>
     * 
     * @return Structure to store information associated with a campaign.
     */
    public final Campaign campaign() {
        return campaign;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(systemEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(customerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(requestIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(campaign());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactDataRequest)) {
            return false;
        }
        ContactDataRequest other = (ContactDataRequest) obj;
        return Objects.equals(systemEndpoint(), other.systemEndpoint())
                && Objects.equals(customerEndpoint(), other.customerEndpoint())
                && Objects.equals(requestIdentifier(), other.requestIdentifier()) && Objects.equals(queueId(), other.queueId())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && Objects.equals(campaign(), other.campaign());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactDataRequest").add("SystemEndpoint", systemEndpoint())
                .add("CustomerEndpoint", customerEndpoint()).add("RequestIdentifier", requestIdentifier())
                .add("QueueId", queueId()).add("Attributes", hasAttributes() ? attributes() : null).add("Campaign", campaign())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SystemEndpoint":
            return Optional.ofNullable(clazz.cast(systemEndpoint()));
        case "CustomerEndpoint":
            return Optional.ofNullable(clazz.cast(customerEndpoint()));
        case "RequestIdentifier":
            return Optional.ofNullable(clazz.cast(requestIdentifier()));
        case "QueueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "Campaign":
            return Optional.ofNullable(clazz.cast(campaign()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SystemEndpoint", SYSTEM_ENDPOINT_FIELD);
        map.put("CustomerEndpoint", CUSTOMER_ENDPOINT_FIELD);
        map.put("RequestIdentifier", REQUEST_IDENTIFIER_FIELD);
        map.put("QueueId", QUEUE_ID_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("Campaign", CAMPAIGN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactDataRequest, T> g) {
        return obj -> g.apply((ContactDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactDataRequest> {
        /**
         * <p>
         * Endpoint associated with the Amazon Connect instance from which outbound contact will be initiated for the
         * campaign.
         * </p>
         * 
         * @param systemEndpoint
         *        Endpoint associated with the Amazon Connect instance from which outbound contact will be initiated for
         *        the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemEndpoint(Endpoint systemEndpoint);

        /**
         * <p>
         * Endpoint associated with the Amazon Connect instance from which outbound contact will be initiated for the
         * campaign.
         * </p>
         * This is a convenience method that creates an instance of the {@link Endpoint.Builder} avoiding the need to
         * create one manually via {@link Endpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Endpoint.Builder#build()} is called immediately and its result is
         * passed to {@link #systemEndpoint(Endpoint)}.
         * 
         * @param systemEndpoint
         *        a consumer that will call methods on {@link Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #systemEndpoint(Endpoint)
         */
        default Builder systemEndpoint(Consumer<Endpoint.Builder> systemEndpoint) {
            return systemEndpoint(Endpoint.builder().applyMutation(systemEndpoint).build());
        }

        /**
         * <p>
         * Endpoint of the customer for which contact will be initiated.
         * </p>
         * 
         * @param customerEndpoint
         *        Endpoint of the customer for which contact will be initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerEndpoint(Endpoint customerEndpoint);

        /**
         * <p>
         * Endpoint of the customer for which contact will be initiated.
         * </p>
         * This is a convenience method that creates an instance of the {@link Endpoint.Builder} avoiding the need to
         * create one manually via {@link Endpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Endpoint.Builder#build()} is called immediately and its result is
         * passed to {@link #customerEndpoint(Endpoint)}.
         * 
         * @param customerEndpoint
         *        a consumer that will call methods on {@link Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerEndpoint(Endpoint)
         */
        default Builder customerEndpoint(Consumer<Endpoint.Builder> customerEndpoint) {
            return customerEndpoint(Endpoint.builder().applyMutation(customerEndpoint).build());
        }

        /**
         * <p>
         * Identifier to uniquely identify individual requests in the batch.
         * </p>
         * 
         * @param requestIdentifier
         *        Identifier to uniquely identify individual requests in the batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestIdentifier(String requestIdentifier);

        /**
         * <p>
         * The identifier of the queue associated with the Amazon Connect instance in which contacts that are created
         * will be queued.
         * </p>
         * 
         * @param queueId
         *        The identifier of the queue associated with the Amazon Connect instance in which contacts that are
         *        created will be queued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * List of attributes to be stored in a contact.
         * </p>
         * 
         * @param attributes
         *        List of attributes to be stored in a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * Structure to store information associated with a campaign.
         * </p>
         * 
         * @param campaign
         *        Structure to store information associated with a campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaign(Campaign campaign);

        /**
         * <p>
         * Structure to store information associated with a campaign.
         * </p>
         * This is a convenience method that creates an instance of the {@link Campaign.Builder} avoiding the need to
         * create one manually via {@link Campaign#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Campaign.Builder#build()} is called immediately and its result is
         * passed to {@link #campaign(Campaign)}.
         * 
         * @param campaign
         *        a consumer that will call methods on {@link Campaign.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #campaign(Campaign)
         */
        default Builder campaign(Consumer<Campaign.Builder> campaign) {
            return campaign(Campaign.builder().applyMutation(campaign).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Endpoint systemEndpoint;

        private Endpoint customerEndpoint;

        private String requestIdentifier;

        private String queueId;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private Campaign campaign;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactDataRequest model) {
            systemEndpoint(model.systemEndpoint);
            customerEndpoint(model.customerEndpoint);
            requestIdentifier(model.requestIdentifier);
            queueId(model.queueId);
            attributes(model.attributes);
            campaign(model.campaign);
        }

        public final Endpoint.Builder getSystemEndpoint() {
            return systemEndpoint != null ? systemEndpoint.toBuilder() : null;
        }

        public final void setSystemEndpoint(Endpoint.BuilderImpl systemEndpoint) {
            this.systemEndpoint = systemEndpoint != null ? systemEndpoint.build() : null;
        }

        @Override
        public final Builder systemEndpoint(Endpoint systemEndpoint) {
            this.systemEndpoint = systemEndpoint;
            return this;
        }

        public final Endpoint.Builder getCustomerEndpoint() {
            return customerEndpoint != null ? customerEndpoint.toBuilder() : null;
        }

        public final void setCustomerEndpoint(Endpoint.BuilderImpl customerEndpoint) {
            this.customerEndpoint = customerEndpoint != null ? customerEndpoint.build() : null;
        }

        @Override
        public final Builder customerEndpoint(Endpoint customerEndpoint) {
            this.customerEndpoint = customerEndpoint;
            return this;
        }

        public final String getRequestIdentifier() {
            return requestIdentifier;
        }

        public final void setRequestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
        }

        @Override
        public final Builder requestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
            return this;
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final Campaign.Builder getCampaign() {
            return campaign != null ? campaign.toBuilder() : null;
        }

        public final void setCampaign(Campaign.BuilderImpl campaign) {
            this.campaign = campaign != null ? campaign.build() : null;
        }

        @Override
        public final Builder campaign(Campaign campaign) {
            this.campaign = campaign;
            return this;
        }

        @Override
        public ContactDataRequest build() {
            return new ContactDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
