/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that can be used to specify Tag conditions inside the <code>SearchFilter</code>. This accepts an
 * <code>OR</code> or <code>AND</code> (List of List) input where:
 * </p>
 * <ul>
 * <li>
 * <p>
 * The top level list specifies conditions that need to be applied with <code>OR</code> operator.
 * </p>
 * </li>
 * <li>
 * <p>
 * The inner list specifies conditions that need to be applied with <code>AND</code> operator.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ControlPlaneAttributeFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ControlPlaneAttributeFilter.Builder, ControlPlaneAttributeFilter> {
    private static final SdkField<List<CommonAttributeAndCondition>> OR_CONDITIONS_FIELD = SdkField
            .<List<CommonAttributeAndCondition>> builder(MarshallingType.LIST)
            .memberName("OrConditions")
            .getter(getter(ControlPlaneAttributeFilter::orConditions))
            .setter(setter(Builder::orConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CommonAttributeAndCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(CommonAttributeAndCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CommonAttributeAndCondition> AND_CONDITION_FIELD = SdkField
            .<CommonAttributeAndCondition> builder(MarshallingType.SDK_POJO).memberName("AndCondition")
            .getter(getter(ControlPlaneAttributeFilter::andCondition)).setter(setter(Builder::andCondition))
            .constructor(CommonAttributeAndCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndCondition").build()).build();

    private static final SdkField<TagCondition> TAG_CONDITION_FIELD = SdkField.<TagCondition> builder(MarshallingType.SDK_POJO)
            .memberName("TagCondition").getter(getter(ControlPlaneAttributeFilter::tagCondition))
            .setter(setter(Builder::tagCondition)).constructor(TagCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagCondition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_CONDITIONS_FIELD,
            AND_CONDITION_FIELD, TAG_CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<CommonAttributeAndCondition> orConditions;

    private final CommonAttributeAndCondition andCondition;

    private final TagCondition tagCondition;

    private ControlPlaneAttributeFilter(BuilderImpl builder) {
        this.orConditions = builder.orConditions;
        this.andCondition = builder.andCondition;
        this.tagCondition = builder.tagCondition;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrConditions() {
        return orConditions != null && !(orConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions which would be applied together with an <code>OR</code> condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrConditions} method.
     * </p>
     * 
     * @return A list of conditions which would be applied together with an <code>OR</code> condition.
     */
    public final List<CommonAttributeAndCondition> orConditions() {
        return orConditions;
    }

    /**
     * <p>
     * A list of conditions which would be applied together with an <code>AND</code> condition.
     * </p>
     * 
     * @return A list of conditions which would be applied together with an <code>AND</code> condition.
     */
    public final CommonAttributeAndCondition andCondition() {
        return andCondition;
    }

    /**
     * Returns the value of the TagCondition property for this object.
     * 
     * @return The value of the TagCondition property for this object.
     */
    public final TagCondition tagCondition() {
        return tagCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOrConditions() ? orConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(andCondition());
        hashCode = 31 * hashCode + Objects.hashCode(tagCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlPlaneAttributeFilter)) {
            return false;
        }
        ControlPlaneAttributeFilter other = (ControlPlaneAttributeFilter) obj;
        return hasOrConditions() == other.hasOrConditions() && Objects.equals(orConditions(), other.orConditions())
                && Objects.equals(andCondition(), other.andCondition()) && Objects.equals(tagCondition(), other.tagCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ControlPlaneAttributeFilter").add("OrConditions", hasOrConditions() ? orConditions() : null)
                .add("AndCondition", andCondition()).add("TagCondition", tagCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrConditions":
            return Optional.ofNullable(clazz.cast(orConditions()));
        case "AndCondition":
            return Optional.ofNullable(clazz.cast(andCondition()));
        case "TagCondition":
            return Optional.ofNullable(clazz.cast(tagCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrConditions", OR_CONDITIONS_FIELD);
        map.put("AndCondition", AND_CONDITION_FIELD);
        map.put("TagCondition", TAG_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ControlPlaneAttributeFilter, T> g) {
        return obj -> g.apply((ControlPlaneAttributeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ControlPlaneAttributeFilter> {
        /**
         * <p>
         * A list of conditions which would be applied together with an <code>OR</code> condition.
         * </p>
         * 
         * @param orConditions
         *        A list of conditions which would be applied together with an <code>OR</code> condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orConditions(Collection<CommonAttributeAndCondition> orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>OR</code> condition.
         * </p>
         * 
         * @param orConditions
         *        A list of conditions which would be applied together with an <code>OR</code> condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orConditions(CommonAttributeAndCondition... orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>OR</code> condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.CommonAttributeAndCondition.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.CommonAttributeAndCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.CommonAttributeAndCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #orConditions(List<CommonAttributeAndCondition>)}.
         * 
         * @param orConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.CommonAttributeAndCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orConditions(java.util.Collection<CommonAttributeAndCondition>)
         */
        Builder orConditions(Consumer<CommonAttributeAndCondition.Builder>... orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>AND</code> condition.
         * </p>
         * 
         * @param andCondition
         *        A list of conditions which would be applied together with an <code>AND</code> condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andCondition(CommonAttributeAndCondition andCondition);

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>AND</code> condition.
         * </p>
         * This is a convenience method that creates an instance of the {@link CommonAttributeAndCondition.Builder}
         * avoiding the need to create one manually via {@link CommonAttributeAndCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommonAttributeAndCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #andCondition(CommonAttributeAndCondition)}.
         * 
         * @param andCondition
         *        a consumer that will call methods on {@link CommonAttributeAndCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #andCondition(CommonAttributeAndCondition)
         */
        default Builder andCondition(Consumer<CommonAttributeAndCondition.Builder> andCondition) {
            return andCondition(CommonAttributeAndCondition.builder().applyMutation(andCondition).build());
        }

        /**
         * Sets the value of the TagCondition property for this object.
         *
         * @param tagCondition
         *        The new value for the TagCondition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagCondition(TagCondition tagCondition);

        /**
         * Sets the value of the TagCondition property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TagCondition.Builder} avoiding the need
         * to create one manually via {@link TagCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TagCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #tagCondition(TagCondition)}.
         * 
         * @param tagCondition
         *        a consumer that will call methods on {@link TagCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagCondition(TagCondition)
         */
        default Builder tagCondition(Consumer<TagCondition.Builder> tagCondition) {
            return tagCondition(TagCondition.builder().applyMutation(tagCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<CommonAttributeAndCondition> orConditions = DefaultSdkAutoConstructList.getInstance();

        private CommonAttributeAndCondition andCondition;

        private TagCondition tagCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlPlaneAttributeFilter model) {
            orConditions(model.orConditions);
            andCondition(model.andCondition);
            tagCondition(model.tagCondition);
        }

        public final List<CommonAttributeAndCondition.Builder> getOrConditions() {
            List<CommonAttributeAndCondition.Builder> result = CommonAttributeOrConditionListCopier
                    .copyToBuilder(this.orConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrConditions(Collection<CommonAttributeAndCondition.BuilderImpl> orConditions) {
            this.orConditions = CommonAttributeOrConditionListCopier.copyFromBuilder(orConditions);
        }

        @Override
        public final Builder orConditions(Collection<CommonAttributeAndCondition> orConditions) {
            this.orConditions = CommonAttributeOrConditionListCopier.copy(orConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(CommonAttributeAndCondition... orConditions) {
            orConditions(Arrays.asList(orConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(Consumer<CommonAttributeAndCondition.Builder>... orConditions) {
            orConditions(Stream.of(orConditions).map(c -> CommonAttributeAndCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final CommonAttributeAndCondition.Builder getAndCondition() {
            return andCondition != null ? andCondition.toBuilder() : null;
        }

        public final void setAndCondition(CommonAttributeAndCondition.BuilderImpl andCondition) {
            this.andCondition = andCondition != null ? andCondition.build() : null;
        }

        @Override
        public final Builder andCondition(CommonAttributeAndCondition andCondition) {
            this.andCondition = andCondition;
            return this;
        }

        public final TagCondition.Builder getTagCondition() {
            return tagCondition != null ? tagCondition.toBuilder() : null;
        }

        public final void setTagCondition(TagCondition.BuilderImpl tagCondition) {
            this.tagCondition = tagCondition != null ? tagCondition.build() : null;
        }

        @Override
        public final Builder tagCondition(TagCondition tagCondition) {
            this.tagCondition = tagCondition;
            return this;
        }

        @Override
        public ControlPlaneAttributeFilter build() {
            return new ControlPlaneAttributeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
