/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContactFlowVersionRequest extends ConnectRequest implements
        ToCopyableBuilder<CreateContactFlowVersionRequest.Builder, CreateContactFlowVersionRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreateContactFlowVersionRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateContactFlowVersionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowId").getter(getter(CreateContactFlowVersionRequest::contactFlowId))
            .setter(setter(Builder::contactFlowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactFlowId").build()).build();

    private static final SdkField<String> FLOW_CONTENT_SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowContentSha256").getter(getter(CreateContactFlowVersionRequest::flowContentSha256))
            .setter(setter(Builder::flowContentSha256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowContentSha256").build()).build();

    private static final SdkField<Long> CONTACT_FLOW_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ContactFlowVersion").getter(getter(CreateContactFlowVersionRequest::contactFlowVersion))
            .setter(setter(Builder::contactFlowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowVersion").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(CreateContactFlowVersionRequest::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedRegion").getter(getter(CreateContactFlowVersionRequest::lastModifiedRegion))
            .setter(setter(Builder::lastModifiedRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            DESCRIPTION_FIELD, CONTACT_FLOW_ID_FIELD, FLOW_CONTENT_SHA256_FIELD, CONTACT_FLOW_VERSION_FIELD,
            LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String description;

    private final String contactFlowId;

    private final String flowContentSha256;

    private final Long contactFlowVersion;

    private final Instant lastModifiedTime;

    private final String lastModifiedRegion;

    private CreateContactFlowVersionRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.description = builder.description;
        this.contactFlowId = builder.contactFlowId;
        this.flowContentSha256 = builder.flowContentSha256;
        this.contactFlowVersion = builder.contactFlowVersion;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The description of the flow version.
     * </p>
     * 
     * @return The description of the flow version.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the flow.
     * </p>
     * 
     * @return The identifier of the flow.
     */
    public final String contactFlowId() {
        return contactFlowId;
    }

    /**
     * <p>
     * Indicates the checksum value of the flow content.
     * </p>
     * 
     * @return Indicates the checksum value of the flow content.
     */
    public final String flowContentSha256() {
        return flowContentSha256;
    }

    /**
     * <p>
     * The identifier of the flow version.
     * </p>
     * 
     * @return The identifier of the flow version.
     */
    public final Long contactFlowVersion() {
        return contactFlowVersion;
    }

    /**
     * <p>
     * The Amazon Web Services Region where this resource was last modified.
     * </p>
     * 
     * @return The Amazon Web Services Region where this resource was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Web Services Region where this resource was last modified.
     * </p>
     * 
     * @return The Amazon Web Services Region where this resource was last modified.
     */
    public final String lastModifiedRegion() {
        return lastModifiedRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(flowContentSha256());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactFlowVersionRequest)) {
            return false;
        }
        CreateContactFlowVersionRequest other = (CreateContactFlowVersionRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(description(), other.description())
                && Objects.equals(contactFlowId(), other.contactFlowId())
                && Objects.equals(flowContentSha256(), other.flowContentSha256())
                && Objects.equals(contactFlowVersion(), other.contactFlowVersion())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedRegion(), other.lastModifiedRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContactFlowVersionRequest").add("InstanceId", instanceId())
                .add("Description", description()).add("ContactFlowId", contactFlowId())
                .add("FlowContentSha256", flowContentSha256()).add("ContactFlowVersion", contactFlowVersion())
                .add("LastModifiedTime", lastModifiedTime()).add("LastModifiedRegion", lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ContactFlowId":
            return Optional.ofNullable(clazz.cast(contactFlowId()));
        case "FlowContentSha256":
            return Optional.ofNullable(clazz.cast(flowContentSha256()));
        case "ContactFlowVersion":
            return Optional.ofNullable(clazz.cast(contactFlowVersion()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedRegion":
            return Optional.ofNullable(clazz.cast(lastModifiedRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ContactFlowId", CONTACT_FLOW_ID_FIELD);
        map.put("FlowContentSha256", FLOW_CONTENT_SHA256_FIELD);
        map.put("ContactFlowVersion", CONTACT_FLOW_VERSION_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateContactFlowVersionRequest, T> g) {
        return obj -> g.apply((CreateContactFlowVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateContactFlowVersionRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The description of the flow version.
         * </p>
         * 
         * @param description
         *        The description of the flow version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the flow.
         * </p>
         * 
         * @param contactFlowId
         *        The identifier of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowId(String contactFlowId);

        /**
         * <p>
         * Indicates the checksum value of the flow content.
         * </p>
         * 
         * @param flowContentSha256
         *        Indicates the checksum value of the flow content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowContentSha256(String flowContentSha256);

        /**
         * <p>
         * The identifier of the flow version.
         * </p>
         * 
         * @param contactFlowVersion
         *        The identifier of the flow version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowVersion(Long contactFlowVersion);

        /**
         * <p>
         * The Amazon Web Services Region where this resource was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The Amazon Web Services Region where this resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The Amazon Web Services Region where this resource was last modified.
         * </p>
         * 
         * @param lastModifiedRegion
         *        The Amazon Web Services Region where this resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedRegion(String lastModifiedRegion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String description;

        private String contactFlowId;

        private String flowContentSha256;

        private Long contactFlowVersion;

        private Instant lastModifiedTime;

        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContactFlowVersionRequest model) {
            super(model);
            instanceId(model.instanceId);
            description(model.description);
            contactFlowId(model.contactFlowId);
            flowContentSha256(model.flowContentSha256);
            contactFlowVersion(model.contactFlowVersion);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedRegion(model.lastModifiedRegion);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getContactFlowId() {
            return contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final String getFlowContentSha256() {
            return flowContentSha256;
        }

        public final void setFlowContentSha256(String flowContentSha256) {
            this.flowContentSha256 = flowContentSha256;
        }

        @Override
        public final Builder flowContentSha256(String flowContentSha256) {
            this.flowContentSha256 = flowContentSha256;
            return this;
        }

        public final Long getContactFlowVersion() {
            return contactFlowVersion;
        }

        public final void setContactFlowVersion(Long contactFlowVersion) {
            this.contactFlowVersion = contactFlowVersion;
        }

        @Override
        public final Builder contactFlowVersion(Long contactFlowVersion) {
            this.contactFlowVersion = contactFlowVersion;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContactFlowVersionRequest build() {
            return new CreateContactFlowVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
