/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContactRequest extends ConnectRequest implements
        ToCopyableBuilder<CreateContactRequest.Builder, CreateContactRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreateContactRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateContactRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> RELATED_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelatedContactId").getter(getter(CreateContactRequest::relatedContactId))
            .setter(setter(Builder::relatedContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedContactId").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(CreateContactRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, Reference>> REFERENCES_FIELD = SdkField
            .<Map<String, Reference>> builder(MarshallingType.MAP)
            .memberName("References")
            .getter(getter(CreateContactRequest::references))
            .setter(setter(Builder::references))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("References").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Reference> builder(MarshallingType.SDK_POJO)
                                            .constructor(Reference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CHANNEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Channel")
            .getter(getter(CreateContactRequest::channelAsString)).setter(setter(Builder::channel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()).build();

    private static final SdkField<String> INITIATION_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitiationMethod").getter(getter(CreateContactRequest::initiationMethodAsString))
            .setter(setter(Builder::initiationMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationMethod").build()).build();

    private static final SdkField<Integer> EXPIRY_DURATION_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExpiryDurationInMinutes").getter(getter(CreateContactRequest::expiryDurationInMinutes))
            .setter(setter(Builder::expiryDurationInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryDurationInMinutes").build())
            .build();

    private static final SdkField<UserInfo> USER_INFO_FIELD = SdkField.<UserInfo> builder(MarshallingType.SDK_POJO)
            .memberName("UserInfo").getter(getter(CreateContactRequest::userInfo)).setter(setter(Builder::userInfo))
            .constructor(UserInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserInfo").build()).build();

    private static final SdkField<String> INITIATE_AS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitiateAs").getter(getter(CreateContactRequest::initiateAsAsString))
            .setter(setter(Builder::initiateAs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiateAs").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateContactRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateContactRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, SegmentAttributeValue>> SEGMENT_ATTRIBUTES_FIELD = SdkField
            .<Map<String, SegmentAttributeValue>> builder(MarshallingType.MAP)
            .memberName("SegmentAttributes")
            .getter(getter(CreateContactRequest::segmentAttributes))
            .setter(setter(Builder::segmentAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<SegmentAttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(SegmentAttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CLIENT_TOKEN_FIELD, RELATED_CONTACT_ID_FIELD, ATTRIBUTES_FIELD, REFERENCES_FIELD, CHANNEL_FIELD,
            INITIATION_METHOD_FIELD, EXPIRY_DURATION_IN_MINUTES_FIELD, USER_INFO_FIELD, INITIATE_AS_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, SEGMENT_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String clientToken;

    private final String relatedContactId;

    private final Map<String, String> attributes;

    private final Map<String, Reference> references;

    private final String channel;

    private final String initiationMethod;

    private final Integer expiryDurationInMinutes;

    private final UserInfo userInfo;

    private final String initiateAs;

    private final String name;

    private final String description;

    private final Map<String, SegmentAttributeValue> segmentAttributes;

    private CreateContactRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.clientToken = builder.clientToken;
        this.relatedContactId = builder.relatedContactId;
        this.attributes = builder.attributes;
        this.references = builder.references;
        this.channel = builder.channel;
        this.initiationMethod = builder.initiationMethod;
        this.expiryDurationInMinutes = builder.expiryDurationInMinutes;
        this.userInfo = builder.userInfo;
        this.initiateAs = builder.initiateAs;
        this.name = builder.name;
        this.description = builder.description;
        this.segmentAttributes = builder.segmentAttributes;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The identifier of the contact in this instance of Amazon Connect.
     * </p>
     * 
     * @return The identifier of the contact in this instance of Amazon Connect.
     */
    public final String relatedContactId() {
        return relatedContactId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be
     * accessed in flows just like any other contact attributes.
     * </p>
     * <p>
     * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only
     * alphanumeric, dash, and underscore characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes,
     *         and can be accessed in flows just like any other contact attributes.</p>
     *         <p>
     *         There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include
     *         only alphanumeric, dash, and underscore characters.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the References property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReferences() {
        return references != null && !(references instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Tasks can have the following
     * reference types at the time of creation: URL | NUMBER | STRING | DATE | EMAIL | ATTACHMENT.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferences} method.
     * </p>
     * 
     * @return A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Tasks can have the
     *         following reference types at the time of creation: URL | NUMBER | STRING | DATE | EMAIL | ATTACHMENT.
     */
    public final Map<String, Reference> references() {
        return references;
    }

    /**
     * <p>
     * The channel for the contact
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link Channel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelAsString}.
     * </p>
     * 
     * @return The channel for the contact
     * @see Channel
     */
    public final Channel channel() {
        return Channel.fromValue(channel);
    }

    /**
     * <p>
     * The channel for the contact
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link Channel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelAsString}.
     * </p>
     * 
     * @return The channel for the contact
     * @see Channel
     */
    public final String channelAsString() {
        return channel;
    }

    /**
     * <p>
     * Indicates how the contact was initiated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #initiationMethod}
     * will return {@link ContactInitiationMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #initiationMethodAsString}.
     * </p>
     * 
     * @return Indicates how the contact was initiated.
     * @see ContactInitiationMethod
     */
    public final ContactInitiationMethod initiationMethod() {
        return ContactInitiationMethod.fromValue(initiationMethod);
    }

    /**
     * <p>
     * Indicates how the contact was initiated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #initiationMethod}
     * will return {@link ContactInitiationMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #initiationMethodAsString}.
     * </p>
     * 
     * @return Indicates how the contact was initiated.
     * @see ContactInitiationMethod
     */
    public final String initiationMethodAsString() {
        return initiationMethod;
    }

    /**
     * <p>
     * Number of minutes the contact will be active for before expiring
     * </p>
     * 
     * @return Number of minutes the contact will be active for before expiring
     */
    public final Integer expiryDurationInMinutes() {
        return expiryDurationInMinutes;
    }

    /**
     * <p>
     * User details for the contact
     * </p>
     * 
     * @return User details for the contact
     */
    public final UserInfo userInfo() {
        return userInfo;
    }

    /**
     * <p>
     * Initial state of the contact when it's created
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #initiateAs} will
     * return {@link InitiateAs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #initiateAsAsString}.
     * </p>
     * 
     * @return Initial state of the contact when it's created
     * @see InitiateAs
     */
    public final InitiateAs initiateAs() {
        return InitiateAs.fromValue(initiateAs);
    }

    /**
     * <p>
     * Initial state of the contact when it's created
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #initiateAs} will
     * return {@link InitiateAs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #initiateAsAsString}.
     * </p>
     * 
     * @return Initial state of the contact when it's created
     * @see InitiateAs
     */
    public final String initiateAsAsString() {
        return initiateAs;
    }

    /**
     * <p>
     * The name of a the contact.
     * </p>
     * 
     * @return The name of a the contact.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the contact.
     * </p>
     * 
     * @return A description of the contact.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the SegmentAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSegmentAttributes() {
        return segmentAttributes != null && !(segmentAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of system defined key-value pairs stored on individual contact segments (unique contact ID) using an
     * attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in flows.
     * </p>
     * <p>
     * Attribute keys can include only alphanumeric, -, and _.
     * </p>
     * <p>
     * This field can be used to set Segment Contact Expiry as a duration in minutes.
     * </p>
     * <note>
     * <p>
     * To set contact expiry, a ValueMap must be specified containing the integer number of minutes the contact will be
     * active for before expiring, with <code>SegmentAttributes</code> like {
     * <code> "connect:ContactExpiry": {"ValueMap" : { "ExpiryDuration": { "ValueInteger": 135}}}}</code>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSegmentAttributes} method.
     * </p>
     * 
     * @return A set of system defined key-value pairs stored on individual contact segments (unique contact ID) using
     *         an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in
     *         flows.</p>
     *         <p>
     *         Attribute keys can include only alphanumeric, -, and _.
     *         </p>
     *         <p>
     *         This field can be used to set Segment Contact Expiry as a duration in minutes.
     *         </p>
     *         <note>
     *         <p>
     *         To set contact expiry, a ValueMap must be specified containing the integer number of minutes the contact
     *         will be active for before expiring, with <code>SegmentAttributes</code> like {
     *         <code> "connect:ContactExpiry": {"ValueMap" : { "ExpiryDuration": { "ValueInteger": 135}}}}</code>.
     *         </p>
     */
    public final Map<String, SegmentAttributeValue> segmentAttributes() {
        return segmentAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(relatedContactId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReferences() ? references() : null);
        hashCode = 31 * hashCode + Objects.hashCode(channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(initiationMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(expiryDurationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(userInfo());
        hashCode = 31 * hashCode + Objects.hashCode(initiateAsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasSegmentAttributes() ? segmentAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactRequest)) {
            return false;
        }
        CreateContactRequest other = (CreateContactRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(relatedContactId(), other.relatedContactId()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes()) && hasReferences() == other.hasReferences()
                && Objects.equals(references(), other.references()) && Objects.equals(channelAsString(), other.channelAsString())
                && Objects.equals(initiationMethodAsString(), other.initiationMethodAsString())
                && Objects.equals(expiryDurationInMinutes(), other.expiryDurationInMinutes())
                && Objects.equals(userInfo(), other.userInfo())
                && Objects.equals(initiateAsAsString(), other.initiateAsAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && hasSegmentAttributes() == other.hasSegmentAttributes()
                && Objects.equals(segmentAttributes(), other.segmentAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContactRequest").add("InstanceId", instanceId()).add("ClientToken", clientToken())
                .add("RelatedContactId", relatedContactId()).add("Attributes", hasAttributes() ? attributes() : null)
                .add("References", hasReferences() ? references() : null).add("Channel", channelAsString())
                .add("InitiationMethod", initiationMethodAsString()).add("ExpiryDurationInMinutes", expiryDurationInMinutes())
                .add("UserInfo", userInfo()).add("InitiateAs", initiateAsAsString())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SegmentAttributes", hasSegmentAttributes() ? segmentAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "RelatedContactId":
            return Optional.ofNullable(clazz.cast(relatedContactId()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "References":
            return Optional.ofNullable(clazz.cast(references()));
        case "Channel":
            return Optional.ofNullable(clazz.cast(channelAsString()));
        case "InitiationMethod":
            return Optional.ofNullable(clazz.cast(initiationMethodAsString()));
        case "ExpiryDurationInMinutes":
            return Optional.ofNullable(clazz.cast(expiryDurationInMinutes()));
        case "UserInfo":
            return Optional.ofNullable(clazz.cast(userInfo()));
        case "InitiateAs":
            return Optional.ofNullable(clazz.cast(initiateAsAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SegmentAttributes":
            return Optional.ofNullable(clazz.cast(segmentAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("RelatedContactId", RELATED_CONTACT_ID_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("References", REFERENCES_FIELD);
        map.put("Channel", CHANNEL_FIELD);
        map.put("InitiationMethod", INITIATION_METHOD_FIELD);
        map.put("ExpiryDurationInMinutes", EXPIRY_DURATION_IN_MINUTES_FIELD);
        map.put("UserInfo", USER_INFO_FIELD);
        map.put("InitiateAs", INITIATE_AS_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("SegmentAttributes", SEGMENT_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateContactRequest, T> g) {
        return obj -> g.apply((CreateContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateContactRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The identifier of the contact in this instance of Amazon Connect.
         * </p>
         * 
         * @param relatedContactId
         *        The identifier of the contact in this instance of Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedContactId(String relatedContactId);

        /**
         * <p>
         * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and
         * can be accessed in flows just like any other contact attributes.
         * </p>
         * <p>
         * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only
         * alphanumeric, dash, and underscore characters.
         * </p>
         * 
         * @param attributes
         *        A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes,
         *        and can be accessed in flows just like any other contact attributes.</p>
         *        <p>
         *        There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can
         *        include only alphanumeric, dash, and underscore characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Tasks can have the following
         * reference types at the time of creation: URL | NUMBER | STRING | DATE | EMAIL | ATTACHMENT.
         * </p>
         * 
         * @param references
         *        A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Tasks can have the
         *        following reference types at the time of creation: URL | NUMBER | STRING | DATE | EMAIL | ATTACHMENT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder references(Map<String, Reference> references);

        /**
         * <p>
         * The channel for the contact
         * </p>
         * 
         * @param channel
         *        The channel for the contact
         * @see Channel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Channel
         */
        Builder channel(String channel);

        /**
         * <p>
         * The channel for the contact
         * </p>
         * 
         * @param channel
         *        The channel for the contact
         * @see Channel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Channel
         */
        Builder channel(Channel channel);

        /**
         * <p>
         * Indicates how the contact was initiated.
         * </p>
         * 
         * @param initiationMethod
         *        Indicates how the contact was initiated.
         * @see ContactInitiationMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactInitiationMethod
         */
        Builder initiationMethod(String initiationMethod);

        /**
         * <p>
         * Indicates how the contact was initiated.
         * </p>
         * 
         * @param initiationMethod
         *        Indicates how the contact was initiated.
         * @see ContactInitiationMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactInitiationMethod
         */
        Builder initiationMethod(ContactInitiationMethod initiationMethod);

        /**
         * <p>
         * Number of minutes the contact will be active for before expiring
         * </p>
         * 
         * @param expiryDurationInMinutes
         *        Number of minutes the contact will be active for before expiring
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiryDurationInMinutes(Integer expiryDurationInMinutes);

        /**
         * <p>
         * User details for the contact
         * </p>
         * 
         * @param userInfo
         *        User details for the contact
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userInfo(UserInfo userInfo);

        /**
         * <p>
         * User details for the contact
         * </p>
         * This is a convenience method that creates an instance of the {@link UserInfo.Builder} avoiding the need to
         * create one manually via {@link UserInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserInfo.Builder#build()} is called immediately and its result is
         * passed to {@link #userInfo(UserInfo)}.
         * 
         * @param userInfo
         *        a consumer that will call methods on {@link UserInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userInfo(UserInfo)
         */
        default Builder userInfo(Consumer<UserInfo.Builder> userInfo) {
            return userInfo(UserInfo.builder().applyMutation(userInfo).build());
        }

        /**
         * <p>
         * Initial state of the contact when it's created
         * </p>
         * 
         * @param initiateAs
         *        Initial state of the contact when it's created
         * @see InitiateAs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InitiateAs
         */
        Builder initiateAs(String initiateAs);

        /**
         * <p>
         * Initial state of the contact when it's created
         * </p>
         * 
         * @param initiateAs
         *        Initial state of the contact when it's created
         * @see InitiateAs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InitiateAs
         */
        Builder initiateAs(InitiateAs initiateAs);

        /**
         * <p>
         * The name of a the contact.
         * </p>
         * 
         * @param name
         *        The name of a the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the contact.
         * </p>
         * 
         * @param description
         *        A description of the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A set of system defined key-value pairs stored on individual contact segments (unique contact ID) using an
         * attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in flows.
         * </p>
         * <p>
         * Attribute keys can include only alphanumeric, -, and _.
         * </p>
         * <p>
         * This field can be used to set Segment Contact Expiry as a duration in minutes.
         * </p>
         * <note>
         * <p>
         * To set contact expiry, a ValueMap must be specified containing the integer number of minutes the contact will
         * be active for before expiring, with <code>SegmentAttributes</code> like {
         * <code> "connect:ContactExpiry": {"ValueMap" : { "ExpiryDuration": { "ValueInteger": 135}}}}</code>.
         * </p>
         * </note>
         * 
         * @param segmentAttributes
         *        A set of system defined key-value pairs stored on individual contact segments (unique contact ID)
         *        using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in
         *        flows.</p>
         *        <p>
         *        Attribute keys can include only alphanumeric, -, and _.
         *        </p>
         *        <p>
         *        This field can be used to set Segment Contact Expiry as a duration in minutes.
         *        </p>
         *        <note>
         *        <p>
         *        To set contact expiry, a ValueMap must be specified containing the integer number of minutes the
         *        contact will be active for before expiring, with <code>SegmentAttributes</code> like {
         *        <code> "connect:ContactExpiry": {"ValueMap" : { "ExpiryDuration": { "ValueInteger": 135}}}}</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentAttributes(Map<String, SegmentAttributeValue> segmentAttributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String clientToken;

        private String relatedContactId;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Reference> references = DefaultSdkAutoConstructMap.getInstance();

        private String channel;

        private String initiationMethod;

        private Integer expiryDurationInMinutes;

        private UserInfo userInfo;

        private String initiateAs;

        private String name;

        private String description;

        private Map<String, SegmentAttributeValue> segmentAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContactRequest model) {
            super(model);
            instanceId(model.instanceId);
            clientToken(model.clientToken);
            relatedContactId(model.relatedContactId);
            attributes(model.attributes);
            references(model.references);
            channel(model.channel);
            initiationMethod(model.initiationMethod);
            expiryDurationInMinutes(model.expiryDurationInMinutes);
            userInfo(model.userInfo);
            initiateAs(model.initiateAs);
            name(model.name);
            description(model.description);
            segmentAttributes(model.segmentAttributes);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getRelatedContactId() {
            return relatedContactId;
        }

        public final void setRelatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
        }

        @Override
        public final Builder relatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final Map<String, Reference.Builder> getReferences() {
            Map<String, Reference.Builder> result = ContactReferencesCopier.copyToBuilder(this.references);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setReferences(Map<String, Reference.BuilderImpl> references) {
            this.references = ContactReferencesCopier.copyFromBuilder(references);
        }

        @Override
        public final Builder references(Map<String, Reference> references) {
            this.references = ContactReferencesCopier.copy(references);
            return this;
        }

        public final String getChannel() {
            return channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final String getInitiationMethod() {
            return initiationMethod;
        }

        public final void setInitiationMethod(String initiationMethod) {
            this.initiationMethod = initiationMethod;
        }

        @Override
        public final Builder initiationMethod(String initiationMethod) {
            this.initiationMethod = initiationMethod;
            return this;
        }

        @Override
        public final Builder initiationMethod(ContactInitiationMethod initiationMethod) {
            this.initiationMethod(initiationMethod == null ? null : initiationMethod.toString());
            return this;
        }

        public final Integer getExpiryDurationInMinutes() {
            return expiryDurationInMinutes;
        }

        public final void setExpiryDurationInMinutes(Integer expiryDurationInMinutes) {
            this.expiryDurationInMinutes = expiryDurationInMinutes;
        }

        @Override
        public final Builder expiryDurationInMinutes(Integer expiryDurationInMinutes) {
            this.expiryDurationInMinutes = expiryDurationInMinutes;
            return this;
        }

        public final UserInfo.Builder getUserInfo() {
            return userInfo != null ? userInfo.toBuilder() : null;
        }

        public final void setUserInfo(UserInfo.BuilderImpl userInfo) {
            this.userInfo = userInfo != null ? userInfo.build() : null;
        }

        @Override
        public final Builder userInfo(UserInfo userInfo) {
            this.userInfo = userInfo;
            return this;
        }

        public final String getInitiateAs() {
            return initiateAs;
        }

        public final void setInitiateAs(String initiateAs) {
            this.initiateAs = initiateAs;
        }

        @Override
        public final Builder initiateAs(String initiateAs) {
            this.initiateAs = initiateAs;
            return this;
        }

        @Override
        public final Builder initiateAs(InitiateAs initiateAs) {
            this.initiateAs(initiateAs == null ? null : initiateAs.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, SegmentAttributeValue.Builder> getSegmentAttributes() {
            Map<String, SegmentAttributeValue.Builder> result = SegmentAttributesCopier.copyToBuilder(this.segmentAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSegmentAttributes(Map<String, SegmentAttributeValue.BuilderImpl> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copyFromBuilder(segmentAttributes);
        }

        @Override
        public final Builder segmentAttributes(Map<String, SegmentAttributeValue> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copy(segmentAttributes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContactRequest build() {
            return new CreateContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
