/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHoursOfOperationOverrideResponse extends ConnectResponse implements
        ToCopyableBuilder<CreateHoursOfOperationOverrideResponse.Builder, CreateHoursOfOperationOverrideResponse> {
    private static final SdkField<String> HOURS_OF_OPERATION_OVERRIDE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HoursOfOperationOverrideId")
            .getter(getter(CreateHoursOfOperationOverrideResponse::hoursOfOperationOverrideId))
            .setter(setter(Builder::hoursOfOperationOverrideId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperationOverrideId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(HOURS_OF_OPERATION_OVERRIDE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hoursOfOperationOverrideId;

    private CreateHoursOfOperationOverrideResponse(BuilderImpl builder) {
        super(builder);
        this.hoursOfOperationOverrideId = builder.hoursOfOperationOverrideId;
    }

    /**
     * <p>
     * The identifier for the hours of operation override.
     * </p>
     * 
     * @return The identifier for the hours of operation override.
     */
    public final String hoursOfOperationOverrideId() {
        return hoursOfOperationOverrideId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hoursOfOperationOverrideId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHoursOfOperationOverrideResponse)) {
            return false;
        }
        CreateHoursOfOperationOverrideResponse other = (CreateHoursOfOperationOverrideResponse) obj;
        return Objects.equals(hoursOfOperationOverrideId(), other.hoursOfOperationOverrideId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateHoursOfOperationOverrideResponse")
                .add("HoursOfOperationOverrideId", hoursOfOperationOverrideId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HoursOfOperationOverrideId":
            return Optional.ofNullable(clazz.cast(hoursOfOperationOverrideId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HoursOfOperationOverrideId", HOURS_OF_OPERATION_OVERRIDE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateHoursOfOperationOverrideResponse, T> g) {
        return obj -> g.apply((CreateHoursOfOperationOverrideResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateHoursOfOperationOverrideResponse> {
        /**
         * <p>
         * The identifier for the hours of operation override.
         * </p>
         * 
         * @param hoursOfOperationOverrideId
         *        The identifier for the hours of operation override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hoursOfOperationOverrideId(String hoursOfOperationOverrideId);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String hoursOfOperationOverrideId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHoursOfOperationOverrideResponse model) {
            super(model);
            hoursOfOperationOverrideId(model.hoursOfOperationOverrideId);
        }

        public final String getHoursOfOperationOverrideId() {
            return hoursOfOperationOverrideId;
        }

        public final void setHoursOfOperationOverrideId(String hoursOfOperationOverrideId) {
            this.hoursOfOperationOverrideId = hoursOfOperationOverrideId;
        }

        @Override
        public final Builder hoursOfOperationOverrideId(String hoursOfOperationOverrideId) {
            this.hoursOfOperationOverrideId = hoursOfOperationOverrideId;
            return this;
        }

        @Override
        public CreateHoursOfOperationOverrideResponse build() {
            return new CreateHoursOfOperationOverrideResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
