/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInstanceRequest extends ConnectRequest implements
        ToCopyableBuilder<CreateInstanceRequest.Builder, CreateInstanceRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CreateInstanceRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> IDENTITY_MANAGEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityManagementType").getter(getter(CreateInstanceRequest::identityManagementTypeAsString))
            .setter(setter(Builder::identityManagementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityManagementType").build())
            .build();

    private static final SdkField<String> INSTANCE_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceAlias").getter(getter(CreateInstanceRequest::instanceAlias))
            .setter(setter(Builder::instanceAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceAlias").build()).build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(CreateInstanceRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<Boolean> INBOUND_CALLS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InboundCallsEnabled").getter(getter(CreateInstanceRequest::inboundCallsEnabled))
            .setter(setter(Builder::inboundCallsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundCallsEnabled").build())
            .build();

    private static final SdkField<Boolean> OUTBOUND_CALLS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OutboundCallsEnabled").getter(getter(CreateInstanceRequest::outboundCallsEnabled))
            .setter(setter(Builder::outboundCallsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundCallsEnabled").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateInstanceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            IDENTITY_MANAGEMENT_TYPE_FIELD, INSTANCE_ALIAS_FIELD, DIRECTORY_ID_FIELD, INBOUND_CALLS_ENABLED_FIELD,
            OUTBOUND_CALLS_ENABLED_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String identityManagementType;

    private final String instanceAlias;

    private final String directoryId;

    private final Boolean inboundCallsEnabled;

    private final Boolean outboundCallsEnabled;

    private final Map<String, String> tags;

    private CreateInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.identityManagementType = builder.identityManagementType;
        this.instanceAlias = builder.instanceAlias;
        this.directoryId = builder.directoryId;
        this.inboundCallsEnabled = builder.inboundCallsEnabled;
        this.outboundCallsEnabled = builder.outboundCallsEnabled;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The idempotency token.
     * </p>
     * 
     * @return The idempotency token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The type of identity management for your Amazon Connect users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityManagementType} will return {@link DirectoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #identityManagementTypeAsString}.
     * </p>
     * 
     * @return The type of identity management for your Amazon Connect users.
     * @see DirectoryType
     */
    public final DirectoryType identityManagementType() {
        return DirectoryType.fromValue(identityManagementType);
    }

    /**
     * <p>
     * The type of identity management for your Amazon Connect users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityManagementType} will return {@link DirectoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #identityManagementTypeAsString}.
     * </p>
     * 
     * @return The type of identity management for your Amazon Connect users.
     * @see DirectoryType
     */
    public final String identityManagementTypeAsString() {
        return identityManagementType;
    }

    /**
     * <p>
     * The name for your instance.
     * </p>
     * 
     * @return The name for your instance.
     */
    public final String instanceAlias() {
        return instanceAlias;
    }

    /**
     * <p>
     * The identifier for the directory.
     * </p>
     * 
     * @return The identifier for the directory.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * Your contact center handles incoming contacts.
     * </p>
     * 
     * @return Your contact center handles incoming contacts.
     */
    public final Boolean inboundCallsEnabled() {
        return inboundCallsEnabled;
    }

    /**
     * <p>
     * Your contact center allows outbound calls.
     * </p>
     * 
     * @return Your contact center allows outbound calls.
     */
    public final Boolean outboundCallsEnabled() {
        return outboundCallsEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example,
     * <code>{ "tags": {"key1":"value1", "key2":"value2"} }</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example,
     *         <code>{ "tags": {"key1":"value1", "key2":"value2"} }</code>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(identityManagementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceAlias());
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(inboundCallsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(outboundCallsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceRequest)) {
            return false;
        }
        CreateInstanceRequest other = (CreateInstanceRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(identityManagementTypeAsString(), other.identityManagementTypeAsString())
                && Objects.equals(instanceAlias(), other.instanceAlias()) && Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(inboundCallsEnabled(), other.inboundCallsEnabled())
                && Objects.equals(outboundCallsEnabled(), other.outboundCallsEnabled()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInstanceRequest").add("ClientToken", clientToken())
                .add("IdentityManagementType", identityManagementTypeAsString())
                .add("InstanceAlias", instanceAlias() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DirectoryId", directoryId()).add("InboundCallsEnabled", inboundCallsEnabled())
                .add("OutboundCallsEnabled", outboundCallsEnabled()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "IdentityManagementType":
            return Optional.ofNullable(clazz.cast(identityManagementTypeAsString()));
        case "InstanceAlias":
            return Optional.ofNullable(clazz.cast(instanceAlias()));
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "InboundCallsEnabled":
            return Optional.ofNullable(clazz.cast(inboundCallsEnabled()));
        case "OutboundCallsEnabled":
            return Optional.ofNullable(clazz.cast(outboundCallsEnabled()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("IdentityManagementType", IDENTITY_MANAGEMENT_TYPE_FIELD);
        map.put("InstanceAlias", INSTANCE_ALIAS_FIELD);
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("InboundCallsEnabled", INBOUND_CALLS_ENABLED_FIELD);
        map.put("OutboundCallsEnabled", OUTBOUND_CALLS_ENABLED_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInstanceRequest, T> g) {
        return obj -> g.apply((CreateInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateInstanceRequest> {
        /**
         * <p>
         * The idempotency token.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The type of identity management for your Amazon Connect users.
         * </p>
         * 
         * @param identityManagementType
         *        The type of identity management for your Amazon Connect users.
         * @see DirectoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectoryType
         */
        Builder identityManagementType(String identityManagementType);

        /**
         * <p>
         * The type of identity management for your Amazon Connect users.
         * </p>
         * 
         * @param identityManagementType
         *        The type of identity management for your Amazon Connect users.
         * @see DirectoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectoryType
         */
        Builder identityManagementType(DirectoryType identityManagementType);

        /**
         * <p>
         * The name for your instance.
         * </p>
         * 
         * @param instanceAlias
         *        The name for your instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceAlias(String instanceAlias);

        /**
         * <p>
         * The identifier for the directory.
         * </p>
         * 
         * @param directoryId
         *        The identifier for the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * Your contact center handles incoming contacts.
         * </p>
         * 
         * @param inboundCallsEnabled
         *        Your contact center handles incoming contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundCallsEnabled(Boolean inboundCallsEnabled);

        /**
         * <p>
         * Your contact center allows outbound calls.
         * </p>
         * 
         * @param outboundCallsEnabled
         *        Your contact center allows outbound calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundCallsEnabled(Boolean outboundCallsEnabled);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example,
         * <code>{ "tags": {"key1":"value1", "key2":"value2"} }</code>.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example,
         *        <code>{ "tags": {"key1":"value1", "key2":"value2"} }</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String identityManagementType;

        private String instanceAlias;

        private String directoryId;

        private Boolean inboundCallsEnabled;

        private Boolean outboundCallsEnabled;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceRequest model) {
            super(model);
            clientToken(model.clientToken);
            identityManagementType(model.identityManagementType);
            instanceAlias(model.instanceAlias);
            directoryId(model.directoryId);
            inboundCallsEnabled(model.inboundCallsEnabled);
            outboundCallsEnabled(model.outboundCallsEnabled);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getIdentityManagementType() {
            return identityManagementType;
        }

        public final void setIdentityManagementType(String identityManagementType) {
            this.identityManagementType = identityManagementType;
        }

        @Override
        public final Builder identityManagementType(String identityManagementType) {
            this.identityManagementType = identityManagementType;
            return this;
        }

        @Override
        public final Builder identityManagementType(DirectoryType identityManagementType) {
            this.identityManagementType(identityManagementType == null ? null : identityManagementType.toString());
            return this;
        }

        public final String getInstanceAlias() {
            return instanceAlias;
        }

        public final void setInstanceAlias(String instanceAlias) {
            this.instanceAlias = instanceAlias;
        }

        @Override
        public final Builder instanceAlias(String instanceAlias) {
            this.instanceAlias = instanceAlias;
            return this;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Boolean getInboundCallsEnabled() {
            return inboundCallsEnabled;
        }

        public final void setInboundCallsEnabled(Boolean inboundCallsEnabled) {
            this.inboundCallsEnabled = inboundCallsEnabled;
        }

        @Override
        public final Builder inboundCallsEnabled(Boolean inboundCallsEnabled) {
            this.inboundCallsEnabled = inboundCallsEnabled;
            return this;
        }

        public final Boolean getOutboundCallsEnabled() {
            return outboundCallsEnabled;
        }

        public final void setOutboundCallsEnabled(Boolean outboundCallsEnabled) {
            this.outboundCallsEnabled = outboundCallsEnabled;
        }

        @Override
        public final Builder outboundCallsEnabled(Boolean outboundCallsEnabled) {
            this.outboundCallsEnabled = outboundCallsEnabled;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInstanceRequest build() {
            return new CreateInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
