/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateParticipantResponse extends ConnectResponse implements
        ToCopyableBuilder<CreateParticipantResponse.Builder, CreateParticipantResponse> {
    private static final SdkField<ParticipantTokenCredentials> PARTICIPANT_CREDENTIALS_FIELD = SdkField
            .<ParticipantTokenCredentials> builder(MarshallingType.SDK_POJO).memberName("ParticipantCredentials")
            .getter(getter(CreateParticipantResponse::participantCredentials)).setter(setter(Builder::participantCredentials))
            .constructor(ParticipantTokenCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantCredentials").build())
            .build();

    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantId").getter(getter(CreateParticipantResponse::participantId))
            .setter(setter(Builder::participantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTICIPANT_CREDENTIALS_FIELD,
            PARTICIPANT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ParticipantTokenCredentials participantCredentials;

    private final String participantId;

    private CreateParticipantResponse(BuilderImpl builder) {
        super(builder);
        this.participantCredentials = builder.participantCredentials;
        this.participantId = builder.participantId;
    }

    /**
     * <p>
     * The token used by the chat participant to call <code>CreateParticipantConnection</code>. The participant token is
     * valid for the lifetime of a chat participant.
     * </p>
     * 
     * @return The token used by the chat participant to call <code>CreateParticipantConnection</code>. The participant
     *         token is valid for the lifetime of a chat participant.
     */
    public final ParticipantTokenCredentials participantCredentials() {
        return participantCredentials;
    }

    /**
     * <p>
     * The identifier for a chat participant. The participantId for a chat participant is the same throughout the chat
     * lifecycle.
     * </p>
     * 
     * @return The identifier for a chat participant. The participantId for a chat participant is the same throughout
     *         the chat lifecycle.
     */
    public final String participantId() {
        return participantId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(participantCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(participantId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateParticipantResponse)) {
            return false;
        }
        CreateParticipantResponse other = (CreateParticipantResponse) obj;
        return Objects.equals(participantCredentials(), other.participantCredentials())
                && Objects.equals(participantId(), other.participantId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateParticipantResponse").add("ParticipantCredentials", participantCredentials())
                .add("ParticipantId", participantId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParticipantCredentials":
            return Optional.ofNullable(clazz.cast(participantCredentials()));
        case "ParticipantId":
            return Optional.ofNullable(clazz.cast(participantId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ParticipantCredentials", PARTICIPANT_CREDENTIALS_FIELD);
        map.put("ParticipantId", PARTICIPANT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateParticipantResponse, T> g) {
        return obj -> g.apply((CreateParticipantResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateParticipantResponse> {
        /**
         * <p>
         * The token used by the chat participant to call <code>CreateParticipantConnection</code>. The participant
         * token is valid for the lifetime of a chat participant.
         * </p>
         * 
         * @param participantCredentials
         *        The token used by the chat participant to call <code>CreateParticipantConnection</code>. The
         *        participant token is valid for the lifetime of a chat participant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantCredentials(ParticipantTokenCredentials participantCredentials);

        /**
         * <p>
         * The token used by the chat participant to call <code>CreateParticipantConnection</code>. The participant
         * token is valid for the lifetime of a chat participant.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParticipantTokenCredentials.Builder}
         * avoiding the need to create one manually via {@link ParticipantTokenCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParticipantTokenCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #participantCredentials(ParticipantTokenCredentials)}.
         * 
         * @param participantCredentials
         *        a consumer that will call methods on {@link ParticipantTokenCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #participantCredentials(ParticipantTokenCredentials)
         */
        default Builder participantCredentials(Consumer<ParticipantTokenCredentials.Builder> participantCredentials) {
            return participantCredentials(ParticipantTokenCredentials.builder().applyMutation(participantCredentials).build());
        }

        /**
         * <p>
         * The identifier for a chat participant. The participantId for a chat participant is the same throughout the
         * chat lifecycle.
         * </p>
         * 
         * @param participantId
         *        The identifier for a chat participant. The participantId for a chat participant is the same throughout
         *        the chat lifecycle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantId(String participantId);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private ParticipantTokenCredentials participantCredentials;

        private String participantId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateParticipantResponse model) {
            super(model);
            participantCredentials(model.participantCredentials);
            participantId(model.participantId);
        }

        public final ParticipantTokenCredentials.Builder getParticipantCredentials() {
            return participantCredentials != null ? participantCredentials.toBuilder() : null;
        }

        public final void setParticipantCredentials(ParticipantTokenCredentials.BuilderImpl participantCredentials) {
            this.participantCredentials = participantCredentials != null ? participantCredentials.build() : null;
        }

        @Override
        public final Builder participantCredentials(ParticipantTokenCredentials participantCredentials) {
            this.participantCredentials = participantCredentials;
            return this;
        }

        public final String getParticipantId() {
            return participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        @Override
        public CreateParticipantResponse build() {
            return new CreateParticipantResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
