/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePushNotificationRegistrationRequest extends ConnectRequest implements
        ToCopyableBuilder<CreatePushNotificationRegistrationRequest.Builder, CreatePushNotificationRegistrationRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreatePushNotificationRegistrationRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreatePushNotificationRegistrationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> PINPOINT_APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PinpointAppArn").getter(getter(CreatePushNotificationRegistrationRequest::pinpointAppArn))
            .setter(setter(Builder::pinpointAppArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinpointAppArn").build()).build();

    private static final SdkField<String> DEVICE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceToken").getter(getter(CreatePushNotificationRegistrationRequest::deviceToken))
            .setter(setter(Builder::deviceToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceToken").build()).build();

    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceType").getter(getter(CreatePushNotificationRegistrationRequest::deviceTypeAsString))
            .setter(setter(Builder::deviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceType").build()).build();

    private static final SdkField<ContactConfiguration> CONTACT_CONFIGURATION_FIELD = SdkField
            .<ContactConfiguration> builder(MarshallingType.SDK_POJO).memberName("ContactConfiguration")
            .getter(getter(CreatePushNotificationRegistrationRequest::contactConfiguration))
            .setter(setter(Builder::contactConfiguration)).constructor(ContactConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CLIENT_TOKEN_FIELD, PINPOINT_APP_ARN_FIELD, DEVICE_TOKEN_FIELD, DEVICE_TYPE_FIELD, CONTACT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String clientToken;

    private final String pinpointAppArn;

    private final String deviceToken;

    private final String deviceType;

    private final ContactConfiguration contactConfiguration;

    private CreatePushNotificationRegistrationRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.clientToken = builder.clientToken;
        this.pinpointAppArn = builder.pinpointAppArn;
        this.deviceToken = builder.deviceToken;
        this.deviceType = builder.deviceType;
        this.contactConfiguration = builder.contactConfiguration;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Pinpoint application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Pinpoint application.
     */
    public final String pinpointAppArn() {
        return pinpointAppArn;
    }

    /**
     * <p>
     * The push notification token issued by the Apple or Google gateways.
     * </p>
     * 
     * @return The push notification token issued by the Apple or Google gateways.
     */
    public final String deviceToken() {
        return deviceToken;
    }

    /**
     * <p>
     * The device type to use when sending the message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceType} will
     * return {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceTypeAsString}.
     * </p>
     * 
     * @return The device type to use when sending the message.
     * @see DeviceType
     */
    public final DeviceType deviceType() {
        return DeviceType.fromValue(deviceType);
    }

    /**
     * <p>
     * The device type to use when sending the message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceType} will
     * return {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceTypeAsString}.
     * </p>
     * 
     * @return The device type to use when sending the message.
     * @see DeviceType
     */
    public final String deviceTypeAsString() {
        return deviceType;
    }

    /**
     * <p>
     * The contact configuration for push notification registration.
     * </p>
     * 
     * @return The contact configuration for push notification registration.
     */
    public final ContactConfiguration contactConfiguration() {
        return contactConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(pinpointAppArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceToken());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contactConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePushNotificationRegistrationRequest)) {
            return false;
        }
        CreatePushNotificationRegistrationRequest other = (CreatePushNotificationRegistrationRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(pinpointAppArn(), other.pinpointAppArn()) && Objects.equals(deviceToken(), other.deviceToken())
                && Objects.equals(deviceTypeAsString(), other.deviceTypeAsString())
                && Objects.equals(contactConfiguration(), other.contactConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePushNotificationRegistrationRequest").add("InstanceId", instanceId())
                .add("ClientToken", clientToken()).add("PinpointAppArn", pinpointAppArn()).add("DeviceToken", deviceToken())
                .add("DeviceType", deviceTypeAsString()).add("ContactConfiguration", contactConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "PinpointAppArn":
            return Optional.ofNullable(clazz.cast(pinpointAppArn()));
        case "DeviceToken":
            return Optional.ofNullable(clazz.cast(deviceToken()));
        case "DeviceType":
            return Optional.ofNullable(clazz.cast(deviceTypeAsString()));
        case "ContactConfiguration":
            return Optional.ofNullable(clazz.cast(contactConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("PinpointAppArn", PINPOINT_APP_ARN_FIELD);
        map.put("DeviceToken", DEVICE_TOKEN_FIELD);
        map.put("DeviceType", DEVICE_TYPE_FIELD);
        map.put("ContactConfiguration", CONTACT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePushNotificationRegistrationRequest, T> g) {
        return obj -> g.apply((CreatePushNotificationRegistrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePushNotificationRegistrationRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Pinpoint application.
         * </p>
         * 
         * @param pinpointAppArn
         *        The Amazon Resource Name (ARN) of the Pinpoint application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pinpointAppArn(String pinpointAppArn);

        /**
         * <p>
         * The push notification token issued by the Apple or Google gateways.
         * </p>
         * 
         * @param deviceToken
         *        The push notification token issued by the Apple or Google gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceToken(String deviceToken);

        /**
         * <p>
         * The device type to use when sending the message.
         * </p>
         * 
         * @param deviceType
         *        The device type to use when sending the message.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder deviceType(String deviceType);

        /**
         * <p>
         * The device type to use when sending the message.
         * </p>
         * 
         * @param deviceType
         *        The device type to use when sending the message.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder deviceType(DeviceType deviceType);

        /**
         * <p>
         * The contact configuration for push notification registration.
         * </p>
         * 
         * @param contactConfiguration
         *        The contact configuration for push notification registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactConfiguration(ContactConfiguration contactConfiguration);

        /**
         * <p>
         * The contact configuration for push notification registration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactConfiguration.Builder} avoiding
         * the need to create one manually via {@link ContactConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #contactConfiguration(ContactConfiguration)}.
         * 
         * @param contactConfiguration
         *        a consumer that will call methods on {@link ContactConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contactConfiguration(ContactConfiguration)
         */
        default Builder contactConfiguration(Consumer<ContactConfiguration.Builder> contactConfiguration) {
            return contactConfiguration(ContactConfiguration.builder().applyMutation(contactConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String clientToken;

        private String pinpointAppArn;

        private String deviceToken;

        private String deviceType;

        private ContactConfiguration contactConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePushNotificationRegistrationRequest model) {
            super(model);
            instanceId(model.instanceId);
            clientToken(model.clientToken);
            pinpointAppArn(model.pinpointAppArn);
            deviceToken(model.deviceToken);
            deviceType(model.deviceType);
            contactConfiguration(model.contactConfiguration);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getPinpointAppArn() {
            return pinpointAppArn;
        }

        public final void setPinpointAppArn(String pinpointAppArn) {
            this.pinpointAppArn = pinpointAppArn;
        }

        @Override
        public final Builder pinpointAppArn(String pinpointAppArn) {
            this.pinpointAppArn = pinpointAppArn;
            return this;
        }

        public final String getDeviceToken() {
            return deviceToken;
        }

        public final void setDeviceToken(String deviceToken) {
            this.deviceToken = deviceToken;
        }

        @Override
        public final Builder deviceToken(String deviceToken) {
            this.deviceToken = deviceToken;
            return this;
        }

        public final String getDeviceType() {
            return deviceType;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        @Override
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        @Override
        public final Builder deviceType(DeviceType deviceType) {
            this.deviceType(deviceType == null ? null : deviceType.toString());
            return this;
        }

        public final ContactConfiguration.Builder getContactConfiguration() {
            return contactConfiguration != null ? contactConfiguration.toBuilder() : null;
        }

        public final void setContactConfiguration(ContactConfiguration.BuilderImpl contactConfiguration) {
            this.contactConfiguration = contactConfiguration != null ? contactConfiguration.build() : null;
        }

        @Override
        public final Builder contactConfiguration(ContactConfiguration contactConfiguration) {
            this.contactConfiguration = contactConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePushNotificationRegistrationRequest build() {
            return new CreatePushNotificationRegistrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
