/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateViewRequest extends ConnectRequest implements
        ToCopyableBuilder<CreateViewRequest.Builder, CreateViewRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreateViewRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CreateViewRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CreateViewRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<ViewInputContent> CONTENT_FIELD = SdkField.<ViewInputContent> builder(MarshallingType.SDK_POJO)
            .memberName("Content").getter(getter(CreateViewRequest::content)).setter(setter(Builder::content))
            .constructor(ViewInputContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateViewRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateViewRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateViewRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CLIENT_TOKEN_FIELD, STATUS_FIELD, CONTENT_FIELD, DESCRIPTION_FIELD, NAME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String clientToken;

    private final String status;

    private final ViewInputContent content;

    private final String description;

    private final String name;

    private final Map<String, String> tags;

    private CreateViewRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.clientToken = builder.clientToken;
        this.status = builder.status;
        this.content = builder.content;
        this.description = builder.description;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A unique Id for each create view request to avoid duplicate view creation. For example, the view is idempotent
     * ClientToken is provided.
     * </p>
     * 
     * @return A unique Id for each create view request to avoid duplicate view creation. For example, the view is
     *         idempotent ClientToken is provided.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The <code>PUBLISHED</code>
     * status will initiate validation on the content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ViewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The
     *         <code>PUBLISHED</code> status will initiate validation on the content.
     * @see ViewStatus
     */
    public final ViewStatus status() {
        return ViewStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The <code>PUBLISHED</code>
     * status will initiate validation on the content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ViewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The
     *         <code>PUBLISHED</code> status will initiate validation on the content.
     * @see ViewStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * View content containing all content necessary to render a view except for runtime input data.
     * </p>
     * <p>
     * The total uncompressed content has a maximum file size of 400kB.
     * </p>
     * 
     * @return View content containing all content necessary to render a view except for runtime input data.</p>
     *         <p>
     *         The total uncompressed content has a maximum file size of 400kB.
     */
    public final ViewInputContent content() {
        return content;
    }

    /**
     * <p>
     * The description of the view.
     * </p>
     * 
     * @return The description of the view.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the view.
     * </p>
     * 
     * @return The name of the view.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the view resource (not specific to view version).These tags can be used to organize,
     * track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the view resource (not specific to view version).These tags can be used to
     *         organize, track, or control access for this resource. For example, { "tags": {"key1":"value1",
     *         "key2":"value2"} }.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateViewRequest)) {
            return false;
        }
        CreateViewRequest other = (CreateViewRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(content(), other.content())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateViewRequest").add("InstanceId", instanceId()).add("ClientToken", clientToken())
                .add("Status", statusAsString()).add("Content", content()).add("Description", description())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateViewRequest, T> g) {
        return obj -> g.apply((CreateViewRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateViewRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A unique Id for each create view request to avoid duplicate view creation. For example, the view is
         * idempotent ClientToken is provided.
         * </p>
         * 
         * @param clientToken
         *        A unique Id for each create view request to avoid duplicate view creation. For example, the view is
         *        idempotent ClientToken is provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The <code>PUBLISHED</code>
         * status will initiate validation on the content.
         * </p>
         * 
         * @param status
         *        Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The
         *        <code>PUBLISHED</code> status will initiate validation on the content.
         * @see ViewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The <code>PUBLISHED</code>
         * status will initiate validation on the content.
         * </p>
         * 
         * @param status
         *        Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The
         *        <code>PUBLISHED</code> status will initiate validation on the content.
         * @see ViewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewStatus
         */
        Builder status(ViewStatus status);

        /**
         * <p>
         * View content containing all content necessary to render a view except for runtime input data.
         * </p>
         * <p>
         * The total uncompressed content has a maximum file size of 400kB.
         * </p>
         * 
         * @param content
         *        View content containing all content necessary to render a view except for runtime input data.</p>
         *        <p>
         *        The total uncompressed content has a maximum file size of 400kB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(ViewInputContent content);

        /**
         * <p>
         * View content containing all content necessary to render a view except for runtime input data.
         * </p>
         * <p>
         * The total uncompressed content has a maximum file size of 400kB.
         * </p>
         * This is a convenience method that creates an instance of the {@link ViewInputContent.Builder} avoiding the
         * need to create one manually via {@link ViewInputContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ViewInputContent.Builder#build()} is called immediately and its
         * result is passed to {@link #content(ViewInputContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link ViewInputContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(ViewInputContent)
         */
        default Builder content(Consumer<ViewInputContent.Builder> content) {
            return content(ViewInputContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The description of the view.
         * </p>
         * 
         * @param description
         *        The description of the view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the view.
         * </p>
         * 
         * @param name
         *        The name of the view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The tags associated with the view resource (not specific to view version).These tags can be used to organize,
         * track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags associated with the view resource (not specific to view version).These tags can be used to
         *        organize, track, or control access for this resource. For example, { "tags": {"key1":"value1",
         *        "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String clientToken;

        private String status;

        private ViewInputContent content;

        private String description;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateViewRequest model) {
            super(model);
            instanceId(model.instanceId);
            clientToken(model.clientToken);
            status(model.status);
            content(model.content);
            description(model.description);
            name(model.name);
            tags(model.tags);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ViewStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ViewInputContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(ViewInputContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(ViewInputContent content) {
            this.content = content;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateViewRequest build() {
            return new CreateViewRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
