/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the cross-channel routing behavior that allows an agent working on a contact in one channel to be offered a
 * contact from a different channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CrossChannelBehavior implements SdkPojo, Serializable,
        ToCopyableBuilder<CrossChannelBehavior.Builder, CrossChannelBehavior> {
    private static final SdkField<String> BEHAVIOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BehaviorType").getter(getter(CrossChannelBehavior::behaviorTypeAsString))
            .setter(setter(Builder::behaviorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BehaviorType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEHAVIOR_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String behaviorType;

    private CrossChannelBehavior(BuilderImpl builder) {
        this.behaviorType = builder.behaviorType;
    }

    /**
     * <p>
     * Specifies the other channels that can be routed to an agent handling their current channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #behaviorType} will
     * return {@link BehaviorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #behaviorTypeAsString}.
     * </p>
     * 
     * @return Specifies the other channels that can be routed to an agent handling their current channel.
     * @see BehaviorType
     */
    public final BehaviorType behaviorType() {
        return BehaviorType.fromValue(behaviorType);
    }

    /**
     * <p>
     * Specifies the other channels that can be routed to an agent handling their current channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #behaviorType} will
     * return {@link BehaviorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #behaviorTypeAsString}.
     * </p>
     * 
     * @return Specifies the other channels that can be routed to an agent handling their current channel.
     * @see BehaviorType
     */
    public final String behaviorTypeAsString() {
        return behaviorType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(behaviorTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrossChannelBehavior)) {
            return false;
        }
        CrossChannelBehavior other = (CrossChannelBehavior) obj;
        return Objects.equals(behaviorTypeAsString(), other.behaviorTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CrossChannelBehavior").add("BehaviorType", behaviorTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BehaviorType":
            return Optional.ofNullable(clazz.cast(behaviorTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BehaviorType", BEHAVIOR_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CrossChannelBehavior, T> g) {
        return obj -> g.apply((CrossChannelBehavior) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CrossChannelBehavior> {
        /**
         * <p>
         * Specifies the other channels that can be routed to an agent handling their current channel.
         * </p>
         * 
         * @param behaviorType
         *        Specifies the other channels that can be routed to an agent handling their current channel.
         * @see BehaviorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BehaviorType
         */
        Builder behaviorType(String behaviorType);

        /**
         * <p>
         * Specifies the other channels that can be routed to an agent handling their current channel.
         * </p>
         * 
         * @param behaviorType
         *        Specifies the other channels that can be routed to an agent handling their current channel.
         * @see BehaviorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BehaviorType
         */
        Builder behaviorType(BehaviorType behaviorType);
    }

    static final class BuilderImpl implements Builder {
        private String behaviorType;

        private BuilderImpl() {
        }

        private BuilderImpl(CrossChannelBehavior model) {
            behaviorType(model.behaviorType);
        }

        public final String getBehaviorType() {
            return behaviorType;
        }

        public final void setBehaviorType(String behaviorType) {
            this.behaviorType = behaviorType;
        }

        @Override
        public final Builder behaviorType(String behaviorType) {
            this.behaviorType = behaviorType;
            return this;
        }

        @Override
        public final Builder behaviorType(BehaviorType behaviorType) {
            this.behaviorType(behaviorType == null ? null : behaviorType.toString());
            return this;
        }

        @Override
        public CrossChannelBehavior build() {
            return new CrossChannelBehavior(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
