/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAgentStatusResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribeAgentStatusResponse.Builder, DescribeAgentStatusResponse> {
    private static final SdkField<AgentStatus> AGENT_STATUS_FIELD = SdkField.<AgentStatus> builder(MarshallingType.SDK_POJO)
            .memberName("AgentStatus").getter(getter(DescribeAgentStatusResponse::agentStatus))
            .setter(setter(Builder::agentStatus)).constructor(AgentStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AgentStatus agentStatus;

    private DescribeAgentStatusResponse(BuilderImpl builder) {
        super(builder);
        this.agentStatus = builder.agentStatus;
    }

    /**
     * <p>
     * The agent status.
     * </p>
     * 
     * @return The agent status.
     */
    public final AgentStatus agentStatus() {
        return agentStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgentStatusResponse)) {
            return false;
        }
        DescribeAgentStatusResponse other = (DescribeAgentStatusResponse) obj;
        return Objects.equals(agentStatus(), other.agentStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAgentStatusResponse").add("AgentStatus", agentStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgentStatus":
            return Optional.ofNullable(clazz.cast(agentStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AgentStatus", AGENT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAgentStatusResponse, T> g) {
        return obj -> g.apply((DescribeAgentStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAgentStatusResponse> {
        /**
         * <p>
         * The agent status.
         * </p>
         * 
         * @param agentStatus
         *        The agent status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentStatus(AgentStatus agentStatus);

        /**
         * <p>
         * The agent status.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentStatus.Builder} avoiding the need to
         * create one manually via {@link AgentStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentStatus.Builder#build()} is called immediately and its result
         * is passed to {@link #agentStatus(AgentStatus)}.
         * 
         * @param agentStatus
         *        a consumer that will call methods on {@link AgentStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentStatus(AgentStatus)
         */
        default Builder agentStatus(Consumer<AgentStatus.Builder> agentStatus) {
            return agentStatus(AgentStatus.builder().applyMutation(agentStatus).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private AgentStatus agentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAgentStatusResponse model) {
            super(model);
            agentStatus(model.agentStatus);
        }

        public final AgentStatus.Builder getAgentStatus() {
            return agentStatus != null ? agentStatus.toBuilder() : null;
        }

        public final void setAgentStatus(AgentStatus.BuilderImpl agentStatus) {
            this.agentStatus = agentStatus != null ? agentStatus.build() : null;
        }

        @Override
        public final Builder agentStatus(AgentStatus agentStatus) {
            this.agentStatus = agentStatus;
            return this;
        }

        @Override
        public DescribeAgentStatusResponse build() {
            return new DescribeAgentStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
