/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHoursOfOperationOverrideResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribeHoursOfOperationOverrideResponse.Builder, DescribeHoursOfOperationOverrideResponse> {
    private static final SdkField<HoursOfOperationOverride> HOURS_OF_OPERATION_OVERRIDE_FIELD = SdkField
            .<HoursOfOperationOverride> builder(MarshallingType.SDK_POJO).memberName("HoursOfOperationOverride")
            .getter(getter(DescribeHoursOfOperationOverrideResponse::hoursOfOperationOverride))
            .setter(setter(Builder::hoursOfOperationOverride)).constructor(HoursOfOperationOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperationOverride").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(HOURS_OF_OPERATION_OVERRIDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final HoursOfOperationOverride hoursOfOperationOverride;

    private DescribeHoursOfOperationOverrideResponse(BuilderImpl builder) {
        super(builder);
        this.hoursOfOperationOverride = builder.hoursOfOperationOverride;
    }

    /**
     * <p>
     * Information about the hours of operations override.
     * </p>
     * 
     * @return Information about the hours of operations override.
     */
    public final HoursOfOperationOverride hoursOfOperationOverride() {
        return hoursOfOperationOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hoursOfOperationOverride());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHoursOfOperationOverrideResponse)) {
            return false;
        }
        DescribeHoursOfOperationOverrideResponse other = (DescribeHoursOfOperationOverrideResponse) obj;
        return Objects.equals(hoursOfOperationOverride(), other.hoursOfOperationOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeHoursOfOperationOverrideResponse")
                .add("HoursOfOperationOverride", hoursOfOperationOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HoursOfOperationOverride":
            return Optional.ofNullable(clazz.cast(hoursOfOperationOverride()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HoursOfOperationOverride", HOURS_OF_OPERATION_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeHoursOfOperationOverrideResponse, T> g) {
        return obj -> g.apply((DescribeHoursOfOperationOverrideResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeHoursOfOperationOverrideResponse> {
        /**
         * <p>
         * Information about the hours of operations override.
         * </p>
         * 
         * @param hoursOfOperationOverride
         *        Information about the hours of operations override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hoursOfOperationOverride(HoursOfOperationOverride hoursOfOperationOverride);

        /**
         * <p>
         * Information about the hours of operations override.
         * </p>
         * This is a convenience method that creates an instance of the {@link HoursOfOperationOverride.Builder}
         * avoiding the need to create one manually via {@link HoursOfOperationOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HoursOfOperationOverride.Builder#build()} is called immediately
         * and its result is passed to {@link #hoursOfOperationOverride(HoursOfOperationOverride)}.
         * 
         * @param hoursOfOperationOverride
         *        a consumer that will call methods on {@link HoursOfOperationOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hoursOfOperationOverride(HoursOfOperationOverride)
         */
        default Builder hoursOfOperationOverride(Consumer<HoursOfOperationOverride.Builder> hoursOfOperationOverride) {
            return hoursOfOperationOverride(HoursOfOperationOverride.builder().applyMutation(hoursOfOperationOverride).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private HoursOfOperationOverride hoursOfOperationOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHoursOfOperationOverrideResponse model) {
            super(model);
            hoursOfOperationOverride(model.hoursOfOperationOverride);
        }

        public final HoursOfOperationOverride.Builder getHoursOfOperationOverride() {
            return hoursOfOperationOverride != null ? hoursOfOperationOverride.toBuilder() : null;
        }

        public final void setHoursOfOperationOverride(HoursOfOperationOverride.BuilderImpl hoursOfOperationOverride) {
            this.hoursOfOperationOverride = hoursOfOperationOverride != null ? hoursOfOperationOverride.build() : null;
        }

        @Override
        public final Builder hoursOfOperationOverride(HoursOfOperationOverride hoursOfOperationOverride) {
            this.hoursOfOperationOverride = hoursOfOperationOverride;
            return this;
        }

        @Override
        public DescribeHoursOfOperationOverrideResponse build() {
            return new DescribeHoursOfOperationOverrideResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
