/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHoursOfOperationResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribeHoursOfOperationResponse.Builder, DescribeHoursOfOperationResponse> {
    private static final SdkField<HoursOfOperation> HOURS_OF_OPERATION_FIELD = SdkField
            .<HoursOfOperation> builder(MarshallingType.SDK_POJO).memberName("HoursOfOperation")
            .getter(getter(DescribeHoursOfOperationResponse::hoursOfOperation)).setter(setter(Builder::hoursOfOperation))
            .constructor(HoursOfOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOURS_OF_OPERATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final HoursOfOperation hoursOfOperation;

    private DescribeHoursOfOperationResponse(BuilderImpl builder) {
        super(builder);
        this.hoursOfOperation = builder.hoursOfOperation;
    }

    /**
     * <p>
     * The hours of operation.
     * </p>
     * 
     * @return The hours of operation.
     */
    public final HoursOfOperation hoursOfOperation() {
        return hoursOfOperation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hoursOfOperation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHoursOfOperationResponse)) {
            return false;
        }
        DescribeHoursOfOperationResponse other = (DescribeHoursOfOperationResponse) obj;
        return Objects.equals(hoursOfOperation(), other.hoursOfOperation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeHoursOfOperationResponse").add("HoursOfOperation", hoursOfOperation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HoursOfOperation":
            return Optional.ofNullable(clazz.cast(hoursOfOperation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HoursOfOperation", HOURS_OF_OPERATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeHoursOfOperationResponse, T> g) {
        return obj -> g.apply((DescribeHoursOfOperationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeHoursOfOperationResponse> {
        /**
         * <p>
         * The hours of operation.
         * </p>
         * 
         * @param hoursOfOperation
         *        The hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hoursOfOperation(HoursOfOperation hoursOfOperation);

        /**
         * <p>
         * The hours of operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link HoursOfOperation.Builder} avoiding the
         * need to create one manually via {@link HoursOfOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HoursOfOperation.Builder#build()} is called immediately and its
         * result is passed to {@link #hoursOfOperation(HoursOfOperation)}.
         * 
         * @param hoursOfOperation
         *        a consumer that will call methods on {@link HoursOfOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hoursOfOperation(HoursOfOperation)
         */
        default Builder hoursOfOperation(Consumer<HoursOfOperation.Builder> hoursOfOperation) {
            return hoursOfOperation(HoursOfOperation.builder().applyMutation(hoursOfOperation).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private HoursOfOperation hoursOfOperation;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHoursOfOperationResponse model) {
            super(model);
            hoursOfOperation(model.hoursOfOperation);
        }

        public final HoursOfOperation.Builder getHoursOfOperation() {
            return hoursOfOperation != null ? hoursOfOperation.toBuilder() : null;
        }

        public final void setHoursOfOperation(HoursOfOperation.BuilderImpl hoursOfOperation) {
            this.hoursOfOperation = hoursOfOperation != null ? hoursOfOperation.build() : null;
        }

        @Override
        public final Builder hoursOfOperation(HoursOfOperation hoursOfOperation) {
            this.hoursOfOperation = hoursOfOperation;
            return this;
        }

        @Override
        public DescribeHoursOfOperationResponse build() {
            return new DescribeHoursOfOperationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
