/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePhoneNumberResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribePhoneNumberResponse.Builder, DescribePhoneNumberResponse> {
    private static final SdkField<ClaimedPhoneNumberSummary> CLAIMED_PHONE_NUMBER_SUMMARY_FIELD = SdkField
            .<ClaimedPhoneNumberSummary> builder(MarshallingType.SDK_POJO).memberName("ClaimedPhoneNumberSummary")
            .getter(getter(DescribePhoneNumberResponse::claimedPhoneNumberSummary))
            .setter(setter(Builder::claimedPhoneNumberSummary)).constructor(ClaimedPhoneNumberSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClaimedPhoneNumberSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CLAIMED_PHONE_NUMBER_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ClaimedPhoneNumberSummary claimedPhoneNumberSummary;

    private DescribePhoneNumberResponse(BuilderImpl builder) {
        super(builder);
        this.claimedPhoneNumberSummary = builder.claimedPhoneNumberSummary;
    }

    /**
     * <p>
     * Information about a phone number that's been claimed to your Amazon Connect instance or traffic distribution
     * group.
     * </p>
     * 
     * @return Information about a phone number that's been claimed to your Amazon Connect instance or traffic
     *         distribution group.
     */
    public final ClaimedPhoneNumberSummary claimedPhoneNumberSummary() {
        return claimedPhoneNumberSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(claimedPhoneNumberSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePhoneNumberResponse)) {
            return false;
        }
        DescribePhoneNumberResponse other = (DescribePhoneNumberResponse) obj;
        return Objects.equals(claimedPhoneNumberSummary(), other.claimedPhoneNumberSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePhoneNumberResponse").add("ClaimedPhoneNumberSummary", claimedPhoneNumberSummary())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClaimedPhoneNumberSummary":
            return Optional.ofNullable(clazz.cast(claimedPhoneNumberSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClaimedPhoneNumberSummary", CLAIMED_PHONE_NUMBER_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePhoneNumberResponse, T> g) {
        return obj -> g.apply((DescribePhoneNumberResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePhoneNumberResponse> {
        /**
         * <p>
         * Information about a phone number that's been claimed to your Amazon Connect instance or traffic distribution
         * group.
         * </p>
         * 
         * @param claimedPhoneNumberSummary
         *        Information about a phone number that's been claimed to your Amazon Connect instance or traffic
         *        distribution group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder claimedPhoneNumberSummary(ClaimedPhoneNumberSummary claimedPhoneNumberSummary);

        /**
         * <p>
         * Information about a phone number that's been claimed to your Amazon Connect instance or traffic distribution
         * group.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClaimedPhoneNumberSummary.Builder}
         * avoiding the need to create one manually via {@link ClaimedPhoneNumberSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClaimedPhoneNumberSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #claimedPhoneNumberSummary(ClaimedPhoneNumberSummary)}.
         * 
         * @param claimedPhoneNumberSummary
         *        a consumer that will call methods on {@link ClaimedPhoneNumberSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #claimedPhoneNumberSummary(ClaimedPhoneNumberSummary)
         */
        default Builder claimedPhoneNumberSummary(Consumer<ClaimedPhoneNumberSummary.Builder> claimedPhoneNumberSummary) {
            return claimedPhoneNumberSummary(ClaimedPhoneNumberSummary.builder().applyMutation(claimedPhoneNumberSummary).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private ClaimedPhoneNumberSummary claimedPhoneNumberSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePhoneNumberResponse model) {
            super(model);
            claimedPhoneNumberSummary(model.claimedPhoneNumberSummary);
        }

        public final ClaimedPhoneNumberSummary.Builder getClaimedPhoneNumberSummary() {
            return claimedPhoneNumberSummary != null ? claimedPhoneNumberSummary.toBuilder() : null;
        }

        public final void setClaimedPhoneNumberSummary(ClaimedPhoneNumberSummary.BuilderImpl claimedPhoneNumberSummary) {
            this.claimedPhoneNumberSummary = claimedPhoneNumberSummary != null ? claimedPhoneNumberSummary.build() : null;
        }

        @Override
        public final Builder claimedPhoneNumberSummary(ClaimedPhoneNumberSummary claimedPhoneNumberSummary) {
            this.claimedPhoneNumberSummary = claimedPhoneNumberSummary;
            return this;
        }

        @Override
        public DescribePhoneNumberResponse build() {
            return new DescribePhoneNumberResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
