/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrafficDistributionGroupResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribeTrafficDistributionGroupResponse.Builder, DescribeTrafficDistributionGroupResponse> {
    private static final SdkField<TrafficDistributionGroup> TRAFFIC_DISTRIBUTION_GROUP_FIELD = SdkField
            .<TrafficDistributionGroup> builder(MarshallingType.SDK_POJO).memberName("TrafficDistributionGroup")
            .getter(getter(DescribeTrafficDistributionGroupResponse::trafficDistributionGroup))
            .setter(setter(Builder::trafficDistributionGroup)).constructor(TrafficDistributionGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficDistributionGroup").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRAFFIC_DISTRIBUTION_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TrafficDistributionGroup trafficDistributionGroup;

    private DescribeTrafficDistributionGroupResponse(BuilderImpl builder) {
        super(builder);
        this.trafficDistributionGroup = builder.trafficDistributionGroup;
    }

    /**
     * <p>
     * Information about the traffic distribution group.
     * </p>
     * 
     * @return Information about the traffic distribution group.
     */
    public final TrafficDistributionGroup trafficDistributionGroup() {
        return trafficDistributionGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trafficDistributionGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrafficDistributionGroupResponse)) {
            return false;
        }
        DescribeTrafficDistributionGroupResponse other = (DescribeTrafficDistributionGroupResponse) obj;
        return Objects.equals(trafficDistributionGroup(), other.trafficDistributionGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTrafficDistributionGroupResponse")
                .add("TrafficDistributionGroup", trafficDistributionGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficDistributionGroup":
            return Optional.ofNullable(clazz.cast(trafficDistributionGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrafficDistributionGroup", TRAFFIC_DISTRIBUTION_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrafficDistributionGroupResponse, T> g) {
        return obj -> g.apply((DescribeTrafficDistributionGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTrafficDistributionGroupResponse> {
        /**
         * <p>
         * Information about the traffic distribution group.
         * </p>
         * 
         * @param trafficDistributionGroup
         *        Information about the traffic distribution group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficDistributionGroup(TrafficDistributionGroup trafficDistributionGroup);

        /**
         * <p>
         * Information about the traffic distribution group.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrafficDistributionGroup.Builder}
         * avoiding the need to create one manually via {@link TrafficDistributionGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrafficDistributionGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #trafficDistributionGroup(TrafficDistributionGroup)}.
         * 
         * @param trafficDistributionGroup
         *        a consumer that will call methods on {@link TrafficDistributionGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficDistributionGroup(TrafficDistributionGroup)
         */
        default Builder trafficDistributionGroup(Consumer<TrafficDistributionGroup.Builder> trafficDistributionGroup) {
            return trafficDistributionGroup(TrafficDistributionGroup.builder().applyMutation(trafficDistributionGroup).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private TrafficDistributionGroup trafficDistributionGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrafficDistributionGroupResponse model) {
            super(model);
            trafficDistributionGroup(model.trafficDistributionGroup);
        }

        public final TrafficDistributionGroup.Builder getTrafficDistributionGroup() {
            return trafficDistributionGroup != null ? trafficDistributionGroup.toBuilder() : null;
        }

        public final void setTrafficDistributionGroup(TrafficDistributionGroup.BuilderImpl trafficDistributionGroup) {
            this.trafficDistributionGroup = trafficDistributionGroup != null ? trafficDistributionGroup.build() : null;
        }

        @Override
        public final Builder trafficDistributionGroup(TrafficDistributionGroup trafficDistributionGroup) {
            this.trafficDistributionGroup = trafficDistributionGroup;
            return this;
        }

        @Override
        public DescribeTrafficDistributionGroupResponse build() {
            return new DescribeTrafficDistributionGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
