/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information regarding the device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceInfo implements SdkPojo, Serializable, ToCopyableBuilder<DeviceInfo.Builder, DeviceInfo> {
    private static final SdkField<String> PLATFORM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformName").getter(getter(DeviceInfo::platformName)).setter(setter(Builder::platformName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformName").build()).build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformVersion").getter(getter(DeviceInfo::platformVersion)).setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()).build();

    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperatingSystem").getter(getter(DeviceInfo::operatingSystem)).setter(setter(Builder::operatingSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_NAME_FIELD,
            PLATFORM_VERSION_FIELD, OPERATING_SYSTEM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String platformName;

    private final String platformVersion;

    private final String operatingSystem;

    private DeviceInfo(BuilderImpl builder) {
        this.platformName = builder.platformName;
        this.platformVersion = builder.platformVersion;
        this.operatingSystem = builder.operatingSystem;
    }

    /**
     * <p>
     * Name of the platform that the participant used for the call.
     * </p>
     * 
     * @return Name of the platform that the participant used for the call.
     */
    public final String platformName() {
        return platformName;
    }

    /**
     * <p>
     * Version of the platform that the participant used for the call.
     * </p>
     * 
     * @return Version of the platform that the participant used for the call.
     */
    public final String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * Operating system that the participant used for the call.
     * </p>
     * 
     * @return Operating system that the participant used for the call.
     */
    public final String operatingSystem() {
        return operatingSystem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(platformName());
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystem());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceInfo)) {
            return false;
        }
        DeviceInfo other = (DeviceInfo) obj;
        return Objects.equals(platformName(), other.platformName()) && Objects.equals(platformVersion(), other.platformVersion())
                && Objects.equals(operatingSystem(), other.operatingSystem());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceInfo").add("PlatformName", platformName()).add("PlatformVersion", platformVersion())
                .add("OperatingSystem", operatingSystem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformName":
            return Optional.ofNullable(clazz.cast(platformName()));
        case "PlatformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "OperatingSystem":
            return Optional.ofNullable(clazz.cast(operatingSystem()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PlatformName", PLATFORM_NAME_FIELD);
        map.put("PlatformVersion", PLATFORM_VERSION_FIELD);
        map.put("OperatingSystem", OPERATING_SYSTEM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeviceInfo, T> g) {
        return obj -> g.apply((DeviceInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceInfo> {
        /**
         * <p>
         * Name of the platform that the participant used for the call.
         * </p>
         * 
         * @param platformName
         *        Name of the platform that the participant used for the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformName(String platformName);

        /**
         * <p>
         * Version of the platform that the participant used for the call.
         * </p>
         * 
         * @param platformVersion
         *        Version of the platform that the participant used for the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * Operating system that the participant used for the call.
         * </p>
         * 
         * @param operatingSystem
         *        Operating system that the participant used for the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystem(String operatingSystem);
    }

    static final class BuilderImpl implements Builder {
        private String platformName;

        private String platformVersion;

        private String operatingSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceInfo model) {
            platformName(model.platformName);
            platformVersion(model.platformVersion);
            operatingSystem(model.operatingSystem);
        }

        public final String getPlatformName() {
            return platformName;
        }

        public final void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        @Override
        public final Builder platformName(String platformName) {
            this.platformName = platformName;
            return this;
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final String getOperatingSystem() {
            return operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public DeviceInfo build() {
            return new DeviceInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
