/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an email address for a contact center.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailAddressMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<EmailAddressMetadata.Builder, EmailAddressMetadata> {
    private static final SdkField<String> EMAIL_ADDRESS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddressId").getter(getter(EmailAddressMetadata::emailAddressId))
            .setter(setter(Builder::emailAddressId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddressId").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddressArn").getter(getter(EmailAddressMetadata::emailAddressArn))
            .setter(setter(Builder::emailAddressArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddressArn").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddress").getter(getter(EmailAddressMetadata::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(EmailAddressMetadata::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(EmailAddressMetadata::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_ADDRESS_ID_FIELD,
            EMAIL_ADDRESS_ARN_FIELD, EMAIL_ADDRESS_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String emailAddressId;

    private final String emailAddressArn;

    private final String emailAddress;

    private final String description;

    private final String displayName;

    private EmailAddressMetadata(BuilderImpl builder) {
        this.emailAddressId = builder.emailAddressId;
        this.emailAddressArn = builder.emailAddressArn;
        this.emailAddress = builder.emailAddress;
        this.description = builder.description;
        this.displayName = builder.displayName;
    }

    /**
     * <p>
     * The identifier of the email address.
     * </p>
     * 
     * @return The identifier of the email address.
     */
    public final String emailAddressId() {
        return emailAddressId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the email address.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the email address.
     */
    public final String emailAddressArn() {
        return emailAddressArn;
    }

    /**
     * <p>
     * The email address with the instance, in [^\s@]+@[^\s@]+\.[^\s@]+ format.
     * </p>
     * 
     * @return The email address with the instance, in [^\s@]+@[^\s@]+\.[^\s@]+ format.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * The description of the email address.
     * </p>
     * 
     * @return The description of the email address.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The display name of email address.
     * </p>
     * 
     * @return The display name of email address.
     */
    public final String displayName() {
        return displayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(emailAddressId());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddressArn());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailAddressMetadata)) {
            return false;
        }
        EmailAddressMetadata other = (EmailAddressMetadata) obj;
        return Objects.equals(emailAddressId(), other.emailAddressId())
                && Objects.equals(emailAddressArn(), other.emailAddressArn())
                && Objects.equals(emailAddress(), other.emailAddress()) && Objects.equals(description(), other.description())
                && Objects.equals(displayName(), other.displayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailAddressMetadata").add("EmailAddressId", emailAddressId())
                .add("EmailAddressArn", emailAddressArn())
                .add("EmailAddress", emailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailAddressId":
            return Optional.ofNullable(clazz.cast(emailAddressId()));
        case "EmailAddressArn":
            return Optional.ofNullable(clazz.cast(emailAddressArn()));
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EmailAddressId", EMAIL_ADDRESS_ID_FIELD);
        map.put("EmailAddressArn", EMAIL_ADDRESS_ARN_FIELD);
        map.put("EmailAddress", EMAIL_ADDRESS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailAddressMetadata, T> g) {
        return obj -> g.apply((EmailAddressMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailAddressMetadata> {
        /**
         * <p>
         * The identifier of the email address.
         * </p>
         * 
         * @param emailAddressId
         *        The identifier of the email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddressId(String emailAddressId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the email address.
         * </p>
         * 
         * @param emailAddressArn
         *        The Amazon Resource Name (ARN) of the email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddressArn(String emailAddressArn);

        /**
         * <p>
         * The email address with the instance, in [^\s@]+@[^\s@]+\.[^\s@]+ format.
         * </p>
         * 
         * @param emailAddress
         *        The email address with the instance, in [^\s@]+@[^\s@]+\.[^\s@]+ format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The description of the email address.
         * </p>
         * 
         * @param description
         *        The description of the email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The display name of email address.
         * </p>
         * 
         * @param displayName
         *        The display name of email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);
    }

    static final class BuilderImpl implements Builder {
        private String emailAddressId;

        private String emailAddressArn;

        private String emailAddress;

        private String description;

        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailAddressMetadata model) {
            emailAddressId(model.emailAddressId);
            emailAddressArn(model.emailAddressArn);
            emailAddress(model.emailAddress);
            description(model.description);
            displayName(model.displayName);
        }

        public final String getEmailAddressId() {
            return emailAddressId;
        }

        public final void setEmailAddressId(String emailAddressId) {
            this.emailAddressId = emailAddressId;
        }

        @Override
        public final Builder emailAddressId(String emailAddressId) {
            this.emailAddressId = emailAddressId;
            return this;
        }

        public final String getEmailAddressArn() {
            return emailAddressArn;
        }

        public final void setEmailAddressArn(String emailAddressArn) {
            this.emailAddressArn = emailAddressArn;
        }

        @Override
        public final Builder emailAddressArn(String emailAddressArn) {
            this.emailAddressArn = emailAddressArn;
            return this;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public EmailAddressMetadata build() {
            return new EmailAddressMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
