/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the email recipient
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailRecipient implements SdkPojo, Serializable, ToCopyableBuilder<EmailRecipient.Builder, EmailRecipient> {
    private static final SdkField<String> ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Address")
            .getter(getter(EmailRecipient::address)).setter(setter(Builder::address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(EmailRecipient::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD,
            DISPLAY_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String address;

    private final String displayName;

    private EmailRecipient(BuilderImpl builder) {
        this.address = builder.address;
        this.displayName = builder.displayName;
    }

    /**
     * <p>
     * Address of the email recipient.
     * </p>
     * <p>
     * Type: String
     * </p>
     * <p>
     * Length Constraints: Minimum length of 1. Maximum length of 256.
     * </p>
     * 
     * @return Address of the email recipient.</p>
     *         <p>
     *         Type: String
     *         </p>
     *         <p>
     *         Length Constraints: Minimum length of 1. Maximum length of 256.
     */
    public final String address() {
        return address;
    }

    /**
     * <p>
     * Display name of the email recipient.
     * </p>
     * <p>
     * Type: String
     * </p>
     * <p>
     * Length Constraints: Minimum length of 1. Maximum length of 256.
     * </p>
     * 
     * @return Display name of the email recipient.</p>
     *         <p>
     *         Type: String
     *         </p>
     *         <p>
     *         Length Constraints: Minimum length of 1. Maximum length of 256.
     */
    public final String displayName() {
        return displayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailRecipient)) {
            return false;
        }
        EmailRecipient other = (EmailRecipient) obj;
        return Objects.equals(address(), other.address()) && Objects.equals(displayName(), other.displayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailRecipient").add("Address", address()).add("DisplayName", displayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Address", ADDRESS_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailRecipient, T> g) {
        return obj -> g.apply((EmailRecipient) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailRecipient> {
        /**
         * <p>
         * Address of the email recipient.
         * </p>
         * <p>
         * Type: String
         * </p>
         * <p>
         * Length Constraints: Minimum length of 1. Maximum length of 256.
         * </p>
         * 
         * @param address
         *        Address of the email recipient.</p>
         *        <p>
         *        Type: String
         *        </p>
         *        <p>
         *        Length Constraints: Minimum length of 1. Maximum length of 256.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        /**
         * <p>
         * Display name of the email recipient.
         * </p>
         * <p>
         * Type: String
         * </p>
         * <p>
         * Length Constraints: Minimum length of 1. Maximum length of 256.
         * </p>
         * 
         * @param displayName
         *        Display name of the email recipient.</p>
         *        <p>
         *        Type: String
         *        </p>
         *        <p>
         *        Length Constraints: Minimum length of 1. Maximum length of 256.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);
    }

    static final class BuilderImpl implements Builder {
        private String address;

        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailRecipient model) {
            address(model.address);
            displayName(model.displayName);
        }

        public final String getAddress() {
            return address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public EmailRecipient build() {
            return new EmailRecipient(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
