/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the evaluation form.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationForm implements SdkPojo, Serializable, ToCopyableBuilder<EvaluationForm.Builder, EvaluationForm> {
    private static final SdkField<String> EVALUATION_FORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationFormId").getter(getter(EvaluationForm::evaluationFormId))
            .setter(setter(Builder::evaluationFormId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormId").build()).build();

    private static final SdkField<Integer> EVALUATION_FORM_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EvaluationFormVersion").getter(getter(EvaluationForm::evaluationFormVersion))
            .setter(setter(Builder::evaluationFormVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormVersion").build())
            .build();

    private static final SdkField<Boolean> LOCKED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Locked").getter(getter(EvaluationForm::locked)).setter(setter(Builder::locked))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locked").build()).build();

    private static final SdkField<String> EVALUATION_FORM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationFormArn").getter(getter(EvaluationForm::evaluationFormArn))
            .setter(setter(Builder::evaluationFormArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormArn").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(EvaluationForm::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(EvaluationForm::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(EvaluationForm::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<EvaluationFormItem>> ITEMS_FIELD = SdkField
            .<List<EvaluationFormItem>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(EvaluationForm::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationFormItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationFormItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EvaluationFormScoringStrategy> SCORING_STRATEGY_FIELD = SdkField
            .<EvaluationFormScoringStrategy> builder(MarshallingType.SDK_POJO).memberName("ScoringStrategy")
            .getter(getter(EvaluationForm::scoringStrategy)).setter(setter(Builder::scoringStrategy))
            .constructor(EvaluationFormScoringStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoringStrategy").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(EvaluationForm::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(EvaluationForm::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(EvaluationForm::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedBy").getter(getter(EvaluationForm::lastModifiedBy)).setter(setter(Builder::lastModifiedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(EvaluationForm::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_FORM_ID_FIELD,
            EVALUATION_FORM_VERSION_FIELD, LOCKED_FIELD, EVALUATION_FORM_ARN_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, STATUS_FIELD,
            ITEMS_FIELD, SCORING_STRATEGY_FIELD, CREATED_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD,
            LAST_MODIFIED_BY_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String evaluationFormId;

    private final Integer evaluationFormVersion;

    private final Boolean locked;

    private final String evaluationFormArn;

    private final String title;

    private final String description;

    private final String status;

    private final List<EvaluationFormItem> items;

    private final EvaluationFormScoringStrategy scoringStrategy;

    private final Instant createdTime;

    private final String createdBy;

    private final Instant lastModifiedTime;

    private final String lastModifiedBy;

    private final Map<String, String> tags;

    private EvaluationForm(BuilderImpl builder) {
        this.evaluationFormId = builder.evaluationFormId;
        this.evaluationFormVersion = builder.evaluationFormVersion;
        this.locked = builder.locked;
        this.evaluationFormArn = builder.evaluationFormArn;
        this.title = builder.title;
        this.description = builder.description;
        this.status = builder.status;
        this.items = builder.items;
        this.scoringStrategy = builder.scoringStrategy;
        this.createdTime = builder.createdTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique identifier for the evaluation form.
     * </p>
     * 
     * @return The unique identifier for the evaluation form.
     */
    public final String evaluationFormId() {
        return evaluationFormId;
    }

    /**
     * <p>
     * A version of the evaluation form.
     * </p>
     * 
     * @return A version of the evaluation form.
     */
    public final Integer evaluationFormVersion() {
        return evaluationFormVersion;
    }

    /**
     * <p>
     * The flag indicating whether the evaluation form is locked for changes.
     * </p>
     * 
     * @return The flag indicating whether the evaluation form is locked for changes.
     */
    public final Boolean locked() {
        return locked;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the evaluation form resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the evaluation form resource.
     */
    public final String evaluationFormArn() {
        return evaluationFormArn;
    }

    /**
     * <p>
     * A title of the evaluation form.
     * </p>
     * 
     * @return A title of the evaluation form.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The description of the evaluation form.
     * </p>
     * 
     * @return The description of the evaluation form.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The status of the evaluation form.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EvaluationFormVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the evaluation form.
     * @see EvaluationFormVersionStatus
     */
    public final EvaluationFormVersionStatus status() {
        return EvaluationFormVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the evaluation form.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EvaluationFormVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the evaluation form.
     * @see EvaluationFormVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Items that are part of the evaluation form. The total number of sections and questions must not exceed 100 each.
     * Questions must be contained in a section.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return Items that are part of the evaluation form. The total number of sections and questions must not exceed
     *         100 each. Questions must be contained in a section.
     */
    public final List<EvaluationFormItem> items() {
        return items;
    }

    /**
     * <p>
     * A scoring strategy of the evaluation form.
     * </p>
     * 
     * @return A scoring strategy of the evaluation form.
     */
    public final EvaluationFormScoringStrategy scoringStrategy() {
        return scoringStrategy;
    }

    /**
     * <p>
     * The timestamp for when the evaluation form was created.
     * </p>
     * 
     * @return The timestamp for when the evaluation form was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who created the evaluation form.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who created the evaluation form.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The timestamp for when the evaluation form was last updated.
     * </p>
     * 
     * @return The timestamp for when the evaluation form was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who last updated the evaluation form.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who last updated the evaluation form.
     */
    public final String lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example, { "Tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluationFormId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationFormVersion());
        hashCode = 31 * hashCode + Objects.hashCode(locked());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationFormArn());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scoringStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationForm)) {
            return false;
        }
        EvaluationForm other = (EvaluationForm) obj;
        return Objects.equals(evaluationFormId(), other.evaluationFormId())
                && Objects.equals(evaluationFormVersion(), other.evaluationFormVersion())
                && Objects.equals(locked(), other.locked()) && Objects.equals(evaluationFormArn(), other.evaluationFormArn())
                && Objects.equals(title(), other.title()) && Objects.equals(description(), other.description())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items()) && Objects.equals(scoringStrategy(), other.scoringStrategy())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationForm").add("EvaluationFormId", evaluationFormId())
                .add("EvaluationFormVersion", evaluationFormVersion()).add("Locked", locked())
                .add("EvaluationFormArn", evaluationFormArn()).add("Title", title()).add("Description", description())
                .add("Status", statusAsString()).add("Items", hasItems() ? items() : null)
                .add("ScoringStrategy", scoringStrategy()).add("CreatedTime", createdTime()).add("CreatedBy", createdBy())
                .add("LastModifiedTime", lastModifiedTime()).add("LastModifiedBy", lastModifiedBy())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationFormId":
            return Optional.ofNullable(clazz.cast(evaluationFormId()));
        case "EvaluationFormVersion":
            return Optional.ofNullable(clazz.cast(evaluationFormVersion()));
        case "Locked":
            return Optional.ofNullable(clazz.cast(locked()));
        case "EvaluationFormArn":
            return Optional.ofNullable(clazz.cast(evaluationFormArn()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "ScoringStrategy":
            return Optional.ofNullable(clazz.cast(scoringStrategy()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EvaluationFormId", EVALUATION_FORM_ID_FIELD);
        map.put("EvaluationFormVersion", EVALUATION_FORM_VERSION_FIELD);
        map.put("Locked", LOCKED_FIELD);
        map.put("EvaluationFormArn", EVALUATION_FORM_ARN_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Items", ITEMS_FIELD);
        map.put("ScoringStrategy", SCORING_STRATEGY_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationForm, T> g) {
        return obj -> g.apply((EvaluationForm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationForm> {
        /**
         * <p>
         * The unique identifier for the evaluation form.
         * </p>
         * 
         * @param evaluationFormId
         *        The unique identifier for the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationFormId(String evaluationFormId);

        /**
         * <p>
         * A version of the evaluation form.
         * </p>
         * 
         * @param evaluationFormVersion
         *        A version of the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationFormVersion(Integer evaluationFormVersion);

        /**
         * <p>
         * The flag indicating whether the evaluation form is locked for changes.
         * </p>
         * 
         * @param locked
         *        The flag indicating whether the evaluation form is locked for changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locked(Boolean locked);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the evaluation form resource.
         * </p>
         * 
         * @param evaluationFormArn
         *        The Amazon Resource Name (ARN) for the evaluation form resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationFormArn(String evaluationFormArn);

        /**
         * <p>
         * A title of the evaluation form.
         * </p>
         * 
         * @param title
         *        A title of the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The description of the evaluation form.
         * </p>
         * 
         * @param description
         *        The description of the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of the evaluation form.
         * </p>
         * 
         * @param status
         *        The status of the evaluation form.
         * @see EvaluationFormVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the evaluation form.
         * </p>
         * 
         * @param status
         *        The status of the evaluation form.
         * @see EvaluationFormVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormVersionStatus
         */
        Builder status(EvaluationFormVersionStatus status);

        /**
         * <p>
         * Items that are part of the evaluation form. The total number of sections and questions must not exceed 100
         * each. Questions must be contained in a section.
         * </p>
         * 
         * @param items
         *        Items that are part of the evaluation form. The total number of sections and questions must not exceed
         *        100 each. Questions must be contained in a section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<EvaluationFormItem> items);

        /**
         * <p>
         * Items that are part of the evaluation form. The total number of sections and questions must not exceed 100
         * each. Questions must be contained in a section.
         * </p>
         * 
         * @param items
         *        Items that are part of the evaluation form. The total number of sections and questions must not exceed
         *        100 each. Questions must be contained in a section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(EvaluationFormItem... items);

        /**
         * <p>
         * Items that are part of the evaluation form. The total number of sections and questions must not exceed 100
         * each. Questions must be contained in a section.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.EvaluationFormItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormItem.Builder#build()} is called
         * immediately and its result is passed to {@link #items(List<EvaluationFormItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EvaluationFormItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<EvaluationFormItem>)
         */
        Builder items(Consumer<EvaluationFormItem.Builder>... items);

        /**
         * <p>
         * A scoring strategy of the evaluation form.
         * </p>
         * 
         * @param scoringStrategy
         *        A scoring strategy of the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoringStrategy(EvaluationFormScoringStrategy scoringStrategy);

        /**
         * <p>
         * A scoring strategy of the evaluation form.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationFormScoringStrategy.Builder}
         * avoiding the need to create one manually via {@link EvaluationFormScoringStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationFormScoringStrategy.Builder#build()} is called
         * immediately and its result is passed to {@link #scoringStrategy(EvaluationFormScoringStrategy)}.
         * 
         * @param scoringStrategy
         *        a consumer that will call methods on {@link EvaluationFormScoringStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scoringStrategy(EvaluationFormScoringStrategy)
         */
        default Builder scoringStrategy(Consumer<EvaluationFormScoringStrategy.Builder> scoringStrategy) {
            return scoringStrategy(EvaluationFormScoringStrategy.builder().applyMutation(scoringStrategy).build());
        }

        /**
         * <p>
         * The timestamp for when the evaluation form was created.
         * </p>
         * 
         * @param createdTime
         *        The timestamp for when the evaluation form was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who created the evaluation form.
         * </p>
         * 
         * @param createdBy
         *        The Amazon Resource Name (ARN) of the user who created the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The timestamp for when the evaluation form was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp for when the evaluation form was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who last updated the evaluation form.
         * </p>
         * 
         * @param lastModifiedBy
         *        The Amazon Resource Name (ARN) of the user who last updated the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(String lastModifiedBy);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example, { "Tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example, { "Tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String evaluationFormId;

        private Integer evaluationFormVersion;

        private Boolean locked;

        private String evaluationFormArn;

        private String title;

        private String description;

        private String status;

        private List<EvaluationFormItem> items = DefaultSdkAutoConstructList.getInstance();

        private EvaluationFormScoringStrategy scoringStrategy;

        private Instant createdTime;

        private String createdBy;

        private Instant lastModifiedTime;

        private String lastModifiedBy;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationForm model) {
            evaluationFormId(model.evaluationFormId);
            evaluationFormVersion(model.evaluationFormVersion);
            locked(model.locked);
            evaluationFormArn(model.evaluationFormArn);
            title(model.title);
            description(model.description);
            status(model.status);
            items(model.items);
            scoringStrategy(model.scoringStrategy);
            createdTime(model.createdTime);
            createdBy(model.createdBy);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedBy(model.lastModifiedBy);
            tags(model.tags);
        }

        public final String getEvaluationFormId() {
            return evaluationFormId;
        }

        public final void setEvaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
        }

        @Override
        public final Builder evaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
            return this;
        }

        public final Integer getEvaluationFormVersion() {
            return evaluationFormVersion;
        }

        public final void setEvaluationFormVersion(Integer evaluationFormVersion) {
            this.evaluationFormVersion = evaluationFormVersion;
        }

        @Override
        public final Builder evaluationFormVersion(Integer evaluationFormVersion) {
            this.evaluationFormVersion = evaluationFormVersion;
            return this;
        }

        public final Boolean getLocked() {
            return locked;
        }

        public final void setLocked(Boolean locked) {
            this.locked = locked;
        }

        @Override
        public final Builder locked(Boolean locked) {
            this.locked = locked;
            return this;
        }

        public final String getEvaluationFormArn() {
            return evaluationFormArn;
        }

        public final void setEvaluationFormArn(String evaluationFormArn) {
            this.evaluationFormArn = evaluationFormArn;
        }

        @Override
        public final Builder evaluationFormArn(String evaluationFormArn) {
            this.evaluationFormArn = evaluationFormArn;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EvaluationFormVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<EvaluationFormItem.Builder> getItems() {
            List<EvaluationFormItem.Builder> result = EvaluationFormItemsListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<EvaluationFormItem.BuilderImpl> items) {
            this.items = EvaluationFormItemsListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<EvaluationFormItem> items) {
            this.items = EvaluationFormItemsListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(EvaluationFormItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<EvaluationFormItem.Builder>... items) {
            items(Stream.of(items).map(c -> EvaluationFormItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final EvaluationFormScoringStrategy.Builder getScoringStrategy() {
            return scoringStrategy != null ? scoringStrategy.toBuilder() : null;
        }

        public final void setScoringStrategy(EvaluationFormScoringStrategy.BuilderImpl scoringStrategy) {
            this.scoringStrategy = scoringStrategy != null ? scoringStrategy.build() : null;
        }

        @Override
        public final Builder scoringStrategy(EvaluationFormScoringStrategy scoringStrategy) {
            this.scoringStrategy = scoringStrategy;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedBy() {
            return lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public EvaluationForm build() {
            return new EvaluationForm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
