/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an item from an evaluation form. The item must be either a section or a question.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormItem implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormItem.Builder, EvaluationFormItem> {
    private static final SdkField<EvaluationFormSection> SECTION_FIELD = SdkField
            .<EvaluationFormSection> builder(MarshallingType.SDK_POJO).memberName("Section")
            .getter(getter(EvaluationFormItem::section)).setter(setter(Builder::section))
            .constructor(EvaluationFormSection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Section").build()).build();

    private static final SdkField<EvaluationFormQuestion> QUESTION_FIELD = SdkField
            .<EvaluationFormQuestion> builder(MarshallingType.SDK_POJO).memberName("Question")
            .getter(getter(EvaluationFormItem::question)).setter(setter(Builder::question))
            .constructor(EvaluationFormQuestion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Question").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SECTION_FIELD, QUESTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EvaluationFormSection section;

    private final EvaluationFormQuestion question;

    private final Type type;

    private EvaluationFormItem(BuilderImpl builder) {
        this.section = builder.section;
        this.question = builder.question;
        this.type = builder.type;
    }

    /**
     * <p>
     * The information of the section.
     * </p>
     * 
     * @return The information of the section.
     */
    public final EvaluationFormSection section() {
        return section;
    }

    /**
     * <p>
     * The information of the question.
     * </p>
     * 
     * @return The information of the question.
     */
    public final EvaluationFormQuestion question() {
        return question;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(section());
        hashCode = 31 * hashCode + Objects.hashCode(question());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormItem)) {
            return false;
        }
        EvaluationFormItem other = (EvaluationFormItem) obj;
        return Objects.equals(section(), other.section()) && Objects.equals(question(), other.question());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormItem").add("Section", section()).add("Question", question()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Section":
            return Optional.ofNullable(clazz.cast(section()));
        case "Question":
            return Optional.ofNullable(clazz.cast(question()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #section()} initialized to the given value.
     *
     * <p>
     * The information of the section.
     * </p>
     * 
     * @param section
     *        The information of the section.
     */
    public static EvaluationFormItem fromSection(EvaluationFormSection section) {
        return builder().section(section).build();
    }

    /**
     * Create an instance of this class with {@link #section()} initialized to the given value.
     *
     * <p>
     * The information of the section.
     * </p>
     * 
     * @param section
     *        The information of the section.
     */
    public static EvaluationFormItem fromSection(Consumer<EvaluationFormSection.Builder> section) {
        EvaluationFormSection.Builder builder = EvaluationFormSection.builder();
        section.accept(builder);
        return fromSection(builder.build());
    }

    /**
     * Create an instance of this class with {@link #question()} initialized to the given value.
     *
     * <p>
     * The information of the question.
     * </p>
     * 
     * @param question
     *        The information of the question.
     */
    public static EvaluationFormItem fromQuestion(EvaluationFormQuestion question) {
        return builder().question(question).build();
    }

    /**
     * Create an instance of this class with {@link #question()} initialized to the given value.
     *
     * <p>
     * The information of the question.
     * </p>
     * 
     * @param question
     *        The information of the question.
     */
    public static EvaluationFormItem fromQuestion(Consumer<EvaluationFormQuestion.Builder> question) {
        EvaluationFormQuestion.Builder builder = EvaluationFormQuestion.builder();
        question.accept(builder);
        return fromQuestion(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Section", SECTION_FIELD);
        map.put("Question", QUESTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormItem, T> g) {
        return obj -> g.apply((EvaluationFormItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormItem> {
        /**
         * <p>
         * The information of the section.
         * </p>
         * 
         * @param section
         *        The information of the section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder section(EvaluationFormSection section);

        /**
         * <p>
         * The information of the section.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationFormSection.Builder} avoiding
         * the need to create one manually via {@link EvaluationFormSection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationFormSection.Builder#build()} is called immediately and
         * its result is passed to {@link #section(EvaluationFormSection)}.
         * 
         * @param section
         *        a consumer that will call methods on {@link EvaluationFormSection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #section(EvaluationFormSection)
         */
        default Builder section(Consumer<EvaluationFormSection.Builder> section) {
            return section(EvaluationFormSection.builder().applyMutation(section).build());
        }

        /**
         * <p>
         * The information of the question.
         * </p>
         * 
         * @param question
         *        The information of the question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder question(EvaluationFormQuestion question);

        /**
         * <p>
         * The information of the question.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationFormQuestion.Builder} avoiding
         * the need to create one manually via {@link EvaluationFormQuestion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationFormQuestion.Builder#build()} is called immediately and
         * its result is passed to {@link #question(EvaluationFormQuestion)}.
         * 
         * @param question
         *        a consumer that will call methods on {@link EvaluationFormQuestion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #question(EvaluationFormQuestion)
         */
        default Builder question(Consumer<EvaluationFormQuestion.Builder> question) {
            return question(EvaluationFormQuestion.builder().applyMutation(question).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EvaluationFormSection section;

        private EvaluationFormQuestion question;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormItem model) {
            section(model.section);
            question(model.question);
        }

        public final EvaluationFormSection.Builder getSection() {
            return section != null ? section.toBuilder() : null;
        }

        public final void setSection(EvaluationFormSection.BuilderImpl section) {
            Object oldValue = this.section;
            this.section = section != null ? section.build() : null;
            handleUnionValueChange(Type.SECTION, oldValue, this.section);
        }

        @Override
        public final Builder section(EvaluationFormSection section) {
            Object oldValue = this.section;
            this.section = section;
            handleUnionValueChange(Type.SECTION, oldValue, this.section);
            return this;
        }

        public final EvaluationFormQuestion.Builder getQuestion() {
            return question != null ? question.toBuilder() : null;
        }

        public final void setQuestion(EvaluationFormQuestion.BuilderImpl question) {
            Object oldValue = this.question;
            this.question = question != null ? question.build() : null;
            handleUnionValueChange(Type.QUESTION, oldValue, this.question);
        }

        @Override
        public final Builder question(EvaluationFormQuestion question) {
            Object oldValue = this.question;
            this.question = question;
            handleUnionValueChange(Type.QUESTION, oldValue, this.question);
            return this;
        }

        @Override
        public EvaluationFormItem build() {
            return new EvaluationFormItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EvaluationFormItem#type()
     */
    public enum Type {
        SECTION,

        QUESTION,

        UNKNOWN_TO_SDK_VERSION
    }
}
