/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a question from an evaluation form.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormQuestion implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormQuestion.Builder, EvaluationFormQuestion> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(EvaluationFormQuestion::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> INSTRUCTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Instructions").getter(getter(EvaluationFormQuestion::instructions))
            .setter(setter(Builder::instructions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instructions").build()).build();

    private static final SdkField<String> REF_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RefId")
            .getter(getter(EvaluationFormQuestion::refId)).setter(setter(Builder::refId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefId").build()).build();

    private static final SdkField<Boolean> NOT_APPLICABLE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NotApplicableEnabled").getter(getter(EvaluationFormQuestion::notApplicableEnabled))
            .setter(setter(Builder::notApplicableEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotApplicableEnabled").build())
            .build();

    private static final SdkField<String> QUESTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionType").getter(getter(EvaluationFormQuestion::questionTypeAsString))
            .setter(setter(Builder::questionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionType").build()).build();

    private static final SdkField<EvaluationFormQuestionTypeProperties> QUESTION_TYPE_PROPERTIES_FIELD = SdkField
            .<EvaluationFormQuestionTypeProperties> builder(MarshallingType.SDK_POJO).memberName("QuestionTypeProperties")
            .getter(getter(EvaluationFormQuestion::questionTypeProperties)).setter(setter(Builder::questionTypeProperties))
            .constructor(EvaluationFormQuestionTypeProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionTypeProperties").build())
            .build();

    private static final SdkField<Double> WEIGHT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Weight")
            .getter(getter(EvaluationFormQuestion::weight)).setter(setter(Builder::weight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD,
            INSTRUCTIONS_FIELD, REF_ID_FIELD, NOT_APPLICABLE_ENABLED_FIELD, QUESTION_TYPE_FIELD, QUESTION_TYPE_PROPERTIES_FIELD,
            WEIGHT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String title;

    private final String instructions;

    private final String refId;

    private final Boolean notApplicableEnabled;

    private final String questionType;

    private final EvaluationFormQuestionTypeProperties questionTypeProperties;

    private final Double weight;

    private EvaluationFormQuestion(BuilderImpl builder) {
        this.title = builder.title;
        this.instructions = builder.instructions;
        this.refId = builder.refId;
        this.notApplicableEnabled = builder.notApplicableEnabled;
        this.questionType = builder.questionType;
        this.questionTypeProperties = builder.questionTypeProperties;
        this.weight = builder.weight;
    }

    /**
     * <p>
     * The title of the question.
     * </p>
     * 
     * @return The title of the question.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The instructions of the section.
     * </p>
     * 
     * @return The instructions of the section.
     */
    public final String instructions() {
        return instructions;
    }

    /**
     * <p>
     * The identifier of the question. An identifier must be unique within the evaluation form.
     * </p>
     * 
     * @return The identifier of the question. An identifier must be unique within the evaluation form.
     */
    public final String refId() {
        return refId;
    }

    /**
     * <p>
     * The flag to enable not applicable answers to the question.
     * </p>
     * 
     * @return The flag to enable not applicable answers to the question.
     */
    public final Boolean notApplicableEnabled() {
        return notApplicableEnabled;
    }

    /**
     * <p>
     * The type of the question.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #questionType} will
     * return {@link EvaluationFormQuestionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #questionTypeAsString}.
     * </p>
     * 
     * @return The type of the question.
     * @see EvaluationFormQuestionType
     */
    public final EvaluationFormQuestionType questionType() {
        return EvaluationFormQuestionType.fromValue(questionType);
    }

    /**
     * <p>
     * The type of the question.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #questionType} will
     * return {@link EvaluationFormQuestionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #questionTypeAsString}.
     * </p>
     * 
     * @return The type of the question.
     * @see EvaluationFormQuestionType
     */
    public final String questionTypeAsString() {
        return questionType;
    }

    /**
     * <p>
     * The properties of the type of question. Text questions do not have to define question type properties.
     * </p>
     * 
     * @return The properties of the type of question. Text questions do not have to define question type properties.
     */
    public final EvaluationFormQuestionTypeProperties questionTypeProperties() {
        return questionTypeProperties;
    }

    /**
     * <p>
     * The scoring weight of the section.
     * </p>
     * 
     * @return The scoring weight of the section.
     */
    public final Double weight() {
        return weight;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(instructions());
        hashCode = 31 * hashCode + Objects.hashCode(refId());
        hashCode = 31 * hashCode + Objects.hashCode(notApplicableEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(questionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(questionTypeProperties());
        hashCode = 31 * hashCode + Objects.hashCode(weight());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormQuestion)) {
            return false;
        }
        EvaluationFormQuestion other = (EvaluationFormQuestion) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(instructions(), other.instructions())
                && Objects.equals(refId(), other.refId()) && Objects.equals(notApplicableEnabled(), other.notApplicableEnabled())
                && Objects.equals(questionTypeAsString(), other.questionTypeAsString())
                && Objects.equals(questionTypeProperties(), other.questionTypeProperties())
                && Objects.equals(weight(), other.weight());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormQuestion").add("Title", title()).add("Instructions", instructions())
                .add("RefId", refId()).add("NotApplicableEnabled", notApplicableEnabled())
                .add("QuestionType", questionTypeAsString()).add("QuestionTypeProperties", questionTypeProperties())
                .add("Weight", weight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Instructions":
            return Optional.ofNullable(clazz.cast(instructions()));
        case "RefId":
            return Optional.ofNullable(clazz.cast(refId()));
        case "NotApplicableEnabled":
            return Optional.ofNullable(clazz.cast(notApplicableEnabled()));
        case "QuestionType":
            return Optional.ofNullable(clazz.cast(questionTypeAsString()));
        case "QuestionTypeProperties":
            return Optional.ofNullable(clazz.cast(questionTypeProperties()));
        case "Weight":
            return Optional.ofNullable(clazz.cast(weight()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Title", TITLE_FIELD);
        map.put("Instructions", INSTRUCTIONS_FIELD);
        map.put("RefId", REF_ID_FIELD);
        map.put("NotApplicableEnabled", NOT_APPLICABLE_ENABLED_FIELD);
        map.put("QuestionType", QUESTION_TYPE_FIELD);
        map.put("QuestionTypeProperties", QUESTION_TYPE_PROPERTIES_FIELD);
        map.put("Weight", WEIGHT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormQuestion, T> g) {
        return obj -> g.apply((EvaluationFormQuestion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormQuestion> {
        /**
         * <p>
         * The title of the question.
         * </p>
         * 
         * @param title
         *        The title of the question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The instructions of the section.
         * </p>
         * 
         * @param instructions
         *        The instructions of the section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instructions(String instructions);

        /**
         * <p>
         * The identifier of the question. An identifier must be unique within the evaluation form.
         * </p>
         * 
         * @param refId
         *        The identifier of the question. An identifier must be unique within the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refId(String refId);

        /**
         * <p>
         * The flag to enable not applicable answers to the question.
         * </p>
         * 
         * @param notApplicableEnabled
         *        The flag to enable not applicable answers to the question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notApplicableEnabled(Boolean notApplicableEnabled);

        /**
         * <p>
         * The type of the question.
         * </p>
         * 
         * @param questionType
         *        The type of the question.
         * @see EvaluationFormQuestionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormQuestionType
         */
        Builder questionType(String questionType);

        /**
         * <p>
         * The type of the question.
         * </p>
         * 
         * @param questionType
         *        The type of the question.
         * @see EvaluationFormQuestionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormQuestionType
         */
        Builder questionType(EvaluationFormQuestionType questionType);

        /**
         * <p>
         * The properties of the type of question. Text questions do not have to define question type properties.
         * </p>
         * 
         * @param questionTypeProperties
         *        The properties of the type of question. Text questions do not have to define question type properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionTypeProperties(EvaluationFormQuestionTypeProperties questionTypeProperties);

        /**
         * <p>
         * The properties of the type of question. Text questions do not have to define question type properties.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EvaluationFormQuestionTypeProperties.Builder} avoiding the need to create one manually via
         * {@link EvaluationFormQuestionTypeProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationFormQuestionTypeProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #questionTypeProperties(EvaluationFormQuestionTypeProperties)}.
         * 
         * @param questionTypeProperties
         *        a consumer that will call methods on {@link EvaluationFormQuestionTypeProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #questionTypeProperties(EvaluationFormQuestionTypeProperties)
         */
        default Builder questionTypeProperties(Consumer<EvaluationFormQuestionTypeProperties.Builder> questionTypeProperties) {
            return questionTypeProperties(EvaluationFormQuestionTypeProperties.builder().applyMutation(questionTypeProperties)
                    .build());
        }

        /**
         * <p>
         * The scoring weight of the section.
         * </p>
         * 
         * @param weight
         *        The scoring weight of the section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(Double weight);
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private String instructions;

        private String refId;

        private Boolean notApplicableEnabled;

        private String questionType;

        private EvaluationFormQuestionTypeProperties questionTypeProperties;

        private Double weight;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormQuestion model) {
            title(model.title);
            instructions(model.instructions);
            refId(model.refId);
            notApplicableEnabled(model.notApplicableEnabled);
            questionType(model.questionType);
            questionTypeProperties(model.questionTypeProperties);
            weight(model.weight);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getInstructions() {
            return instructions;
        }

        public final void setInstructions(String instructions) {
            this.instructions = instructions;
        }

        @Override
        public final Builder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public final String getRefId() {
            return refId;
        }

        public final void setRefId(String refId) {
            this.refId = refId;
        }

        @Override
        public final Builder refId(String refId) {
            this.refId = refId;
            return this;
        }

        public final Boolean getNotApplicableEnabled() {
            return notApplicableEnabled;
        }

        public final void setNotApplicableEnabled(Boolean notApplicableEnabled) {
            this.notApplicableEnabled = notApplicableEnabled;
        }

        @Override
        public final Builder notApplicableEnabled(Boolean notApplicableEnabled) {
            this.notApplicableEnabled = notApplicableEnabled;
            return this;
        }

        public final String getQuestionType() {
            return questionType;
        }

        public final void setQuestionType(String questionType) {
            this.questionType = questionType;
        }

        @Override
        public final Builder questionType(String questionType) {
            this.questionType = questionType;
            return this;
        }

        @Override
        public final Builder questionType(EvaluationFormQuestionType questionType) {
            this.questionType(questionType == null ? null : questionType.toString());
            return this;
        }

        public final EvaluationFormQuestionTypeProperties.Builder getQuestionTypeProperties() {
            return questionTypeProperties != null ? questionTypeProperties.toBuilder() : null;
        }

        public final void setQuestionTypeProperties(EvaluationFormQuestionTypeProperties.BuilderImpl questionTypeProperties) {
            this.questionTypeProperties = questionTypeProperties != null ? questionTypeProperties.build() : null;
        }

        @Override
        public final Builder questionTypeProperties(EvaluationFormQuestionTypeProperties questionTypeProperties) {
            this.questionTypeProperties = questionTypeProperties;
            return this;
        }

        public final Double getWeight() {
            return weight;
        }

        public final void setWeight(Double weight) {
            this.weight = weight;
        }

        @Override
        public final Builder weight(Double weight) {
            this.weight = weight;
            return this;
        }

        @Override
        public EvaluationFormQuestion build() {
            return new EvaluationFormQuestion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
