/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a section from an evaluation form. A section can contain sections and/or questions. Evaluation
 * forms can only contain sections and subsections (two level nesting).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormSection implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormSection.Builder, EvaluationFormSection> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(EvaluationFormSection::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> REF_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RefId")
            .getter(getter(EvaluationFormSection::refId)).setter(setter(Builder::refId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefId").build()).build();

    private static final SdkField<String> INSTRUCTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Instructions").getter(getter(EvaluationFormSection::instructions)).setter(setter(Builder::instructions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instructions").build()).build();

    private static final SdkField<List<EvaluationFormItem>> ITEMS_FIELD = SdkField
            .<List<EvaluationFormItem>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(EvaluationFormSection::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationFormItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationFormItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> WEIGHT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Weight")
            .getter(getter(EvaluationFormSection::weight)).setter(setter(Builder::weight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, REF_ID_FIELD,
            INSTRUCTIONS_FIELD, ITEMS_FIELD, WEIGHT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String title;

    private final String refId;

    private final String instructions;

    private final List<EvaluationFormItem> items;

    private final Double weight;

    private EvaluationFormSection(BuilderImpl builder) {
        this.title = builder.title;
        this.refId = builder.refId;
        this.instructions = builder.instructions;
        this.items = builder.items;
        this.weight = builder.weight;
    }

    /**
     * <p>
     * The title of the section.
     * </p>
     * 
     * @return The title of the section.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The identifier of the section. An identifier must be unique within the evaluation form.
     * </p>
     * 
     * @return The identifier of the section. An identifier must be unique within the evaluation form.
     */
    public final String refId() {
        return refId;
    }

    /**
     * <p>
     * The instructions of the section.
     * </p>
     * 
     * @return The instructions of the section.
     */
    public final String instructions() {
        return instructions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The items of the section.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return The items of the section.
     */
    public final List<EvaluationFormItem> items() {
        return items;
    }

    /**
     * <p>
     * The scoring weight of the section.
     * </p>
     * 
     * @return The scoring weight of the section.
     */
    public final Double weight() {
        return weight;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(refId());
        hashCode = 31 * hashCode + Objects.hashCode(instructions());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(weight());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormSection)) {
            return false;
        }
        EvaluationFormSection other = (EvaluationFormSection) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(refId(), other.refId())
                && Objects.equals(instructions(), other.instructions()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items()) && Objects.equals(weight(), other.weight());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormSection").add("Title", title()).add("RefId", refId())
                .add("Instructions", instructions()).add("Items", hasItems() ? items() : null).add("Weight", weight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "RefId":
            return Optional.ofNullable(clazz.cast(refId()));
        case "Instructions":
            return Optional.ofNullable(clazz.cast(instructions()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "Weight":
            return Optional.ofNullable(clazz.cast(weight()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Title", TITLE_FIELD);
        map.put("RefId", REF_ID_FIELD);
        map.put("Instructions", INSTRUCTIONS_FIELD);
        map.put("Items", ITEMS_FIELD);
        map.put("Weight", WEIGHT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormSection, T> g) {
        return obj -> g.apply((EvaluationFormSection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormSection> {
        /**
         * <p>
         * The title of the section.
         * </p>
         * 
         * @param title
         *        The title of the section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The identifier of the section. An identifier must be unique within the evaluation form.
         * </p>
         * 
         * @param refId
         *        The identifier of the section. An identifier must be unique within the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refId(String refId);

        /**
         * <p>
         * The instructions of the section.
         * </p>
         * 
         * @param instructions
         *        The instructions of the section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instructions(String instructions);

        /**
         * <p>
         * The items of the section.
         * </p>
         * 
         * @param items
         *        The items of the section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<EvaluationFormItem> items);

        /**
         * <p>
         * The items of the section.
         * </p>
         * 
         * @param items
         *        The items of the section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(EvaluationFormItem... items);

        /**
         * <p>
         * The items of the section.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.EvaluationFormItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormItem.Builder#build()} is called
         * immediately and its result is passed to {@link #items(List<EvaluationFormItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EvaluationFormItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<EvaluationFormItem>)
         */
        Builder items(Consumer<EvaluationFormItem.Builder>... items);

        /**
         * <p>
         * The scoring weight of the section.
         * </p>
         * 
         * @param weight
         *        The scoring weight of the section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(Double weight);
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private String refId;

        private String instructions;

        private List<EvaluationFormItem> items = DefaultSdkAutoConstructList.getInstance();

        private Double weight;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormSection model) {
            title(model.title);
            refId(model.refId);
            instructions(model.instructions);
            items(model.items);
            weight(model.weight);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getRefId() {
            return refId;
        }

        public final void setRefId(String refId) {
            this.refId = refId;
        }

        @Override
        public final Builder refId(String refId) {
            this.refId = refId;
            return this;
        }

        public final String getInstructions() {
            return instructions;
        }

        public final void setInstructions(String instructions) {
            this.instructions = instructions;
        }

        @Override
        public final Builder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public final List<EvaluationFormItem.Builder> getItems() {
            List<EvaluationFormItem.Builder> result = EvaluationFormItemsListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<EvaluationFormItem.BuilderImpl> items) {
            this.items = EvaluationFormItemsListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<EvaluationFormItem> items) {
            this.items = EvaluationFormItemsListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(EvaluationFormItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<EvaluationFormItem.Builder>... items) {
            items(Stream.of(items).map(c -> EvaluationFormItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getWeight() {
            return weight;
        }

        public final void setWeight(Double weight) {
            this.weight = weight;
        }

        @Override
        public final Builder weight(Double weight) {
            this.weight = weight;
            return this;
        }

        @Override
        public EvaluationFormSection build() {
            return new EvaluationFormSection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
