/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about notes for a contact evaluation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationNote implements SdkPojo, Serializable, ToCopyableBuilder<EvaluationNote.Builder, EvaluationNote> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(EvaluationNote::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String value;

    private EvaluationNote(BuilderImpl builder) {
        this.value = builder.value;
    }

    /**
     * <p>
     * The note for an item (section or question) in a contact evaluation.
     * </p>
     * <note>
     * <p>
     * Even though a note in an evaluation can have up to 3072 chars, there is also a limit on the total number of chars
     * for all the notes in the evaluation combined. Assuming there are N questions in the evaluation being submitted,
     * then the max char limit for all notes combined is N x 1024.
     * </p>
     * </note>
     * 
     * @return The note for an item (section or question) in a contact evaluation.</p> <note>
     *         <p>
     *         Even though a note in an evaluation can have up to 3072 chars, there is also a limit on the total number
     *         of chars for all the notes in the evaluation combined. Assuming there are N questions in the evaluation
     *         being submitted, then the max char limit for all notes combined is N x 1024.
     *         </p>
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationNote)) {
            return false;
        }
        EvaluationNote other = (EvaluationNote) obj;
        return Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationNote").add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationNote, T> g) {
        return obj -> g.apply((EvaluationNote) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationNote> {
        /**
         * <p>
         * The note for an item (section or question) in a contact evaluation.
         * </p>
         * <note>
         * <p>
         * Even though a note in an evaluation can have up to 3072 chars, there is also a limit on the total number of
         * chars for all the notes in the evaluation combined. Assuming there are N questions in the evaluation being
         * submitted, then the max char limit for all notes combined is N x 1024.
         * </p>
         * </note>
         * 
         * @param value
         *        The note for an item (section or question) in a contact evaluation.</p> <note>
         *        <p>
         *        Even though a note in an evaluation can have up to 3072 chars, there is also a limit on the total
         *        number of chars for all the notes in the evaluation combined. Assuming there are N questions in the
         *        evaluation being submitted, then the max char limit for all notes combined is N x 1024.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationNote model) {
            value(model.value);
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public EvaluationNote build() {
            return new EvaluationNote(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
