/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A tagged union to specify expression for a routing step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Expression implements SdkPojo, Serializable, ToCopyableBuilder<Expression.Builder, Expression> {
    private static final SdkField<AttributeCondition> ATTRIBUTE_CONDITION_FIELD = SdkField
            .<AttributeCondition> builder(MarshallingType.SDK_POJO).memberName("AttributeCondition")
            .getter(getter(Expression::attributeCondition)).setter(setter(Builder::attributeCondition))
            .constructor(AttributeCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeCondition").build())
            .build();

    private static final SdkField<List<Expression>> AND_EXPRESSION_FIELD = SdkField
            .<List<Expression>> builder(MarshallingType.LIST)
            .memberName("AndExpression")
            .getter(getter(Expression::andExpression))
            .setter(setter(Builder::andExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndExpression").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Expression> builder(MarshallingType.SDK_POJO)
                                            .constructor(Expression::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Expression>> OR_EXPRESSION_FIELD = SdkField
            .<List<Expression>> builder(MarshallingType.LIST)
            .memberName("OrExpression")
            .getter(getter(Expression::orExpression))
            .setter(setter(Builder::orExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrExpression").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Expression> builder(MarshallingType.SDK_POJO)
                                            .constructor(Expression::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AttributeCondition> NOT_ATTRIBUTE_CONDITION_FIELD = SdkField
            .<AttributeCondition> builder(MarshallingType.SDK_POJO).memberName("NotAttributeCondition")
            .getter(getter(Expression::notAttributeCondition)).setter(setter(Builder::notAttributeCondition))
            .constructor(AttributeCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotAttributeCondition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_CONDITION_FIELD,
            AND_EXPRESSION_FIELD, OR_EXPRESSION_FIELD, NOT_ATTRIBUTE_CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AttributeCondition attributeCondition;

    private final List<Expression> andExpression;

    private final List<Expression> orExpression;

    private final AttributeCondition notAttributeCondition;

    private Expression(BuilderImpl builder) {
        this.attributeCondition = builder.attributeCondition;
        this.andExpression = builder.andExpression;
        this.orExpression = builder.orExpression;
        this.notAttributeCondition = builder.notAttributeCondition;
    }

    /**
     * <p>
     * An object to specify the predefined attribute condition.
     * </p>
     * 
     * @return An object to specify the predefined attribute condition.
     */
    public final AttributeCondition attributeCondition() {
        return attributeCondition;
    }

    /**
     * For responses, this returns true if the service returned a value for the AndExpression property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAndExpression() {
        return andExpression != null && !(andExpression instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of routing expressions which will be AND-ed together.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAndExpression} method.
     * </p>
     * 
     * @return List of routing expressions which will be AND-ed together.
     */
    public final List<Expression> andExpression() {
        return andExpression;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrExpression property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrExpression() {
        return orExpression != null && !(orExpression instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of routing expressions which will be OR-ed together.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrExpression} method.
     * </p>
     * 
     * @return List of routing expressions which will be OR-ed together.
     */
    public final List<Expression> orExpression() {
        return orExpression;
    }

    /**
     * Returns the value of the NotAttributeCondition property for this object.
     * 
     * @return The value of the NotAttributeCondition property for this object.
     */
    public final AttributeCondition notAttributeCondition() {
        return notAttributeCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeCondition());
        hashCode = 31 * hashCode + Objects.hashCode(hasAndExpression() ? andExpression() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOrExpression() ? orExpression() : null);
        hashCode = 31 * hashCode + Objects.hashCode(notAttributeCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Expression)) {
            return false;
        }
        Expression other = (Expression) obj;
        return Objects.equals(attributeCondition(), other.attributeCondition()) && hasAndExpression() == other.hasAndExpression()
                && Objects.equals(andExpression(), other.andExpression()) && hasOrExpression() == other.hasOrExpression()
                && Objects.equals(orExpression(), other.orExpression())
                && Objects.equals(notAttributeCondition(), other.notAttributeCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Expression").add("AttributeCondition", attributeCondition())
                .add("AndExpression", hasAndExpression() ? andExpression() : null)
                .add("OrExpression", hasOrExpression() ? orExpression() : null)
                .add("NotAttributeCondition", notAttributeCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeCondition":
            return Optional.ofNullable(clazz.cast(attributeCondition()));
        case "AndExpression":
            return Optional.ofNullable(clazz.cast(andExpression()));
        case "OrExpression":
            return Optional.ofNullable(clazz.cast(orExpression()));
        case "NotAttributeCondition":
            return Optional.ofNullable(clazz.cast(notAttributeCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttributeCondition", ATTRIBUTE_CONDITION_FIELD);
        map.put("AndExpression", AND_EXPRESSION_FIELD);
        map.put("OrExpression", OR_EXPRESSION_FIELD);
        map.put("NotAttributeCondition", NOT_ATTRIBUTE_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Expression, T> g) {
        return obj -> g.apply((Expression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Expression> {
        /**
         * <p>
         * An object to specify the predefined attribute condition.
         * </p>
         * 
         * @param attributeCondition
         *        An object to specify the predefined attribute condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeCondition(AttributeCondition attributeCondition);

        /**
         * <p>
         * An object to specify the predefined attribute condition.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeCondition.Builder} avoiding the
         * need to create one manually via {@link AttributeCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #attributeCondition(AttributeCondition)}.
         * 
         * @param attributeCondition
         *        a consumer that will call methods on {@link AttributeCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeCondition(AttributeCondition)
         */
        default Builder attributeCondition(Consumer<AttributeCondition.Builder> attributeCondition) {
            return attributeCondition(AttributeCondition.builder().applyMutation(attributeCondition).build());
        }

        /**
         * <p>
         * List of routing expressions which will be AND-ed together.
         * </p>
         * 
         * @param andExpression
         *        List of routing expressions which will be AND-ed together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andExpression(Collection<Expression> andExpression);

        /**
         * <p>
         * List of routing expressions which will be AND-ed together.
         * </p>
         * 
         * @param andExpression
         *        List of routing expressions which will be AND-ed together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andExpression(Expression... andExpression);

        /**
         * <p>
         * List of routing expressions which will be AND-ed together.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.Expression.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.Expression.Builder#build()} is called immediately and
         * its result is passed to {@link #andExpression(List<Expression>)}.
         * 
         * @param andExpression
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #andExpression(java.util.Collection<Expression>)
         */
        Builder andExpression(Consumer<Builder>... andExpression);

        /**
         * <p>
         * List of routing expressions which will be OR-ed together.
         * </p>
         * 
         * @param orExpression
         *        List of routing expressions which will be OR-ed together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orExpression(Collection<Expression> orExpression);

        /**
         * <p>
         * List of routing expressions which will be OR-ed together.
         * </p>
         * 
         * @param orExpression
         *        List of routing expressions which will be OR-ed together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orExpression(Expression... orExpression);

        /**
         * <p>
         * List of routing expressions which will be OR-ed together.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.Expression.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.Expression.Builder#build()} is called immediately and
         * its result is passed to {@link #orExpression(List<Expression>)}.
         * 
         * @param orExpression
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orExpression(java.util.Collection<Expression>)
         */
        Builder orExpression(Consumer<Builder>... orExpression);

        /**
         * Sets the value of the NotAttributeCondition property for this object.
         *
         * @param notAttributeCondition
         *        The new value for the NotAttributeCondition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notAttributeCondition(AttributeCondition notAttributeCondition);

        /**
         * Sets the value of the NotAttributeCondition property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AttributeCondition.Builder} avoiding the
         * need to create one manually via {@link AttributeCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #notAttributeCondition(AttributeCondition)}.
         * 
         * @param notAttributeCondition
         *        a consumer that will call methods on {@link AttributeCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notAttributeCondition(AttributeCondition)
         */
        default Builder notAttributeCondition(Consumer<AttributeCondition.Builder> notAttributeCondition) {
            return notAttributeCondition(AttributeCondition.builder().applyMutation(notAttributeCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AttributeCondition attributeCondition;

        private List<Expression> andExpression = DefaultSdkAutoConstructList.getInstance();

        private List<Expression> orExpression = DefaultSdkAutoConstructList.getInstance();

        private AttributeCondition notAttributeCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(Expression model) {
            attributeCondition(model.attributeCondition);
            andExpression(model.andExpression);
            orExpression(model.orExpression);
            notAttributeCondition(model.notAttributeCondition);
        }

        public final AttributeCondition.Builder getAttributeCondition() {
            return attributeCondition != null ? attributeCondition.toBuilder() : null;
        }

        public final void setAttributeCondition(AttributeCondition.BuilderImpl attributeCondition) {
            this.attributeCondition = attributeCondition != null ? attributeCondition.build() : null;
        }

        @Override
        public final Builder attributeCondition(AttributeCondition attributeCondition) {
            this.attributeCondition = attributeCondition;
            return this;
        }

        public final List<Builder> getAndExpression() {
            List<Builder> result = ExpressionsCopier.copyToBuilder(this.andExpression);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndExpression(Collection<BuilderImpl> andExpression) {
            this.andExpression = ExpressionsCopier.copyFromBuilder(andExpression);
        }

        @Override
        public final Builder andExpression(Collection<Expression> andExpression) {
            this.andExpression = ExpressionsCopier.copy(andExpression);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andExpression(Expression... andExpression) {
            andExpression(Arrays.asList(andExpression));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andExpression(Consumer<Builder>... andExpression) {
            andExpression(Stream.of(andExpression).map(c -> Expression.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getOrExpression() {
            List<Builder> result = ExpressionsCopier.copyToBuilder(this.orExpression);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrExpression(Collection<BuilderImpl> orExpression) {
            this.orExpression = ExpressionsCopier.copyFromBuilder(orExpression);
        }

        @Override
        public final Builder orExpression(Collection<Expression> orExpression) {
            this.orExpression = ExpressionsCopier.copy(orExpression);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orExpression(Expression... orExpression) {
            orExpression(Arrays.asList(orExpression));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orExpression(Consumer<Builder>... orExpression) {
            orExpression(Stream.of(orExpression).map(c -> Expression.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AttributeCondition.Builder getNotAttributeCondition() {
            return notAttributeCondition != null ? notAttributeCondition.toBuilder() : null;
        }

        public final void setNotAttributeCondition(AttributeCondition.BuilderImpl notAttributeCondition) {
            this.notAttributeCondition = notAttributeCondition != null ? notAttributeCondition.build() : null;
        }

        @Override
        public final Builder notAttributeCondition(AttributeCondition notAttributeCondition) {
            this.notAttributeCondition = notAttributeCondition;
            return this;
        }

        @Override
        public Expression build() {
            return new Expression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
