/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEffectiveHoursOfOperationsResponse extends ConnectResponse implements
        ToCopyableBuilder<GetEffectiveHoursOfOperationsResponse.Builder, GetEffectiveHoursOfOperationsResponse> {
    private static final SdkField<List<EffectiveHoursOfOperations>> EFFECTIVE_HOURS_OF_OPERATION_LIST_FIELD = SdkField
            .<List<EffectiveHoursOfOperations>> builder(MarshallingType.LIST)
            .memberName("EffectiveHoursOfOperationList")
            .getter(getter(GetEffectiveHoursOfOperationsResponse::effectiveHoursOfOperationList))
            .setter(setter(Builder::effectiveHoursOfOperationList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveHoursOfOperationList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EffectiveHoursOfOperations> builder(MarshallingType.SDK_POJO)
                                            .constructor(EffectiveHoursOfOperations::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeZone").getter(getter(GetEffectiveHoursOfOperationsResponse::timeZone))
            .setter(setter(Builder::timeZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EFFECTIVE_HOURS_OF_OPERATION_LIST_FIELD, TIME_ZONE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<EffectiveHoursOfOperations> effectiveHoursOfOperationList;

    private final String timeZone;

    private GetEffectiveHoursOfOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.effectiveHoursOfOperationList = builder.effectiveHoursOfOperationList;
        this.timeZone = builder.timeZone;
    }

    /**
     * For responses, this returns true if the service returned a value for the EffectiveHoursOfOperationList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEffectiveHoursOfOperationList() {
        return effectiveHoursOfOperationList != null && !(effectiveHoursOfOperationList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the effective hours of operations
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEffectiveHoursOfOperationList} method.
     * </p>
     * 
     * @return Information about the effective hours of operations
     */
    public final List<EffectiveHoursOfOperations> effectiveHoursOfOperationList() {
        return effectiveHoursOfOperationList;
    }

    /**
     * <p>
     * The time zone for the hours of operation.
     * </p>
     * 
     * @return The time zone for the hours of operation.
     */
    public final String timeZone() {
        return timeZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEffectiveHoursOfOperationList() ? effectiveHoursOfOperationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeZone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEffectiveHoursOfOperationsResponse)) {
            return false;
        }
        GetEffectiveHoursOfOperationsResponse other = (GetEffectiveHoursOfOperationsResponse) obj;
        return hasEffectiveHoursOfOperationList() == other.hasEffectiveHoursOfOperationList()
                && Objects.equals(effectiveHoursOfOperationList(), other.effectiveHoursOfOperationList())
                && Objects.equals(timeZone(), other.timeZone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetEffectiveHoursOfOperationsResponse")
                .add("EffectiveHoursOfOperationList", hasEffectiveHoursOfOperationList() ? effectiveHoursOfOperationList() : null)
                .add("TimeZone", timeZone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EffectiveHoursOfOperationList":
            return Optional.ofNullable(clazz.cast(effectiveHoursOfOperationList()));
        case "TimeZone":
            return Optional.ofNullable(clazz.cast(timeZone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EffectiveHoursOfOperationList", EFFECTIVE_HOURS_OF_OPERATION_LIST_FIELD);
        map.put("TimeZone", TIME_ZONE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEffectiveHoursOfOperationsResponse, T> g) {
        return obj -> g.apply((GetEffectiveHoursOfOperationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEffectiveHoursOfOperationsResponse> {
        /**
         * <p>
         * Information about the effective hours of operations
         * </p>
         * 
         * @param effectiveHoursOfOperationList
         *        Information about the effective hours of operations
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveHoursOfOperationList(Collection<EffectiveHoursOfOperations> effectiveHoursOfOperationList);

        /**
         * <p>
         * Information about the effective hours of operations
         * </p>
         * 
         * @param effectiveHoursOfOperationList
         *        Information about the effective hours of operations
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveHoursOfOperationList(EffectiveHoursOfOperations... effectiveHoursOfOperationList);

        /**
         * <p>
         * Information about the effective hours of operations
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EffectiveHoursOfOperations.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connect.model.EffectiveHoursOfOperations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EffectiveHoursOfOperations.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #effectiveHoursOfOperationList(List<EffectiveHoursOfOperations>)}.
         * 
         * @param effectiveHoursOfOperationList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EffectiveHoursOfOperations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #effectiveHoursOfOperationList(java.util.Collection<EffectiveHoursOfOperations>)
         */
        Builder effectiveHoursOfOperationList(Consumer<EffectiveHoursOfOperations.Builder>... effectiveHoursOfOperationList);

        /**
         * <p>
         * The time zone for the hours of operation.
         * </p>
         * 
         * @param timeZone
         *        The time zone for the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZone(String timeZone);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<EffectiveHoursOfOperations> effectiveHoursOfOperationList = DefaultSdkAutoConstructList.getInstance();

        private String timeZone;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEffectiveHoursOfOperationsResponse model) {
            super(model);
            effectiveHoursOfOperationList(model.effectiveHoursOfOperationList);
            timeZone(model.timeZone);
        }

        public final List<EffectiveHoursOfOperations.Builder> getEffectiveHoursOfOperationList() {
            List<EffectiveHoursOfOperations.Builder> result = EffectiveHoursOfOperationListCopier
                    .copyToBuilder(this.effectiveHoursOfOperationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEffectiveHoursOfOperationList(
                Collection<EffectiveHoursOfOperations.BuilderImpl> effectiveHoursOfOperationList) {
            this.effectiveHoursOfOperationList = EffectiveHoursOfOperationListCopier
                    .copyFromBuilder(effectiveHoursOfOperationList);
        }

        @Override
        public final Builder effectiveHoursOfOperationList(Collection<EffectiveHoursOfOperations> effectiveHoursOfOperationList) {
            this.effectiveHoursOfOperationList = EffectiveHoursOfOperationListCopier.copy(effectiveHoursOfOperationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectiveHoursOfOperationList(EffectiveHoursOfOperations... effectiveHoursOfOperationList) {
            effectiveHoursOfOperationList(Arrays.asList(effectiveHoursOfOperationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectiveHoursOfOperationList(
                Consumer<EffectiveHoursOfOperations.Builder>... effectiveHoursOfOperationList) {
            effectiveHoursOfOperationList(Stream.of(effectiveHoursOfOperationList)
                    .map(c -> EffectiveHoursOfOperations.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTimeZone() {
            return timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        @Override
        public GetEffectiveHoursOfOperationsResponse build() {
            return new GetEffectiveHoursOfOperationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
