/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMetricDataV2Request extends ConnectRequest implements
        ToCopyableBuilder<GetMetricDataV2Request.Builder, GetMetricDataV2Request> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(GetMetricDataV2Request::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(GetMetricDataV2Request::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(GetMetricDataV2Request::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<IntervalDetails> INTERVAL_FIELD = SdkField.<IntervalDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Interval").getter(getter(GetMetricDataV2Request::interval)).setter(setter(Builder::interval))
            .constructor(IntervalDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()).build();

    private static final SdkField<List<FilterV2>> FILTERS_FIELD = SdkField
            .<List<FilterV2>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(GetMetricDataV2Request::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterV2> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterV2::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> GROUPINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Groupings")
            .getter(getter(GetMetricDataV2Request::groupings))
            .setter(setter(Builder::groupings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groupings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MetricV2>> METRICS_FIELD = SdkField
            .<List<MetricV2>> builder(MarshallingType.LIST)
            .memberName("Metrics")
            .getter(getter(GetMetricDataV2Request::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricV2> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricV2::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetMetricDataV2Request::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetMetricDataV2Request::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, INTERVAL_FIELD, FILTERS_FIELD, GROUPINGS_FIELD, METRICS_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceArn;

    private final Instant startTime;

    private final Instant endTime;

    private final IntervalDetails interval;

    private final List<FilterV2> filters;

    private final List<String> groupings;

    private final List<MetricV2> metrics;

    private final String nextToken;

    private final Integer maxResults;

    private GetMetricDataV2Request(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.interval = builder.interval;
        this.filters = builder.filters;
        this.groupings = builder.groupings;
        this.metrics = builder.metrics;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource. This includes the <code>instanceId</code> an Amazon Connect
     * instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource. This includes the <code>instanceId</code> an Amazon
     *         Connect instance.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of
     * historical metrics data. The time must be before the end time timestamp. The start and end time depends on the
     * <code>IntervalPeriod</code> selected. By default the time range between start and end time is 35 days. Historical
     * metrics are available for 3 months.
     * </p>
     * 
     * @return The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of
     *         historical metrics data. The time must be before the end time timestamp. The start and end time depends
     *         on the <code>IntervalPeriod</code> selected. By default the time range between start and end time is 35
     *         days. Historical metrics are available for 3 months.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical
     * metrics data. The time must be later than the start time timestamp. It cannot be later than the current
     * timestamp.
     * </p>
     * 
     * @return The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of
     *         historical metrics data. The time must be later than the start time timestamp. It cannot be later than
     *         the current timestamp.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The interval period and timezone to apply to returned metrics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IntervalPeriod</code>: An aggregated grouping applied to request metrics. Valid <code>IntervalPeriod</code>
     * values are: <code>FIFTEEN_MIN</code> | <code>THIRTY_MIN</code> | <code>HOUR</code> | <code>DAY</code> |
     * <code>WEEK</code> | <code>TOTAL</code>.
     * </p>
     * <p>
     * For example, if <code>IntervalPeriod</code> is selected <code>THIRTY_MIN</code>, <code>StartTime</code> and
     * <code>EndTime</code> differs by 1 day, then Amazon Connect returns 48 results in the response. Each result is
     * aggregated by the THIRTY_MIN period. By default Amazon Connect aggregates results based on the <code>TOTAL</code>
     * interval period.
     * </p>
     * <p>
     * The following list describes restrictions on <code>StartTime</code> and <code>EndTime</code> based on which
     * <code>IntervalPeriod</code> is requested.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FIFTEEN_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
     * than 3 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>THIRTY_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than
     * 3 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOUR</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 3
     * days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DAY</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 35
     * days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WEEK</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 35
     * days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TOTAL</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 35
     * days.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TimeZone</code>: The timezone applied to requested metrics.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The interval period and timezone to apply to returned metrics.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IntervalPeriod</code>: An aggregated grouping applied to request metrics. Valid
     *         <code>IntervalPeriod</code> values are: <code>FIFTEEN_MIN</code> | <code>THIRTY_MIN</code> |
     *         <code>HOUR</code> | <code>DAY</code> | <code>WEEK</code> | <code>TOTAL</code>.
     *         </p>
     *         <p>
     *         For example, if <code>IntervalPeriod</code> is selected <code>THIRTY_MIN</code>, <code>StartTime</code>
     *         and <code>EndTime</code> differs by 1 day, then Amazon Connect returns 48 results in the response. Each
     *         result is aggregated by the THIRTY_MIN period. By default Amazon Connect aggregates results based on the
     *         <code>TOTAL</code> interval period.
     *         </p>
     *         <p>
     *         The following list describes restrictions on <code>StartTime</code> and <code>EndTime</code> based on
     *         which <code>IntervalPeriod</code> is requested.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FIFTEEN_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be
     *         less than 3 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>THIRTY_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be
     *         less than 3 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOUR</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
     *         than 3 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DAY</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
     *         than 35 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WEEK</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
     *         than 35 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TOTAL</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
     *         than 35 days.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TimeZone</code>: The timezone applied to requested metrics.
     *         </p>
     *         </li>
     */
    public final IntervalDetails interval() {
        return interval;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters to apply to returned metrics. You can filter on the following resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Agents
     * </p>
     * </li>
     * <li>
     * <p>
     * Campaigns
     * </p>
     * </li>
     * <li>
     * <p>
     * Channels
     * </p>
     * </li>
     * <li>
     * <p>
     * Feature
     * </p>
     * </li>
     * <li>
     * <p>
     * Queues
     * </p>
     * </li>
     * <li>
     * <p>
     * Routing profiles
     * </p>
     * </li>
     * <li>
     * <p>
     * Routing step expression
     * </p>
     * </li>
     * <li>
     * <p>
     * User hierarchy groups
     * </p>
     * </li>
     * </ul>
     * <p>
     * At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.
     * </p>
     * <p>
     * For metrics for outbound campaigns analytics, you can also use campaigns to satisfy at least one filter
     * requirement.
     * </p>
     * <p>
     * To filter by phone number, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html">Create a
     * historical metrics report</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <p>
     * Note the following limits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Filter keys</b>: A maximum of 5 filter keys are supported in a single request. Valid filter keys:
     * <code>AGENT</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
     * <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
     * <code>AGENT_HIERARCHY_LEVEL_FIVE</code> | <code>ANSWERING_MACHINE_DETECTION_STATUS</code> | <code> BOT_ID</code>
     * | <code>BOT_ALIAS</code> | <code>BOT_VERSION</code> | <code>BOT_LOCALE</code> | <code>BOT_INTENT_NAME</code> |
     * <code>CAMPAIGN</code> | <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code> |<code>CASE_TEMPLATE_ARN</code> |
     * <code>CASE_STATUS</code> | <code>CHANNEL</code> | <code>contact/segmentAttributes/connect:Subtype</code> |
     * <code>DISCONNECT_REASON</code> | <code>FEATURE</code> | <code>FLOW_ACTION_ID</code> | <code>FLOW_TYPE</code> |
     * <code>FLOWS_MODULE_RESOURCE_ID</code> | <code>FLOWS_NEXT_RESOURCE_ID</code> |
     * <code>FLOWS_NEXT_RESOURCE_QUEUE_ID</code> | <code>FLOWS_OUTCOME_TYPE</code> | <code>FLOWS_RESOURCE_ID</code> |
     * <code>INITIATION_METHOD</code> | <code>INVOKING_RESOURCE_PUBLISHED_TIMESTAMP</code> |
     * <code>INVOKING_RESOURCE_TYPE</code> | <code>PARENT_FLOWS_RESOURCE_ID</code> |
     * <code>RESOURCE_PUBLISHED_TIMESTAMP</code> | <code>ROUTING_PROFILE</code> | <code>ROUTING_STEP_EXPRESSION</code> |
     * <code>QUEUE</code> | <code>Q_CONNECT_ENABLED</code> |
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Filter values</b>: A maximum of 100 filter values are supported in a single request. VOICE, CHAT, and TASK are
     * valid <code>filterValue</code> for the CHANNEL filter key. They do not count towards limitation of 100 filter
     * values. For example, a GetMetricDataV2 request can filter by 50 queues, 35 agents, and 15 routing profiles for a
     * total of 100 filter values, along with 3 channel filters.
     * </p>
     * <p>
     * <code>contact_lens_conversational_analytics</code> is a valid filterValue for the <code>FEATURE</code> filter
     * key. It is available only to contacts analyzed by Contact Lens conversational analytics.
     * </p>
     * <p>
     * <code>connect:Chat</code>, <code>connect:SMS</code>, <code>connect:Telephony</code>, and
     * <code>connect:WebRTC</code> are valid <code>filterValue</code> examples (not exhaustive) for the
     * <code>contact/segmentAttributes/connect:Subtype filter</code> key.
     * </p>
     * <p>
     * <code>ROUTING_STEP_EXPRESSION</code> is a valid filter key with a filter value up to 3000 length. This filter is
     * case and order sensitive. JSON string fields must be sorted in ascending order and JSON array order should be
     * kept as is.
     * </p>
     * <p>
     * <code>Q_CONNECT_ENABLED</code>. TRUE and FALSE are the only valid filterValues for the
     * <code>Q_CONNECT_ENABLED</code> filter key.
     * </p>
     * <ul>
     * <li>
     * <p>
     * TRUE includes all contacts that had Amazon Q in Connect enabled as part of the flow.
     * </p>
     * </li>
     * <li>
     * <p>
     * FALSE includes all contacts that did not have Amazon Q in Connect enabled as part of the flow
     * </p>
     * </li>
     * </ul>
     * <p>
     * This filter is available only for contact record-driven metrics.
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-outbound-campaigns_Campaign.html">
     * Campaign</a> ARNs are valid <code>filterValues</code> for the <code>CAMPAIGN</code> filter key.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters to apply to returned metrics. You can filter on the following resources:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Agents
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Campaigns
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Channels
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Feature
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Queues
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Routing profiles
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Routing step expression
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         User hierarchy groups
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.
     *         </p>
     *         <p>
     *         For metrics for outbound campaigns analytics, you can also use campaigns to satisfy at least one filter
     *         requirement.
     *         </p>
     *         <p>
     *         To filter by phone number, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html">Create
     *         a historical metrics report</a> in the <i>Amazon Connect Administrator Guide</i>.
     *         </p>
     *         <p>
     *         Note the following limits:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Filter keys</b>: A maximum of 5 filter keys are supported in a single request. Valid filter keys:
     *         <code>AGENT</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
     *         <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
     *         <code>AGENT_HIERARCHY_LEVEL_FIVE</code> | <code>ANSWERING_MACHINE_DETECTION_STATUS</code> |
     *         <code> BOT_ID</code> | <code>BOT_ALIAS</code> | <code>BOT_VERSION</code> | <code>BOT_LOCALE</code> |
     *         <code>BOT_INTENT_NAME</code> | <code>CAMPAIGN</code> | <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code> |
     *         <code>CASE_TEMPLATE_ARN</code> | <code>CASE_STATUS</code> | <code>CHANNEL</code> |
     *         <code>contact/segmentAttributes/connect:Subtype</code> | <code>DISCONNECT_REASON</code> |
     *         <code>FEATURE</code> | <code>FLOW_ACTION_ID</code> | <code>FLOW_TYPE</code> |
     *         <code>FLOWS_MODULE_RESOURCE_ID</code> | <code>FLOWS_NEXT_RESOURCE_ID</code> |
     *         <code>FLOWS_NEXT_RESOURCE_QUEUE_ID</code> | <code>FLOWS_OUTCOME_TYPE</code> |
     *         <code>FLOWS_RESOURCE_ID</code> | <code>INITIATION_METHOD</code> |
     *         <code>INVOKING_RESOURCE_PUBLISHED_TIMESTAMP</code> | <code>INVOKING_RESOURCE_TYPE</code> |
     *         <code>PARENT_FLOWS_RESOURCE_ID</code> | <code>RESOURCE_PUBLISHED_TIMESTAMP</code> |
     *         <code>ROUTING_PROFILE</code> | <code>ROUTING_STEP_EXPRESSION</code> | <code>QUEUE</code> |
     *         <code>Q_CONNECT_ENABLED</code> |
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Filter values</b>: A maximum of 100 filter values are supported in a single request. VOICE, CHAT, and
     *         TASK are valid <code>filterValue</code> for the CHANNEL filter key. They do not count towards limitation
     *         of 100 filter values. For example, a GetMetricDataV2 request can filter by 50 queues, 35 agents, and 15
     *         routing profiles for a total of 100 filter values, along with 3 channel filters.
     *         </p>
     *         <p>
     *         <code>contact_lens_conversational_analytics</code> is a valid filterValue for the <code>FEATURE</code>
     *         filter key. It is available only to contacts analyzed by Contact Lens conversational analytics.
     *         </p>
     *         <p>
     *         <code>connect:Chat</code>, <code>connect:SMS</code>, <code>connect:Telephony</code>, and
     *         <code>connect:WebRTC</code> are valid <code>filterValue</code> examples (not exhaustive) for the
     *         <code>contact/segmentAttributes/connect:Subtype filter</code> key.
     *         </p>
     *         <p>
     *         <code>ROUTING_STEP_EXPRESSION</code> is a valid filter key with a filter value up to 3000 length. This
     *         filter is case and order sensitive. JSON string fields must be sorted in ascending order and JSON array
     *         order should be kept as is.
     *         </p>
     *         <p>
     *         <code>Q_CONNECT_ENABLED</code>. TRUE and FALSE are the only valid filterValues for the
     *         <code>Q_CONNECT_ENABLED</code> filter key.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         TRUE includes all contacts that had Amazon Q in Connect enabled as part of the flow.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FALSE includes all contacts that did not have Amazon Q in Connect enabled as part of the flow
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This filter is available only for contact record-driven metrics.
     *         </p>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-outbound-campaigns_Campaign.html"
     *         >Campaign</a> ARNs are valid <code>filterValues</code> for the <code>CAMPAIGN</code> filter key.
     *         </p>
     *         </li>
     */
    public final List<FilterV2> filters() {
        return filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groupings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroupings() {
        return groupings != null && !(groupings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The grouping applied to the metrics that are returned. For example, when results are grouped by queue, the
     * metrics returned are grouped by queue. The values that are returned apply to the metrics for each queue. They are
     * not aggregated for all queues.
     * </p>
     * <p>
     * If no grouping is specified, a summary of all metrics is returned.
     * </p>
     * <p>
     * Valid grouping keys: <code>AGENT</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> |
     * <code>AGENT_HIERARCHY_LEVEL_TWO</code> | <code>AGENT_HIERARCHY_LEVEL_THREE</code> |
     * <code>AGENT_HIERARCHY_LEVEL_FOUR</code> | <code>AGENT_HIERARCHY_LEVEL_FIVE</code> |
     * <code>ANSWERING_MACHINE_DETECTION_STATUS</code> | <code>BOT_ID</code> | <code>BOT_ALIAS</code> |
     * <code>BOT_VERSION</code> | <code>BOT_LOCALE</code> | <code>BOT_INTENT_NAME</code> | <code>CAMPAIGN</code> |
     * <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code> | <code>CASE_TEMPLATE_ARN</code> | <code>CASE_STATUS</code> |
     * <code>CHANNEL</code> | <code>contact/segmentAttributes/connect:Subtype</code> | <code>DISCONNECT_REASON</code> |
     * <code>FLOWS_RESOURCE_ID</code> | <code>FLOWS_MODULE_RESOURCE_ID</code> | <code>FLOW_ACTION_ID</code> |
     * <code>FLOW_TYPE</code> | <code>FLOWS_OUTCOME_TYPE</code> | <code>INITIATION_METHOD</code> |
     * <code>INVOKING_RESOURCE_PUBLISHED_TIMESTAMP</code> | <code>INVOKING_RESOURCE_TYPE</code> |
     * <code>PARENT_FLOWS_RESOURCE_ID</code> | <code>Q_CONNECT_ENABLED</code> | <code>QUEUE</code> |
     * <code>RESOURCE_PUBLISHED_TIMESTAMP</code> | <code>ROUTING_PROFILE</code> | <code>ROUTING_STEP_EXPRESSION</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupings} method.
     * </p>
     * 
     * @return The grouping applied to the metrics that are returned. For example, when results are grouped by queue,
     *         the metrics returned are grouped by queue. The values that are returned apply to the metrics for each
     *         queue. They are not aggregated for all queues.</p>
     *         <p>
     *         If no grouping is specified, a summary of all metrics is returned.
     *         </p>
     *         <p>
     *         Valid grouping keys: <code>AGENT</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> |
     *         <code>AGENT_HIERARCHY_LEVEL_TWO</code> | <code>AGENT_HIERARCHY_LEVEL_THREE</code> |
     *         <code>AGENT_HIERARCHY_LEVEL_FOUR</code> | <code>AGENT_HIERARCHY_LEVEL_FIVE</code> |
     *         <code>ANSWERING_MACHINE_DETECTION_STATUS</code> | <code>BOT_ID</code> | <code>BOT_ALIAS</code> |
     *         <code>BOT_VERSION</code> | <code>BOT_LOCALE</code> | <code>BOT_INTENT_NAME</code> | <code>CAMPAIGN</code>
     *         | <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code> | <code>CASE_TEMPLATE_ARN</code> | <code>CASE_STATUS</code> |
     *         <code>CHANNEL</code> | <code>contact/segmentAttributes/connect:Subtype</code> |
     *         <code>DISCONNECT_REASON</code> | <code>FLOWS_RESOURCE_ID</code> | <code>FLOWS_MODULE_RESOURCE_ID</code> |
     *         <code>FLOW_ACTION_ID</code> | <code>FLOW_TYPE</code> | <code>FLOWS_OUTCOME_TYPE</code> |
     *         <code>INITIATION_METHOD</code> | <code>INVOKING_RESOURCE_PUBLISHED_TIMESTAMP</code> |
     *         <code>INVOKING_RESOURCE_TYPE</code> | <code>PARENT_FLOWS_RESOURCE_ID</code> |
     *         <code>Q_CONNECT_ENABLED</code> | <code>QUEUE</code> | <code>RESOURCE_PUBLISHED_TIMESTAMP</code> |
     *         <code>ROUTING_PROFILE</code> | <code>ROUTING_STEP_EXPRESSION</code>
     */
    public final List<String> groupings() {
        return groupings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following historical
     * metrics are available. For a description of each metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
     * metrics definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <dl>
     * <dt>ABANDONMENT_RATE</dt>
     * <dd>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#abandonment-rate-historical"
     * >Abandonment rate</a>
     * </p>
     * </dd>
     * <dt>AGENT_ADHERENT_TIME</dt>
     * <dd>
     * <p>
     * This metric is available only in Amazon Web Services Regions where <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     * capacity planning, and scheduling</a> is available.
     * </p>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherent-time-historical"
     * >Adherent time</a>
     * </p>
     * </dd>
     * <dt>AGENT_ANSWER_RATE</dt>
     * <dd>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-answer-rate-historical"
     * >Agent answer rate</a>
     * </p>
     * </dd>
     * <dt>AGENT_NON_ADHERENT_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#non-adherent-time"
     * >Non-adherent time</a>
     * </p>
     * </dd>
     * <dt>AGENT_NON_RESPONSE</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-non-response"
     * >Agent non-response</a>
     * </p>
     * </dd>
     * <dt>AGENT_NON_RESPONSE_WITHOUT_CUSTOMER_ABANDONS</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * <p>
     * Data for this metric is available starting from October 1, 2023 0:00:00 GMT.
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-nonresponse-no-abandon-historical"
     * >Agent non-response without customer abandons</a>
     * </p>
     * </dd>
     * <dt>AGENT_OCCUPANCY</dt>
     * <dd>
     * <p>
     * Unit: Percentage
     * </p>
     * <p>
     * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#occupancy-historical"
     * >Occupancy</a>
     * </p>
     * </dd>
     * <dt>AGENT_SCHEDULE_ADHERENCE</dt>
     * <dd>
     * <p>
     * This metric is available only in Amazon Web Services Regions where <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     * capacity planning, and scheduling</a> is available.
     * </p>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherence-historical"
     * >Adherence</a>
     * </p>
     * </dd>
     * <dt>AGENT_SCHEDULED_TIME</dt>
     * <dd>
     * <p>
     * This metric is available only in Amazon Web Services Regions where <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     * capacity planning, and scheduling</a> is available.
     * </p>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#scheduled-time-historical"
     * >Scheduled time</a>
     * </p>
     * </dd>
     * <dt>AVG_ABANDON_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-abandon-time-historical"
     * >Average queue abandon time</a>
     * </p>
     * </dd>
     * <dt>AVG_ACTIVE_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-active-time-historical"
     * >Average active time</a>
     * </p>
     * </dd>
     * <dt>AVG_AFTER_CONTACT_WORK_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-acw-time-historical"
     * >Average after contact work time</a>
     * </p>
     * <note>
     * <p>
     * Feature is a valid filter but not a valid grouping.
     * </p>
     * </note></dd>
     * <dt>AVG_AGENT_CONNECTING_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>. For now, this metric only supports the following as
     * <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>CALLBACK</code> |
     * <code>API</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-avg-agent-api-connecting-time"
     * >Average agent API connecting time</a>
     * </p>
     * <note>
     * <p>
     * The <code>Negate</code> key in metric-level filters is not applicable for this metric.
     * </p>
     * </note></dd>
     * <dt>AVG_AGENT_PAUSE_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-pause-time-historical"
     * >Average agent pause time</a>
     * </p>
     * </dd>
     * <dt>AVG_BOT_CONVERSATION_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot version,
     * Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking resource published
     * timestamp, Initiation method, Invoking resource type, Parent flows resource ID
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#average-bot-conversation-time-metric"
     * >Average bot conversation time</a>
     * </p>
     * </dd>
     * <dt>AVG_BOT_CONVERSATION_TURNS</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot version,
     * Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking resource published
     * timestamp, Initiation method, Invoking resource type, Parent flows resource ID
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#average-bot-conversation-turns-metric"
     * >Average bot conversation turns</a>
     * </p>
     * </dd>
     * <dt>AVG_CASE_RELATED_CONTACTS</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Required filter key: CASE_TEMPLATE_ARN
     * </p>
     * <p>
     * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contacts-case-historical"
     * >Average contacts per case</a>
     * </p>
     * </dd>
     * <dt>AVG_CASE_RESOLUTION_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Required filter key: CASE_TEMPLATE_ARN
     * </p>
     * <p>
     * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-case-resolution-time-historical"
     * >Average case resolution time</a>
     * </p>
     * </dd>
     * <dt>AVG_CONTACT_DURATION</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contact-duration-historical"
     * >Average contact duration</a>
     * </p>
     * <note>
     * <p>
     * Feature is a valid filter but not a valid grouping.
     * </p>
     * </note></dd>
     * <dt>AVG_CONVERSATION_DURATION</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-conversation-duration-historical"
     * >Average conversation duration</a>
     * </p>
     * </dd>
     * <dt>AVG_DIALS_PER_MINUTE</dt>
     * <dd>
     * <p>
     * This metric is available only for outbound campaigns that use the agent assisted voice and automated voice
     * delivery modes.
     * </p>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Agent, Campaign, Queue, Routing Profile
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-dials-historical"
     * >Average dials per minute</a>
     * </p>
     * </dd>
     * <dt>AVG_FLOW_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource
     * ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID, Initiation
     * method, Resource published timestamp
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-flow-time-historical"
     * >Average flow time</a>
     * </p>
     * </dd>
     * <dt>AVG_GREETING_TIME_AGENT</dt>
     * <dd>
     * <p>
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     * </p>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-greeting-time-agent-historical"
     * >Average agent greeting time</a>
     * </p>
     * </dd>
     * <dt>AVG_HANDLE_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
     * contact/segmentAttributes/connect:Subtype, RoutingStepExpression
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-handle-time-historical"
     * >Average handle time</a>
     * </p>
     * <note>
     * <p>
     * Feature is a valid filter but not a valid grouping.
     * </p>
     * </note></dd>
     * <dt>AVG_HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-customer-hold-time-historical"
     * >Average customer hold time</a>
     * </p>
     * <note>
     * <p>
     * Feature is a valid filter but not a valid grouping.
     * </p>
     * </note></dd>
     * <dt>AVG_HOLD_TIME_ALL_CONTACTS</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#avg-customer-hold-time-all-contacts-historical"
     * >Average customer hold time all contacts</a>
     * </p>
     * </dd>
     * <dt>AVG_HOLDS</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-holds-historical"
     * >Average holds</a>
     * </p>
     * <note>
     * <p>
     * Feature is a valid filter but not a valid grouping.
     * </p>
     * </note></dd>
     * <dt>AVG_INTERACTION_AND_HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-customer-hold-time-historical"
     * >Average agent interaction and customer hold time</a>
     * </p>
     * </dd>
     * <dt>AVG_INTERACTION_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Feature, contact/segmentAttributes/connect:Subtype,
     * Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-time-historical"
     * >Average agent interaction time</a>
     * </p>
     * <note>
     * <p>
     * Feature is a valid filter but not a valid grouping.
     * </p>
     * </note></dd>
     * <dt>AVG_INTERRUPTIONS_AGENT</dt>
     * <dd>
     * <p>
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     * </p>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-agent-historical"
     * >Average agent interruptions</a>
     * </p>
     * </dd>
     * <dt>AVG_INTERRUPTION_TIME_AGENT</dt>
     * <dd>
     * <p>
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     * </p>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-time-agent-historical"
     * >Average agent interruption time</a>
     * </p>
     * </dd>
     * <dt>AVG_NON_TALK_TIME</dt>
     * <dd>
     * <p>
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     * </p>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html##average-non-talk-time-historical"
     * >Average non-talk time</a>
     * </p>
     * </dd>
     * <dt>AVG_QUEUE_ANSWER_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Feature, contact/segmentAttributes/connect:Subtype,
     * Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-answer-time-historical"
     * >Average queue answer time</a>
     * </p>
     * <note>
     * <p>
     * Feature is a valid filter but not a valid grouping.
     * </p>
     * </note></dd>
     * <dt>AVG_RESOLUTION_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in
     * Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-resolution-time-historical"
     * >Average resolution time</a>
     * </p>
     * </dd>
     * <dt>AVG_TALK_TIME</dt>
     * <dd>
     * <p>
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     * </p>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-historical"
     * >Average talk time</a>
     * </p>
     * </dd>
     * <dt>AVG_TALK_TIME_AGENT</dt>
     * <dd>
     * <p>
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     * </p>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-agent-historical"
     * >Average agent talk time</a>
     * </p>
     * </dd>
     * <dt>AVG_TALK_TIME_CUSTOMER</dt>
     * <dd>
     * <p>
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     * </p>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-customer-historical"
     * >Average customer talk time</a>
     * </p>
     * </dd>
     * <dt>AVG_WAIT_TIME_AFTER_CUSTOMER_CONNECTION</dt>
     * <dd>
     * <p>
     * This metric is available only for outbound campaigns that use the agent assisted voice and automated voice
     * delivery modes.
     * </p>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Campaign
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-wait-time-historical"
     * >Average wait time after customer connection</a>
     * </p>
     * </dd>
     * <dt>BOT_CONVERSATIONS_COMPLETED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot version,
     * Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking resource published
     * timestamp, Initiation method, Invoking resource type, Parent flows resource ID
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-conversations-completed-metric">Bot
     * conversations</a>
     * </p>
     * </dd>
     * <dt>BOT_INTENTS_COMPLETED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot version,
     * Bot locale, Bot intent name, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking
     * resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-intents-completed-metric">Bot
     * intents completed</a>
     * </p>
     * </dd>
     * <dt>CAMPAIGN_CONTACTS_ABANDONED_AFTER_X</dt>
     * <dd>
     * <p>
     * This metric is available only for outbound campaigns using the agent assisted voice and automated voice delivery
     * modes.
     * </p>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Agent, Campaign
     * </p>
     * <p>
     * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For
     * <code>Comparison</code>, you must enter <code>GT</code> (for <i>Greater than</i>).
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-contacts-abandoned-historical"
     * >Campaign contacts abandoned after X</a>
     * </p>
     * </dd>
     * <dt>CAMPAIGN_CONTACTS_ABANDONED_AFTER_X_RATE</dt>
     * <dd>
     * <p>
     * This metric is available only for outbound campaigns using the agent assisted voice and automated voice delivery
     * modes.
     * </p>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid groupings and filters: Agent, Campaign
     * </p>
     * <p>
     * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For
     * <code>Comparison</code>, you must enter <code>GT</code> (for <i>Greater than</i>).
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-contacts-abandoned-rate-historical"
     * >Campaign contacts abandoned after X rate</a>
     * </p>
     * </dd>
     * <dt>CAMPAIGN_INTERACTIONS</dt>
     * <dd>
     * <p>
     * This metric is available only for outbound campaigns using the email delivery mode.
     * </p>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid metric filter key: CAMPAIGN_INTERACTION_EVENT_TYPE
     * </p>
     * <p>
     * Valid groupings and filters: Campaign
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-interactions-historical"
     * >Campaign interactions</a>
     * </p>
     * </dd>
     * <dt>CAMPAIGN_SEND_ATTEMPTS</dt>
     * <dd>
     * <p>
     * This metric is available only for outbound campaigns.
     * </p>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Campaign, Channel, contact/segmentAttributes/connect:Subtype
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-send-attempts-historical"
     * >Campaign send attempts</a>
     * </p>
     * </dd>
     * <dt>CASES_CREATED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Required filter key: CASE_TEMPLATE_ARN
     * </p>
     * <p>
     * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-created-historical"
     * >Cases created</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_CREATED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Feature, contact/segmentAttributes/connect:Subtype,
     * Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-created-historical"
     * >Contacts created</a>
     * </p>
     * <note>
     * <p>
     * Feature is a valid filter but not a valid grouping.
     * </p>
     * </note></dd>
     * <dt>CONTACTS_HANDLED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>, <code>DISCONNECT_REASON</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
     * contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#api-contacts-handled-historical"
     * >API contacts handled</a>
     * </p>
     * <note>
     * <p>
     * Feature is a valid filter but not a valid grouping.
     * </p>
     * </note></dd>
     * <dt>CONTACTS_HANDLED_BY_CONNECTED_TO_AGENT</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q
     * in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical"
     * >Contacts handled (connected to agent timestamp)</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_HOLD_ABANDONS</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical"
     * >Contacts hold disconnect</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_ON_HOLD_AGENT_DISCONNECT</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-agent-disconnect-historical"
     * >Contacts hold agent disconnect</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_ON_HOLD_CUSTOMER_DISCONNECT</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical"
     * >Contacts hold customer disconnect</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_PUT_ON_HOLD</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical"
     * >Contacts put on hold</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT_EXTERNAL</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-external-historical"
     * >Contacts transferred out external</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT_INTERNAL</dt>
     * <dd>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-internal-historical"
     * >Contacts transferred out internal</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_QUEUED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-historical"
     * >Contacts queued</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_QUEUED_BY_ENQUEUE</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-by-enqueue-historical"
     * >Contacts queued (enqueue timestamp)</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_REMOVED_FROM_QUEUE_IN_X</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect
     * </p>
     * <p>
     * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For
     * <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code> (for
     * "Less than equal").
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-removed-historical"
     * >Contacts removed from queue in X seconds</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_RESOLVED_IN_X</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in
     * Connect
     * </p>
     * <p>
     * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For
     * <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code> (for
     * "Less than equal").
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-resolved-historical"
     * >Contacts resolved in X</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-historical"
     * >Contacts transferred out</a>
     * </p>
     * <note>
     * <p>
     * Feature is a valid filter but not a valid grouping.
     * </p>
     * </note></dd>
     * <dt>CONTACTS_TRANSFERRED_OUT_BY_AGENT</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical"
     * >Contacts transferred out by agent</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical"
     * >Contacts transferred out queue</a>
     * </p>
     * </dd>
     * <dt>CURRENT_CASES</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Required filter key: CASE_TEMPLATE_ARN
     * </p>
     * <p>
     * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#current-cases-historical"
     * >Current cases</a>
     * </p>
     * </dd>
     * <dt>DELIVERY_ATTEMPTS</dt>
     * <dd>
     * <p>
     * This metric is available only for outbound campaigns.
     * </p>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid metric filter key: <code>ANSWERING_MACHINE_DETECTION_STATUS</code>,
     * <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code>, <code>DISCONNECT_REASON</code>
     * </p>
     * <p>
     * Valid groupings and filters: Agent, Answering Machine Detection Status, Campaign, Campaign Delivery EventType,
     * Channel, contact/segmentAttributes/connect:Subtype, Disconnect Reason, Queue, Routing Profile
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#delivery-attempts-historical"
     * >Delivery attempts</a>
     * </p>
     * <note>
     * <p>
     * Campaign Delivery EventType filter and grouping are only available for SMS and Email campaign delivery modes.
     * Agent, Queue, Routing Profile, Answering Machine Detection Status and Disconnect Reason are only available for
     * agent assisted voice and automated voice delivery modes.
     * </p>
     * </note></dd>
     * <dt>DELIVERY_ATTEMPT_DISPOSITION_RATE</dt>
     * <dd>
     * <p>
     * This metric is available only for outbound campaigns. Dispositions for the agent assisted voice and automated
     * voice delivery modes are only available with answering machine detection enabled.
     * </p>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid metric filter key: <code>ANSWERING_MACHINE_DETECTION_STATUS</code>,
     * <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code>, <code>DISCONNECT_REASON</code>
     * </p>
     * <p>
     * Valid groupings and filters: Agent, Answering Machine Detection Status, Campaign, Channel,
     * contact/segmentAttributes/connect:Subtype, Disconnect Reason, Queue, Routing Profile
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#delivery-attempt-disposition-rate-historical"
     * >Delivery attempt disposition rate</a>
     * </p>
     * <note>
     * <p>
     * Campaign Delivery Event Type filter and grouping are only available for SMS and Email campaign delivery modes.
     * Agent, Queue, Routing Profile, Answering Machine Detection Status and Disconnect Reason are only available for
     * agent assisted voice and automated voice delivery modes.
     * </p>
     * </note></dd>
     * <dt>FLOWS_OUTCOME</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource
     * ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID, Initiation
     * method, Resource published timestamp
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-historical"
     * >Flows outcome</a>
     * </p>
     * </dd>
     * <dt>FLOWS_STARTED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource
     * ID, Flows resource ID, Initiation method, Resource published timestamp
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-started-historical"
     * >Flows started</a>
     * </p>
     * </dd>
     * <dt>HUMAN_ANSWERED_CALLS</dt>
     * <dd>
     * <p>
     * This metric is available only for outbound campaigns. Dispositions for the agent assisted voice and automated
     * voice delivery modes are only available with answering machine detection enabled.
     * </p>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Agent, Campaign
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#human-answered-historical"
     * >Human answered</a>
     * </p>
     * </dd>
     * <dt>MAX_FLOW_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource
     * ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID, Initiation
     * method, Resource published timestamp
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-flow-time-historical"
     * >Maximum flow time</a>
     * </p>
     * </dd>
     * <dt>MAX_QUEUED_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-queued-time-historical"
     * >Maximum queued time</a>
     * </p>
     * </dd>
     * <dt>MIN_FLOW_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource
     * ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID, Initiation
     * method, Resource published timestamp
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#minimum-flow-time-historical"
     * >Minimum flow time</a>
     * </p>
     * </dd>
     * <dt>PERCENT_BOT_CONVERSATIONS_OUTCOME</dt>
     * <dd>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot version,
     * Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking resource published
     * timestamp, Initiation method, Invoking resource type, Parent flows resource ID
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#percent-bot-conversations-outcome-metric"
     * >Percent bot conversations outcome</a>
     * </p>
     * </dd>
     * <dt>PERCENT_BOT_INTENTS_OUTCOME</dt>
     * <dd>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot version,
     * Bot locale, Bot intent name, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking
     * resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#percent-bot-intents-outcome-metric"
     * >Percent bot intents outcome</a>
     * </p>
     * </dd>
     * <dt>PERCENT_CASES_FIRST_CONTACT_RESOLVED</dt>
     * <dd>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Required filter key: CASE_TEMPLATE_ARN
     * </p>
     * <p>
     * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-first-contact-historical"
     * >Cases resolved on first contact</a>
     * </p>
     * </dd>
     * <dt>PERCENT_CONTACTS_STEP_EXPIRED</dt>
     * <dd>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid groupings and filters: Queue, RoutingStepExpression
     * </p>
     * <p>
     * UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
     * </p>
     * </dd>
     * <dt>PERCENT_CONTACTS_STEP_JOINED</dt>
     * <dd>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid groupings and filters: Queue, RoutingStepExpression
     * </p>
     * <p>
     * UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
     * </p>
     * </dd>
     * <dt>PERCENT_FLOWS_OUTCOME</dt>
     * <dd>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid metric filter key: <code>FLOWS_OUTCOME_TYPE</code>
     * </p>
     * <p>
     * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource
     * ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID, Initiation
     * method, Resource published timestamp
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-percentage-historical"
     * >Flows outcome percentage</a>.
     * </p>
     * <note>
     * <p>
     * The <code>FLOWS_OUTCOME_TYPE</code> is not a valid grouping.
     * </p>
     * </note></dd>
     * <dt>PERCENT_NON_TALK_TIME</dt>
     * <dd>
     * <p>
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     * </p>
     * <p>
     * Unit: Percentage
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ntt-historical"
     * >Non-talk time percent</a>
     * </p>
     * </dd>
     * <dt>PERCENT_TALK_TIME</dt>
     * <dd>
     * <p>
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     * </p>
     * <p>
     * Unit: Percentage
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#tt-historical"
     * >Talk time percent</a>
     * </p>
     * </dd>
     * <dt>PERCENT_TALK_TIME_AGENT</dt>
     * <dd>
     * <p>
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     * </p>
     * <p>
     * Unit: Percentage
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttagent-historical"
     * >Agent talk time percent</a>
     * </p>
     * </dd>
     * <dt>PERCENT_TALK_TIME_CUSTOMER</dt>
     * <dd>
     * <p>
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     * </p>
     * <p>
     * Unit: Percentage
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttcustomer-historical"
     * >Customer talk time percent</a>
     * </p>
     * </dd>
     * <dt>REOPENED_CASE_ACTIONS</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Required filter key: CASE_TEMPLATE_ARN
     * </p>
     * <p>
     * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-reopened-historical"
     * >Cases reopened</a>
     * </p>
     * </dd>
     * <dt>RESOLVED_CASE_ACTIONS</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Required filter key: CASE_TEMPLATE_ARN
     * </p>
     * <p>
     * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-historical"
     * >Cases resolved</a>
     * </p>
     * </dd>
     * <dt>SERVICE_LEVEL</dt>
     * <dd>
     * <p>
     * You can include up to 20 SERVICE_LEVEL metrics in a request.
     * </p>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect
     * </p>
     * <p>
     * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For
     * <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code> (for
     * "Less than equal").
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#service-level-historical"
     * >Service level X</a>
     * </p>
     * </dd>
     * <dt>STEP_CONTACTS_QUEUED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, RoutingStepExpression
     * </p>
     * <p>
     * UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
     * </p>
     * </dd>
     * <dt>SUM_AFTER_CONTACT_WORK_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#acw-historical"
     * >After contact work time</a>
     * </p>
     * </dd>
     * <dt>SUM_CONNECTING_TIME_AGENT</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>. This metric only supports the following filter keys as
     * <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>CALLBACK</code> |
     * <code>API</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-agent-api-connecting-time"
     * >Agent API connecting time</a>
     * </p>
     * <note>
     * <p>
     * The <code>Negate</code> key in metric-level filters is not applicable for this metric.
     * </p>
     * </note></dd>
     * <dt>CONTACTS_ABANDONED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Metric filter:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Valid values: <code>API</code>| <code>Incoming</code> | <code>Outbound</code> | <code>Transfer</code> |
     * <code>Callback</code> | <code>Queue_Transfer</code>| <code>Disconnect</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     * contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-historical"
     * >Contact abandoned</a>
     * </p>
     * </dd>
     * <dt>SUM_CONTACTS_ABANDONED_IN_X</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in
     * Connect
     * </p>
     * <p>
     * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For
     * <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code> (for
     * "Less than equal").
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-x-historical"
     * >Contacts abandoned in X seconds</a>
     * </p>
     * </dd>
     * <dt>SUM_CONTACTS_ANSWERED_IN_X</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in
     * Connect
     * </p>
     * <p>
     * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For
     * <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code> (for
     * "Less than equal").
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-answered-x-historical"
     * >Contacts answered in X seconds</a>
     * </p>
     * </dd>
     * <dt>SUM_CONTACT_FLOW_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-flow-time-historical"
     * >Contact flow time</a>
     * </p>
     * </dd>
     * <dt>SUM_CONTACT_TIME_AGENT</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-on-contact-time-historical"
     * >Agent on contact time</a>
     * </p>
     * </dd>
     * <dt>SUM_CONTACTS_DISCONNECTED</dt>
     * <dd>
     * <p>
     * Valid metric filter key: <code>DISCONNECT_REASON</code>
     * </p>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     * contact/segmentAttributes/connect:Subtype, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-disconnected-historical"
     * >Contact disconnected</a>
     * </p>
     * </dd>
     * <dt>SUM_ERROR_STATUS_TIME_AGENT</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#error-status-time-historical"
     * >Error status time</a>
     * </p>
     * </dd>
     * <dt>SUM_HANDLE_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-handle-time-historical"
     * >Contact handle time</a>
     * </p>
     * </dd>
     * <dt>SUM_HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#customer-hold-time-historical"
     * >Customer hold time</a>
     * </p>
     * </dd>
     * <dt>SUM_IDLE_TIME_AGENT</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-idle-time-historica"
     * >Agent idle time</a>
     * </p>
     * </dd>
     * <dt>SUM_INTERACTION_AND_HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-hold-time-historical"
     * >Agent interaction and hold time</a>
     * </p>
     * </dd>
     * <dt>SUM_INTERACTION_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-time-historical"
     * >Agent interaction time</a>
     * </p>
     * </dd>
     * <dt>SUM_NON_PRODUCTIVE_TIME_AGENT</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#npt-historical"
     * >Non-Productive Time</a>
     * </p>
     * </dd>
     * <dt>SUM_ONLINE_TIME_AGENT</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#online-time-historical"
     * >Online time</a>
     * </p>
     * </dd>
     * <dt>SUM_RETRY_CALLBACK_ATTEMPTS</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in
     * Connect
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#callback-attempts-historical"
     * >Callback attempts</a>
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following
     *         historical metrics are available. For a description of each metric, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html"
     *         >Historical metrics definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
     *         <dl>
     *         <dt>ABANDONMENT_RATE</dt>
     *         <dd>
     *         <p>
     *         Unit: Percent
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#abandonment-rate-historical"
     *         >Abandonment rate</a>
     *         </p>
     *         </dd>
     *         <dt>AGENT_ADHERENT_TIME</dt>
     *         <dd>
     *         <p>
     *         This metric is available only in Amazon Web Services Regions where <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region"
     *         >Forecasting, capacity planning, and scheduling</a> is available.
     *         </p>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherent-time-historical"
     *         >Adherent time</a>
     *         </p>
     *         </dd>
     *         <dt>AGENT_ANSWER_RATE</dt>
     *         <dd>
     *         <p>
     *         Unit: Percent
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-answer-rate-historical"
     *         >Agent answer rate</a>
     *         </p>
     *         </dd>
     *         <dt>AGENT_NON_ADHERENT_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#non-adherent-time"
     *         >Non-adherent time</a>
     *         </p>
     *         </dd>
     *         <dt>AGENT_NON_RESPONSE</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-non-response"
     *         >Agent non-response</a>
     *         </p>
     *         </dd>
     *         <dt>AGENT_NON_RESPONSE_WITHOUT_CUSTOMER_ABANDONS</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         <p>
     *         Data for this metric is available starting from October 1, 2023 0:00:00 GMT.
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-nonresponse-no-abandon-historical"
     *         >Agent non-response without customer abandons</a>
     *         </p>
     *         </dd>
     *         <dt>AGENT_OCCUPANCY</dt>
     *         <dd>
     *         <p>
     *         Unit: Percentage
     *         </p>
     *         <p>
     *         Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#occupancy-historical"
     *         >Occupancy</a>
     *         </p>
     *         </dd>
     *         <dt>AGENT_SCHEDULE_ADHERENCE</dt>
     *         <dd>
     *         <p>
     *         This metric is available only in Amazon Web Services Regions where <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region"
     *         >Forecasting, capacity planning, and scheduling</a> is available.
     *         </p>
     *         <p>
     *         Unit: Percent
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherence-historical"
     *         >Adherence</a>
     *         </p>
     *         </dd>
     *         <dt>AGENT_SCHEDULED_TIME</dt>
     *         <dd>
     *         <p>
     *         This metric is available only in Amazon Web Services Regions where <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region"
     *         >Forecasting, capacity planning, and scheduling</a> is available.
     *         </p>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#scheduled-time-historical"
     *         >Scheduled time</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_ABANDON_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-abandon-time-historical"
     *         >Average queue abandon time</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_ACTIVE_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-active-time-historical"
     *         >Average active time</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_AFTER_CONTACT_WORK_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid metric filter key: <code>INITIATION_METHOD</code>
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-acw-time-historical"
     *         >Average after contact work time</a>
     *         </p>
     *         <note>
     *         <p>
     *         Feature is a valid filter but not a valid grouping.
     *         </p>
     *         </note></dd>
     *         <dt>AVG_AGENT_CONNECTING_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid metric filter key: <code>INITIATION_METHOD</code>. For now, this metric only supports the following
     *         as <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>CALLBACK</code> |
     *         <code>API</code>
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-avg-agent-api-connecting-time"
     *         >Average agent API connecting time</a>
     *         </p>
     *         <note>
     *         <p>
     *         The <code>Negate</code> key in metric-level filters is not applicable for this metric.
     *         </p>
     *         </note></dd>
     *         <dt>AVG_AGENT_PAUSE_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-pause-time-historical"
     *         >Average agent pause time</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_BOT_CONVERSATION_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
     *         version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking
     *         resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#average-bot-conversation-time-metric"
     *         >Average bot conversation time</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_BOT_CONVERSATION_TURNS</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
     *         version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking
     *         resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#average-bot-conversation-turns-metric"
     *         >Average bot conversation turns</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_CASE_RELATED_CONTACTS</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Required filter key: CASE_TEMPLATE_ARN
     *         </p>
     *         <p>
     *         Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contacts-case-historical"
     *         >Average contacts per case</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_CASE_RESOLUTION_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Required filter key: CASE_TEMPLATE_ARN
     *         </p>
     *         <p>
     *         Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-case-resolution-time-historical"
     *         >Average case resolution time</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_CONTACT_DURATION</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contact-duration-historical"
     *         >Average contact duration</a>
     *         </p>
     *         <note>
     *         <p>
     *         Feature is a valid filter but not a valid grouping.
     *         </p>
     *         </note></dd>
     *         <dt>AVG_CONVERSATION_DURATION</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-conversation-duration-historical"
     *         >Average conversation duration</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_DIALS_PER_MINUTE</dt>
     *         <dd>
     *         <p>
     *         This metric is available only for outbound campaigns that use the agent assisted voice and automated
     *         voice delivery modes.
     *         </p>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Agent, Campaign, Queue, Routing Profile
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-dials-historical"
     *         >Average dials per minute</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_FLOW_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
     *         resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID,
     *         Initiation method, Resource published timestamp
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-flow-time-historical"
     *         >Average flow time</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_GREETING_TIME_AGENT</dt>
     *         <dd>
     *         <p>
     *         This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *         </p>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-greeting-time-agent-historical"
     *         >Average agent greeting time</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_HANDLE_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
     *         contact/segmentAttributes/connect:Subtype, RoutingStepExpression
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-handle-time-historical"
     *         >Average handle time</a>
     *         </p>
     *         <note>
     *         <p>
     *         Feature is a valid filter but not a valid grouping.
     *         </p>
     *         </note></dd>
     *         <dt>AVG_HOLD_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-customer-hold-time-historical"
     *         >Average customer hold time</a>
     *         </p>
     *         <note>
     *         <p>
     *         Feature is a valid filter but not a valid grouping.
     *         </p>
     *         </note></dd>
     *         <dt>AVG_HOLD_TIME_ALL_CONTACTS</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#avg-customer-hold-time-all-contacts-historical"
     *         >Average customer hold time all contacts</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_HOLDS</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-holds-historical"
     *         >Average holds</a>
     *         </p>
     *         <note>
     *         <p>
     *         Feature is a valid filter but not a valid grouping.
     *         </p>
     *         </note></dd>
     *         <dt>AVG_INTERACTION_AND_HOLD_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-customer-hold-time-historical"
     *         >Average agent interaction and customer hold time</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_INTERACTION_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid metric filter key: <code>INITIATION_METHOD</code>
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-time-historical"
     *         >Average agent interaction time</a>
     *         </p>
     *         <note>
     *         <p>
     *         Feature is a valid filter but not a valid grouping.
     *         </p>
     *         </note></dd>
     *         <dt>AVG_INTERRUPTIONS_AGENT</dt>
     *         <dd>
     *         <p>
     *         This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *         </p>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-agent-historical"
     *         >Average agent interruptions</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_INTERRUPTION_TIME_AGENT</dt>
     *         <dd>
     *         <p>
     *         This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *         </p>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-time-agent-historical"
     *         >Average agent interruption time</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_NON_TALK_TIME</dt>
     *         <dd>
     *         <p>
     *         This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *         </p>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html##average-non-talk-time-historical"
     *         >Average non-talk time</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_QUEUE_ANSWER_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-answer-time-historical"
     *         >Average queue answer time</a>
     *         </p>
     *         <note>
     *         <p>
     *         Feature is a valid filter but not a valid grouping.
     *         </p>
     *         </note></dd>
     *         <dt>AVG_RESOLUTION_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype,
     *         Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-resolution-time-historical"
     *         >Average resolution time</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_TALK_TIME</dt>
     *         <dd>
     *         <p>
     *         This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *         </p>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-historical"
     *         >Average talk time</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_TALK_TIME_AGENT</dt>
     *         <dd>
     *         <p>
     *         This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *         </p>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-agent-historical"
     *         >Average agent talk time</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_TALK_TIME_CUSTOMER</dt>
     *         <dd>
     *         <p>
     *         This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *         </p>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-customer-historical"
     *         >Average customer talk time</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_WAIT_TIME_AFTER_CUSTOMER_CONNECTION</dt>
     *         <dd>
     *         <p>
     *         This metric is available only for outbound campaigns that use the agent assisted voice and automated
     *         voice delivery modes.
     *         </p>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Campaign
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-wait-time-historical"
     *         >Average wait time after customer connection</a>
     *         </p>
     *         </dd>
     *         <dt>BOT_CONVERSATIONS_COMPLETED</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
     *         version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking
     *         resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-conversations-completed-metric"
     *         >Bot conversations</a>
     *         </p>
     *         </dd>
     *         <dt>BOT_INTENTS_COMPLETED</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
     *         version, Bot locale, Bot intent name, Flows resource ID, Flows module resource ID, Flow type, Flow action
     *         ID, Invoking resource published timestamp, Initiation method, Invoking resource type, Parent flows
     *         resource ID
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-intents-completed-metric">Bot
     *         intents completed</a>
     *         </p>
     *         </dd>
     *         <dt>CAMPAIGN_CONTACTS_ABANDONED_AFTER_X</dt>
     *         <dd>
     *         <p>
     *         This metric is available only for outbound campaigns using the agent assisted voice and automated voice
     *         delivery modes.
     *         </p>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Agent, Campaign
     *         </p>
     *         <p>
     *         Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
     *         seconds. For <code>Comparison</code>, you must enter <code>GT</code> (for <i>Greater than</i>).
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-contacts-abandoned-historical"
     *         >Campaign contacts abandoned after X</a>
     *         </p>
     *         </dd>
     *         <dt>CAMPAIGN_CONTACTS_ABANDONED_AFTER_X_RATE</dt>
     *         <dd>
     *         <p>
     *         This metric is available only for outbound campaigns using the agent assisted voice and automated voice
     *         delivery modes.
     *         </p>
     *         <p>
     *         Unit: Percent
     *         </p>
     *         <p>
     *         Valid groupings and filters: Agent, Campaign
     *         </p>
     *         <p>
     *         Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
     *         seconds. For <code>Comparison</code>, you must enter <code>GT</code> (for <i>Greater than</i>).
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-contacts-abandoned-rate-historical"
     *         >Campaign contacts abandoned after X rate</a>
     *         </p>
     *         </dd>
     *         <dt>CAMPAIGN_INTERACTIONS</dt>
     *         <dd>
     *         <p>
     *         This metric is available only for outbound campaigns using the email delivery mode.
     *         </p>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid metric filter key: CAMPAIGN_INTERACTION_EVENT_TYPE
     *         </p>
     *         <p>
     *         Valid groupings and filters: Campaign
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-interactions-historical"
     *         >Campaign interactions</a>
     *         </p>
     *         </dd>
     *         <dt>CAMPAIGN_SEND_ATTEMPTS</dt>
     *         <dd>
     *         <p>
     *         This metric is available only for outbound campaigns.
     *         </p>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Campaign, Channel, contact/segmentAttributes/connect:Subtype
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-send-attempts-historical"
     *         >Campaign send attempts</a>
     *         </p>
     *         </dd>
     *         <dt>CASES_CREATED</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Required filter key: CASE_TEMPLATE_ARN
     *         </p>
     *         <p>
     *         Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-created-historical"
     *         >Cases created</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_CREATED</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid metric filter key: <code>INITIATION_METHOD</code>
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-created-historical"
     *         >Contacts created</a>
     *         </p>
     *         <note>
     *         <p>
     *         Feature is a valid filter but not a valid grouping.
     *         </p>
     *         </note></dd>
     *         <dt>CONTACTS_HANDLED</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid metric filter key: <code>INITIATION_METHOD</code>, <code>DISCONNECT_REASON</code>
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
     *         contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#api-contacts-handled-historical"
     *         >API contacts handled</a>
     *         </p>
     *         <note>
     *         <p>
     *         Feature is a valid filter but not a valid grouping.
     *         </p>
     *         </note></dd>
     *         <dt>CONTACTS_HANDLED_BY_CONNECTED_TO_AGENT</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid metric filter key: <code>INITIATION_METHOD</code>
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical"
     *         >Contacts handled (connected to agent timestamp)</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_HOLD_ABANDONS</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical"
     *         >Contacts hold disconnect</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_ON_HOLD_AGENT_DISCONNECT</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-agent-disconnect-historical"
     *         >Contacts hold agent disconnect</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_ON_HOLD_CUSTOMER_DISCONNECT</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical"
     *         >Contacts hold customer disconnect</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_PUT_ON_HOLD</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical"
     *         >Contacts put on hold</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_OUT_EXTERNAL</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-external-historical"
     *         >Contacts transferred out external</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_OUT_INTERNAL</dt>
     *         <dd>
     *         <p>
     *         Unit: Percent
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-internal-historical"
     *         >Contacts transferred out internal</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_QUEUED</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-historical"
     *         >Contacts queued</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_QUEUED_BY_ENQUEUE</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-by-enqueue-historical"
     *         >Contacts queued (enqueue timestamp)</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_REMOVED_FROM_QUEUE_IN_X</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect
     *         </p>
     *         <p>
     *         Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
     *         seconds. For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code>
     *         (for "Less than equal").
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-removed-historical"
     *         >Contacts removed from queue in X seconds</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_RESOLVED_IN_X</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype,
     *         Q in Connect
     *         </p>
     *         <p>
     *         Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
     *         seconds. For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code>
     *         (for "Less than equal").
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-resolved-historical"
     *         >Contacts resolved in X</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_OUT</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-historical"
     *         >Contacts transferred out</a>
     *         </p>
     *         <note>
     *         <p>
     *         Feature is a valid filter but not a valid grouping.
     *         </p>
     *         </note></dd>
     *         <dt>CONTACTS_TRANSFERRED_OUT_BY_AGENT</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical"
     *         >Contacts transferred out by agent</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical"
     *         >Contacts transferred out queue</a>
     *         </p>
     *         </dd>
     *         <dt>CURRENT_CASES</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Required filter key: CASE_TEMPLATE_ARN
     *         </p>
     *         <p>
     *         Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#current-cases-historical"
     *         >Current cases</a>
     *         </p>
     *         </dd>
     *         <dt>DELIVERY_ATTEMPTS</dt>
     *         <dd>
     *         <p>
     *         This metric is available only for outbound campaigns.
     *         </p>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid metric filter key: <code>ANSWERING_MACHINE_DETECTION_STATUS</code>,
     *         <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code>, <code>DISCONNECT_REASON</code>
     *         </p>
     *         <p>
     *         Valid groupings and filters: Agent, Answering Machine Detection Status, Campaign, Campaign Delivery
     *         EventType, Channel, contact/segmentAttributes/connect:Subtype, Disconnect Reason, Queue, Routing Profile
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#delivery-attempts-historical"
     *         >Delivery attempts</a>
     *         </p>
     *         <note>
     *         <p>
     *         Campaign Delivery EventType filter and grouping are only available for SMS and Email campaign delivery
     *         modes. Agent, Queue, Routing Profile, Answering Machine Detection Status and Disconnect Reason are only
     *         available for agent assisted voice and automated voice delivery modes.
     *         </p>
     *         </note></dd>
     *         <dt>DELIVERY_ATTEMPT_DISPOSITION_RATE</dt>
     *         <dd>
     *         <p>
     *         This metric is available only for outbound campaigns. Dispositions for the agent assisted voice and
     *         automated voice delivery modes are only available with answering machine detection enabled.
     *         </p>
     *         <p>
     *         Unit: Percent
     *         </p>
     *         <p>
     *         Valid metric filter key: <code>ANSWERING_MACHINE_DETECTION_STATUS</code>,
     *         <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code>, <code>DISCONNECT_REASON</code>
     *         </p>
     *         <p>
     *         Valid groupings and filters: Agent, Answering Machine Detection Status, Campaign, Channel,
     *         contact/segmentAttributes/connect:Subtype, Disconnect Reason, Queue, Routing Profile
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#delivery-attempt-disposition-rate-historical"
     *         >Delivery attempt disposition rate</a>
     *         </p>
     *         <note>
     *         <p>
     *         Campaign Delivery Event Type filter and grouping are only available for SMS and Email campaign delivery
     *         modes. Agent, Queue, Routing Profile, Answering Machine Detection Status and Disconnect Reason are only
     *         available for agent assisted voice and automated voice delivery modes.
     *         </p>
     *         </note></dd>
     *         <dt>FLOWS_OUTCOME</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
     *         resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID,
     *         Initiation method, Resource published timestamp
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-historical"
     *         >Flows outcome</a>
     *         </p>
     *         </dd>
     *         <dt>FLOWS_STARTED</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
     *         resource ID, Flows resource ID, Initiation method, Resource published timestamp
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-started-historical"
     *         >Flows started</a>
     *         </p>
     *         </dd>
     *         <dt>HUMAN_ANSWERED_CALLS</dt>
     *         <dd>
     *         <p>
     *         This metric is available only for outbound campaigns. Dispositions for the agent assisted voice and
     *         automated voice delivery modes are only available with answering machine detection enabled.
     *         </p>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Agent, Campaign
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#human-answered-historical"
     *         >Human answered</a>
     *         </p>
     *         </dd>
     *         <dt>MAX_FLOW_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
     *         resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID,
     *         Initiation method, Resource published timestamp
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-flow-time-historical"
     *         >Maximum flow time</a>
     *         </p>
     *         </dd>
     *         <dt>MAX_QUEUED_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-queued-time-historical"
     *         >Maximum queued time</a>
     *         </p>
     *         </dd>
     *         <dt>MIN_FLOW_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
     *         resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID,
     *         Initiation method, Resource published timestamp
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#minimum-flow-time-historical"
     *         >Minimum flow time</a>
     *         </p>
     *         </dd>
     *         <dt>PERCENT_BOT_CONVERSATIONS_OUTCOME</dt>
     *         <dd>
     *         <p>
     *         Unit: Percent
     *         </p>
     *         <p>
     *         Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
     *         version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking
     *         resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#percent-bot-conversations-outcome-metric"
     *         >Percent bot conversations outcome</a>
     *         </p>
     *         </dd>
     *         <dt>PERCENT_BOT_INTENTS_OUTCOME</dt>
     *         <dd>
     *         <p>
     *         Unit: Percent
     *         </p>
     *         <p>
     *         Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
     *         version, Bot locale, Bot intent name, Flows resource ID, Flows module resource ID, Flow type, Flow action
     *         ID, Invoking resource published timestamp, Initiation method, Invoking resource type, Parent flows
     *         resource ID
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#percent-bot-intents-outcome-metric"
     *         >Percent bot intents outcome</a>
     *         </p>
     *         </dd>
     *         <dt>PERCENT_CASES_FIRST_CONTACT_RESOLVED</dt>
     *         <dd>
     *         <p>
     *         Unit: Percent
     *         </p>
     *         <p>
     *         Required filter key: CASE_TEMPLATE_ARN
     *         </p>
     *         <p>
     *         Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-first-contact-historical"
     *         >Cases resolved on first contact</a>
     *         </p>
     *         </dd>
     *         <dt>PERCENT_CONTACTS_STEP_EXPIRED</dt>
     *         <dd>
     *         <p>
     *         Unit: Percent
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, RoutingStepExpression
     *         </p>
     *         <p>
     *         UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
     *         </p>
     *         </dd>
     *         <dt>PERCENT_CONTACTS_STEP_JOINED</dt>
     *         <dd>
     *         <p>
     *         Unit: Percent
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, RoutingStepExpression
     *         </p>
     *         <p>
     *         UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
     *         </p>
     *         </dd>
     *         <dt>PERCENT_FLOWS_OUTCOME</dt>
     *         <dd>
     *         <p>
     *         Unit: Percent
     *         </p>
     *         <p>
     *         Valid metric filter key: <code>FLOWS_OUTCOME_TYPE</code>
     *         </p>
     *         <p>
     *         Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
     *         resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID,
     *         Initiation method, Resource published timestamp
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-percentage-historical"
     *         >Flows outcome percentage</a>.
     *         </p>
     *         <note>
     *         <p>
     *         The <code>FLOWS_OUTCOME_TYPE</code> is not a valid grouping.
     *         </p>
     *         </note></dd>
     *         <dt>PERCENT_NON_TALK_TIME</dt>
     *         <dd>
     *         <p>
     *         This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *         </p>
     *         <p>
     *         Unit: Percentage
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ntt-historical"
     *         >Non-talk time percent</a>
     *         </p>
     *         </dd>
     *         <dt>PERCENT_TALK_TIME</dt>
     *         <dd>
     *         <p>
     *         This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *         </p>
     *         <p>
     *         Unit: Percentage
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#tt-historical"
     *         >Talk time percent</a>
     *         </p>
     *         </dd>
     *         <dt>PERCENT_TALK_TIME_AGENT</dt>
     *         <dd>
     *         <p>
     *         This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *         </p>
     *         <p>
     *         Unit: Percentage
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttagent-historical"
     *         >Agent talk time percent</a>
     *         </p>
     *         </dd>
     *         <dt>PERCENT_TALK_TIME_CUSTOMER</dt>
     *         <dd>
     *         <p>
     *         This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *         </p>
     *         <p>
     *         Unit: Percentage
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttcustomer-historical"
     *         >Customer talk time percent</a>
     *         </p>
     *         </dd>
     *         <dt>REOPENED_CASE_ACTIONS</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Required filter key: CASE_TEMPLATE_ARN
     *         </p>
     *         <p>
     *         Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-reopened-historical"
     *         >Cases reopened</a>
     *         </p>
     *         </dd>
     *         <dt>RESOLVED_CASE_ACTIONS</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Required filter key: CASE_TEMPLATE_ARN
     *         </p>
     *         <p>
     *         Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-historical"
     *         >Cases resolved</a>
     *         </p>
     *         </dd>
     *         <dt>SERVICE_LEVEL</dt>
     *         <dd>
     *         <p>
     *         You can include up to 20 SERVICE_LEVEL metrics in a request.
     *         </p>
     *         <p>
     *         Unit: Percent
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect
     *         </p>
     *         <p>
     *         Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
     *         seconds. For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code>
     *         (for "Less than equal").
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#service-level-historical"
     *         >Service level X</a>
     *         </p>
     *         </dd>
     *         <dt>STEP_CONTACTS_QUEUED</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, RoutingStepExpression
     *         </p>
     *         <p>
     *         UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
     *         </p>
     *         </dd>
     *         <dt>SUM_AFTER_CONTACT_WORK_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#acw-historical"
     *         >After contact work time</a>
     *         </p>
     *         </dd>
     *         <dt>SUM_CONNECTING_TIME_AGENT</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid metric filter key: <code>INITIATION_METHOD</code>. This metric only supports the following filter
     *         keys as <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> |
     *         <code>CALLBACK</code> | <code>API</code>
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-agent-api-connecting-time"
     *         >Agent API connecting time</a>
     *         </p>
     *         <note>
     *         <p>
     *         The <code>Negate</code> key in metric-level filters is not applicable for this metric.
     *         </p>
     *         </note></dd>
     *         <dt>CONTACTS_ABANDONED</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Metric filter:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Valid values: <code>API</code>| <code>Incoming</code> | <code>Outbound</code> | <code>Transfer</code> |
     *         <code>Callback</code> | <code>Queue_Transfer</code>| <code>Disconnect</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-historical"
     *         >Contact abandoned</a>
     *         </p>
     *         </dd>
     *         <dt>SUM_CONTACTS_ABANDONED_IN_X</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype,
     *         Q in Connect
     *         </p>
     *         <p>
     *         Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
     *         seconds. For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code>
     *         (for "Less than equal").
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-x-historical"
     *         >Contacts abandoned in X seconds</a>
     *         </p>
     *         </dd>
     *         <dt>SUM_CONTACTS_ANSWERED_IN_X</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype,
     *         Q in Connect
     *         </p>
     *         <p>
     *         Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
     *         seconds. For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code>
     *         (for "Less than equal").
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-answered-x-historical"
     *         >Contacts answered in X seconds</a>
     *         </p>
     *         </dd>
     *         <dt>SUM_CONTACT_FLOW_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-flow-time-historical"
     *         >Contact flow time</a>
     *         </p>
     *         </dd>
     *         <dt>SUM_CONTACT_TIME_AGENT</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-on-contact-time-historical"
     *         >Agent on contact time</a>
     *         </p>
     *         </dd>
     *         <dt>SUM_CONTACTS_DISCONNECTED</dt>
     *         <dd>
     *         <p>
     *         Valid metric filter key: <code>DISCONNECT_REASON</code>
     *         </p>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
     *         contact/segmentAttributes/connect:Subtype, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-disconnected-historical"
     *         >Contact disconnected</a>
     *         </p>
     *         </dd>
     *         <dt>SUM_ERROR_STATUS_TIME_AGENT</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#error-status-time-historical"
     *         >Error status time</a>
     *         </p>
     *         </dd>
     *         <dt>SUM_HANDLE_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-handle-time-historical"
     *         >Contact handle time</a>
     *         </p>
     *         </dd>
     *         <dt>SUM_HOLD_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#customer-hold-time-historical"
     *         >Customer hold time</a>
     *         </p>
     *         </dd>
     *         <dt>SUM_IDLE_TIME_AGENT</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-idle-time-historica"
     *         >Agent idle time</a>
     *         </p>
     *         </dd>
     *         <dt>SUM_INTERACTION_AND_HOLD_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-hold-time-historical"
     *         >Agent interaction and hold time</a>
     *         </p>
     *         </dd>
     *         <dt>SUM_INTERACTION_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-time-historical"
     *         >Agent interaction time</a>
     *         </p>
     *         </dd>
     *         <dt>SUM_NON_PRODUCTIVE_TIME_AGENT</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#npt-historical"
     *         >Non-Productive Time</a>
     *         </p>
     *         </dd>
     *         <dt>SUM_ONLINE_TIME_AGENT</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#online-time-historical"
     *         >Online time</a>
     *         </p>
     *         </dd>
     *         <dt>SUM_RETRY_CALLBACK_ATTEMPTS</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype,
     *         Q in Connect
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#callback-attempts-historical"
     *         >Callback attempts</a>
     *         </p>
     *         </dd>
     */
    public final List<MetricV2> metrics() {
        return metrics;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(interval());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupings() ? groupings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricDataV2Request)) {
            return false;
        }
        GetMetricDataV2Request other = (GetMetricDataV2Request) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(interval(), other.interval())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && hasGroupings() == other.hasGroupings() && Objects.equals(groupings(), other.groupings())
                && hasMetrics() == other.hasMetrics() && Objects.equals(metrics(), other.metrics())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMetricDataV2Request").add("ResourceArn", resourceArn()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Interval", interval()).add("Filters", hasFilters() ? filters() : null)
                .add("Groupings", hasGroupings() ? groupings() : null).add("Metrics", hasMetrics() ? metrics() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Interval":
            return Optional.ofNullable(clazz.cast(interval()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Groupings":
            return Optional.ofNullable(clazz.cast(groupings()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Interval", INTERVAL_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("Groupings", GROUPINGS_FIELD);
        map.put("Metrics", METRICS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMetricDataV2Request, T> g) {
        return obj -> g.apply((GetMetricDataV2Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetMetricDataV2Request> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource. This includes the <code>instanceId</code> an Amazon Connect
         * instance.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the resource. This includes the <code>instanceId</code> an Amazon
         *        Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of
         * historical metrics data. The time must be before the end time timestamp. The start and end time depends on
         * the <code>IntervalPeriod</code> selected. By default the time range between start and end time is 35 days.
         * Historical metrics are available for 3 months.
         * </p>
         * 
         * @param startTime
         *        The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval
         *        of historical metrics data. The time must be before the end time timestamp. The start and end time
         *        depends on the <code>IntervalPeriod</code> selected. By default the time range between start and end
         *        time is 35 days. Historical metrics are available for 3 months.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of
         * historical metrics data. The time must be later than the start time timestamp. It cannot be later than the
         * current timestamp.
         * </p>
         * 
         * @param endTime
         *        The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of
         *        historical metrics data. The time must be later than the start time timestamp. It cannot be later than
         *        the current timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The interval period and timezone to apply to returned metrics.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IntervalPeriod</code>: An aggregated grouping applied to request metrics. Valid
         * <code>IntervalPeriod</code> values are: <code>FIFTEEN_MIN</code> | <code>THIRTY_MIN</code> |
         * <code>HOUR</code> | <code>DAY</code> | <code>WEEK</code> | <code>TOTAL</code>.
         * </p>
         * <p>
         * For example, if <code>IntervalPeriod</code> is selected <code>THIRTY_MIN</code>, <code>StartTime</code> and
         * <code>EndTime</code> differs by 1 day, then Amazon Connect returns 48 results in the response. Each result is
         * aggregated by the THIRTY_MIN period. By default Amazon Connect aggregates results based on the
         * <code>TOTAL</code> interval period.
         * </p>
         * <p>
         * The following list describes restrictions on <code>StartTime</code> and <code>EndTime</code> based on which
         * <code>IntervalPeriod</code> is requested.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FIFTEEN_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
         * than 3 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>THIRTY_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
         * than 3 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOUR</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 3
         * days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DAY</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 35
         * days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WEEK</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than
         * 35 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TOTAL</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than
         * 35 days.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TimeZone</code>: The timezone applied to requested metrics.
         * </p>
         * </li>
         * </ul>
         * 
         * @param interval
         *        The interval period and timezone to apply to returned metrics.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IntervalPeriod</code>: An aggregated grouping applied to request metrics. Valid
         *        <code>IntervalPeriod</code> values are: <code>FIFTEEN_MIN</code> | <code>THIRTY_MIN</code> |
         *        <code>HOUR</code> | <code>DAY</code> | <code>WEEK</code> | <code>TOTAL</code>.
         *        </p>
         *        <p>
         *        For example, if <code>IntervalPeriod</code> is selected <code>THIRTY_MIN</code>,
         *        <code>StartTime</code> and <code>EndTime</code> differs by 1 day, then Amazon Connect returns 48
         *        results in the response. Each result is aggregated by the THIRTY_MIN period. By default Amazon Connect
         *        aggregates results based on the <code>TOTAL</code> interval period.
         *        </p>
         *        <p>
         *        The following list describes restrictions on <code>StartTime</code> and <code>EndTime</code> based on
         *        which <code>IntervalPeriod</code> is requested.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FIFTEEN_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must
         *        be less than 3 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>THIRTY_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must
         *        be less than 3 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOUR</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
         *        than 3 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DAY</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
         *        than 35 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WEEK</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
         *        than 35 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TOTAL</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be
         *        less than 35 days.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TimeZone</code>: The timezone applied to requested metrics.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interval(IntervalDetails interval);

        /**
         * <p>
         * The interval period and timezone to apply to returned metrics.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IntervalPeriod</code>: An aggregated grouping applied to request metrics. Valid
         * <code>IntervalPeriod</code> values are: <code>FIFTEEN_MIN</code> | <code>THIRTY_MIN</code> |
         * <code>HOUR</code> | <code>DAY</code> | <code>WEEK</code> | <code>TOTAL</code>.
         * </p>
         * <p>
         * For example, if <code>IntervalPeriod</code> is selected <code>THIRTY_MIN</code>, <code>StartTime</code> and
         * <code>EndTime</code> differs by 1 day, then Amazon Connect returns 48 results in the response. Each result is
         * aggregated by the THIRTY_MIN period. By default Amazon Connect aggregates results based on the
         * <code>TOTAL</code> interval period.
         * </p>
         * <p>
         * The following list describes restrictions on <code>StartTime</code> and <code>EndTime</code> based on which
         * <code>IntervalPeriod</code> is requested.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FIFTEEN_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
         * than 3 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>THIRTY_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
         * than 3 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOUR</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 3
         * days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DAY</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 35
         * days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WEEK</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than
         * 35 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TOTAL</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than
         * 35 days.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TimeZone</code>: The timezone applied to requested metrics.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link IntervalDetails.Builder} avoiding the
         * need to create one manually via {@link IntervalDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntervalDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #interval(IntervalDetails)}.
         * 
         * @param interval
         *        a consumer that will call methods on {@link IntervalDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interval(IntervalDetails)
         */
        default Builder interval(Consumer<IntervalDetails.Builder> interval) {
            return interval(IntervalDetails.builder().applyMutation(interval).build());
        }

        /**
         * <p>
         * The filters to apply to returned metrics. You can filter on the following resources:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Agents
         * </p>
         * </li>
         * <li>
         * <p>
         * Campaigns
         * </p>
         * </li>
         * <li>
         * <p>
         * Channels
         * </p>
         * </li>
         * <li>
         * <p>
         * Feature
         * </p>
         * </li>
         * <li>
         * <p>
         * Queues
         * </p>
         * </li>
         * <li>
         * <p>
         * Routing profiles
         * </p>
         * </li>
         * <li>
         * <p>
         * Routing step expression
         * </p>
         * </li>
         * <li>
         * <p>
         * User hierarchy groups
         * </p>
         * </li>
         * </ul>
         * <p>
         * At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.
         * </p>
         * <p>
         * For metrics for outbound campaigns analytics, you can also use campaigns to satisfy at least one filter
         * requirement.
         * </p>
         * <p>
         * To filter by phone number, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html">Create a
         * historical metrics report</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * <p>
         * Note the following limits:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Filter keys</b>: A maximum of 5 filter keys are supported in a single request. Valid filter keys:
         * <code>AGENT</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
         * <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
         * <code>AGENT_HIERARCHY_LEVEL_FIVE</code> | <code>ANSWERING_MACHINE_DETECTION_STATUS</code> |
         * <code> BOT_ID</code> | <code>BOT_ALIAS</code> | <code>BOT_VERSION</code> | <code>BOT_LOCALE</code> |
         * <code>BOT_INTENT_NAME</code> | <code>CAMPAIGN</code> | <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code> |
         * <code>CASE_TEMPLATE_ARN</code> | <code>CASE_STATUS</code> | <code>CHANNEL</code> |
         * <code>contact/segmentAttributes/connect:Subtype</code> | <code>DISCONNECT_REASON</code> |
         * <code>FEATURE</code> | <code>FLOW_ACTION_ID</code> | <code>FLOW_TYPE</code> |
         * <code>FLOWS_MODULE_RESOURCE_ID</code> | <code>FLOWS_NEXT_RESOURCE_ID</code> |
         * <code>FLOWS_NEXT_RESOURCE_QUEUE_ID</code> | <code>FLOWS_OUTCOME_TYPE</code> | <code>FLOWS_RESOURCE_ID</code>
         * | <code>INITIATION_METHOD</code> | <code>INVOKING_RESOURCE_PUBLISHED_TIMESTAMP</code> |
         * <code>INVOKING_RESOURCE_TYPE</code> | <code>PARENT_FLOWS_RESOURCE_ID</code> |
         * <code>RESOURCE_PUBLISHED_TIMESTAMP</code> | <code>ROUTING_PROFILE</code> |
         * <code>ROUTING_STEP_EXPRESSION</code> | <code>QUEUE</code> | <code>Q_CONNECT_ENABLED</code> |
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Filter values</b>: A maximum of 100 filter values are supported in a single request. VOICE, CHAT, and TASK
         * are valid <code>filterValue</code> for the CHANNEL filter key. They do not count towards limitation of 100
         * filter values. For example, a GetMetricDataV2 request can filter by 50 queues, 35 agents, and 15 routing
         * profiles for a total of 100 filter values, along with 3 channel filters.
         * </p>
         * <p>
         * <code>contact_lens_conversational_analytics</code> is a valid filterValue for the <code>FEATURE</code> filter
         * key. It is available only to contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * <code>connect:Chat</code>, <code>connect:SMS</code>, <code>connect:Telephony</code>, and
         * <code>connect:WebRTC</code> are valid <code>filterValue</code> examples (not exhaustive) for the
         * <code>contact/segmentAttributes/connect:Subtype filter</code> key.
         * </p>
         * <p>
         * <code>ROUTING_STEP_EXPRESSION</code> is a valid filter key with a filter value up to 3000 length. This filter
         * is case and order sensitive. JSON string fields must be sorted in ascending order and JSON array order should
         * be kept as is.
         * </p>
         * <p>
         * <code>Q_CONNECT_ENABLED</code>. TRUE and FALSE are the only valid filterValues for the
         * <code>Q_CONNECT_ENABLED</code> filter key.
         * </p>
         * <ul>
         * <li>
         * <p>
         * TRUE includes all contacts that had Amazon Q in Connect enabled as part of the flow.
         * </p>
         * </li>
         * <li>
         * <p>
         * FALSE includes all contacts that did not have Amazon Q in Connect enabled as part of the flow
         * </p>
         * </li>
         * </ul>
         * <p>
         * This filter is available only for contact record-driven metrics.
         * </p>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-outbound-campaigns_Campaign.html"
         * >Campaign</a> ARNs are valid <code>filterValues</code> for the <code>CAMPAIGN</code> filter key.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters to apply to returned metrics. You can filter on the following resources:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Agents
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Campaigns
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Channels
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Feature
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Queues
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Routing profiles
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Routing step expression
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        User hierarchy groups
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.
         *        </p>
         *        <p>
         *        For metrics for outbound campaigns analytics, you can also use campaigns to satisfy at least one
         *        filter requirement.
         *        </p>
         *        <p>
         *        To filter by phone number, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html"
         *        >Create a historical metrics report</a> in the <i>Amazon Connect Administrator Guide</i>.
         *        </p>
         *        <p>
         *        Note the following limits:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Filter keys</b>: A maximum of 5 filter keys are supported in a single request. Valid filter keys:
         *        <code>AGENT</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
         *        <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
         *        <code>AGENT_HIERARCHY_LEVEL_FIVE</code> | <code>ANSWERING_MACHINE_DETECTION_STATUS</code> |
         *        <code> BOT_ID</code> | <code>BOT_ALIAS</code> | <code>BOT_VERSION</code> | <code>BOT_LOCALE</code> |
         *        <code>BOT_INTENT_NAME</code> | <code>CAMPAIGN</code> | <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code> |
         *        <code>CASE_TEMPLATE_ARN</code> | <code>CASE_STATUS</code> | <code>CHANNEL</code> |
         *        <code>contact/segmentAttributes/connect:Subtype</code> | <code>DISCONNECT_REASON</code> |
         *        <code>FEATURE</code> | <code>FLOW_ACTION_ID</code> | <code>FLOW_TYPE</code> |
         *        <code>FLOWS_MODULE_RESOURCE_ID</code> | <code>FLOWS_NEXT_RESOURCE_ID</code> |
         *        <code>FLOWS_NEXT_RESOURCE_QUEUE_ID</code> | <code>FLOWS_OUTCOME_TYPE</code> |
         *        <code>FLOWS_RESOURCE_ID</code> | <code>INITIATION_METHOD</code> |
         *        <code>INVOKING_RESOURCE_PUBLISHED_TIMESTAMP</code> | <code>INVOKING_RESOURCE_TYPE</code> |
         *        <code>PARENT_FLOWS_RESOURCE_ID</code> | <code>RESOURCE_PUBLISHED_TIMESTAMP</code> |
         *        <code>ROUTING_PROFILE</code> | <code>ROUTING_STEP_EXPRESSION</code> | <code>QUEUE</code> |
         *        <code>Q_CONNECT_ENABLED</code> |
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Filter values</b>: A maximum of 100 filter values are supported in a single request. VOICE, CHAT,
         *        and TASK are valid <code>filterValue</code> for the CHANNEL filter key. They do not count towards
         *        limitation of 100 filter values. For example, a GetMetricDataV2 request can filter by 50 queues, 35
         *        agents, and 15 routing profiles for a total of 100 filter values, along with 3 channel filters.
         *        </p>
         *        <p>
         *        <code>contact_lens_conversational_analytics</code> is a valid filterValue for the <code>FEATURE</code>
         *        filter key. It is available only to contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        <code>connect:Chat</code>, <code>connect:SMS</code>, <code>connect:Telephony</code>, and
         *        <code>connect:WebRTC</code> are valid <code>filterValue</code> examples (not exhaustive) for the
         *        <code>contact/segmentAttributes/connect:Subtype filter</code> key.
         *        </p>
         *        <p>
         *        <code>ROUTING_STEP_EXPRESSION</code> is a valid filter key with a filter value up to 3000 length. This
         *        filter is case and order sensitive. JSON string fields must be sorted in ascending order and JSON
         *        array order should be kept as is.
         *        </p>
         *        <p>
         *        <code>Q_CONNECT_ENABLED</code>. TRUE and FALSE are the only valid filterValues for the
         *        <code>Q_CONNECT_ENABLED</code> filter key.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        TRUE includes all contacts that had Amazon Q in Connect enabled as part of the flow.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FALSE includes all contacts that did not have Amazon Q in Connect enabled as part of the flow
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This filter is available only for contact record-driven metrics.
         *        </p>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-outbound-campaigns_Campaign.html"
         *        >Campaign</a> ARNs are valid <code>filterValues</code> for the <code>CAMPAIGN</code> filter key.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<FilterV2> filters);

        /**
         * <p>
         * The filters to apply to returned metrics. You can filter on the following resources:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Agents
         * </p>
         * </li>
         * <li>
         * <p>
         * Campaigns
         * </p>
         * </li>
         * <li>
         * <p>
         * Channels
         * </p>
         * </li>
         * <li>
         * <p>
         * Feature
         * </p>
         * </li>
         * <li>
         * <p>
         * Queues
         * </p>
         * </li>
         * <li>
         * <p>
         * Routing profiles
         * </p>
         * </li>
         * <li>
         * <p>
         * Routing step expression
         * </p>
         * </li>
         * <li>
         * <p>
         * User hierarchy groups
         * </p>
         * </li>
         * </ul>
         * <p>
         * At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.
         * </p>
         * <p>
         * For metrics for outbound campaigns analytics, you can also use campaigns to satisfy at least one filter
         * requirement.
         * </p>
         * <p>
         * To filter by phone number, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html">Create a
         * historical metrics report</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * <p>
         * Note the following limits:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Filter keys</b>: A maximum of 5 filter keys are supported in a single request. Valid filter keys:
         * <code>AGENT</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
         * <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
         * <code>AGENT_HIERARCHY_LEVEL_FIVE</code> | <code>ANSWERING_MACHINE_DETECTION_STATUS</code> |
         * <code> BOT_ID</code> | <code>BOT_ALIAS</code> | <code>BOT_VERSION</code> | <code>BOT_LOCALE</code> |
         * <code>BOT_INTENT_NAME</code> | <code>CAMPAIGN</code> | <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code> |
         * <code>CASE_TEMPLATE_ARN</code> | <code>CASE_STATUS</code> | <code>CHANNEL</code> |
         * <code>contact/segmentAttributes/connect:Subtype</code> | <code>DISCONNECT_REASON</code> |
         * <code>FEATURE</code> | <code>FLOW_ACTION_ID</code> | <code>FLOW_TYPE</code> |
         * <code>FLOWS_MODULE_RESOURCE_ID</code> | <code>FLOWS_NEXT_RESOURCE_ID</code> |
         * <code>FLOWS_NEXT_RESOURCE_QUEUE_ID</code> | <code>FLOWS_OUTCOME_TYPE</code> | <code>FLOWS_RESOURCE_ID</code>
         * | <code>INITIATION_METHOD</code> | <code>INVOKING_RESOURCE_PUBLISHED_TIMESTAMP</code> |
         * <code>INVOKING_RESOURCE_TYPE</code> | <code>PARENT_FLOWS_RESOURCE_ID</code> |
         * <code>RESOURCE_PUBLISHED_TIMESTAMP</code> | <code>ROUTING_PROFILE</code> |
         * <code>ROUTING_STEP_EXPRESSION</code> | <code>QUEUE</code> | <code>Q_CONNECT_ENABLED</code> |
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Filter values</b>: A maximum of 100 filter values are supported in a single request. VOICE, CHAT, and TASK
         * are valid <code>filterValue</code> for the CHANNEL filter key. They do not count towards limitation of 100
         * filter values. For example, a GetMetricDataV2 request can filter by 50 queues, 35 agents, and 15 routing
         * profiles for a total of 100 filter values, along with 3 channel filters.
         * </p>
         * <p>
         * <code>contact_lens_conversational_analytics</code> is a valid filterValue for the <code>FEATURE</code> filter
         * key. It is available only to contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * <code>connect:Chat</code>, <code>connect:SMS</code>, <code>connect:Telephony</code>, and
         * <code>connect:WebRTC</code> are valid <code>filterValue</code> examples (not exhaustive) for the
         * <code>contact/segmentAttributes/connect:Subtype filter</code> key.
         * </p>
         * <p>
         * <code>ROUTING_STEP_EXPRESSION</code> is a valid filter key with a filter value up to 3000 length. This filter
         * is case and order sensitive. JSON string fields must be sorted in ascending order and JSON array order should
         * be kept as is.
         * </p>
         * <p>
         * <code>Q_CONNECT_ENABLED</code>. TRUE and FALSE are the only valid filterValues for the
         * <code>Q_CONNECT_ENABLED</code> filter key.
         * </p>
         * <ul>
         * <li>
         * <p>
         * TRUE includes all contacts that had Amazon Q in Connect enabled as part of the flow.
         * </p>
         * </li>
         * <li>
         * <p>
         * FALSE includes all contacts that did not have Amazon Q in Connect enabled as part of the flow
         * </p>
         * </li>
         * </ul>
         * <p>
         * This filter is available only for contact record-driven metrics.
         * </p>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-outbound-campaigns_Campaign.html"
         * >Campaign</a> ARNs are valid <code>filterValues</code> for the <code>CAMPAIGN</code> filter key.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters to apply to returned metrics. You can filter on the following resources:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Agents
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Campaigns
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Channels
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Feature
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Queues
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Routing profiles
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Routing step expression
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        User hierarchy groups
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.
         *        </p>
         *        <p>
         *        For metrics for outbound campaigns analytics, you can also use campaigns to satisfy at least one
         *        filter requirement.
         *        </p>
         *        <p>
         *        To filter by phone number, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html"
         *        >Create a historical metrics report</a> in the <i>Amazon Connect Administrator Guide</i>.
         *        </p>
         *        <p>
         *        Note the following limits:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Filter keys</b>: A maximum of 5 filter keys are supported in a single request. Valid filter keys:
         *        <code>AGENT</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
         *        <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
         *        <code>AGENT_HIERARCHY_LEVEL_FIVE</code> | <code>ANSWERING_MACHINE_DETECTION_STATUS</code> |
         *        <code> BOT_ID</code> | <code>BOT_ALIAS</code> | <code>BOT_VERSION</code> | <code>BOT_LOCALE</code> |
         *        <code>BOT_INTENT_NAME</code> | <code>CAMPAIGN</code> | <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code> |
         *        <code>CASE_TEMPLATE_ARN</code> | <code>CASE_STATUS</code> | <code>CHANNEL</code> |
         *        <code>contact/segmentAttributes/connect:Subtype</code> | <code>DISCONNECT_REASON</code> |
         *        <code>FEATURE</code> | <code>FLOW_ACTION_ID</code> | <code>FLOW_TYPE</code> |
         *        <code>FLOWS_MODULE_RESOURCE_ID</code> | <code>FLOWS_NEXT_RESOURCE_ID</code> |
         *        <code>FLOWS_NEXT_RESOURCE_QUEUE_ID</code> | <code>FLOWS_OUTCOME_TYPE</code> |
         *        <code>FLOWS_RESOURCE_ID</code> | <code>INITIATION_METHOD</code> |
         *        <code>INVOKING_RESOURCE_PUBLISHED_TIMESTAMP</code> | <code>INVOKING_RESOURCE_TYPE</code> |
         *        <code>PARENT_FLOWS_RESOURCE_ID</code> | <code>RESOURCE_PUBLISHED_TIMESTAMP</code> |
         *        <code>ROUTING_PROFILE</code> | <code>ROUTING_STEP_EXPRESSION</code> | <code>QUEUE</code> |
         *        <code>Q_CONNECT_ENABLED</code> |
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Filter values</b>: A maximum of 100 filter values are supported in a single request. VOICE, CHAT,
         *        and TASK are valid <code>filterValue</code> for the CHANNEL filter key. They do not count towards
         *        limitation of 100 filter values. For example, a GetMetricDataV2 request can filter by 50 queues, 35
         *        agents, and 15 routing profiles for a total of 100 filter values, along with 3 channel filters.
         *        </p>
         *        <p>
         *        <code>contact_lens_conversational_analytics</code> is a valid filterValue for the <code>FEATURE</code>
         *        filter key. It is available only to contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        <code>connect:Chat</code>, <code>connect:SMS</code>, <code>connect:Telephony</code>, and
         *        <code>connect:WebRTC</code> are valid <code>filterValue</code> examples (not exhaustive) for the
         *        <code>contact/segmentAttributes/connect:Subtype filter</code> key.
         *        </p>
         *        <p>
         *        <code>ROUTING_STEP_EXPRESSION</code> is a valid filter key with a filter value up to 3000 length. This
         *        filter is case and order sensitive. JSON string fields must be sorted in ascending order and JSON
         *        array order should be kept as is.
         *        </p>
         *        <p>
         *        <code>Q_CONNECT_ENABLED</code>. TRUE and FALSE are the only valid filterValues for the
         *        <code>Q_CONNECT_ENABLED</code> filter key.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        TRUE includes all contacts that had Amazon Q in Connect enabled as part of the flow.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FALSE includes all contacts that did not have Amazon Q in Connect enabled as part of the flow
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This filter is available only for contact record-driven metrics.
         *        </p>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-outbound-campaigns_Campaign.html"
         *        >Campaign</a> ARNs are valid <code>filterValues</code> for the <code>CAMPAIGN</code> filter key.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(FilterV2... filters);

        /**
         * <p>
         * The filters to apply to returned metrics. You can filter on the following resources:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Agents
         * </p>
         * </li>
         * <li>
         * <p>
         * Campaigns
         * </p>
         * </li>
         * <li>
         * <p>
         * Channels
         * </p>
         * </li>
         * <li>
         * <p>
         * Feature
         * </p>
         * </li>
         * <li>
         * <p>
         * Queues
         * </p>
         * </li>
         * <li>
         * <p>
         * Routing profiles
         * </p>
         * </li>
         * <li>
         * <p>
         * Routing step expression
         * </p>
         * </li>
         * <li>
         * <p>
         * User hierarchy groups
         * </p>
         * </li>
         * </ul>
         * <p>
         * At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.
         * </p>
         * <p>
         * For metrics for outbound campaigns analytics, you can also use campaigns to satisfy at least one filter
         * requirement.
         * </p>
         * <p>
         * To filter by phone number, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html">Create a
         * historical metrics report</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * <p>
         * Note the following limits:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Filter keys</b>: A maximum of 5 filter keys are supported in a single request. Valid filter keys:
         * <code>AGENT</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
         * <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
         * <code>AGENT_HIERARCHY_LEVEL_FIVE</code> | <code>ANSWERING_MACHINE_DETECTION_STATUS</code> |
         * <code> BOT_ID</code> | <code>BOT_ALIAS</code> | <code>BOT_VERSION</code> | <code>BOT_LOCALE</code> |
         * <code>BOT_INTENT_NAME</code> | <code>CAMPAIGN</code> | <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code> |
         * <code>CASE_TEMPLATE_ARN</code> | <code>CASE_STATUS</code> | <code>CHANNEL</code> |
         * <code>contact/segmentAttributes/connect:Subtype</code> | <code>DISCONNECT_REASON</code> |
         * <code>FEATURE</code> | <code>FLOW_ACTION_ID</code> | <code>FLOW_TYPE</code> |
         * <code>FLOWS_MODULE_RESOURCE_ID</code> | <code>FLOWS_NEXT_RESOURCE_ID</code> |
         * <code>FLOWS_NEXT_RESOURCE_QUEUE_ID</code> | <code>FLOWS_OUTCOME_TYPE</code> | <code>FLOWS_RESOURCE_ID</code>
         * | <code>INITIATION_METHOD</code> | <code>INVOKING_RESOURCE_PUBLISHED_TIMESTAMP</code> |
         * <code>INVOKING_RESOURCE_TYPE</code> | <code>PARENT_FLOWS_RESOURCE_ID</code> |
         * <code>RESOURCE_PUBLISHED_TIMESTAMP</code> | <code>ROUTING_PROFILE</code> |
         * <code>ROUTING_STEP_EXPRESSION</code> | <code>QUEUE</code> | <code>Q_CONNECT_ENABLED</code> |
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Filter values</b>: A maximum of 100 filter values are supported in a single request. VOICE, CHAT, and TASK
         * are valid <code>filterValue</code> for the CHANNEL filter key. They do not count towards limitation of 100
         * filter values. For example, a GetMetricDataV2 request can filter by 50 queues, 35 agents, and 15 routing
         * profiles for a total of 100 filter values, along with 3 channel filters.
         * </p>
         * <p>
         * <code>contact_lens_conversational_analytics</code> is a valid filterValue for the <code>FEATURE</code> filter
         * key. It is available only to contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * <code>connect:Chat</code>, <code>connect:SMS</code>, <code>connect:Telephony</code>, and
         * <code>connect:WebRTC</code> are valid <code>filterValue</code> examples (not exhaustive) for the
         * <code>contact/segmentAttributes/connect:Subtype filter</code> key.
         * </p>
         * <p>
         * <code>ROUTING_STEP_EXPRESSION</code> is a valid filter key with a filter value up to 3000 length. This filter
         * is case and order sensitive. JSON string fields must be sorted in ascending order and JSON array order should
         * be kept as is.
         * </p>
         * <p>
         * <code>Q_CONNECT_ENABLED</code>. TRUE and FALSE are the only valid filterValues for the
         * <code>Q_CONNECT_ENABLED</code> filter key.
         * </p>
         * <ul>
         * <li>
         * <p>
         * TRUE includes all contacts that had Amazon Q in Connect enabled as part of the flow.
         * </p>
         * </li>
         * <li>
         * <p>
         * FALSE includes all contacts that did not have Amazon Q in Connect enabled as part of the flow
         * </p>
         * </li>
         * </ul>
         * <p>
         * This filter is available only for contact record-driven metrics.
         * </p>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-outbound-campaigns_Campaign.html"
         * >Campaign</a> ARNs are valid <code>filterValues</code> for the <code>CAMPAIGN</code> filter key.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.FilterV2.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.FilterV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.FilterV2.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<FilterV2>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.FilterV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<FilterV2>)
         */
        Builder filters(Consumer<FilterV2.Builder>... filters);

        /**
         * <p>
         * The grouping applied to the metrics that are returned. For example, when results are grouped by queue, the
         * metrics returned are grouped by queue. The values that are returned apply to the metrics for each queue. They
         * are not aggregated for all queues.
         * </p>
         * <p>
         * If no grouping is specified, a summary of all metrics is returned.
         * </p>
         * <p>
         * Valid grouping keys: <code>AGENT</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> |
         * <code>AGENT_HIERARCHY_LEVEL_TWO</code> | <code>AGENT_HIERARCHY_LEVEL_THREE</code> |
         * <code>AGENT_HIERARCHY_LEVEL_FOUR</code> | <code>AGENT_HIERARCHY_LEVEL_FIVE</code> |
         * <code>ANSWERING_MACHINE_DETECTION_STATUS</code> | <code>BOT_ID</code> | <code>BOT_ALIAS</code> |
         * <code>BOT_VERSION</code> | <code>BOT_LOCALE</code> | <code>BOT_INTENT_NAME</code> | <code>CAMPAIGN</code> |
         * <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code> | <code>CASE_TEMPLATE_ARN</code> | <code>CASE_STATUS</code> |
         * <code>CHANNEL</code> | <code>contact/segmentAttributes/connect:Subtype</code> |
         * <code>DISCONNECT_REASON</code> | <code>FLOWS_RESOURCE_ID</code> | <code>FLOWS_MODULE_RESOURCE_ID</code> |
         * <code>FLOW_ACTION_ID</code> | <code>FLOW_TYPE</code> | <code>FLOWS_OUTCOME_TYPE</code> |
         * <code>INITIATION_METHOD</code> | <code>INVOKING_RESOURCE_PUBLISHED_TIMESTAMP</code> |
         * <code>INVOKING_RESOURCE_TYPE</code> | <code>PARENT_FLOWS_RESOURCE_ID</code> | <code>Q_CONNECT_ENABLED</code>
         * | <code>QUEUE</code> | <code>RESOURCE_PUBLISHED_TIMESTAMP</code> | <code>ROUTING_PROFILE</code> |
         * <code>ROUTING_STEP_EXPRESSION</code>
         * </p>
         * 
         * @param groupings
         *        The grouping applied to the metrics that are returned. For example, when results are grouped by queue,
         *        the metrics returned are grouped by queue. The values that are returned apply to the metrics for each
         *        queue. They are not aggregated for all queues.</p>
         *        <p>
         *        If no grouping is specified, a summary of all metrics is returned.
         *        </p>
         *        <p>
         *        Valid grouping keys: <code>AGENT</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> |
         *        <code>AGENT_HIERARCHY_LEVEL_TWO</code> | <code>AGENT_HIERARCHY_LEVEL_THREE</code> |
         *        <code>AGENT_HIERARCHY_LEVEL_FOUR</code> | <code>AGENT_HIERARCHY_LEVEL_FIVE</code> |
         *        <code>ANSWERING_MACHINE_DETECTION_STATUS</code> | <code>BOT_ID</code> | <code>BOT_ALIAS</code> |
         *        <code>BOT_VERSION</code> | <code>BOT_LOCALE</code> | <code>BOT_INTENT_NAME</code> |
         *        <code>CAMPAIGN</code> | <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code> | <code>CASE_TEMPLATE_ARN</code> |
         *        <code>CASE_STATUS</code> | <code>CHANNEL</code> |
         *        <code>contact/segmentAttributes/connect:Subtype</code> | <code>DISCONNECT_REASON</code> |
         *        <code>FLOWS_RESOURCE_ID</code> | <code>FLOWS_MODULE_RESOURCE_ID</code> | <code>FLOW_ACTION_ID</code> |
         *        <code>FLOW_TYPE</code> | <code>FLOWS_OUTCOME_TYPE</code> | <code>INITIATION_METHOD</code> |
         *        <code>INVOKING_RESOURCE_PUBLISHED_TIMESTAMP</code> | <code>INVOKING_RESOURCE_TYPE</code> |
         *        <code>PARENT_FLOWS_RESOURCE_ID</code> | <code>Q_CONNECT_ENABLED</code> | <code>QUEUE</code> |
         *        <code>RESOURCE_PUBLISHED_TIMESTAMP</code> | <code>ROUTING_PROFILE</code> |
         *        <code>ROUTING_STEP_EXPRESSION</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupings(Collection<String> groupings);

        /**
         * <p>
         * The grouping applied to the metrics that are returned. For example, when results are grouped by queue, the
         * metrics returned are grouped by queue. The values that are returned apply to the metrics for each queue. They
         * are not aggregated for all queues.
         * </p>
         * <p>
         * If no grouping is specified, a summary of all metrics is returned.
         * </p>
         * <p>
         * Valid grouping keys: <code>AGENT</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> |
         * <code>AGENT_HIERARCHY_LEVEL_TWO</code> | <code>AGENT_HIERARCHY_LEVEL_THREE</code> |
         * <code>AGENT_HIERARCHY_LEVEL_FOUR</code> | <code>AGENT_HIERARCHY_LEVEL_FIVE</code> |
         * <code>ANSWERING_MACHINE_DETECTION_STATUS</code> | <code>BOT_ID</code> | <code>BOT_ALIAS</code> |
         * <code>BOT_VERSION</code> | <code>BOT_LOCALE</code> | <code>BOT_INTENT_NAME</code> | <code>CAMPAIGN</code> |
         * <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code> | <code>CASE_TEMPLATE_ARN</code> | <code>CASE_STATUS</code> |
         * <code>CHANNEL</code> | <code>contact/segmentAttributes/connect:Subtype</code> |
         * <code>DISCONNECT_REASON</code> | <code>FLOWS_RESOURCE_ID</code> | <code>FLOWS_MODULE_RESOURCE_ID</code> |
         * <code>FLOW_ACTION_ID</code> | <code>FLOW_TYPE</code> | <code>FLOWS_OUTCOME_TYPE</code> |
         * <code>INITIATION_METHOD</code> | <code>INVOKING_RESOURCE_PUBLISHED_TIMESTAMP</code> |
         * <code>INVOKING_RESOURCE_TYPE</code> | <code>PARENT_FLOWS_RESOURCE_ID</code> | <code>Q_CONNECT_ENABLED</code>
         * | <code>QUEUE</code> | <code>RESOURCE_PUBLISHED_TIMESTAMP</code> | <code>ROUTING_PROFILE</code> |
         * <code>ROUTING_STEP_EXPRESSION</code>
         * </p>
         * 
         * @param groupings
         *        The grouping applied to the metrics that are returned. For example, when results are grouped by queue,
         *        the metrics returned are grouped by queue. The values that are returned apply to the metrics for each
         *        queue. They are not aggregated for all queues.</p>
         *        <p>
         *        If no grouping is specified, a summary of all metrics is returned.
         *        </p>
         *        <p>
         *        Valid grouping keys: <code>AGENT</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> |
         *        <code>AGENT_HIERARCHY_LEVEL_TWO</code> | <code>AGENT_HIERARCHY_LEVEL_THREE</code> |
         *        <code>AGENT_HIERARCHY_LEVEL_FOUR</code> | <code>AGENT_HIERARCHY_LEVEL_FIVE</code> |
         *        <code>ANSWERING_MACHINE_DETECTION_STATUS</code> | <code>BOT_ID</code> | <code>BOT_ALIAS</code> |
         *        <code>BOT_VERSION</code> | <code>BOT_LOCALE</code> | <code>BOT_INTENT_NAME</code> |
         *        <code>CAMPAIGN</code> | <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code> | <code>CASE_TEMPLATE_ARN</code> |
         *        <code>CASE_STATUS</code> | <code>CHANNEL</code> |
         *        <code>contact/segmentAttributes/connect:Subtype</code> | <code>DISCONNECT_REASON</code> |
         *        <code>FLOWS_RESOURCE_ID</code> | <code>FLOWS_MODULE_RESOURCE_ID</code> | <code>FLOW_ACTION_ID</code> |
         *        <code>FLOW_TYPE</code> | <code>FLOWS_OUTCOME_TYPE</code> | <code>INITIATION_METHOD</code> |
         *        <code>INVOKING_RESOURCE_PUBLISHED_TIMESTAMP</code> | <code>INVOKING_RESOURCE_TYPE</code> |
         *        <code>PARENT_FLOWS_RESOURCE_ID</code> | <code>Q_CONNECT_ENABLED</code> | <code>QUEUE</code> |
         *        <code>RESOURCE_PUBLISHED_TIMESTAMP</code> | <code>ROUTING_PROFILE</code> |
         *        <code>ROUTING_STEP_EXPRESSION</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupings(String... groupings);

        /**
         * <p>
         * The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following historical
         * metrics are available. For a description of each metric, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
         * metrics definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * <dl>
         * <dt>ABANDONMENT_RATE</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#abandonment-rate-historical"
         * >Abandonment rate</a>
         * </p>
         * </dd>
         * <dt>AGENT_ADHERENT_TIME</dt>
         * <dd>
         * <p>
         * This metric is available only in Amazon Web Services Regions where <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
         * capacity planning, and scheduling</a> is available.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherent-time-historical"
         * >Adherent time</a>
         * </p>
         * </dd>
         * <dt>AGENT_ANSWER_RATE</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-answer-rate-historical"
         * >Agent answer rate</a>
         * </p>
         * </dd>
         * <dt>AGENT_NON_ADHERENT_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#non-adherent-time"
         * >Non-adherent time</a>
         * </p>
         * </dd>
         * <dt>AGENT_NON_RESPONSE</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-non-response"
         * >Agent non-response</a>
         * </p>
         * </dd>
         * <dt>AGENT_NON_RESPONSE_WITHOUT_CUSTOMER_ABANDONS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * Data for this metric is available starting from October 1, 2023 0:00:00 GMT.
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-nonresponse-no-abandon-historical"
         * >Agent non-response without customer abandons</a>
         * </p>
         * </dd>
         * <dt>AGENT_OCCUPANCY</dt>
         * <dd>
         * <p>
         * Unit: Percentage
         * </p>
         * <p>
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#occupancy-historical"
         * >Occupancy</a>
         * </p>
         * </dd>
         * <dt>AGENT_SCHEDULE_ADHERENCE</dt>
         * <dd>
         * <p>
         * This metric is available only in Amazon Web Services Regions where <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
         * capacity planning, and scheduling</a> is available.
         * </p>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherence-historical"
         * >Adherence</a>
         * </p>
         * </dd>
         * <dt>AGENT_SCHEDULED_TIME</dt>
         * <dd>
         * <p>
         * This metric is available only in Amazon Web Services Regions where <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
         * capacity planning, and scheduling</a> is available.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#scheduled-time-historical"
         * >Scheduled time</a>
         * </p>
         * </dd>
         * <dt>AVG_ABANDON_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-abandon-time-historical"
         * >Average queue abandon time</a>
         * </p>
         * </dd>
         * <dt>AVG_ACTIVE_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-active-time-historical"
         * >Average active time</a>
         * </p>
         * </dd>
         * <dt>AVG_AFTER_CONTACT_WORK_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-acw-time-historical"
         * >Average after contact work time</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_AGENT_CONNECTING_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>. For now, this metric only supports the following as
         * <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>CALLBACK</code> |
         * <code>API</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-avg-agent-api-connecting-time"
         * >Average agent API connecting time</a>
         * </p>
         * <note>
         * <p>
         * The <code>Negate</code> key in metric-level filters is not applicable for this metric.
         * </p>
         * </note></dd>
         * <dt>AVG_AGENT_PAUSE_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-pause-time-historical"
         * >Average agent pause time</a>
         * </p>
         * </dd>
         * <dt>AVG_BOT_CONVERSATION_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
         * version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking
         * resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#average-bot-conversation-time-metric"
         * >Average bot conversation time</a>
         * </p>
         * </dd>
         * <dt>AVG_BOT_CONVERSATION_TURNS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
         * version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking
         * resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#average-bot-conversation-turns-metric"
         * >Average bot conversation turns</a>
         * </p>
         * </dd>
         * <dt>AVG_CASE_RELATED_CONTACTS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contacts-case-historical"
         * >Average contacts per case</a>
         * </p>
         * </dd>
         * <dt>AVG_CASE_RESOLUTION_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-case-resolution-time-historical"
         * >Average case resolution time</a>
         * </p>
         * </dd>
         * <dt>AVG_CONTACT_DURATION</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contact-duration-historical"
         * >Average contact duration</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_CONVERSATION_DURATION</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-conversation-duration-historical"
         * >Average conversation duration</a>
         * </p>
         * </dd>
         * <dt>AVG_DIALS_PER_MINUTE</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns that use the agent assisted voice and automated voice
         * delivery modes.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Agent, Campaign, Queue, Routing Profile
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-dials-historical"
         * >Average dials per minute</a>
         * </p>
         * </dd>
         * <dt>AVG_FLOW_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
         * resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID,
         * Initiation method, Resource published timestamp
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-flow-time-historical"
         * >Average flow time</a>
         * </p>
         * </dd>
         * <dt>AVG_GREETING_TIME_AGENT</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-greeting-time-agent-historical"
         * >Average agent greeting time</a>
         * </p>
         * </dd>
         * <dt>AVG_HANDLE_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, RoutingStepExpression
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-handle-time-historical"
         * >Average handle time</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-customer-hold-time-historical"
         * >Average customer hold time</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_HOLD_TIME_ALL_CONTACTS</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#avg-customer-hold-time-all-contacts-historical"
         * >Average customer hold time all contacts</a>
         * </p>
         * </dd>
         * <dt>AVG_HOLDS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-holds-historical"
         * >Average holds</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_INTERACTION_AND_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-customer-hold-time-historical"
         * >Average agent interaction and customer hold time</a>
         * </p>
         * </dd>
         * <dt>AVG_INTERACTION_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-time-historical"
         * >Average agent interaction time</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_INTERRUPTIONS_AGENT</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-agent-historical"
         * >Average agent interruptions</a>
         * </p>
         * </dd>
         * <dt>AVG_INTERRUPTION_TIME_AGENT</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-time-agent-historical"
         * >Average agent interruption time</a>
         * </p>
         * </dd>
         * <dt>AVG_NON_TALK_TIME</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html##average-non-talk-time-historical"
         * >Average non-talk time</a>
         * </p>
         * </dd>
         * <dt>AVG_QUEUE_ANSWER_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-answer-time-historical"
         * >Average queue answer time</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_RESOLUTION_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in
         * Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-resolution-time-historical"
         * >Average resolution time</a>
         * </p>
         * </dd>
         * <dt>AVG_TALK_TIME</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-historical"
         * >Average talk time</a>
         * </p>
         * </dd>
         * <dt>AVG_TALK_TIME_AGENT</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-agent-historical"
         * >Average agent talk time</a>
         * </p>
         * </dd>
         * <dt>AVG_TALK_TIME_CUSTOMER</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-customer-historical"
         * >Average customer talk time</a>
         * </p>
         * </dd>
         * <dt>AVG_WAIT_TIME_AFTER_CUSTOMER_CONNECTION</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns that use the agent assisted voice and automated voice
         * delivery modes.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Campaign
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-wait-time-historical"
         * >Average wait time after customer connection</a>
         * </p>
         * </dd>
         * <dt>BOT_CONVERSATIONS_COMPLETED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
         * version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking
         * resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-conversations-completed-metric"
         * >Bot conversations</a>
         * </p>
         * </dd>
         * <dt>BOT_INTENTS_COMPLETED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
         * version, Bot locale, Bot intent name, Flows resource ID, Flows module resource ID, Flow type, Flow action ID,
         * Invoking resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-intents-completed-metric"
         * >Bot intents completed</a>
         * </p>
         * </dd>
         * <dt>CAMPAIGN_CONTACTS_ABANDONED_AFTER_X</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns using the agent assisted voice and automated voice
         * delivery modes.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Agent, Campaign
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you must enter <code>GT</code> (for <i>Greater than</i>).
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-contacts-abandoned-historical"
         * >Campaign contacts abandoned after X</a>
         * </p>
         * </dd>
         * <dt>CAMPAIGN_CONTACTS_ABANDONED_AFTER_X_RATE</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns using the agent assisted voice and automated voice
         * delivery modes.
         * </p>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Agent, Campaign
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you must enter <code>GT</code> (for <i>Greater than</i>).
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-contacts-abandoned-rate-historical"
         * >Campaign contacts abandoned after X rate</a>
         * </p>
         * </dd>
         * <dt>CAMPAIGN_INTERACTIONS</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns using the email delivery mode.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid metric filter key: CAMPAIGN_INTERACTION_EVENT_TYPE
         * </p>
         * <p>
         * Valid groupings and filters: Campaign
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-interactions-historical"
         * >Campaign interactions</a>
         * </p>
         * </dd>
         * <dt>CAMPAIGN_SEND_ATTEMPTS</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Campaign, Channel, contact/segmentAttributes/connect:Subtype
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-send-attempts-historical"
         * >Campaign send attempts</a>
         * </p>
         * </dd>
         * <dt>CASES_CREATED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-created-historical"
         * >Cases created</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_CREATED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-created-historical"
         * >Contacts created</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>, <code>DISCONNECT_REASON</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#api-contacts-handled-historical"
         * >API contacts handled</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>CONTACTS_HANDLED_BY_CONNECTED_TO_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical"
         * >Contacts handled (connected to agent timestamp)</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_HOLD_ABANDONS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical"
         * >Contacts hold disconnect</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_ON_HOLD_AGENT_DISCONNECT</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-agent-disconnect-historical"
         * >Contacts hold agent disconnect</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_ON_HOLD_CUSTOMER_DISCONNECT</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical"
         * >Contacts hold customer disconnect</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_PUT_ON_HOLD</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical"
         * >Contacts put on hold</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT_EXTERNAL</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-external-historical"
         * >Contacts transferred out external</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT_INTERNAL</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-internal-historical"
         * >Contacts transferred out internal</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_QUEUED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-historical"
         * >Contacts queued</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_QUEUED_BY_ENQUEUE</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-by-enqueue-historical"
         * >Contacts queued (enqueue timestamp)</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_REMOVED_FROM_QUEUE_IN_X</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code> (for
         * "Less than equal").
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-removed-historical"
         * >Contacts removed from queue in X seconds</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_RESOLVED_IN_X</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in
         * Connect
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code> (for
         * "Less than equal").
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-resolved-historical"
         * >Contacts resolved in X</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-historical"
         * >Contacts transferred out</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>CONTACTS_TRANSFERRED_OUT_BY_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical"
         * >Contacts transferred out by agent</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical"
         * >Contacts transferred out queue</a>
         * </p>
         * </dd>
         * <dt>CURRENT_CASES</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#current-cases-historical"
         * >Current cases</a>
         * </p>
         * </dd>
         * <dt>DELIVERY_ATTEMPTS</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid metric filter key: <code>ANSWERING_MACHINE_DETECTION_STATUS</code>,
         * <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code>, <code>DISCONNECT_REASON</code>
         * </p>
         * <p>
         * Valid groupings and filters: Agent, Answering Machine Detection Status, Campaign, Campaign Delivery
         * EventType, Channel, contact/segmentAttributes/connect:Subtype, Disconnect Reason, Queue, Routing Profile
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#delivery-attempts-historical"
         * >Delivery attempts</a>
         * </p>
         * <note>
         * <p>
         * Campaign Delivery EventType filter and grouping are only available for SMS and Email campaign delivery modes.
         * Agent, Queue, Routing Profile, Answering Machine Detection Status and Disconnect Reason are only available
         * for agent assisted voice and automated voice delivery modes.
         * </p>
         * </note></dd>
         * <dt>DELIVERY_ATTEMPT_DISPOSITION_RATE</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns. Dispositions for the agent assisted voice and automated
         * voice delivery modes are only available with answering machine detection enabled.
         * </p>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid metric filter key: <code>ANSWERING_MACHINE_DETECTION_STATUS</code>,
         * <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code>, <code>DISCONNECT_REASON</code>
         * </p>
         * <p>
         * Valid groupings and filters: Agent, Answering Machine Detection Status, Campaign, Channel,
         * contact/segmentAttributes/connect:Subtype, Disconnect Reason, Queue, Routing Profile
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#delivery-attempt-disposition-rate-historical"
         * >Delivery attempt disposition rate</a>
         * </p>
         * <note>
         * <p>
         * Campaign Delivery Event Type filter and grouping are only available for SMS and Email campaign delivery
         * modes. Agent, Queue, Routing Profile, Answering Machine Detection Status and Disconnect Reason are only
         * available for agent assisted voice and automated voice delivery modes.
         * </p>
         * </note></dd>
         * <dt>FLOWS_OUTCOME</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
         * resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID,
         * Initiation method, Resource published timestamp
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-historical"
         * >Flows outcome</a>
         * </p>
         * </dd>
         * <dt>FLOWS_STARTED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
         * resource ID, Flows resource ID, Initiation method, Resource published timestamp
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-started-historical"
         * >Flows started</a>
         * </p>
         * </dd>
         * <dt>HUMAN_ANSWERED_CALLS</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns. Dispositions for the agent assisted voice and automated
         * voice delivery modes are only available with answering machine detection enabled.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Agent, Campaign
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#human-answered-historical"
         * >Human answered</a>
         * </p>
         * </dd>
         * <dt>MAX_FLOW_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
         * resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID,
         * Initiation method, Resource published timestamp
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-flow-time-historical"
         * >Maximum flow time</a>
         * </p>
         * </dd>
         * <dt>MAX_QUEUED_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-queued-time-historical"
         * >Maximum queued time</a>
         * </p>
         * </dd>
         * <dt>MIN_FLOW_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
         * resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID,
         * Initiation method, Resource published timestamp
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#minimum-flow-time-historical"
         * >Minimum flow time</a>
         * </p>
         * </dd>
         * <dt>PERCENT_BOT_CONVERSATIONS_OUTCOME</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
         * version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking
         * resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#percent-bot-conversations-outcome-metric"
         * >Percent bot conversations outcome</a>
         * </p>
         * </dd>
         * <dt>PERCENT_BOT_INTENTS_OUTCOME</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
         * version, Bot locale, Bot intent name, Flows resource ID, Flows module resource ID, Flow type, Flow action ID,
         * Invoking resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#percent-bot-intents-outcome-metric"
         * >Percent bot intents outcome</a>
         * </p>
         * </dd>
         * <dt>PERCENT_CASES_FIRST_CONTACT_RESOLVED</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-first-contact-historical"
         * >Cases resolved on first contact</a>
         * </p>
         * </dd>
         * <dt>PERCENT_CONTACTS_STEP_EXPIRED</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, RoutingStepExpression
         * </p>
         * <p>
         * UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
         * </p>
         * </dd>
         * <dt>PERCENT_CONTACTS_STEP_JOINED</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, RoutingStepExpression
         * </p>
         * <p>
         * UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
         * </p>
         * </dd>
         * <dt>PERCENT_FLOWS_OUTCOME</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid metric filter key: <code>FLOWS_OUTCOME_TYPE</code>
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
         * resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID,
         * Initiation method, Resource published timestamp
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-percentage-historical"
         * >Flows outcome percentage</a>.
         * </p>
         * <note>
         * <p>
         * The <code>FLOWS_OUTCOME_TYPE</code> is not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>PERCENT_NON_TALK_TIME</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Percentage
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ntt-historical"
         * >Non-talk time percent</a>
         * </p>
         * </dd>
         * <dt>PERCENT_TALK_TIME</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Percentage
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#tt-historical"
         * >Talk time percent</a>
         * </p>
         * </dd>
         * <dt>PERCENT_TALK_TIME_AGENT</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Percentage
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttagent-historical"
         * >Agent talk time percent</a>
         * </p>
         * </dd>
         * <dt>PERCENT_TALK_TIME_CUSTOMER</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Percentage
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttcustomer-historical"
         * >Customer talk time percent</a>
         * </p>
         * </dd>
         * <dt>REOPENED_CASE_ACTIONS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-reopened-historical"
         * >Cases reopened</a>
         * </p>
         * </dd>
         * <dt>RESOLVED_CASE_ACTIONS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-historical"
         * >Cases resolved</a>
         * </p>
         * </dd>
         * <dt>SERVICE_LEVEL</dt>
         * <dd>
         * <p>
         * You can include up to 20 SERVICE_LEVEL metrics in a request.
         * </p>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code> (for
         * "Less than equal").
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#service-level-historical"
         * >Service level X</a>
         * </p>
         * </dd>
         * <dt>STEP_CONTACTS_QUEUED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, RoutingStepExpression
         * </p>
         * <p>
         * UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
         * </p>
         * </dd>
         * <dt>SUM_AFTER_CONTACT_WORK_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#acw-historical"
         * >After contact work time</a>
         * </p>
         * </dd>
         * <dt>SUM_CONNECTING_TIME_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>. This metric only supports the following filter keys
         * as <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>CALLBACK</code> |
         * <code>API</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-agent-api-connecting-time"
         * >Agent API connecting time</a>
         * </p>
         * <note>
         * <p>
         * The <code>Negate</code> key in metric-level filters is not applicable for this metric.
         * </p>
         * </note></dd>
         * <dt>CONTACTS_ABANDONED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Metric filter:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Valid values: <code>API</code>| <code>Incoming</code> | <code>Outbound</code> | <code>Transfer</code> |
         * <code>Callback</code> | <code>Queue_Transfer</code>| <code>Disconnect</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-historical"
         * >Contact abandoned</a>
         * </p>
         * </dd>
         * <dt>SUM_CONTACTS_ABANDONED_IN_X</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in
         * Connect
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code> (for
         * "Less than equal").
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-x-historical"
         * >Contacts abandoned in X seconds</a>
         * </p>
         * </dd>
         * <dt>SUM_CONTACTS_ANSWERED_IN_X</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in
         * Connect
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code> (for
         * "Less than equal").
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-answered-x-historical"
         * >Contacts answered in X seconds</a>
         * </p>
         * </dd>
         * <dt>SUM_CONTACT_FLOW_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-flow-time-historical"
         * >Contact flow time</a>
         * </p>
         * </dd>
         * <dt>SUM_CONTACT_TIME_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-on-contact-time-historical"
         * >Agent on contact time</a>
         * </p>
         * </dd>
         * <dt>SUM_CONTACTS_DISCONNECTED</dt>
         * <dd>
         * <p>
         * Valid metric filter key: <code>DISCONNECT_REASON</code>
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-disconnected-historical"
         * >Contact disconnected</a>
         * </p>
         * </dd>
         * <dt>SUM_ERROR_STATUS_TIME_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#error-status-time-historical"
         * >Error status time</a>
         * </p>
         * </dd>
         * <dt>SUM_HANDLE_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-handle-time-historical"
         * >Contact handle time</a>
         * </p>
         * </dd>
         * <dt>SUM_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#customer-hold-time-historical"
         * >Customer hold time</a>
         * </p>
         * </dd>
         * <dt>SUM_IDLE_TIME_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-idle-time-historica"
         * >Agent idle time</a>
         * </p>
         * </dd>
         * <dt>SUM_INTERACTION_AND_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-hold-time-historical"
         * >Agent interaction and hold time</a>
         * </p>
         * </dd>
         * <dt>SUM_INTERACTION_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-time-historical"
         * >Agent interaction time</a>
         * </p>
         * </dd>
         * <dt>SUM_NON_PRODUCTIVE_TIME_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#npt-historical"
         * >Non-Productive Time</a>
         * </p>
         * </dd>
         * <dt>SUM_ONLINE_TIME_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#online-time-historical"
         * >Online time</a>
         * </p>
         * </dd>
         * <dt>SUM_RETRY_CALLBACK_ATTEMPTS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in
         * Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#callback-attempts-historical"
         * >Callback attempts</a>
         * </p>
         * </dd>
         * </dl>
         * 
         * @param metrics
         *        The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following
         *        historical metrics are available. For a description of each metric, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html"
         *        >Historical metrics definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
         *        <dl>
         *        <dt>ABANDONMENT_RATE</dt>
         *        <dd>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#abandonment-rate-historical"
         *        >Abandonment rate</a>
         *        </p>
         *        </dd>
         *        <dt>AGENT_ADHERENT_TIME</dt>
         *        <dd>
         *        <p>
         *        This metric is available only in Amazon Web Services Regions where <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region"
         *        >Forecasting, capacity planning, and scheduling</a> is available.
         *        </p>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherent-time-historical"
         *        >Adherent time</a>
         *        </p>
         *        </dd>
         *        <dt>AGENT_ANSWER_RATE</dt>
         *        <dd>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-answer-rate-historical"
         *        >Agent answer rate</a>
         *        </p>
         *        </dd>
         *        <dt>AGENT_NON_ADHERENT_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#non-adherent-time"
         *        >Non-adherent time</a>
         *        </p>
         *        </dd>
         *        <dt>AGENT_NON_RESPONSE</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-non-response"
         *        >Agent non-response</a>
         *        </p>
         *        </dd>
         *        <dt>AGENT_NON_RESPONSE_WITHOUT_CUSTOMER_ABANDONS</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        Data for this metric is available starting from October 1, 2023 0:00:00 GMT.
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-nonresponse-no-abandon-historical"
         *        >Agent non-response without customer abandons</a>
         *        </p>
         *        </dd>
         *        <dt>AGENT_OCCUPANCY</dt>
         *        <dd>
         *        <p>
         *        Unit: Percentage
         *        </p>
         *        <p>
         *        Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#occupancy-historical"
         *        >Occupancy</a>
         *        </p>
         *        </dd>
         *        <dt>AGENT_SCHEDULE_ADHERENCE</dt>
         *        <dd>
         *        <p>
         *        This metric is available only in Amazon Web Services Regions where <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region"
         *        >Forecasting, capacity planning, and scheduling</a> is available.
         *        </p>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherence-historical"
         *        >Adherence</a>
         *        </p>
         *        </dd>
         *        <dt>AGENT_SCHEDULED_TIME</dt>
         *        <dd>
         *        <p>
         *        This metric is available only in Amazon Web Services Regions where <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region"
         *        >Forecasting, capacity planning, and scheduling</a> is available.
         *        </p>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#scheduled-time-historical"
         *        >Scheduled time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_ABANDON_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-abandon-time-historical"
         *        >Average queue abandon time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_ACTIVE_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-active-time-historical"
         *        >Average active time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_AFTER_CONTACT_WORK_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid metric filter key: <code>INITIATION_METHOD</code>
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-acw-time-historical"
         *        >Average after contact work time</a>
         *        </p>
         *        <note>
         *        <p>
         *        Feature is a valid filter but not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>AVG_AGENT_CONNECTING_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid metric filter key: <code>INITIATION_METHOD</code>. For now, this metric only supports the
         *        following as <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> |
         *        <code>CALLBACK</code> | <code>API</code>
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-avg-agent-api-connecting-time"
         *        >Average agent API connecting time</a>
         *        </p>
         *        <note>
         *        <p>
         *        The <code>Negate</code> key in metric-level filters is not applicable for this metric.
         *        </p>
         *        </note></dd>
         *        <dt>AVG_AGENT_PAUSE_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-pause-time-historical"
         *        >Average agent pause time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_BOT_CONVERSATION_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias,
         *        Bot version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID,
         *        Invoking resource published timestamp, Initiation method, Invoking resource type, Parent flows
         *        resource ID
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#average-bot-conversation-time-metric"
         *        >Average bot conversation time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_BOT_CONVERSATION_TURNS</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias,
         *        Bot version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID,
         *        Invoking resource published timestamp, Initiation method, Invoking resource type, Parent flows
         *        resource ID
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#average-bot-conversation-turns-metric"
         *        >Average bot conversation turns</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_CASE_RELATED_CONTACTS</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Required filter key: CASE_TEMPLATE_ARN
         *        </p>
         *        <p>
         *        Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contacts-case-historical"
         *        >Average contacts per case</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_CASE_RESOLUTION_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Required filter key: CASE_TEMPLATE_ARN
         *        </p>
         *        <p>
         *        Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-case-resolution-time-historical"
         *        >Average case resolution time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_CONTACT_DURATION</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contact-duration-historical"
         *        >Average contact duration</a>
         *        </p>
         *        <note>
         *        <p>
         *        Feature is a valid filter but not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>AVG_CONVERSATION_DURATION</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-conversation-duration-historical"
         *        >Average conversation duration</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_DIALS_PER_MINUTE</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for outbound campaigns that use the agent assisted voice and automated
         *        voice delivery modes.
         *        </p>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Agent, Campaign, Queue, Routing Profile
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-dials-historical"
         *        >Average dials per minute</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_FLOW_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows
         *        module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows
         *        resource ID, Initiation method, Resource published timestamp
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-flow-time-historical"
         *        >Average flow time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_GREETING_TIME_AGENT</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-greeting-time-agent-historical"
         *        >Average agent greeting time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_HANDLE_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         *        contact/segmentAttributes/connect:Subtype, RoutingStepExpression
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-handle-time-historical"
         *        >Average handle time</a>
         *        </p>
         *        <note>
         *        <p>
         *        Feature is a valid filter but not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>AVG_HOLD_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-customer-hold-time-historical"
         *        >Average customer hold time</a>
         *        </p>
         *        <note>
         *        <p>
         *        Feature is a valid filter but not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>AVG_HOLD_TIME_ALL_CONTACTS</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#avg-customer-hold-time-all-contacts-historical"
         *        >Average customer hold time all contacts</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_HOLDS</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-holds-historical"
         *        >Average holds</a>
         *        </p>
         *        <note>
         *        <p>
         *        Feature is a valid filter but not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>AVG_INTERACTION_AND_HOLD_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-customer-hold-time-historical"
         *        >Average agent interaction and customer hold time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_INTERACTION_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid metric filter key: <code>INITIATION_METHOD</code>
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-time-historical"
         *        >Average agent interaction time</a>
         *        </p>
         *        <note>
         *        <p>
         *        Feature is a valid filter but not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>AVG_INTERRUPTIONS_AGENT</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-agent-historical"
         *        >Average agent interruptions</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_INTERRUPTION_TIME_AGENT</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-time-agent-historical"
         *        >Average agent interruption time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_NON_TALK_TIME</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html##average-non-talk-time-historical"
         *        >Average non-talk time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_QUEUE_ANSWER_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-answer-time-historical"
         *        >Average queue answer time</a>
         *        </p>
         *        <note>
         *        <p>
         *        Feature is a valid filter but not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>AVG_RESOLUTION_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-resolution-time-historical"
         *        >Average resolution time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_TALK_TIME</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-historical"
         *        >Average talk time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_TALK_TIME_AGENT</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-agent-historical"
         *        >Average agent talk time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_TALK_TIME_CUSTOMER</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-customer-historical"
         *        >Average customer talk time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_WAIT_TIME_AFTER_CUSTOMER_CONNECTION</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for outbound campaigns that use the agent assisted voice and automated
         *        voice delivery modes.
         *        </p>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Campaign
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-wait-time-historical"
         *        >Average wait time after customer connection</a>
         *        </p>
         *        </dd>
         *        <dt>BOT_CONVERSATIONS_COMPLETED</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias,
         *        Bot version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID,
         *        Invoking resource published timestamp, Initiation method, Invoking resource type, Parent flows
         *        resource ID
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-conversations-completed-metric"
         *        >Bot conversations</a>
         *        </p>
         *        </dd>
         *        <dt>BOT_INTENTS_COMPLETED</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias,
         *        Bot version, Bot locale, Bot intent name, Flows resource ID, Flows module resource ID, Flow type, Flow
         *        action ID, Invoking resource published timestamp, Initiation method, Invoking resource type, Parent
         *        flows resource ID
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-intents-completed-metric"
         *        >Bot intents completed</a>
         *        </p>
         *        </dd>
         *        <dt>CAMPAIGN_CONTACTS_ABANDONED_AFTER_X</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for outbound campaigns using the agent assisted voice and automated
         *        voice delivery modes.
         *        </p>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Agent, Campaign
         *        </p>
         *        <p>
         *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
         *        seconds. For <code>Comparison</code>, you must enter <code>GT</code> (for <i>Greater than</i>).
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-contacts-abandoned-historical"
         *        >Campaign contacts abandoned after X</a>
         *        </p>
         *        </dd>
         *        <dt>CAMPAIGN_CONTACTS_ABANDONED_AFTER_X_RATE</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for outbound campaigns using the agent assisted voice and automated
         *        voice delivery modes.
         *        </p>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid groupings and filters: Agent, Campaign
         *        </p>
         *        <p>
         *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
         *        seconds. For <code>Comparison</code>, you must enter <code>GT</code> (for <i>Greater than</i>).
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-contacts-abandoned-rate-historical"
         *        >Campaign contacts abandoned after X rate</a>
         *        </p>
         *        </dd>
         *        <dt>CAMPAIGN_INTERACTIONS</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for outbound campaigns using the email delivery mode.
         *        </p>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid metric filter key: CAMPAIGN_INTERACTION_EVENT_TYPE
         *        </p>
         *        <p>
         *        Valid groupings and filters: Campaign
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-interactions-historical"
         *        >Campaign interactions</a>
         *        </p>
         *        </dd>
         *        <dt>CAMPAIGN_SEND_ATTEMPTS</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for outbound campaigns.
         *        </p>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Campaign, Channel, contact/segmentAttributes/connect:Subtype
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-send-attempts-historical"
         *        >Campaign send attempts</a>
         *        </p>
         *        </dd>
         *        <dt>CASES_CREATED</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Required filter key: CASE_TEMPLATE_ARN
         *        </p>
         *        <p>
         *        Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-created-historical"
         *        >Cases created</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_CREATED</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid metric filter key: <code>INITIATION_METHOD</code>
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-created-historical"
         *        >Contacts created</a>
         *        </p>
         *        <note>
         *        <p>
         *        Feature is a valid filter but not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid metric filter key: <code>INITIATION_METHOD</code>, <code>DISCONNECT_REASON</code>
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         *        contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#api-contacts-handled-historical"
         *        >API contacts handled</a>
         *        </p>
         *        <note>
         *        <p>
         *        Feature is a valid filter but not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>CONTACTS_HANDLED_BY_CONNECTED_TO_AGENT</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid metric filter key: <code>INITIATION_METHOD</code>
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical"
         *        >Contacts handled (connected to agent timestamp)</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HOLD_ABANDONS</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical"
         *        >Contacts hold disconnect</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_ON_HOLD_AGENT_DISCONNECT</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-agent-disconnect-historical"
         *        >Contacts hold agent disconnect</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_ON_HOLD_CUSTOMER_DISCONNECT</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical"
         *        >Contacts hold customer disconnect</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_PUT_ON_HOLD</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical"
         *        >Contacts put on hold</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT_EXTERNAL</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-external-historical"
         *        >Contacts transferred out external</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT_INTERNAL</dt>
         *        <dd>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-internal-historical"
         *        >Contacts transferred out internal</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_QUEUED</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-historical"
         *        >Contacts queued</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_QUEUED_BY_ENQUEUE</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-by-enqueue-historical"
         *        >Contacts queued (enqueue timestamp)</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_REMOVED_FROM_QUEUE_IN_X</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect
         *        </p>
         *        <p>
         *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
         *        seconds. For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or
         *        <code>LTE</code> (for "Less than equal").
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-removed-historical"
         *        >Contacts removed from queue in X seconds</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_RESOLVED_IN_X</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
         *        seconds. For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or
         *        <code>LTE</code> (for "Less than equal").
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-resolved-historical"
         *        >Contacts resolved in X</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-historical"
         *        >Contacts transferred out</a>
         *        </p>
         *        <note>
         *        <p>
         *        Feature is a valid filter but not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT_BY_AGENT</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical"
         *        >Contacts transferred out by agent</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical"
         *        >Contacts transferred out queue</a>
         *        </p>
         *        </dd>
         *        <dt>CURRENT_CASES</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Required filter key: CASE_TEMPLATE_ARN
         *        </p>
         *        <p>
         *        Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#current-cases-historical"
         *        >Current cases</a>
         *        </p>
         *        </dd>
         *        <dt>DELIVERY_ATTEMPTS</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for outbound campaigns.
         *        </p>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid metric filter key: <code>ANSWERING_MACHINE_DETECTION_STATUS</code>,
         *        <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code>, <code>DISCONNECT_REASON</code>
         *        </p>
         *        <p>
         *        Valid groupings and filters: Agent, Answering Machine Detection Status, Campaign, Campaign Delivery
         *        EventType, Channel, contact/segmentAttributes/connect:Subtype, Disconnect Reason, Queue, Routing
         *        Profile
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#delivery-attempts-historical"
         *        >Delivery attempts</a>
         *        </p>
         *        <note>
         *        <p>
         *        Campaign Delivery EventType filter and grouping are only available for SMS and Email campaign delivery
         *        modes. Agent, Queue, Routing Profile, Answering Machine Detection Status and Disconnect Reason are
         *        only available for agent assisted voice and automated voice delivery modes.
         *        </p>
         *        </note></dd>
         *        <dt>DELIVERY_ATTEMPT_DISPOSITION_RATE</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for outbound campaigns. Dispositions for the agent assisted voice and
         *        automated voice delivery modes are only available with answering machine detection enabled.
         *        </p>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid metric filter key: <code>ANSWERING_MACHINE_DETECTION_STATUS</code>,
         *        <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code>, <code>DISCONNECT_REASON</code>
         *        </p>
         *        <p>
         *        Valid groupings and filters: Agent, Answering Machine Detection Status, Campaign, Channel,
         *        contact/segmentAttributes/connect:Subtype, Disconnect Reason, Queue, Routing Profile
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#delivery-attempt-disposition-rate-historical"
         *        >Delivery attempt disposition rate</a>
         *        </p>
         *        <note>
         *        <p>
         *        Campaign Delivery Event Type filter and grouping are only available for SMS and Email campaign
         *        delivery modes. Agent, Queue, Routing Profile, Answering Machine Detection Status and Disconnect
         *        Reason are only available for agent assisted voice and automated voice delivery modes.
         *        </p>
         *        </note></dd>
         *        <dt>FLOWS_OUTCOME</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows
         *        module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows
         *        resource ID, Initiation method, Resource published timestamp
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-historical"
         *        >Flows outcome</a>
         *        </p>
         *        </dd>
         *        <dt>FLOWS_STARTED</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows
         *        module resource ID, Flows resource ID, Initiation method, Resource published timestamp
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-started-historical"
         *        >Flows started</a>
         *        </p>
         *        </dd>
         *        <dt>HUMAN_ANSWERED_CALLS</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for outbound campaigns. Dispositions for the agent assisted voice and
         *        automated voice delivery modes are only available with answering machine detection enabled.
         *        </p>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Agent, Campaign
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#human-answered-historical"
         *        >Human answered</a>
         *        </p>
         *        </dd>
         *        <dt>MAX_FLOW_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows
         *        module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows
         *        resource ID, Initiation method, Resource published timestamp
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-flow-time-historical"
         *        >Maximum flow time</a>
         *        </p>
         *        </dd>
         *        <dt>MAX_QUEUED_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-queued-time-historical"
         *        >Maximum queued time</a>
         *        </p>
         *        </dd>
         *        <dt>MIN_FLOW_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows
         *        module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows
         *        resource ID, Initiation method, Resource published timestamp
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#minimum-flow-time-historical"
         *        >Minimum flow time</a>
         *        </p>
         *        </dd>
         *        <dt>PERCENT_BOT_CONVERSATIONS_OUTCOME</dt>
         *        <dd>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias,
         *        Bot version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID,
         *        Invoking resource published timestamp, Initiation method, Invoking resource type, Parent flows
         *        resource ID
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#percent-bot-conversations-outcome-metric"
         *        >Percent bot conversations outcome</a>
         *        </p>
         *        </dd>
         *        <dt>PERCENT_BOT_INTENTS_OUTCOME</dt>
         *        <dd>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias,
         *        Bot version, Bot locale, Bot intent name, Flows resource ID, Flows module resource ID, Flow type, Flow
         *        action ID, Invoking resource published timestamp, Initiation method, Invoking resource type, Parent
         *        flows resource ID
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#percent-bot-intents-outcome-metric"
         *        >Percent bot intents outcome</a>
         *        </p>
         *        </dd>
         *        <dt>PERCENT_CASES_FIRST_CONTACT_RESOLVED</dt>
         *        <dd>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Required filter key: CASE_TEMPLATE_ARN
         *        </p>
         *        <p>
         *        Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-first-contact-historical"
         *        >Cases resolved on first contact</a>
         *        </p>
         *        </dd>
         *        <dt>PERCENT_CONTACTS_STEP_EXPIRED</dt>
         *        <dd>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, RoutingStepExpression
         *        </p>
         *        <p>
         *        UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
         *        </p>
         *        </dd>
         *        <dt>PERCENT_CONTACTS_STEP_JOINED</dt>
         *        <dd>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, RoutingStepExpression
         *        </p>
         *        <p>
         *        UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
         *        </p>
         *        </dd>
         *        <dt>PERCENT_FLOWS_OUTCOME</dt>
         *        <dd>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid metric filter key: <code>FLOWS_OUTCOME_TYPE</code>
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows
         *        module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows
         *        resource ID, Initiation method, Resource published timestamp
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-percentage-historical"
         *        >Flows outcome percentage</a>.
         *        </p>
         *        <note>
         *        <p>
         *        The <code>FLOWS_OUTCOME_TYPE</code> is not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>PERCENT_NON_TALK_TIME</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Percentage
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ntt-historical"
         *        >Non-talk time percent</a>
         *        </p>
         *        </dd>
         *        <dt>PERCENT_TALK_TIME</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Percentage
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#tt-historical"
         *        >Talk time percent</a>
         *        </p>
         *        </dd>
         *        <dt>PERCENT_TALK_TIME_AGENT</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Percentage
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttagent-historical"
         *        >Agent talk time percent</a>
         *        </p>
         *        </dd>
         *        <dt>PERCENT_TALK_TIME_CUSTOMER</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Percentage
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttcustomer-historical"
         *        >Customer talk time percent</a>
         *        </p>
         *        </dd>
         *        <dt>REOPENED_CASE_ACTIONS</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Required filter key: CASE_TEMPLATE_ARN
         *        </p>
         *        <p>
         *        Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-reopened-historical"
         *        >Cases reopened</a>
         *        </p>
         *        </dd>
         *        <dt>RESOLVED_CASE_ACTIONS</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Required filter key: CASE_TEMPLATE_ARN
         *        </p>
         *        <p>
         *        Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-historical"
         *        >Cases resolved</a>
         *        </p>
         *        </dd>
         *        <dt>SERVICE_LEVEL</dt>
         *        <dd>
         *        <p>
         *        You can include up to 20 SERVICE_LEVEL metrics in a request.
         *        </p>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect
         *        </p>
         *        <p>
         *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
         *        seconds. For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or
         *        <code>LTE</code> (for "Less than equal").
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#service-level-historical"
         *        >Service level X</a>
         *        </p>
         *        </dd>
         *        <dt>STEP_CONTACTS_QUEUED</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, RoutingStepExpression
         *        </p>
         *        <p>
         *        UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
         *        </p>
         *        </dd>
         *        <dt>SUM_AFTER_CONTACT_WORK_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#acw-historical"
         *        >After contact work time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_CONNECTING_TIME_AGENT</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid metric filter key: <code>INITIATION_METHOD</code>. This metric only supports the following
         *        filter keys as <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> |
         *        <code>CALLBACK</code> | <code>API</code>
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-agent-api-connecting-time"
         *        >Agent API connecting time</a>
         *        </p>
         *        <note>
         *        <p>
         *        The <code>Negate</code> key in metric-level filters is not applicable for this metric.
         *        </p>
         *        </note></dd>
         *        <dt>CONTACTS_ABANDONED</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Metric filter:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Valid values: <code>API</code>| <code>Incoming</code> | <code>Outbound</code> | <code>Transfer</code>
         *        | <code>Callback</code> | <code>Queue_Transfer</code>| <code>Disconnect</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-historical"
         *        >Contact abandoned</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_CONTACTS_ABANDONED_IN_X</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
         *        seconds. For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or
         *        <code>LTE</code> (for "Less than equal").
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-x-historical"
         *        >Contacts abandoned in X seconds</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_CONTACTS_ANSWERED_IN_X</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
         *        seconds. For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or
         *        <code>LTE</code> (for "Less than equal").
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-answered-x-historical"
         *        >Contacts answered in X seconds</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_CONTACT_FLOW_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-flow-time-historical"
         *        >Contact flow time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_CONTACT_TIME_AGENT</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-on-contact-time-historical"
         *        >Agent on contact time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_CONTACTS_DISCONNECTED</dt>
         *        <dd>
         *        <p>
         *        Valid metric filter key: <code>DISCONNECT_REASON</code>
         *        </p>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-disconnected-historical"
         *        >Contact disconnected</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_ERROR_STATUS_TIME_AGENT</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#error-status-time-historical"
         *        >Error status time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_HANDLE_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-handle-time-historical"
         *        >Contact handle time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_HOLD_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#customer-hold-time-historical"
         *        >Customer hold time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_IDLE_TIME_AGENT</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-idle-time-historica"
         *        >Agent idle time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_INTERACTION_AND_HOLD_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-hold-time-historical"
         *        >Agent interaction and hold time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_INTERACTION_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-time-historical"
         *        >Agent interaction time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_NON_PRODUCTIVE_TIME_AGENT</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#npt-historical"
         *        >Non-Productive Time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_ONLINE_TIME_AGENT</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#online-time-historical"
         *        >Online time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_RETRY_CALLBACK_ATTEMPTS</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#callback-attempts-historical"
         *        >Callback attempts</a>
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<MetricV2> metrics);

        /**
         * <p>
         * The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following historical
         * metrics are available. For a description of each metric, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
         * metrics definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * <dl>
         * <dt>ABANDONMENT_RATE</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#abandonment-rate-historical"
         * >Abandonment rate</a>
         * </p>
         * </dd>
         * <dt>AGENT_ADHERENT_TIME</dt>
         * <dd>
         * <p>
         * This metric is available only in Amazon Web Services Regions where <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
         * capacity planning, and scheduling</a> is available.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherent-time-historical"
         * >Adherent time</a>
         * </p>
         * </dd>
         * <dt>AGENT_ANSWER_RATE</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-answer-rate-historical"
         * >Agent answer rate</a>
         * </p>
         * </dd>
         * <dt>AGENT_NON_ADHERENT_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#non-adherent-time"
         * >Non-adherent time</a>
         * </p>
         * </dd>
         * <dt>AGENT_NON_RESPONSE</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-non-response"
         * >Agent non-response</a>
         * </p>
         * </dd>
         * <dt>AGENT_NON_RESPONSE_WITHOUT_CUSTOMER_ABANDONS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * Data for this metric is available starting from October 1, 2023 0:00:00 GMT.
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-nonresponse-no-abandon-historical"
         * >Agent non-response without customer abandons</a>
         * </p>
         * </dd>
         * <dt>AGENT_OCCUPANCY</dt>
         * <dd>
         * <p>
         * Unit: Percentage
         * </p>
         * <p>
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#occupancy-historical"
         * >Occupancy</a>
         * </p>
         * </dd>
         * <dt>AGENT_SCHEDULE_ADHERENCE</dt>
         * <dd>
         * <p>
         * This metric is available only in Amazon Web Services Regions where <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
         * capacity planning, and scheduling</a> is available.
         * </p>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherence-historical"
         * >Adherence</a>
         * </p>
         * </dd>
         * <dt>AGENT_SCHEDULED_TIME</dt>
         * <dd>
         * <p>
         * This metric is available only in Amazon Web Services Regions where <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
         * capacity planning, and scheduling</a> is available.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#scheduled-time-historical"
         * >Scheduled time</a>
         * </p>
         * </dd>
         * <dt>AVG_ABANDON_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-abandon-time-historical"
         * >Average queue abandon time</a>
         * </p>
         * </dd>
         * <dt>AVG_ACTIVE_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-active-time-historical"
         * >Average active time</a>
         * </p>
         * </dd>
         * <dt>AVG_AFTER_CONTACT_WORK_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-acw-time-historical"
         * >Average after contact work time</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_AGENT_CONNECTING_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>. For now, this metric only supports the following as
         * <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>CALLBACK</code> |
         * <code>API</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-avg-agent-api-connecting-time"
         * >Average agent API connecting time</a>
         * </p>
         * <note>
         * <p>
         * The <code>Negate</code> key in metric-level filters is not applicable for this metric.
         * </p>
         * </note></dd>
         * <dt>AVG_AGENT_PAUSE_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-pause-time-historical"
         * >Average agent pause time</a>
         * </p>
         * </dd>
         * <dt>AVG_BOT_CONVERSATION_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
         * version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking
         * resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#average-bot-conversation-time-metric"
         * >Average bot conversation time</a>
         * </p>
         * </dd>
         * <dt>AVG_BOT_CONVERSATION_TURNS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
         * version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking
         * resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#average-bot-conversation-turns-metric"
         * >Average bot conversation turns</a>
         * </p>
         * </dd>
         * <dt>AVG_CASE_RELATED_CONTACTS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contacts-case-historical"
         * >Average contacts per case</a>
         * </p>
         * </dd>
         * <dt>AVG_CASE_RESOLUTION_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-case-resolution-time-historical"
         * >Average case resolution time</a>
         * </p>
         * </dd>
         * <dt>AVG_CONTACT_DURATION</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contact-duration-historical"
         * >Average contact duration</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_CONVERSATION_DURATION</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-conversation-duration-historical"
         * >Average conversation duration</a>
         * </p>
         * </dd>
         * <dt>AVG_DIALS_PER_MINUTE</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns that use the agent assisted voice and automated voice
         * delivery modes.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Agent, Campaign, Queue, Routing Profile
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-dials-historical"
         * >Average dials per minute</a>
         * </p>
         * </dd>
         * <dt>AVG_FLOW_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
         * resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID,
         * Initiation method, Resource published timestamp
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-flow-time-historical"
         * >Average flow time</a>
         * </p>
         * </dd>
         * <dt>AVG_GREETING_TIME_AGENT</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-greeting-time-agent-historical"
         * >Average agent greeting time</a>
         * </p>
         * </dd>
         * <dt>AVG_HANDLE_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, RoutingStepExpression
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-handle-time-historical"
         * >Average handle time</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-customer-hold-time-historical"
         * >Average customer hold time</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_HOLD_TIME_ALL_CONTACTS</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#avg-customer-hold-time-all-contacts-historical"
         * >Average customer hold time all contacts</a>
         * </p>
         * </dd>
         * <dt>AVG_HOLDS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-holds-historical"
         * >Average holds</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_INTERACTION_AND_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-customer-hold-time-historical"
         * >Average agent interaction and customer hold time</a>
         * </p>
         * </dd>
         * <dt>AVG_INTERACTION_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-time-historical"
         * >Average agent interaction time</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_INTERRUPTIONS_AGENT</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-agent-historical"
         * >Average agent interruptions</a>
         * </p>
         * </dd>
         * <dt>AVG_INTERRUPTION_TIME_AGENT</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-time-agent-historical"
         * >Average agent interruption time</a>
         * </p>
         * </dd>
         * <dt>AVG_NON_TALK_TIME</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html##average-non-talk-time-historical"
         * >Average non-talk time</a>
         * </p>
         * </dd>
         * <dt>AVG_QUEUE_ANSWER_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-answer-time-historical"
         * >Average queue answer time</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_RESOLUTION_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in
         * Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-resolution-time-historical"
         * >Average resolution time</a>
         * </p>
         * </dd>
         * <dt>AVG_TALK_TIME</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-historical"
         * >Average talk time</a>
         * </p>
         * </dd>
         * <dt>AVG_TALK_TIME_AGENT</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-agent-historical"
         * >Average agent talk time</a>
         * </p>
         * </dd>
         * <dt>AVG_TALK_TIME_CUSTOMER</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-customer-historical"
         * >Average customer talk time</a>
         * </p>
         * </dd>
         * <dt>AVG_WAIT_TIME_AFTER_CUSTOMER_CONNECTION</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns that use the agent assisted voice and automated voice
         * delivery modes.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Campaign
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-wait-time-historical"
         * >Average wait time after customer connection</a>
         * </p>
         * </dd>
         * <dt>BOT_CONVERSATIONS_COMPLETED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
         * version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking
         * resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-conversations-completed-metric"
         * >Bot conversations</a>
         * </p>
         * </dd>
         * <dt>BOT_INTENTS_COMPLETED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
         * version, Bot locale, Bot intent name, Flows resource ID, Flows module resource ID, Flow type, Flow action ID,
         * Invoking resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-intents-completed-metric"
         * >Bot intents completed</a>
         * </p>
         * </dd>
         * <dt>CAMPAIGN_CONTACTS_ABANDONED_AFTER_X</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns using the agent assisted voice and automated voice
         * delivery modes.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Agent, Campaign
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you must enter <code>GT</code> (for <i>Greater than</i>).
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-contacts-abandoned-historical"
         * >Campaign contacts abandoned after X</a>
         * </p>
         * </dd>
         * <dt>CAMPAIGN_CONTACTS_ABANDONED_AFTER_X_RATE</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns using the agent assisted voice and automated voice
         * delivery modes.
         * </p>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Agent, Campaign
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you must enter <code>GT</code> (for <i>Greater than</i>).
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-contacts-abandoned-rate-historical"
         * >Campaign contacts abandoned after X rate</a>
         * </p>
         * </dd>
         * <dt>CAMPAIGN_INTERACTIONS</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns using the email delivery mode.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid metric filter key: CAMPAIGN_INTERACTION_EVENT_TYPE
         * </p>
         * <p>
         * Valid groupings and filters: Campaign
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-interactions-historical"
         * >Campaign interactions</a>
         * </p>
         * </dd>
         * <dt>CAMPAIGN_SEND_ATTEMPTS</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Campaign, Channel, contact/segmentAttributes/connect:Subtype
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-send-attempts-historical"
         * >Campaign send attempts</a>
         * </p>
         * </dd>
         * <dt>CASES_CREATED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-created-historical"
         * >Cases created</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_CREATED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-created-historical"
         * >Contacts created</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>, <code>DISCONNECT_REASON</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#api-contacts-handled-historical"
         * >API contacts handled</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>CONTACTS_HANDLED_BY_CONNECTED_TO_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical"
         * >Contacts handled (connected to agent timestamp)</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_HOLD_ABANDONS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical"
         * >Contacts hold disconnect</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_ON_HOLD_AGENT_DISCONNECT</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-agent-disconnect-historical"
         * >Contacts hold agent disconnect</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_ON_HOLD_CUSTOMER_DISCONNECT</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical"
         * >Contacts hold customer disconnect</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_PUT_ON_HOLD</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical"
         * >Contacts put on hold</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT_EXTERNAL</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-external-historical"
         * >Contacts transferred out external</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT_INTERNAL</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-internal-historical"
         * >Contacts transferred out internal</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_QUEUED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-historical"
         * >Contacts queued</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_QUEUED_BY_ENQUEUE</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-by-enqueue-historical"
         * >Contacts queued (enqueue timestamp)</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_REMOVED_FROM_QUEUE_IN_X</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code> (for
         * "Less than equal").
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-removed-historical"
         * >Contacts removed from queue in X seconds</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_RESOLVED_IN_X</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in
         * Connect
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code> (for
         * "Less than equal").
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-resolved-historical"
         * >Contacts resolved in X</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-historical"
         * >Contacts transferred out</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>CONTACTS_TRANSFERRED_OUT_BY_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical"
         * >Contacts transferred out by agent</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical"
         * >Contacts transferred out queue</a>
         * </p>
         * </dd>
         * <dt>CURRENT_CASES</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#current-cases-historical"
         * >Current cases</a>
         * </p>
         * </dd>
         * <dt>DELIVERY_ATTEMPTS</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid metric filter key: <code>ANSWERING_MACHINE_DETECTION_STATUS</code>,
         * <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code>, <code>DISCONNECT_REASON</code>
         * </p>
         * <p>
         * Valid groupings and filters: Agent, Answering Machine Detection Status, Campaign, Campaign Delivery
         * EventType, Channel, contact/segmentAttributes/connect:Subtype, Disconnect Reason, Queue, Routing Profile
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#delivery-attempts-historical"
         * >Delivery attempts</a>
         * </p>
         * <note>
         * <p>
         * Campaign Delivery EventType filter and grouping are only available for SMS and Email campaign delivery modes.
         * Agent, Queue, Routing Profile, Answering Machine Detection Status and Disconnect Reason are only available
         * for agent assisted voice and automated voice delivery modes.
         * </p>
         * </note></dd>
         * <dt>DELIVERY_ATTEMPT_DISPOSITION_RATE</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns. Dispositions for the agent assisted voice and automated
         * voice delivery modes are only available with answering machine detection enabled.
         * </p>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid metric filter key: <code>ANSWERING_MACHINE_DETECTION_STATUS</code>,
         * <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code>, <code>DISCONNECT_REASON</code>
         * </p>
         * <p>
         * Valid groupings and filters: Agent, Answering Machine Detection Status, Campaign, Channel,
         * contact/segmentAttributes/connect:Subtype, Disconnect Reason, Queue, Routing Profile
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#delivery-attempt-disposition-rate-historical"
         * >Delivery attempt disposition rate</a>
         * </p>
         * <note>
         * <p>
         * Campaign Delivery Event Type filter and grouping are only available for SMS and Email campaign delivery
         * modes. Agent, Queue, Routing Profile, Answering Machine Detection Status and Disconnect Reason are only
         * available for agent assisted voice and automated voice delivery modes.
         * </p>
         * </note></dd>
         * <dt>FLOWS_OUTCOME</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
         * resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID,
         * Initiation method, Resource published timestamp
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-historical"
         * >Flows outcome</a>
         * </p>
         * </dd>
         * <dt>FLOWS_STARTED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
         * resource ID, Flows resource ID, Initiation method, Resource published timestamp
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-started-historical"
         * >Flows started</a>
         * </p>
         * </dd>
         * <dt>HUMAN_ANSWERED_CALLS</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns. Dispositions for the agent assisted voice and automated
         * voice delivery modes are only available with answering machine detection enabled.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Agent, Campaign
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#human-answered-historical"
         * >Human answered</a>
         * </p>
         * </dd>
         * <dt>MAX_FLOW_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
         * resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID,
         * Initiation method, Resource published timestamp
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-flow-time-historical"
         * >Maximum flow time</a>
         * </p>
         * </dd>
         * <dt>MAX_QUEUED_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-queued-time-historical"
         * >Maximum queued time</a>
         * </p>
         * </dd>
         * <dt>MIN_FLOW_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
         * resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID,
         * Initiation method, Resource published timestamp
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#minimum-flow-time-historical"
         * >Minimum flow time</a>
         * </p>
         * </dd>
         * <dt>PERCENT_BOT_CONVERSATIONS_OUTCOME</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
         * version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking
         * resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#percent-bot-conversations-outcome-metric"
         * >Percent bot conversations outcome</a>
         * </p>
         * </dd>
         * <dt>PERCENT_BOT_INTENTS_OUTCOME</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
         * version, Bot locale, Bot intent name, Flows resource ID, Flows module resource ID, Flow type, Flow action ID,
         * Invoking resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#percent-bot-intents-outcome-metric"
         * >Percent bot intents outcome</a>
         * </p>
         * </dd>
         * <dt>PERCENT_CASES_FIRST_CONTACT_RESOLVED</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-first-contact-historical"
         * >Cases resolved on first contact</a>
         * </p>
         * </dd>
         * <dt>PERCENT_CONTACTS_STEP_EXPIRED</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, RoutingStepExpression
         * </p>
         * <p>
         * UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
         * </p>
         * </dd>
         * <dt>PERCENT_CONTACTS_STEP_JOINED</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, RoutingStepExpression
         * </p>
         * <p>
         * UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
         * </p>
         * </dd>
         * <dt>PERCENT_FLOWS_OUTCOME</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid metric filter key: <code>FLOWS_OUTCOME_TYPE</code>
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
         * resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID,
         * Initiation method, Resource published timestamp
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-percentage-historical"
         * >Flows outcome percentage</a>.
         * </p>
         * <note>
         * <p>
         * The <code>FLOWS_OUTCOME_TYPE</code> is not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>PERCENT_NON_TALK_TIME</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Percentage
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ntt-historical"
         * >Non-talk time percent</a>
         * </p>
         * </dd>
         * <dt>PERCENT_TALK_TIME</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Percentage
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#tt-historical"
         * >Talk time percent</a>
         * </p>
         * </dd>
         * <dt>PERCENT_TALK_TIME_AGENT</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Percentage
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttagent-historical"
         * >Agent talk time percent</a>
         * </p>
         * </dd>
         * <dt>PERCENT_TALK_TIME_CUSTOMER</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Percentage
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttcustomer-historical"
         * >Customer talk time percent</a>
         * </p>
         * </dd>
         * <dt>REOPENED_CASE_ACTIONS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-reopened-historical"
         * >Cases reopened</a>
         * </p>
         * </dd>
         * <dt>RESOLVED_CASE_ACTIONS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-historical"
         * >Cases resolved</a>
         * </p>
         * </dd>
         * <dt>SERVICE_LEVEL</dt>
         * <dd>
         * <p>
         * You can include up to 20 SERVICE_LEVEL metrics in a request.
         * </p>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code> (for
         * "Less than equal").
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#service-level-historical"
         * >Service level X</a>
         * </p>
         * </dd>
         * <dt>STEP_CONTACTS_QUEUED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, RoutingStepExpression
         * </p>
         * <p>
         * UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
         * </p>
         * </dd>
         * <dt>SUM_AFTER_CONTACT_WORK_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#acw-historical"
         * >After contact work time</a>
         * </p>
         * </dd>
         * <dt>SUM_CONNECTING_TIME_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>. This metric only supports the following filter keys
         * as <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>CALLBACK</code> |
         * <code>API</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-agent-api-connecting-time"
         * >Agent API connecting time</a>
         * </p>
         * <note>
         * <p>
         * The <code>Negate</code> key in metric-level filters is not applicable for this metric.
         * </p>
         * </note></dd>
         * <dt>CONTACTS_ABANDONED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Metric filter:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Valid values: <code>API</code>| <code>Incoming</code> | <code>Outbound</code> | <code>Transfer</code> |
         * <code>Callback</code> | <code>Queue_Transfer</code>| <code>Disconnect</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-historical"
         * >Contact abandoned</a>
         * </p>
         * </dd>
         * <dt>SUM_CONTACTS_ABANDONED_IN_X</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in
         * Connect
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code> (for
         * "Less than equal").
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-x-historical"
         * >Contacts abandoned in X seconds</a>
         * </p>
         * </dd>
         * <dt>SUM_CONTACTS_ANSWERED_IN_X</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in
         * Connect
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code> (for
         * "Less than equal").
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-answered-x-historical"
         * >Contacts answered in X seconds</a>
         * </p>
         * </dd>
         * <dt>SUM_CONTACT_FLOW_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-flow-time-historical"
         * >Contact flow time</a>
         * </p>
         * </dd>
         * <dt>SUM_CONTACT_TIME_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-on-contact-time-historical"
         * >Agent on contact time</a>
         * </p>
         * </dd>
         * <dt>SUM_CONTACTS_DISCONNECTED</dt>
         * <dd>
         * <p>
         * Valid metric filter key: <code>DISCONNECT_REASON</code>
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-disconnected-historical"
         * >Contact disconnected</a>
         * </p>
         * </dd>
         * <dt>SUM_ERROR_STATUS_TIME_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#error-status-time-historical"
         * >Error status time</a>
         * </p>
         * </dd>
         * <dt>SUM_HANDLE_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-handle-time-historical"
         * >Contact handle time</a>
         * </p>
         * </dd>
         * <dt>SUM_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#customer-hold-time-historical"
         * >Customer hold time</a>
         * </p>
         * </dd>
         * <dt>SUM_IDLE_TIME_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-idle-time-historica"
         * >Agent idle time</a>
         * </p>
         * </dd>
         * <dt>SUM_INTERACTION_AND_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-hold-time-historical"
         * >Agent interaction and hold time</a>
         * </p>
         * </dd>
         * <dt>SUM_INTERACTION_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-time-historical"
         * >Agent interaction time</a>
         * </p>
         * </dd>
         * <dt>SUM_NON_PRODUCTIVE_TIME_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#npt-historical"
         * >Non-Productive Time</a>
         * </p>
         * </dd>
         * <dt>SUM_ONLINE_TIME_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#online-time-historical"
         * >Online time</a>
         * </p>
         * </dd>
         * <dt>SUM_RETRY_CALLBACK_ATTEMPTS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in
         * Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#callback-attempts-historical"
         * >Callback attempts</a>
         * </p>
         * </dd>
         * </dl>
         * 
         * @param metrics
         *        The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following
         *        historical metrics are available. For a description of each metric, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html"
         *        >Historical metrics definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
         *        <dl>
         *        <dt>ABANDONMENT_RATE</dt>
         *        <dd>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#abandonment-rate-historical"
         *        >Abandonment rate</a>
         *        </p>
         *        </dd>
         *        <dt>AGENT_ADHERENT_TIME</dt>
         *        <dd>
         *        <p>
         *        This metric is available only in Amazon Web Services Regions where <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region"
         *        >Forecasting, capacity planning, and scheduling</a> is available.
         *        </p>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherent-time-historical"
         *        >Adherent time</a>
         *        </p>
         *        </dd>
         *        <dt>AGENT_ANSWER_RATE</dt>
         *        <dd>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-answer-rate-historical"
         *        >Agent answer rate</a>
         *        </p>
         *        </dd>
         *        <dt>AGENT_NON_ADHERENT_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#non-adherent-time"
         *        >Non-adherent time</a>
         *        </p>
         *        </dd>
         *        <dt>AGENT_NON_RESPONSE</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-non-response"
         *        >Agent non-response</a>
         *        </p>
         *        </dd>
         *        <dt>AGENT_NON_RESPONSE_WITHOUT_CUSTOMER_ABANDONS</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        Data for this metric is available starting from October 1, 2023 0:00:00 GMT.
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-nonresponse-no-abandon-historical"
         *        >Agent non-response without customer abandons</a>
         *        </p>
         *        </dd>
         *        <dt>AGENT_OCCUPANCY</dt>
         *        <dd>
         *        <p>
         *        Unit: Percentage
         *        </p>
         *        <p>
         *        Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#occupancy-historical"
         *        >Occupancy</a>
         *        </p>
         *        </dd>
         *        <dt>AGENT_SCHEDULE_ADHERENCE</dt>
         *        <dd>
         *        <p>
         *        This metric is available only in Amazon Web Services Regions where <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region"
         *        >Forecasting, capacity planning, and scheduling</a> is available.
         *        </p>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherence-historical"
         *        >Adherence</a>
         *        </p>
         *        </dd>
         *        <dt>AGENT_SCHEDULED_TIME</dt>
         *        <dd>
         *        <p>
         *        This metric is available only in Amazon Web Services Regions where <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region"
         *        >Forecasting, capacity planning, and scheduling</a> is available.
         *        </p>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#scheduled-time-historical"
         *        >Scheduled time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_ABANDON_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-abandon-time-historical"
         *        >Average queue abandon time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_ACTIVE_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-active-time-historical"
         *        >Average active time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_AFTER_CONTACT_WORK_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid metric filter key: <code>INITIATION_METHOD</code>
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-acw-time-historical"
         *        >Average after contact work time</a>
         *        </p>
         *        <note>
         *        <p>
         *        Feature is a valid filter but not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>AVG_AGENT_CONNECTING_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid metric filter key: <code>INITIATION_METHOD</code>. For now, this metric only supports the
         *        following as <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> |
         *        <code>CALLBACK</code> | <code>API</code>
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-avg-agent-api-connecting-time"
         *        >Average agent API connecting time</a>
         *        </p>
         *        <note>
         *        <p>
         *        The <code>Negate</code> key in metric-level filters is not applicable for this metric.
         *        </p>
         *        </note></dd>
         *        <dt>AVG_AGENT_PAUSE_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-pause-time-historical"
         *        >Average agent pause time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_BOT_CONVERSATION_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias,
         *        Bot version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID,
         *        Invoking resource published timestamp, Initiation method, Invoking resource type, Parent flows
         *        resource ID
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#average-bot-conversation-time-metric"
         *        >Average bot conversation time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_BOT_CONVERSATION_TURNS</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias,
         *        Bot version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID,
         *        Invoking resource published timestamp, Initiation method, Invoking resource type, Parent flows
         *        resource ID
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#average-bot-conversation-turns-metric"
         *        >Average bot conversation turns</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_CASE_RELATED_CONTACTS</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Required filter key: CASE_TEMPLATE_ARN
         *        </p>
         *        <p>
         *        Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contacts-case-historical"
         *        >Average contacts per case</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_CASE_RESOLUTION_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Required filter key: CASE_TEMPLATE_ARN
         *        </p>
         *        <p>
         *        Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-case-resolution-time-historical"
         *        >Average case resolution time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_CONTACT_DURATION</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contact-duration-historical"
         *        >Average contact duration</a>
         *        </p>
         *        <note>
         *        <p>
         *        Feature is a valid filter but not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>AVG_CONVERSATION_DURATION</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-conversation-duration-historical"
         *        >Average conversation duration</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_DIALS_PER_MINUTE</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for outbound campaigns that use the agent assisted voice and automated
         *        voice delivery modes.
         *        </p>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Agent, Campaign, Queue, Routing Profile
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-dials-historical"
         *        >Average dials per minute</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_FLOW_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows
         *        module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows
         *        resource ID, Initiation method, Resource published timestamp
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-flow-time-historical"
         *        >Average flow time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_GREETING_TIME_AGENT</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-greeting-time-agent-historical"
         *        >Average agent greeting time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_HANDLE_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         *        contact/segmentAttributes/connect:Subtype, RoutingStepExpression
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-handle-time-historical"
         *        >Average handle time</a>
         *        </p>
         *        <note>
         *        <p>
         *        Feature is a valid filter but not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>AVG_HOLD_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-customer-hold-time-historical"
         *        >Average customer hold time</a>
         *        </p>
         *        <note>
         *        <p>
         *        Feature is a valid filter but not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>AVG_HOLD_TIME_ALL_CONTACTS</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#avg-customer-hold-time-all-contacts-historical"
         *        >Average customer hold time all contacts</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_HOLDS</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-holds-historical"
         *        >Average holds</a>
         *        </p>
         *        <note>
         *        <p>
         *        Feature is a valid filter but not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>AVG_INTERACTION_AND_HOLD_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-customer-hold-time-historical"
         *        >Average agent interaction and customer hold time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_INTERACTION_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid metric filter key: <code>INITIATION_METHOD</code>
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-time-historical"
         *        >Average agent interaction time</a>
         *        </p>
         *        <note>
         *        <p>
         *        Feature is a valid filter but not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>AVG_INTERRUPTIONS_AGENT</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-agent-historical"
         *        >Average agent interruptions</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_INTERRUPTION_TIME_AGENT</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-time-agent-historical"
         *        >Average agent interruption time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_NON_TALK_TIME</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html##average-non-talk-time-historical"
         *        >Average non-talk time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_QUEUE_ANSWER_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-answer-time-historical"
         *        >Average queue answer time</a>
         *        </p>
         *        <note>
         *        <p>
         *        Feature is a valid filter but not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>AVG_RESOLUTION_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-resolution-time-historical"
         *        >Average resolution time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_TALK_TIME</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-historical"
         *        >Average talk time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_TALK_TIME_AGENT</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-agent-historical"
         *        >Average agent talk time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_TALK_TIME_CUSTOMER</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-customer-historical"
         *        >Average customer talk time</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_WAIT_TIME_AFTER_CUSTOMER_CONNECTION</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for outbound campaigns that use the agent assisted voice and automated
         *        voice delivery modes.
         *        </p>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Campaign
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-wait-time-historical"
         *        >Average wait time after customer connection</a>
         *        </p>
         *        </dd>
         *        <dt>BOT_CONVERSATIONS_COMPLETED</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias,
         *        Bot version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID,
         *        Invoking resource published timestamp, Initiation method, Invoking resource type, Parent flows
         *        resource ID
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-conversations-completed-metric"
         *        >Bot conversations</a>
         *        </p>
         *        </dd>
         *        <dt>BOT_INTENTS_COMPLETED</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias,
         *        Bot version, Bot locale, Bot intent name, Flows resource ID, Flows module resource ID, Flow type, Flow
         *        action ID, Invoking resource published timestamp, Initiation method, Invoking resource type, Parent
         *        flows resource ID
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-intents-completed-metric"
         *        >Bot intents completed</a>
         *        </p>
         *        </dd>
         *        <dt>CAMPAIGN_CONTACTS_ABANDONED_AFTER_X</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for outbound campaigns using the agent assisted voice and automated
         *        voice delivery modes.
         *        </p>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Agent, Campaign
         *        </p>
         *        <p>
         *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
         *        seconds. For <code>Comparison</code>, you must enter <code>GT</code> (for <i>Greater than</i>).
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-contacts-abandoned-historical"
         *        >Campaign contacts abandoned after X</a>
         *        </p>
         *        </dd>
         *        <dt>CAMPAIGN_CONTACTS_ABANDONED_AFTER_X_RATE</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for outbound campaigns using the agent assisted voice and automated
         *        voice delivery modes.
         *        </p>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid groupings and filters: Agent, Campaign
         *        </p>
         *        <p>
         *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
         *        seconds. For <code>Comparison</code>, you must enter <code>GT</code> (for <i>Greater than</i>).
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-contacts-abandoned-rate-historical"
         *        >Campaign contacts abandoned after X rate</a>
         *        </p>
         *        </dd>
         *        <dt>CAMPAIGN_INTERACTIONS</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for outbound campaigns using the email delivery mode.
         *        </p>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid metric filter key: CAMPAIGN_INTERACTION_EVENT_TYPE
         *        </p>
         *        <p>
         *        Valid groupings and filters: Campaign
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-interactions-historical"
         *        >Campaign interactions</a>
         *        </p>
         *        </dd>
         *        <dt>CAMPAIGN_SEND_ATTEMPTS</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for outbound campaigns.
         *        </p>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Campaign, Channel, contact/segmentAttributes/connect:Subtype
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-send-attempts-historical"
         *        >Campaign send attempts</a>
         *        </p>
         *        </dd>
         *        <dt>CASES_CREATED</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Required filter key: CASE_TEMPLATE_ARN
         *        </p>
         *        <p>
         *        Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-created-historical"
         *        >Cases created</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_CREATED</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid metric filter key: <code>INITIATION_METHOD</code>
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-created-historical"
         *        >Contacts created</a>
         *        </p>
         *        <note>
         *        <p>
         *        Feature is a valid filter but not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid metric filter key: <code>INITIATION_METHOD</code>, <code>DISCONNECT_REASON</code>
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         *        contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#api-contacts-handled-historical"
         *        >API contacts handled</a>
         *        </p>
         *        <note>
         *        <p>
         *        Feature is a valid filter but not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>CONTACTS_HANDLED_BY_CONNECTED_TO_AGENT</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid metric filter key: <code>INITIATION_METHOD</code>
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical"
         *        >Contacts handled (connected to agent timestamp)</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HOLD_ABANDONS</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical"
         *        >Contacts hold disconnect</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_ON_HOLD_AGENT_DISCONNECT</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-agent-disconnect-historical"
         *        >Contacts hold agent disconnect</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_ON_HOLD_CUSTOMER_DISCONNECT</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical"
         *        >Contacts hold customer disconnect</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_PUT_ON_HOLD</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical"
         *        >Contacts put on hold</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT_EXTERNAL</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-external-historical"
         *        >Contacts transferred out external</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT_INTERNAL</dt>
         *        <dd>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-internal-historical"
         *        >Contacts transferred out internal</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_QUEUED</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-historical"
         *        >Contacts queued</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_QUEUED_BY_ENQUEUE</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-by-enqueue-historical"
         *        >Contacts queued (enqueue timestamp)</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_REMOVED_FROM_QUEUE_IN_X</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect
         *        </p>
         *        <p>
         *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
         *        seconds. For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or
         *        <code>LTE</code> (for "Less than equal").
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-removed-historical"
         *        >Contacts removed from queue in X seconds</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_RESOLVED_IN_X</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
         *        seconds. For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or
         *        <code>LTE</code> (for "Less than equal").
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-resolved-historical"
         *        >Contacts resolved in X</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-historical"
         *        >Contacts transferred out</a>
         *        </p>
         *        <note>
         *        <p>
         *        Feature is a valid filter but not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT_BY_AGENT</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical"
         *        >Contacts transferred out by agent</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical"
         *        >Contacts transferred out queue</a>
         *        </p>
         *        </dd>
         *        <dt>CURRENT_CASES</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Required filter key: CASE_TEMPLATE_ARN
         *        </p>
         *        <p>
         *        Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#current-cases-historical"
         *        >Current cases</a>
         *        </p>
         *        </dd>
         *        <dt>DELIVERY_ATTEMPTS</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for outbound campaigns.
         *        </p>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid metric filter key: <code>ANSWERING_MACHINE_DETECTION_STATUS</code>,
         *        <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code>, <code>DISCONNECT_REASON</code>
         *        </p>
         *        <p>
         *        Valid groupings and filters: Agent, Answering Machine Detection Status, Campaign, Campaign Delivery
         *        EventType, Channel, contact/segmentAttributes/connect:Subtype, Disconnect Reason, Queue, Routing
         *        Profile
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#delivery-attempts-historical"
         *        >Delivery attempts</a>
         *        </p>
         *        <note>
         *        <p>
         *        Campaign Delivery EventType filter and grouping are only available for SMS and Email campaign delivery
         *        modes. Agent, Queue, Routing Profile, Answering Machine Detection Status and Disconnect Reason are
         *        only available for agent assisted voice and automated voice delivery modes.
         *        </p>
         *        </note></dd>
         *        <dt>DELIVERY_ATTEMPT_DISPOSITION_RATE</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for outbound campaigns. Dispositions for the agent assisted voice and
         *        automated voice delivery modes are only available with answering machine detection enabled.
         *        </p>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid metric filter key: <code>ANSWERING_MACHINE_DETECTION_STATUS</code>,
         *        <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code>, <code>DISCONNECT_REASON</code>
         *        </p>
         *        <p>
         *        Valid groupings and filters: Agent, Answering Machine Detection Status, Campaign, Channel,
         *        contact/segmentAttributes/connect:Subtype, Disconnect Reason, Queue, Routing Profile
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#delivery-attempt-disposition-rate-historical"
         *        >Delivery attempt disposition rate</a>
         *        </p>
         *        <note>
         *        <p>
         *        Campaign Delivery Event Type filter and grouping are only available for SMS and Email campaign
         *        delivery modes. Agent, Queue, Routing Profile, Answering Machine Detection Status and Disconnect
         *        Reason are only available for agent assisted voice and automated voice delivery modes.
         *        </p>
         *        </note></dd>
         *        <dt>FLOWS_OUTCOME</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows
         *        module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows
         *        resource ID, Initiation method, Resource published timestamp
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-historical"
         *        >Flows outcome</a>
         *        </p>
         *        </dd>
         *        <dt>FLOWS_STARTED</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows
         *        module resource ID, Flows resource ID, Initiation method, Resource published timestamp
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-started-historical"
         *        >Flows started</a>
         *        </p>
         *        </dd>
         *        <dt>HUMAN_ANSWERED_CALLS</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for outbound campaigns. Dispositions for the agent assisted voice and
         *        automated voice delivery modes are only available with answering machine detection enabled.
         *        </p>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Agent, Campaign
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#human-answered-historical"
         *        >Human answered</a>
         *        </p>
         *        </dd>
         *        <dt>MAX_FLOW_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows
         *        module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows
         *        resource ID, Initiation method, Resource published timestamp
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-flow-time-historical"
         *        >Maximum flow time</a>
         *        </p>
         *        </dd>
         *        <dt>MAX_QUEUED_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-queued-time-historical"
         *        >Maximum queued time</a>
         *        </p>
         *        </dd>
         *        <dt>MIN_FLOW_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows
         *        module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows
         *        resource ID, Initiation method, Resource published timestamp
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#minimum-flow-time-historical"
         *        >Minimum flow time</a>
         *        </p>
         *        </dd>
         *        <dt>PERCENT_BOT_CONVERSATIONS_OUTCOME</dt>
         *        <dd>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias,
         *        Bot version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID,
         *        Invoking resource published timestamp, Initiation method, Invoking resource type, Parent flows
         *        resource ID
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#percent-bot-conversations-outcome-metric"
         *        >Percent bot conversations outcome</a>
         *        </p>
         *        </dd>
         *        <dt>PERCENT_BOT_INTENTS_OUTCOME</dt>
         *        <dd>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias,
         *        Bot version, Bot locale, Bot intent name, Flows resource ID, Flows module resource ID, Flow type, Flow
         *        action ID, Invoking resource published timestamp, Initiation method, Invoking resource type, Parent
         *        flows resource ID
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#percent-bot-intents-outcome-metric"
         *        >Percent bot intents outcome</a>
         *        </p>
         *        </dd>
         *        <dt>PERCENT_CASES_FIRST_CONTACT_RESOLVED</dt>
         *        <dd>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Required filter key: CASE_TEMPLATE_ARN
         *        </p>
         *        <p>
         *        Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-first-contact-historical"
         *        >Cases resolved on first contact</a>
         *        </p>
         *        </dd>
         *        <dt>PERCENT_CONTACTS_STEP_EXPIRED</dt>
         *        <dd>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, RoutingStepExpression
         *        </p>
         *        <p>
         *        UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
         *        </p>
         *        </dd>
         *        <dt>PERCENT_CONTACTS_STEP_JOINED</dt>
         *        <dd>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, RoutingStepExpression
         *        </p>
         *        <p>
         *        UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
         *        </p>
         *        </dd>
         *        <dt>PERCENT_FLOWS_OUTCOME</dt>
         *        <dd>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid metric filter key: <code>FLOWS_OUTCOME_TYPE</code>
         *        </p>
         *        <p>
         *        Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows
         *        module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows
         *        resource ID, Initiation method, Resource published timestamp
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-percentage-historical"
         *        >Flows outcome percentage</a>.
         *        </p>
         *        <note>
         *        <p>
         *        The <code>FLOWS_OUTCOME_TYPE</code> is not a valid grouping.
         *        </p>
         *        </note></dd>
         *        <dt>PERCENT_NON_TALK_TIME</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Percentage
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ntt-historical"
         *        >Non-talk time percent</a>
         *        </p>
         *        </dd>
         *        <dt>PERCENT_TALK_TIME</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Percentage
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#tt-historical"
         *        >Talk time percent</a>
         *        </p>
         *        </dd>
         *        <dt>PERCENT_TALK_TIME_AGENT</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Percentage
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttagent-historical"
         *        >Agent talk time percent</a>
         *        </p>
         *        </dd>
         *        <dt>PERCENT_TALK_TIME_CUSTOMER</dt>
         *        <dd>
         *        <p>
         *        This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *        </p>
         *        <p>
         *        Unit: Percentage
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttcustomer-historical"
         *        >Customer talk time percent</a>
         *        </p>
         *        </dd>
         *        <dt>REOPENED_CASE_ACTIONS</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Required filter key: CASE_TEMPLATE_ARN
         *        </p>
         *        <p>
         *        Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-reopened-historical"
         *        >Cases reopened</a>
         *        </p>
         *        </dd>
         *        <dt>RESOLVED_CASE_ACTIONS</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Required filter key: CASE_TEMPLATE_ARN
         *        </p>
         *        <p>
         *        Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-historical"
         *        >Cases resolved</a>
         *        </p>
         *        </dd>
         *        <dt>SERVICE_LEVEL</dt>
         *        <dd>
         *        <p>
         *        You can include up to 20 SERVICE_LEVEL metrics in a request.
         *        </p>
         *        <p>
         *        Unit: Percent
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect
         *        </p>
         *        <p>
         *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
         *        seconds. For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or
         *        <code>LTE</code> (for "Less than equal").
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#service-level-historical"
         *        >Service level X</a>
         *        </p>
         *        </dd>
         *        <dt>STEP_CONTACTS_QUEUED</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, RoutingStepExpression
         *        </p>
         *        <p>
         *        UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
         *        </p>
         *        </dd>
         *        <dt>SUM_AFTER_CONTACT_WORK_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#acw-historical"
         *        >After contact work time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_CONNECTING_TIME_AGENT</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid metric filter key: <code>INITIATION_METHOD</code>. This metric only supports the following
         *        filter keys as <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> |
         *        <code>CALLBACK</code> | <code>API</code>
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-agent-api-connecting-time"
         *        >Agent API connecting time</a>
         *        </p>
         *        <note>
         *        <p>
         *        The <code>Negate</code> key in metric-level filters is not applicable for this metric.
         *        </p>
         *        </note></dd>
         *        <dt>CONTACTS_ABANDONED</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Metric filter:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Valid values: <code>API</code>| <code>Incoming</code> | <code>Outbound</code> | <code>Transfer</code>
         *        | <code>Callback</code> | <code>Queue_Transfer</code>| <code>Disconnect</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-historical"
         *        >Contact abandoned</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_CONTACTS_ABANDONED_IN_X</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
         *        seconds. For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or
         *        <code>LTE</code> (for "Less than equal").
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-x-historical"
         *        >Contacts abandoned in X seconds</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_CONTACTS_ANSWERED_IN_X</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
         *        seconds. For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or
         *        <code>LTE</code> (for "Less than equal").
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-answered-x-historical"
         *        >Contacts answered in X seconds</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_CONTACT_FLOW_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-flow-time-historical"
         *        >Contact flow time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_CONTACT_TIME_AGENT</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-on-contact-time-historical"
         *        >Agent on contact time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_CONTACTS_DISCONNECTED</dt>
         *        <dd>
         *        <p>
         *        Valid metric filter key: <code>DISCONNECT_REASON</code>
         *        </p>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-disconnected-historical"
         *        >Contact disconnected</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_ERROR_STATUS_TIME_AGENT</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#error-status-time-historical"
         *        >Error status time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_HANDLE_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-handle-time-historical"
         *        >Contact handle time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_HOLD_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#customer-hold-time-historical"
         *        >Customer hold time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_IDLE_TIME_AGENT</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-idle-time-historica"
         *        >Agent idle time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_INTERACTION_AND_HOLD_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-hold-time-historical"
         *        >Agent interaction and hold time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_INTERACTION_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-time-historical"
         *        >Agent interaction time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_NON_PRODUCTIVE_TIME_AGENT</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#npt-historical"
         *        >Non-Productive Time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_ONLINE_TIME_AGENT</dt>
         *        <dd>
         *        <p>
         *        Unit: Seconds
         *        </p>
         *        <p>
         *        Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#online-time-historical"
         *        >Online time</a>
         *        </p>
         *        </dd>
         *        <dt>SUM_RETRY_CALLBACK_ATTEMPTS</dt>
         *        <dd>
         *        <p>
         *        Unit: Count
         *        </p>
         *        <p>
         *        Valid groupings and filters: Queue, Channel, Routing Profile,
         *        contact/segmentAttributes/connect:Subtype, Q in Connect
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#callback-attempts-historical"
         *        >Callback attempts</a>
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(MetricV2... metrics);

        /**
         * <p>
         * The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following historical
         * metrics are available. For a description of each metric, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
         * metrics definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * <dl>
         * <dt>ABANDONMENT_RATE</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#abandonment-rate-historical"
         * >Abandonment rate</a>
         * </p>
         * </dd>
         * <dt>AGENT_ADHERENT_TIME</dt>
         * <dd>
         * <p>
         * This metric is available only in Amazon Web Services Regions where <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
         * capacity planning, and scheduling</a> is available.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherent-time-historical"
         * >Adherent time</a>
         * </p>
         * </dd>
         * <dt>AGENT_ANSWER_RATE</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-answer-rate-historical"
         * >Agent answer rate</a>
         * </p>
         * </dd>
         * <dt>AGENT_NON_ADHERENT_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#non-adherent-time"
         * >Non-adherent time</a>
         * </p>
         * </dd>
         * <dt>AGENT_NON_RESPONSE</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-non-response"
         * >Agent non-response</a>
         * </p>
         * </dd>
         * <dt>AGENT_NON_RESPONSE_WITHOUT_CUSTOMER_ABANDONS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * Data for this metric is available starting from October 1, 2023 0:00:00 GMT.
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-nonresponse-no-abandon-historical"
         * >Agent non-response without customer abandons</a>
         * </p>
         * </dd>
         * <dt>AGENT_OCCUPANCY</dt>
         * <dd>
         * <p>
         * Unit: Percentage
         * </p>
         * <p>
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#occupancy-historical"
         * >Occupancy</a>
         * </p>
         * </dd>
         * <dt>AGENT_SCHEDULE_ADHERENCE</dt>
         * <dd>
         * <p>
         * This metric is available only in Amazon Web Services Regions where <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
         * capacity planning, and scheduling</a> is available.
         * </p>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherence-historical"
         * >Adherence</a>
         * </p>
         * </dd>
         * <dt>AGENT_SCHEDULED_TIME</dt>
         * <dd>
         * <p>
         * This metric is available only in Amazon Web Services Regions where <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
         * capacity planning, and scheduling</a> is available.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#scheduled-time-historical"
         * >Scheduled time</a>
         * </p>
         * </dd>
         * <dt>AVG_ABANDON_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-abandon-time-historical"
         * >Average queue abandon time</a>
         * </p>
         * </dd>
         * <dt>AVG_ACTIVE_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-active-time-historical"
         * >Average active time</a>
         * </p>
         * </dd>
         * <dt>AVG_AFTER_CONTACT_WORK_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-acw-time-historical"
         * >Average after contact work time</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_AGENT_CONNECTING_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>. For now, this metric only supports the following as
         * <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>CALLBACK</code> |
         * <code>API</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-avg-agent-api-connecting-time"
         * >Average agent API connecting time</a>
         * </p>
         * <note>
         * <p>
         * The <code>Negate</code> key in metric-level filters is not applicable for this metric.
         * </p>
         * </note></dd>
         * <dt>AVG_AGENT_PAUSE_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-pause-time-historical"
         * >Average agent pause time</a>
         * </p>
         * </dd>
         * <dt>AVG_BOT_CONVERSATION_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
         * version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking
         * resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#average-bot-conversation-time-metric"
         * >Average bot conversation time</a>
         * </p>
         * </dd>
         * <dt>AVG_BOT_CONVERSATION_TURNS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
         * version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking
         * resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#average-bot-conversation-turns-metric"
         * >Average bot conversation turns</a>
         * </p>
         * </dd>
         * <dt>AVG_CASE_RELATED_CONTACTS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contacts-case-historical"
         * >Average contacts per case</a>
         * </p>
         * </dd>
         * <dt>AVG_CASE_RESOLUTION_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-case-resolution-time-historical"
         * >Average case resolution time</a>
         * </p>
         * </dd>
         * <dt>AVG_CONTACT_DURATION</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contact-duration-historical"
         * >Average contact duration</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_CONVERSATION_DURATION</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-conversation-duration-historical"
         * >Average conversation duration</a>
         * </p>
         * </dd>
         * <dt>AVG_DIALS_PER_MINUTE</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns that use the agent assisted voice and automated voice
         * delivery modes.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Agent, Campaign, Queue, Routing Profile
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-dials-historical"
         * >Average dials per minute</a>
         * </p>
         * </dd>
         * <dt>AVG_FLOW_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
         * resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID,
         * Initiation method, Resource published timestamp
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-flow-time-historical"
         * >Average flow time</a>
         * </p>
         * </dd>
         * <dt>AVG_GREETING_TIME_AGENT</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-greeting-time-agent-historical"
         * >Average agent greeting time</a>
         * </p>
         * </dd>
         * <dt>AVG_HANDLE_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, RoutingStepExpression
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-handle-time-historical"
         * >Average handle time</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-customer-hold-time-historical"
         * >Average customer hold time</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_HOLD_TIME_ALL_CONTACTS</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#avg-customer-hold-time-all-contacts-historical"
         * >Average customer hold time all contacts</a>
         * </p>
         * </dd>
         * <dt>AVG_HOLDS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-holds-historical"
         * >Average holds</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_INTERACTION_AND_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-customer-hold-time-historical"
         * >Average agent interaction and customer hold time</a>
         * </p>
         * </dd>
         * <dt>AVG_INTERACTION_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-time-historical"
         * >Average agent interaction time</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_INTERRUPTIONS_AGENT</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-agent-historical"
         * >Average agent interruptions</a>
         * </p>
         * </dd>
         * <dt>AVG_INTERRUPTION_TIME_AGENT</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-time-agent-historical"
         * >Average agent interruption time</a>
         * </p>
         * </dd>
         * <dt>AVG_NON_TALK_TIME</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html##average-non-talk-time-historical"
         * >Average non-talk time</a>
         * </p>
         * </dd>
         * <dt>AVG_QUEUE_ANSWER_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-answer-time-historical"
         * >Average queue answer time</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>AVG_RESOLUTION_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in
         * Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-resolution-time-historical"
         * >Average resolution time</a>
         * </p>
         * </dd>
         * <dt>AVG_TALK_TIME</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-historical"
         * >Average talk time</a>
         * </p>
         * </dd>
         * <dt>AVG_TALK_TIME_AGENT</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-agent-historical"
         * >Average agent talk time</a>
         * </p>
         * </dd>
         * <dt>AVG_TALK_TIME_CUSTOMER</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-customer-historical"
         * >Average customer talk time</a>
         * </p>
         * </dd>
         * <dt>AVG_WAIT_TIME_AFTER_CUSTOMER_CONNECTION</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns that use the agent assisted voice and automated voice
         * delivery modes.
         * </p>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Campaign
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-wait-time-historical"
         * >Average wait time after customer connection</a>
         * </p>
         * </dd>
         * <dt>BOT_CONVERSATIONS_COMPLETED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
         * version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking
         * resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-conversations-completed-metric"
         * >Bot conversations</a>
         * </p>
         * </dd>
         * <dt>BOT_INTENTS_COMPLETED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
         * version, Bot locale, Bot intent name, Flows resource ID, Flows module resource ID, Flow type, Flow action ID,
         * Invoking resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-intents-completed-metric"
         * >Bot intents completed</a>
         * </p>
         * </dd>
         * <dt>CAMPAIGN_CONTACTS_ABANDONED_AFTER_X</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns using the agent assisted voice and automated voice
         * delivery modes.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Agent, Campaign
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you must enter <code>GT</code> (for <i>Greater than</i>).
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-contacts-abandoned-historical"
         * >Campaign contacts abandoned after X</a>
         * </p>
         * </dd>
         * <dt>CAMPAIGN_CONTACTS_ABANDONED_AFTER_X_RATE</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns using the agent assisted voice and automated voice
         * delivery modes.
         * </p>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Agent, Campaign
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you must enter <code>GT</code> (for <i>Greater than</i>).
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-contacts-abandoned-rate-historical"
         * >Campaign contacts abandoned after X rate</a>
         * </p>
         * </dd>
         * <dt>CAMPAIGN_INTERACTIONS</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns using the email delivery mode.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid metric filter key: CAMPAIGN_INTERACTION_EVENT_TYPE
         * </p>
         * <p>
         * Valid groupings and filters: Campaign
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-interactions-historical"
         * >Campaign interactions</a>
         * </p>
         * </dd>
         * <dt>CAMPAIGN_SEND_ATTEMPTS</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Campaign, Channel, contact/segmentAttributes/connect:Subtype
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-send-attempts-historical"
         * >Campaign send attempts</a>
         * </p>
         * </dd>
         * <dt>CASES_CREATED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-created-historical"
         * >Cases created</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_CREATED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-created-historical"
         * >Contacts created</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>, <code>DISCONNECT_REASON</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#api-contacts-handled-historical"
         * >API contacts handled</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>CONTACTS_HANDLED_BY_CONNECTED_TO_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical"
         * >Contacts handled (connected to agent timestamp)</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_HOLD_ABANDONS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical"
         * >Contacts hold disconnect</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_ON_HOLD_AGENT_DISCONNECT</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-agent-disconnect-historical"
         * >Contacts hold agent disconnect</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_ON_HOLD_CUSTOMER_DISCONNECT</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical"
         * >Contacts hold customer disconnect</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_PUT_ON_HOLD</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical"
         * >Contacts put on hold</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT_EXTERNAL</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-external-historical"
         * >Contacts transferred out external</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT_INTERNAL</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-internal-historical"
         * >Contacts transferred out internal</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_QUEUED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-historical"
         * >Contacts queued</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_QUEUED_BY_ENQUEUE</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-by-enqueue-historical"
         * >Contacts queued (enqueue timestamp)</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_REMOVED_FROM_QUEUE_IN_X</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code> (for
         * "Less than equal").
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-removed-historical"
         * >Contacts removed from queue in X seconds</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_RESOLVED_IN_X</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in
         * Connect
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code> (for
         * "Less than equal").
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-resolved-historical"
         * >Contacts resolved in X</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-historical"
         * >Contacts transferred out</a>
         * </p>
         * <note>
         * <p>
         * Feature is a valid filter but not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>CONTACTS_TRANSFERRED_OUT_BY_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical"
         * >Contacts transferred out by agent</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical"
         * >Contacts transferred out queue</a>
         * </p>
         * </dd>
         * <dt>CURRENT_CASES</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#current-cases-historical"
         * >Current cases</a>
         * </p>
         * </dd>
         * <dt>DELIVERY_ATTEMPTS</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid metric filter key: <code>ANSWERING_MACHINE_DETECTION_STATUS</code>,
         * <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code>, <code>DISCONNECT_REASON</code>
         * </p>
         * <p>
         * Valid groupings and filters: Agent, Answering Machine Detection Status, Campaign, Campaign Delivery
         * EventType, Channel, contact/segmentAttributes/connect:Subtype, Disconnect Reason, Queue, Routing Profile
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#delivery-attempts-historical"
         * >Delivery attempts</a>
         * </p>
         * <note>
         * <p>
         * Campaign Delivery EventType filter and grouping are only available for SMS and Email campaign delivery modes.
         * Agent, Queue, Routing Profile, Answering Machine Detection Status and Disconnect Reason are only available
         * for agent assisted voice and automated voice delivery modes.
         * </p>
         * </note></dd>
         * <dt>DELIVERY_ATTEMPT_DISPOSITION_RATE</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns. Dispositions for the agent assisted voice and automated
         * voice delivery modes are only available with answering machine detection enabled.
         * </p>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid metric filter key: <code>ANSWERING_MACHINE_DETECTION_STATUS</code>,
         * <code>CAMPAIGN_DELIVERY_EVENT_TYPE</code>, <code>DISCONNECT_REASON</code>
         * </p>
         * <p>
         * Valid groupings and filters: Agent, Answering Machine Detection Status, Campaign, Channel,
         * contact/segmentAttributes/connect:Subtype, Disconnect Reason, Queue, Routing Profile
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#delivery-attempt-disposition-rate-historical"
         * >Delivery attempt disposition rate</a>
         * </p>
         * <note>
         * <p>
         * Campaign Delivery Event Type filter and grouping are only available for SMS and Email campaign delivery
         * modes. Agent, Queue, Routing Profile, Answering Machine Detection Status and Disconnect Reason are only
         * available for agent assisted voice and automated voice delivery modes.
         * </p>
         * </note></dd>
         * <dt>FLOWS_OUTCOME</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
         * resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID,
         * Initiation method, Resource published timestamp
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-historical"
         * >Flows outcome</a>
         * </p>
         * </dd>
         * <dt>FLOWS_STARTED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
         * resource ID, Flows resource ID, Initiation method, Resource published timestamp
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-started-historical"
         * >Flows started</a>
         * </p>
         * </dd>
         * <dt>HUMAN_ANSWERED_CALLS</dt>
         * <dd>
         * <p>
         * This metric is available only for outbound campaigns. Dispositions for the agent assisted voice and automated
         * voice delivery modes are only available with answering machine detection enabled.
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Agent, Campaign
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#human-answered-historical"
         * >Human answered</a>
         * </p>
         * </dd>
         * <dt>MAX_FLOW_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
         * resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID,
         * Initiation method, Resource published timestamp
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-flow-time-historical"
         * >Maximum flow time</a>
         * </p>
         * </dd>
         * <dt>MAX_QUEUED_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-queued-time-historical"
         * >Maximum queued time</a>
         * </p>
         * </dd>
         * <dt>MIN_FLOW_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
         * resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID,
         * Initiation method, Resource published timestamp
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#minimum-flow-time-historical"
         * >Minimum flow time</a>
         * </p>
         * </dd>
         * <dt>PERCENT_BOT_CONVERSATIONS_OUTCOME</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
         * version, Bot locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID, Invoking
         * resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#percent-bot-conversations-outcome-metric"
         * >Percent bot conversations outcome</a>
         * </p>
         * </dd>
         * <dt>PERCENT_BOT_INTENTS_OUTCOME</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
         * version, Bot locale, Bot intent name, Flows resource ID, Flows module resource ID, Flow type, Flow action ID,
         * Invoking resource published timestamp, Initiation method, Invoking resource type, Parent flows resource ID
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#percent-bot-intents-outcome-metric"
         * >Percent bot intents outcome</a>
         * </p>
         * </dd>
         * <dt>PERCENT_CASES_FIRST_CONTACT_RESOLVED</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-first-contact-historical"
         * >Cases resolved on first contact</a>
         * </p>
         * </dd>
         * <dt>PERCENT_CONTACTS_STEP_EXPIRED</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, RoutingStepExpression
         * </p>
         * <p>
         * UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
         * </p>
         * </dd>
         * <dt>PERCENT_CONTACTS_STEP_JOINED</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, RoutingStepExpression
         * </p>
         * <p>
         * UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
         * </p>
         * </dd>
         * <dt>PERCENT_FLOWS_OUTCOME</dt>
         * <dd>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid metric filter key: <code>FLOWS_OUTCOME_TYPE</code>
         * </p>
         * <p>
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module
         * resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID,
         * Initiation method, Resource published timestamp
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-percentage-historical"
         * >Flows outcome percentage</a>.
         * </p>
         * <note>
         * <p>
         * The <code>FLOWS_OUTCOME_TYPE</code> is not a valid grouping.
         * </p>
         * </note></dd>
         * <dt>PERCENT_NON_TALK_TIME</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Percentage
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ntt-historical"
         * >Non-talk time percent</a>
         * </p>
         * </dd>
         * <dt>PERCENT_TALK_TIME</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Percentage
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#tt-historical"
         * >Talk time percent</a>
         * </p>
         * </dd>
         * <dt>PERCENT_TALK_TIME_AGENT</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Percentage
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttagent-historical"
         * >Agent talk time percent</a>
         * </p>
         * </dd>
         * <dt>PERCENT_TALK_TIME_CUSTOMER</dt>
         * <dd>
         * <p>
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         * </p>
         * <p>
         * Unit: Percentage
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttcustomer-historical"
         * >Customer talk time percent</a>
         * </p>
         * </dd>
         * <dt>REOPENED_CASE_ACTIONS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-reopened-historical"
         * >Cases reopened</a>
         * </p>
         * </dd>
         * <dt>RESOLVED_CASE_ACTIONS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Required filter key: CASE_TEMPLATE_ARN
         * </p>
         * <p>
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-historical"
         * >Cases resolved</a>
         * </p>
         * </dd>
         * <dt>SERVICE_LEVEL</dt>
         * <dd>
         * <p>
         * You can include up to 20 SERVICE_LEVEL metrics in a request.
         * </p>
         * <p>
         * Unit: Percent
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code> (for
         * "Less than equal").
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#service-level-historical"
         * >Service level X</a>
         * </p>
         * </dd>
         * <dt>STEP_CONTACTS_QUEUED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, RoutingStepExpression
         * </p>
         * <p>
         * UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
         * </p>
         * </dd>
         * <dt>SUM_AFTER_CONTACT_WORK_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#acw-historical"
         * >After contact work time</a>
         * </p>
         * </dd>
         * <dt>SUM_CONNECTING_TIME_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid metric filter key: <code>INITIATION_METHOD</code>. This metric only supports the following filter keys
         * as <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>CALLBACK</code> |
         * <code>API</code>
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-agent-api-connecting-time"
         * >Agent API connecting time</a>
         * </p>
         * <note>
         * <p>
         * The <code>Negate</code> key in metric-level filters is not applicable for this metric.
         * </p>
         * </note></dd>
         * <dt>CONTACTS_ABANDONED</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Metric filter:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Valid values: <code>API</code>| <code>Incoming</code> | <code>Outbound</code> | <code>Transfer</code> |
         * <code>Callback</code> | <code>Queue_Transfer</code>| <code>Disconnect</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-historical"
         * >Contact abandoned</a>
         * </p>
         * </dd>
         * <dt>SUM_CONTACTS_ABANDONED_IN_X</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in
         * Connect
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code> (for
         * "Less than equal").
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-x-historical"
         * >Contacts abandoned in X seconds</a>
         * </p>
         * </dd>
         * <dt>SUM_CONTACTS_ANSWERED_IN_X</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in
         * Connect
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you can use <code>LT</code> (for "Less than") or <code>LTE</code> (for
         * "Less than equal").
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-answered-x-historical"
         * >Contacts answered in X seconds</a>
         * </p>
         * </dd>
         * <dt>SUM_CONTACT_FLOW_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-flow-time-historical"
         * >Contact flow time</a>
         * </p>
         * </dd>
         * <dt>SUM_CONTACT_TIME_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-on-contact-time-historical"
         * >Agent on contact time</a>
         * </p>
         * </dd>
         * <dt>SUM_CONTACTS_DISCONNECTED</dt>
         * <dd>
         * <p>
         * Valid metric filter key: <code>DISCONNECT_REASON</code>
         * </p>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy,
         * contact/segmentAttributes/connect:Subtype, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-disconnected-historical"
         * >Contact disconnected</a>
         * </p>
         * </dd>
         * <dt>SUM_ERROR_STATUS_TIME_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#error-status-time-historical"
         * >Error status time</a>
         * </p>
         * </dd>
         * <dt>SUM_HANDLE_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-handle-time-historical"
         * >Contact handle time</a>
         * </p>
         * </dd>
         * <dt>SUM_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#customer-hold-time-historical"
         * >Customer hold time</a>
         * </p>
         * </dd>
         * <dt>SUM_IDLE_TIME_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-idle-time-historica"
         * >Agent idle time</a>
         * </p>
         * </dd>
         * <dt>SUM_INTERACTION_AND_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-hold-time-historical"
         * >Agent interaction and hold time</a>
         * </p>
         * </dd>
         * <dt>SUM_INTERACTION_TIME</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-time-historical"
         * >Agent interaction time</a>
         * </p>
         * </dd>
         * <dt>SUM_NON_PRODUCTIVE_TIME_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#npt-historical"
         * >Non-Productive Time</a>
         * </p>
         * </dd>
         * <dt>SUM_ONLINE_TIME_AGENT</dt>
         * <dd>
         * <p>
         * Unit: Seconds
         * </p>
         * <p>
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#online-time-historical"
         * >Online time</a>
         * </p>
         * </dd>
         * <dt>SUM_RETRY_CALLBACK_ATTEMPTS</dt>
         * <dd>
         * <p>
         * Unit: Count
         * </p>
         * <p>
         * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in
         * Connect
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#callback-attempts-historical"
         * >Callback attempts</a>
         * </p>
         * </dd>
         * </dl>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.MetricV2.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.MetricV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.MetricV2.Builder#build()} is called immediately and its
         * result is passed to {@link #metrics(List<MetricV2>)}.
         * 
         * @param metrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.MetricV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(java.util.Collection<MetricV2>)
         */
        Builder metrics(Consumer<MetricV2.Builder>... metrics);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private Instant startTime;

        private Instant endTime;

        private IntervalDetails interval;

        private List<FilterV2> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> groupings = DefaultSdkAutoConstructList.getInstance();

        private List<MetricV2> metrics = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricDataV2Request model) {
            super(model);
            resourceArn(model.resourceArn);
            startTime(model.startTime);
            endTime(model.endTime);
            interval(model.interval);
            filters(model.filters);
            groupings(model.groupings);
            metrics(model.metrics);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final IntervalDetails.Builder getInterval() {
            return interval != null ? interval.toBuilder() : null;
        }

        public final void setInterval(IntervalDetails.BuilderImpl interval) {
            this.interval = interval != null ? interval.build() : null;
        }

        @Override
        public final Builder interval(IntervalDetails interval) {
            this.interval = interval;
            return this;
        }

        public final List<FilterV2.Builder> getFilters() {
            List<FilterV2.Builder> result = FiltersV2ListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<FilterV2.BuilderImpl> filters) {
            this.filters = FiltersV2ListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<FilterV2> filters) {
            this.filters = FiltersV2ListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(FilterV2... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<FilterV2.Builder>... filters) {
            filters(Stream.of(filters).map(c -> FilterV2.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getGroupings() {
            if (groupings instanceof SdkAutoConstructList) {
                return null;
            }
            return groupings;
        }

        public final void setGroupings(Collection<String> groupings) {
            this.groupings = GroupingsV2Copier.copy(groupings);
        }

        @Override
        public final Builder groupings(Collection<String> groupings) {
            this.groupings = GroupingsV2Copier.copy(groupings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupings(String... groupings) {
            groupings(Arrays.asList(groupings));
            return this;
        }

        public final List<MetricV2.Builder> getMetrics() {
            List<MetricV2.Builder> result = MetricsV2Copier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<MetricV2.BuilderImpl> metrics) {
            this.metrics = MetricsV2Copier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<MetricV2> metrics) {
            this.metrics = MetricsV2Copier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(MetricV2... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<MetricV2.Builder>... metrics) {
            metrics(Stream.of(metrics).map(c -> MetricV2.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMetricDataV2Request build() {
            return new GetMetricDataV2Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
