/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the agent hierarchy. Hierarchies can be configured with up to five levels.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HierarchyGroups implements SdkPojo, Serializable, ToCopyableBuilder<HierarchyGroups.Builder, HierarchyGroups> {
    private static final SdkField<AgentHierarchyGroup> LEVEL1_FIELD = SdkField
            .<AgentHierarchyGroup> builder(MarshallingType.SDK_POJO).memberName("Level1").getter(getter(HierarchyGroups::level1))
            .setter(setter(Builder::level1)).constructor(AgentHierarchyGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Level1").build()).build();

    private static final SdkField<AgentHierarchyGroup> LEVEL2_FIELD = SdkField
            .<AgentHierarchyGroup> builder(MarshallingType.SDK_POJO).memberName("Level2").getter(getter(HierarchyGroups::level2))
            .setter(setter(Builder::level2)).constructor(AgentHierarchyGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Level2").build()).build();

    private static final SdkField<AgentHierarchyGroup> LEVEL3_FIELD = SdkField
            .<AgentHierarchyGroup> builder(MarshallingType.SDK_POJO).memberName("Level3").getter(getter(HierarchyGroups::level3))
            .setter(setter(Builder::level3)).constructor(AgentHierarchyGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Level3").build()).build();

    private static final SdkField<AgentHierarchyGroup> LEVEL4_FIELD = SdkField
            .<AgentHierarchyGroup> builder(MarshallingType.SDK_POJO).memberName("Level4").getter(getter(HierarchyGroups::level4))
            .setter(setter(Builder::level4)).constructor(AgentHierarchyGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Level4").build()).build();

    private static final SdkField<AgentHierarchyGroup> LEVEL5_FIELD = SdkField
            .<AgentHierarchyGroup> builder(MarshallingType.SDK_POJO).memberName("Level5").getter(getter(HierarchyGroups::level5))
            .setter(setter(Builder::level5)).constructor(AgentHierarchyGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Level5").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEVEL1_FIELD, LEVEL2_FIELD,
            LEVEL3_FIELD, LEVEL4_FIELD, LEVEL5_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AgentHierarchyGroup level1;

    private final AgentHierarchyGroup level2;

    private final AgentHierarchyGroup level3;

    private final AgentHierarchyGroup level4;

    private final AgentHierarchyGroup level5;

    private HierarchyGroups(BuilderImpl builder) {
        this.level1 = builder.level1;
        this.level2 = builder.level2;
        this.level3 = builder.level3;
        this.level4 = builder.level4;
        this.level5 = builder.level5;
    }

    /**
     * <p>
     * The group at level one of the agent hierarchy.
     * </p>
     * 
     * @return The group at level one of the agent hierarchy.
     */
    public final AgentHierarchyGroup level1() {
        return level1;
    }

    /**
     * <p>
     * The group at level two of the agent hierarchy.
     * </p>
     * 
     * @return The group at level two of the agent hierarchy.
     */
    public final AgentHierarchyGroup level2() {
        return level2;
    }

    /**
     * <p>
     * The group at level three of the agent hierarchy.
     * </p>
     * 
     * @return The group at level three of the agent hierarchy.
     */
    public final AgentHierarchyGroup level3() {
        return level3;
    }

    /**
     * <p>
     * The group at level four of the agent hierarchy.
     * </p>
     * 
     * @return The group at level four of the agent hierarchy.
     */
    public final AgentHierarchyGroup level4() {
        return level4;
    }

    /**
     * <p>
     * The group at level five of the agent hierarchy.
     * </p>
     * 
     * @return The group at level five of the agent hierarchy.
     */
    public final AgentHierarchyGroup level5() {
        return level5;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(level1());
        hashCode = 31 * hashCode + Objects.hashCode(level2());
        hashCode = 31 * hashCode + Objects.hashCode(level3());
        hashCode = 31 * hashCode + Objects.hashCode(level4());
        hashCode = 31 * hashCode + Objects.hashCode(level5());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HierarchyGroups)) {
            return false;
        }
        HierarchyGroups other = (HierarchyGroups) obj;
        return Objects.equals(level1(), other.level1()) && Objects.equals(level2(), other.level2())
                && Objects.equals(level3(), other.level3()) && Objects.equals(level4(), other.level4())
                && Objects.equals(level5(), other.level5());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HierarchyGroups").add("Level1", level1()).add("Level2", level2()).add("Level3", level3())
                .add("Level4", level4()).add("Level5", level5()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Level1":
            return Optional.ofNullable(clazz.cast(level1()));
        case "Level2":
            return Optional.ofNullable(clazz.cast(level2()));
        case "Level3":
            return Optional.ofNullable(clazz.cast(level3()));
        case "Level4":
            return Optional.ofNullable(clazz.cast(level4()));
        case "Level5":
            return Optional.ofNullable(clazz.cast(level5()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Level1", LEVEL1_FIELD);
        map.put("Level2", LEVEL2_FIELD);
        map.put("Level3", LEVEL3_FIELD);
        map.put("Level4", LEVEL4_FIELD);
        map.put("Level5", LEVEL5_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HierarchyGroups, T> g) {
        return obj -> g.apply((HierarchyGroups) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HierarchyGroups> {
        /**
         * <p>
         * The group at level one of the agent hierarchy.
         * </p>
         * 
         * @param level1
         *        The group at level one of the agent hierarchy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder level1(AgentHierarchyGroup level1);

        /**
         * <p>
         * The group at level one of the agent hierarchy.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentHierarchyGroup.Builder} avoiding the
         * need to create one manually via {@link AgentHierarchyGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentHierarchyGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #level1(AgentHierarchyGroup)}.
         * 
         * @param level1
         *        a consumer that will call methods on {@link AgentHierarchyGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #level1(AgentHierarchyGroup)
         */
        default Builder level1(Consumer<AgentHierarchyGroup.Builder> level1) {
            return level1(AgentHierarchyGroup.builder().applyMutation(level1).build());
        }

        /**
         * <p>
         * The group at level two of the agent hierarchy.
         * </p>
         * 
         * @param level2
         *        The group at level two of the agent hierarchy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder level2(AgentHierarchyGroup level2);

        /**
         * <p>
         * The group at level two of the agent hierarchy.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentHierarchyGroup.Builder} avoiding the
         * need to create one manually via {@link AgentHierarchyGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentHierarchyGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #level2(AgentHierarchyGroup)}.
         * 
         * @param level2
         *        a consumer that will call methods on {@link AgentHierarchyGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #level2(AgentHierarchyGroup)
         */
        default Builder level2(Consumer<AgentHierarchyGroup.Builder> level2) {
            return level2(AgentHierarchyGroup.builder().applyMutation(level2).build());
        }

        /**
         * <p>
         * The group at level three of the agent hierarchy.
         * </p>
         * 
         * @param level3
         *        The group at level three of the agent hierarchy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder level3(AgentHierarchyGroup level3);

        /**
         * <p>
         * The group at level three of the agent hierarchy.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentHierarchyGroup.Builder} avoiding the
         * need to create one manually via {@link AgentHierarchyGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentHierarchyGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #level3(AgentHierarchyGroup)}.
         * 
         * @param level3
         *        a consumer that will call methods on {@link AgentHierarchyGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #level3(AgentHierarchyGroup)
         */
        default Builder level3(Consumer<AgentHierarchyGroup.Builder> level3) {
            return level3(AgentHierarchyGroup.builder().applyMutation(level3).build());
        }

        /**
         * <p>
         * The group at level four of the agent hierarchy.
         * </p>
         * 
         * @param level4
         *        The group at level four of the agent hierarchy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder level4(AgentHierarchyGroup level4);

        /**
         * <p>
         * The group at level four of the agent hierarchy.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentHierarchyGroup.Builder} avoiding the
         * need to create one manually via {@link AgentHierarchyGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentHierarchyGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #level4(AgentHierarchyGroup)}.
         * 
         * @param level4
         *        a consumer that will call methods on {@link AgentHierarchyGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #level4(AgentHierarchyGroup)
         */
        default Builder level4(Consumer<AgentHierarchyGroup.Builder> level4) {
            return level4(AgentHierarchyGroup.builder().applyMutation(level4).build());
        }

        /**
         * <p>
         * The group at level five of the agent hierarchy.
         * </p>
         * 
         * @param level5
         *        The group at level five of the agent hierarchy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder level5(AgentHierarchyGroup level5);

        /**
         * <p>
         * The group at level five of the agent hierarchy.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentHierarchyGroup.Builder} avoiding the
         * need to create one manually via {@link AgentHierarchyGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentHierarchyGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #level5(AgentHierarchyGroup)}.
         * 
         * @param level5
         *        a consumer that will call methods on {@link AgentHierarchyGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #level5(AgentHierarchyGroup)
         */
        default Builder level5(Consumer<AgentHierarchyGroup.Builder> level5) {
            return level5(AgentHierarchyGroup.builder().applyMutation(level5).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AgentHierarchyGroup level1;

        private AgentHierarchyGroup level2;

        private AgentHierarchyGroup level3;

        private AgentHierarchyGroup level4;

        private AgentHierarchyGroup level5;

        private BuilderImpl() {
        }

        private BuilderImpl(HierarchyGroups model) {
            level1(model.level1);
            level2(model.level2);
            level3(model.level3);
            level4(model.level4);
            level5(model.level5);
        }

        public final AgentHierarchyGroup.Builder getLevel1() {
            return level1 != null ? level1.toBuilder() : null;
        }

        public final void setLevel1(AgentHierarchyGroup.BuilderImpl level1) {
            this.level1 = level1 != null ? level1.build() : null;
        }

        @Override
        public final Builder level1(AgentHierarchyGroup level1) {
            this.level1 = level1;
            return this;
        }

        public final AgentHierarchyGroup.Builder getLevel2() {
            return level2 != null ? level2.toBuilder() : null;
        }

        public final void setLevel2(AgentHierarchyGroup.BuilderImpl level2) {
            this.level2 = level2 != null ? level2.build() : null;
        }

        @Override
        public final Builder level2(AgentHierarchyGroup level2) {
            this.level2 = level2;
            return this;
        }

        public final AgentHierarchyGroup.Builder getLevel3() {
            return level3 != null ? level3.toBuilder() : null;
        }

        public final void setLevel3(AgentHierarchyGroup.BuilderImpl level3) {
            this.level3 = level3 != null ? level3.build() : null;
        }

        @Override
        public final Builder level3(AgentHierarchyGroup level3) {
            this.level3 = level3;
            return this;
        }

        public final AgentHierarchyGroup.Builder getLevel4() {
            return level4 != null ? level4.toBuilder() : null;
        }

        public final void setLevel4(AgentHierarchyGroup.BuilderImpl level4) {
            this.level4 = level4 != null ? level4.build() : null;
        }

        @Override
        public final Builder level4(AgentHierarchyGroup level4) {
            this.level4 = level4;
            return this;
        }

        public final AgentHierarchyGroup.Builder getLevel5() {
            return level5 != null ? level5.toBuilder() : null;
        }

        public final void setLevel5(AgentHierarchyGroup.BuilderImpl level5) {
            this.level5 = level5 != null ? level5.build() : null;
        }

        @Override
        public final Builder level5(AgentHierarchyGroup level5) {
            this.level5 = level5;
            return this;
        }

        @Override
        public HierarchyGroups build() {
            return new HierarchyGroups(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
