/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the hours of operation override config: day, start time, and end time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HoursOfOperationOverrideConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<HoursOfOperationOverrideConfig.Builder, HoursOfOperationOverrideConfig> {
    private static final SdkField<String> DAY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Day")
            .getter(getter(HoursOfOperationOverrideConfig::dayAsString)).setter(setter(Builder::day))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Day").build()).build();

    private static final SdkField<OverrideTimeSlice> START_TIME_FIELD = SdkField
            .<OverrideTimeSlice> builder(MarshallingType.SDK_POJO).memberName("StartTime")
            .getter(getter(HoursOfOperationOverrideConfig::startTime)).setter(setter(Builder::startTime))
            .constructor(OverrideTimeSlice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<OverrideTimeSlice> END_TIME_FIELD = SdkField
            .<OverrideTimeSlice> builder(MarshallingType.SDK_POJO).memberName("EndTime")
            .getter(getter(HoursOfOperationOverrideConfig::endTime)).setter(setter(Builder::endTime))
            .constructor(OverrideTimeSlice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAY_FIELD, START_TIME_FIELD,
            END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String day;

    private final OverrideTimeSlice startTime;

    private final OverrideTimeSlice endTime;

    private HoursOfOperationOverrideConfig(BuilderImpl builder) {
        this.day = builder.day;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The day that the hours of operation override applies to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #day} will return
     * {@link OverrideDays#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dayAsString}.
     * </p>
     * 
     * @return The day that the hours of operation override applies to.
     * @see OverrideDays
     */
    public final OverrideDays day() {
        return OverrideDays.fromValue(day);
    }

    /**
     * <p>
     * The day that the hours of operation override applies to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #day} will return
     * {@link OverrideDays#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dayAsString}.
     * </p>
     * 
     * @return The day that the hours of operation override applies to.
     * @see OverrideDays
     */
    public final String dayAsString() {
        return day;
    }

    /**
     * <p>
     * The start time when your contact center opens if overrides are applied.
     * </p>
     * 
     * @return The start time when your contact center opens if overrides are applied.
     */
    public final OverrideTimeSlice startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time that your contact center closes if overrides are applied.
     * </p>
     * 
     * @return The end time that your contact center closes if overrides are applied.
     */
    public final OverrideTimeSlice endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dayAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HoursOfOperationOverrideConfig)) {
            return false;
        }
        HoursOfOperationOverrideConfig other = (HoursOfOperationOverrideConfig) obj;
        return Objects.equals(dayAsString(), other.dayAsString()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HoursOfOperationOverrideConfig").add("Day", dayAsString()).add("StartTime", startTime())
                .add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Day":
            return Optional.ofNullable(clazz.cast(dayAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Day", DAY_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HoursOfOperationOverrideConfig, T> g) {
        return obj -> g.apply((HoursOfOperationOverrideConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HoursOfOperationOverrideConfig> {
        /**
         * <p>
         * The day that the hours of operation override applies to.
         * </p>
         * 
         * @param day
         *        The day that the hours of operation override applies to.
         * @see OverrideDays
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OverrideDays
         */
        Builder day(String day);

        /**
         * <p>
         * The day that the hours of operation override applies to.
         * </p>
         * 
         * @param day
         *        The day that the hours of operation override applies to.
         * @see OverrideDays
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OverrideDays
         */
        Builder day(OverrideDays day);

        /**
         * <p>
         * The start time when your contact center opens if overrides are applied.
         * </p>
         * 
         * @param startTime
         *        The start time when your contact center opens if overrides are applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(OverrideTimeSlice startTime);

        /**
         * <p>
         * The start time when your contact center opens if overrides are applied.
         * </p>
         * This is a convenience method that creates an instance of the {@link OverrideTimeSlice.Builder} avoiding the
         * need to create one manually via {@link OverrideTimeSlice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OverrideTimeSlice.Builder#build()} is called immediately and its
         * result is passed to {@link #startTime(OverrideTimeSlice)}.
         * 
         * @param startTime
         *        a consumer that will call methods on {@link OverrideTimeSlice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startTime(OverrideTimeSlice)
         */
        default Builder startTime(Consumer<OverrideTimeSlice.Builder> startTime) {
            return startTime(OverrideTimeSlice.builder().applyMutation(startTime).build());
        }

        /**
         * <p>
         * The end time that your contact center closes if overrides are applied.
         * </p>
         * 
         * @param endTime
         *        The end time that your contact center closes if overrides are applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(OverrideTimeSlice endTime);

        /**
         * <p>
         * The end time that your contact center closes if overrides are applied.
         * </p>
         * This is a convenience method that creates an instance of the {@link OverrideTimeSlice.Builder} avoiding the
         * need to create one manually via {@link OverrideTimeSlice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OverrideTimeSlice.Builder#build()} is called immediately and its
         * result is passed to {@link #endTime(OverrideTimeSlice)}.
         * 
         * @param endTime
         *        a consumer that will call methods on {@link OverrideTimeSlice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endTime(OverrideTimeSlice)
         */
        default Builder endTime(Consumer<OverrideTimeSlice.Builder> endTime) {
            return endTime(OverrideTimeSlice.builder().applyMutation(endTime).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String day;

        private OverrideTimeSlice startTime;

        private OverrideTimeSlice endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(HoursOfOperationOverrideConfig model) {
            day(model.day);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getDay() {
            return day;
        }

        public final void setDay(String day) {
            this.day = day;
        }

        @Override
        public final Builder day(String day) {
            this.day = day;
            return this;
        }

        @Override
        public final Builder day(OverrideDays day) {
            this.day(day == null ? null : day.toString());
            return this;
        }

        public final OverrideTimeSlice.Builder getStartTime() {
            return startTime != null ? startTime.toBuilder() : null;
        }

        public final void setStartTime(OverrideTimeSlice.BuilderImpl startTime) {
            this.startTime = startTime != null ? startTime.build() : null;
        }

        @Override
        public final Builder startTime(OverrideTimeSlice startTime) {
            this.startTime = startTime;
            return this;
        }

        public final OverrideTimeSlice.Builder getEndTime() {
            return endTime != null ? endTime.toBuilder() : null;
        }

        public final void setEndTime(OverrideTimeSlice.BuilderImpl endTime) {
            this.endTime = endTime != null ? endTime.build() : null;
        }

        @Override
        public final Builder endTime(OverrideTimeSlice endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public HoursOfOperationOverrideConfig build() {
            return new HoursOfOperationOverrideConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
