/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about email body content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InboundEmailContent implements SdkPojo, Serializable,
        ToCopyableBuilder<InboundEmailContent.Builder, InboundEmailContent> {
    private static final SdkField<String> MESSAGE_SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageSourceType").getter(getter(InboundEmailContent::messageSourceTypeAsString))
            .setter(setter(Builder::messageSourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageSourceType").build()).build();

    private static final SdkField<InboundRawMessage> RAW_MESSAGE_FIELD = SdkField
            .<InboundRawMessage> builder(MarshallingType.SDK_POJO).memberName("RawMessage")
            .getter(getter(InboundEmailContent::rawMessage)).setter(setter(Builder::rawMessage))
            .constructor(InboundRawMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_SOURCE_TYPE_FIELD,
            RAW_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String messageSourceType;

    private final InboundRawMessage rawMessage;

    private InboundEmailContent(BuilderImpl builder) {
        this.messageSourceType = builder.messageSourceType;
        this.rawMessage = builder.rawMessage;
    }

    /**
     * <p>
     * The message source type, that is, <code>RAW</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageSourceType}
     * will return {@link InboundMessageSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #messageSourceTypeAsString}.
     * </p>
     * 
     * @return The message source type, that is, <code>RAW</code>.
     * @see InboundMessageSourceType
     */
    public final InboundMessageSourceType messageSourceType() {
        return InboundMessageSourceType.fromValue(messageSourceType);
    }

    /**
     * <p>
     * The message source type, that is, <code>RAW</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageSourceType}
     * will return {@link InboundMessageSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #messageSourceTypeAsString}.
     * </p>
     * 
     * @return The message source type, that is, <code>RAW</code>.
     * @see InboundMessageSourceType
     */
    public final String messageSourceTypeAsString() {
        return messageSourceType;
    }

    /**
     * <p>
     * The raw email body content.
     * </p>
     * 
     * @return The raw email body content.
     */
    public final InboundRawMessage rawMessage() {
        return rawMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rawMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InboundEmailContent)) {
            return false;
        }
        InboundEmailContent other = (InboundEmailContent) obj;
        return Objects.equals(messageSourceTypeAsString(), other.messageSourceTypeAsString())
                && Objects.equals(rawMessage(), other.rawMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InboundEmailContent").add("MessageSourceType", messageSourceTypeAsString())
                .add("RawMessage", rawMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageSourceType":
            return Optional.ofNullable(clazz.cast(messageSourceTypeAsString()));
        case "RawMessage":
            return Optional.ofNullable(clazz.cast(rawMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MessageSourceType", MESSAGE_SOURCE_TYPE_FIELD);
        map.put("RawMessage", RAW_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InboundEmailContent, T> g) {
        return obj -> g.apply((InboundEmailContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InboundEmailContent> {
        /**
         * <p>
         * The message source type, that is, <code>RAW</code>.
         * </p>
         * 
         * @param messageSourceType
         *        The message source type, that is, <code>RAW</code>.
         * @see InboundMessageSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InboundMessageSourceType
         */
        Builder messageSourceType(String messageSourceType);

        /**
         * <p>
         * The message source type, that is, <code>RAW</code>.
         * </p>
         * 
         * @param messageSourceType
         *        The message source type, that is, <code>RAW</code>.
         * @see InboundMessageSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InboundMessageSourceType
         */
        Builder messageSourceType(InboundMessageSourceType messageSourceType);

        /**
         * <p>
         * The raw email body content.
         * </p>
         * 
         * @param rawMessage
         *        The raw email body content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawMessage(InboundRawMessage rawMessage);

        /**
         * <p>
         * The raw email body content.
         * </p>
         * This is a convenience method that creates an instance of the {@link InboundRawMessage.Builder} avoiding the
         * need to create one manually via {@link InboundRawMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InboundRawMessage.Builder#build()} is called immediately and its
         * result is passed to {@link #rawMessage(InboundRawMessage)}.
         * 
         * @param rawMessage
         *        a consumer that will call methods on {@link InboundRawMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rawMessage(InboundRawMessage)
         */
        default Builder rawMessage(Consumer<InboundRawMessage.Builder> rawMessage) {
            return rawMessage(InboundRawMessage.builder().applyMutation(rawMessage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String messageSourceType;

        private InboundRawMessage rawMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(InboundEmailContent model) {
            messageSourceType(model.messageSourceType);
            rawMessage(model.rawMessage);
        }

        public final String getMessageSourceType() {
            return messageSourceType;
        }

        public final void setMessageSourceType(String messageSourceType) {
            this.messageSourceType = messageSourceType;
        }

        @Override
        public final Builder messageSourceType(String messageSourceType) {
            this.messageSourceType = messageSourceType;
            return this;
        }

        @Override
        public final Builder messageSourceType(InboundMessageSourceType messageSourceType) {
            this.messageSourceType(messageSourceType == null ? null : messageSourceType.toString());
            return this;
        }

        public final InboundRawMessage.Builder getRawMessage() {
            return rawMessage != null ? rawMessage.toBuilder() : null;
        }

        public final void setRawMessage(InboundRawMessage.BuilderImpl rawMessage) {
            this.rawMessage = rawMessage != null ? rawMessage.build() : null;
        }

        @Override
        public final Builder rawMessage(InboundRawMessage rawMessage) {
            this.rawMessage = rawMessage;
            return this;
        }

        @Override
        public InboundEmailContent build() {
            return new InboundEmailContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
