/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information of a Kinesis Data Firehose delivery stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisFirehoseConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<KinesisFirehoseConfig.Builder, KinesisFirehoseConfig> {
    private static final SdkField<String> FIREHOSE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirehoseArn").getter(getter(KinesisFirehoseConfig::firehoseArn)).setter(setter(Builder::firehoseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirehoseArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREHOSE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String firehoseArn;

    private KinesisFirehoseConfig(BuilderImpl builder) {
        this.firehoseArn = builder.firehoseArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the delivery stream.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the delivery stream.
     */
    public final String firehoseArn() {
        return firehoseArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(firehoseArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisFirehoseConfig)) {
            return false;
        }
        KinesisFirehoseConfig other = (KinesisFirehoseConfig) obj;
        return Objects.equals(firehoseArn(), other.firehoseArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisFirehoseConfig").add("FirehoseArn", firehoseArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirehoseArn":
            return Optional.ofNullable(clazz.cast(firehoseArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FirehoseArn", FIREHOSE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KinesisFirehoseConfig, T> g) {
        return obj -> g.apply((KinesisFirehoseConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisFirehoseConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the delivery stream.
         * </p>
         * 
         * @param firehoseArn
         *        The Amazon Resource Name (ARN) of the delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firehoseArn(String firehoseArn);
    }

    static final class BuilderImpl implements Builder {
        private String firehoseArn;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisFirehoseConfig model) {
            firehoseArn(model.firehoseArn);
        }

        public final String getFirehoseArn() {
            return firehoseArn;
        }

        public final void setFirehoseArn(String firehoseArn) {
            this.firehoseArn = firehoseArn;
        }

        @Override
        public final Builder firehoseArn(String firehoseArn) {
            this.firehoseArn = firehoseArn;
            return this;
        }

        @Override
        public KinesisFirehoseConfig build() {
            return new KinesisFirehoseConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
