/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information of a Kinesis video stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisVideoStreamConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<KinesisVideoStreamConfig.Builder, KinesisVideoStreamConfig> {
    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Prefix")
            .getter(getter(KinesisVideoStreamConfig::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()).build();

    private static final SdkField<Integer> RETENTION_PERIOD_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetentionPeriodHours").getter(getter(KinesisVideoStreamConfig::retentionPeriodHours))
            .setter(setter(Builder::retentionPeriodHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriodHours").build())
            .build();

    private static final SdkField<EncryptionConfig> ENCRYPTION_CONFIG_FIELD = SdkField
            .<EncryptionConfig> builder(MarshallingType.SDK_POJO).memberName("EncryptionConfig")
            .getter(getter(KinesisVideoStreamConfig::encryptionConfig)).setter(setter(Builder::encryptionConfig))
            .constructor(EncryptionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_FIELD,
            RETENTION_PERIOD_HOURS_FIELD, ENCRYPTION_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String prefix;

    private final Integer retentionPeriodHours;

    private final EncryptionConfig encryptionConfig;

    private KinesisVideoStreamConfig(BuilderImpl builder) {
        this.prefix = builder.prefix;
        this.retentionPeriodHours = builder.retentionPeriodHours;
        this.encryptionConfig = builder.encryptionConfig;
    }

    /**
     * <p>
     * The prefix of the video stream.
     * </p>
     * 
     * @return The prefix of the video stream.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * <p>
     * The number of hours data is retained in the stream. Kinesis Video Streams retains the data in a data store that
     * is associated with the stream.
     * </p>
     * <p>
     * The default value is 0, indicating that the stream does not persist data.
     * </p>
     * 
     * @return The number of hours data is retained in the stream. Kinesis Video Streams retains the data in a data
     *         store that is associated with the stream.</p>
     *         <p>
     *         The default value is 0, indicating that the stream does not persist data.
     */
    public final Integer retentionPeriodHours() {
        return retentionPeriodHours;
    }

    /**
     * <p>
     * The encryption configuration.
     * </p>
     * 
     * @return The encryption configuration.
     */
    public final EncryptionConfig encryptionConfig() {
        return encryptionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriodHours());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisVideoStreamConfig)) {
            return false;
        }
        KinesisVideoStreamConfig other = (KinesisVideoStreamConfig) obj;
        return Objects.equals(prefix(), other.prefix()) && Objects.equals(retentionPeriodHours(), other.retentionPeriodHours())
                && Objects.equals(encryptionConfig(), other.encryptionConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisVideoStreamConfig").add("Prefix", prefix())
                .add("RetentionPeriodHours", retentionPeriodHours()).add("EncryptionConfig", encryptionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "RetentionPeriodHours":
            return Optional.ofNullable(clazz.cast(retentionPeriodHours()));
        case "EncryptionConfig":
            return Optional.ofNullable(clazz.cast(encryptionConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Prefix", PREFIX_FIELD);
        map.put("RetentionPeriodHours", RETENTION_PERIOD_HOURS_FIELD);
        map.put("EncryptionConfig", ENCRYPTION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KinesisVideoStreamConfig, T> g) {
        return obj -> g.apply((KinesisVideoStreamConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisVideoStreamConfig> {
        /**
         * <p>
         * The prefix of the video stream.
         * </p>
         * 
         * @param prefix
         *        The prefix of the video stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The number of hours data is retained in the stream. Kinesis Video Streams retains the data in a data store
         * that is associated with the stream.
         * </p>
         * <p>
         * The default value is 0, indicating that the stream does not persist data.
         * </p>
         * 
         * @param retentionPeriodHours
         *        The number of hours data is retained in the stream. Kinesis Video Streams retains the data in a data
         *        store that is associated with the stream.</p>
         *        <p>
         *        The default value is 0, indicating that the stream does not persist data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriodHours(Integer retentionPeriodHours);

        /**
         * <p>
         * The encryption configuration.
         * </p>
         * 
         * @param encryptionConfig
         *        The encryption configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfig(EncryptionConfig encryptionConfig);

        /**
         * <p>
         * The encryption configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfig.Builder} avoiding the
         * need to create one manually via {@link EncryptionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionConfig(EncryptionConfig)}.
         * 
         * @param encryptionConfig
         *        a consumer that will call methods on {@link EncryptionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfig(EncryptionConfig)
         */
        default Builder encryptionConfig(Consumer<EncryptionConfig.Builder> encryptionConfig) {
            return encryptionConfig(EncryptionConfig.builder().applyMutation(encryptionConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String prefix;

        private Integer retentionPeriodHours;

        private EncryptionConfig encryptionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisVideoStreamConfig model) {
            prefix(model.prefix);
            retentionPeriodHours(model.retentionPeriodHours);
            encryptionConfig(model.encryptionConfig);
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final Integer getRetentionPeriodHours() {
            return retentionPeriodHours;
        }

        public final void setRetentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
        }

        @Override
        public final Builder retentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
            return this;
        }

        public final EncryptionConfig.Builder getEncryptionConfig() {
            return encryptionConfig != null ? encryptionConfig.toBuilder() : null;
        }

        public final void setEncryptionConfig(EncryptionConfig.BuilderImpl encryptionConfig) {
            this.encryptionConfig = encryptionConfig != null ? encryptionConfig.build() : null;
        }

        @Override
        public final Builder encryptionConfig(EncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        @Override
        public KinesisVideoStreamConfig build() {
            return new KinesisVideoStreamConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
