/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBotsResponse extends ConnectResponse implements
        ToCopyableBuilder<ListBotsResponse.Builder, ListBotsResponse> {
    private static final SdkField<List<LexBotConfig>> LEX_BOTS_FIELD = SdkField
            .<List<LexBotConfig>> builder(MarshallingType.LIST)
            .memberName("LexBots")
            .getter(getter(ListBotsResponse::lexBots))
            .setter(setter(Builder::lexBots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexBots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LexBotConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(LexBotConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBotsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEX_BOTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<LexBotConfig> lexBots;

    private final String nextToken;

    private ListBotsResponse(BuilderImpl builder) {
        super(builder);
        this.lexBots = builder.lexBots;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LexBots property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLexBots() {
        return lexBots != null && !(lexBots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names and Amazon Web Services Regions of the Amazon Lex or Amazon Lex V2 bots associated with the specified
     * instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLexBots} method.
     * </p>
     * 
     * @return The names and Amazon Web Services Regions of the Amazon Lex or Amazon Lex V2 bots associated with the
     *         specified instance.
     */
    public final List<LexBotConfig> lexBots() {
        return lexBots;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLexBots() ? lexBots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotsResponse)) {
            return false;
        }
        ListBotsResponse other = (ListBotsResponse) obj;
        return hasLexBots() == other.hasLexBots() && Objects.equals(lexBots(), other.lexBots())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBotsResponse").add("LexBots", hasLexBots() ? lexBots() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LexBots":
            return Optional.ofNullable(clazz.cast(lexBots()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LexBots", LEX_BOTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBotsResponse, T> g) {
        return obj -> g.apply((ListBotsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBotsResponse> {
        /**
         * <p>
         * The names and Amazon Web Services Regions of the Amazon Lex or Amazon Lex V2 bots associated with the
         * specified instance.
         * </p>
         * 
         * @param lexBots
         *        The names and Amazon Web Services Regions of the Amazon Lex or Amazon Lex V2 bots associated with the
         *        specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lexBots(Collection<LexBotConfig> lexBots);

        /**
         * <p>
         * The names and Amazon Web Services Regions of the Amazon Lex or Amazon Lex V2 bots associated with the
         * specified instance.
         * </p>
         * 
         * @param lexBots
         *        The names and Amazon Web Services Regions of the Amazon Lex or Amazon Lex V2 bots associated with the
         *        specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lexBots(LexBotConfig... lexBots);

        /**
         * <p>
         * The names and Amazon Web Services Regions of the Amazon Lex or Amazon Lex V2 bots associated with the
         * specified instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.LexBotConfig.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.LexBotConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.LexBotConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #lexBots(List<LexBotConfig>)}.
         * 
         * @param lexBots
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.LexBotConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lexBots(java.util.Collection<LexBotConfig>)
         */
        Builder lexBots(Consumer<LexBotConfig.Builder>... lexBots);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<LexBotConfig> lexBots = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotsResponse model) {
            super(model);
            lexBots(model.lexBots);
            nextToken(model.nextToken);
        }

        public final List<LexBotConfig.Builder> getLexBots() {
            List<LexBotConfig.Builder> result = LexBotConfigListCopier.copyToBuilder(this.lexBots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLexBots(Collection<LexBotConfig.BuilderImpl> lexBots) {
            this.lexBots = LexBotConfigListCopier.copyFromBuilder(lexBots);
        }

        @Override
        public final Builder lexBots(Collection<LexBotConfig> lexBots) {
            this.lexBots = LexBotConfigListCopier.copy(lexBots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexBots(LexBotConfig... lexBots) {
            lexBots(Arrays.asList(lexBots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexBots(Consumer<LexBotConfig.Builder>... lexBots) {
            lexBots(Stream.of(lexBots).map(c -> LexBotConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBotsResponse build() {
            return new ListBotsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
