/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListContactEvaluationsResponse extends ConnectResponse implements
        ToCopyableBuilder<ListContactEvaluationsResponse.Builder, ListContactEvaluationsResponse> {
    private static final SdkField<List<EvaluationSummary>> EVALUATION_SUMMARY_LIST_FIELD = SdkField
            .<List<EvaluationSummary>> builder(MarshallingType.LIST)
            .memberName("EvaluationSummaryList")
            .getter(getter(ListContactEvaluationsResponse::evaluationSummaryList))
            .setter(setter(Builder::evaluationSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListContactEvaluationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_SUMMARY_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<EvaluationSummary> evaluationSummaryList;

    private final String nextToken;

    private ListContactEvaluationsResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationSummaryList = builder.evaluationSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EvaluationSummaryList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEvaluationSummaryList() {
        return evaluationSummaryList != null && !(evaluationSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides details about a list of contact evaluations belonging to an instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvaluationSummaryList} method.
     * </p>
     * 
     * @return Provides details about a list of contact evaluations belonging to an instance.
     */
    public final List<EvaluationSummary> evaluationSummaryList() {
        return evaluationSummaryList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * <important>
     * <p>
     * This is always returned as null in the response.
     * </p>
     * </important>
     * 
     * @return If there are additional results, this is the token for the next set of results.</p> <important>
     *         <p>
     *         This is always returned as null in the response.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEvaluationSummaryList() ? evaluationSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactEvaluationsResponse)) {
            return false;
        }
        ListContactEvaluationsResponse other = (ListContactEvaluationsResponse) obj;
        return hasEvaluationSummaryList() == other.hasEvaluationSummaryList()
                && Objects.equals(evaluationSummaryList(), other.evaluationSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListContactEvaluationsResponse")
                .add("EvaluationSummaryList", hasEvaluationSummaryList() ? evaluationSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationSummaryList":
            return Optional.ofNullable(clazz.cast(evaluationSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EvaluationSummaryList", EVALUATION_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListContactEvaluationsResponse, T> g) {
        return obj -> g.apply((ListContactEvaluationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListContactEvaluationsResponse> {
        /**
         * <p>
         * Provides details about a list of contact evaluations belonging to an instance.
         * </p>
         * 
         * @param evaluationSummaryList
         *        Provides details about a list of contact evaluations belonging to an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationSummaryList(Collection<EvaluationSummary> evaluationSummaryList);

        /**
         * <p>
         * Provides details about a list of contact evaluations belonging to an instance.
         * </p>
         * 
         * @param evaluationSummaryList
         *        Provides details about a list of contact evaluations belonging to an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationSummaryList(EvaluationSummary... evaluationSummaryList);

        /**
         * <p>
         * Provides details about a list of contact evaluations belonging to an instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EvaluationSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.EvaluationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EvaluationSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #evaluationSummaryList(List<EvaluationSummary>)}.
         * 
         * @param evaluationSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EvaluationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationSummaryList(java.util.Collection<EvaluationSummary>)
         */
        Builder evaluationSummaryList(Consumer<EvaluationSummary.Builder>... evaluationSummaryList);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * <important>
         * <p>
         * This is always returned as null in the response.
         * </p>
         * </important>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.</p> <important>
         *        <p>
         *        This is always returned as null in the response.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<EvaluationSummary> evaluationSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactEvaluationsResponse model) {
            super(model);
            evaluationSummaryList(model.evaluationSummaryList);
            nextToken(model.nextToken);
        }

        public final List<EvaluationSummary.Builder> getEvaluationSummaryList() {
            List<EvaluationSummary.Builder> result = EvaluationSummaryListCopier.copyToBuilder(this.evaluationSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluationSummaryList(Collection<EvaluationSummary.BuilderImpl> evaluationSummaryList) {
            this.evaluationSummaryList = EvaluationSummaryListCopier.copyFromBuilder(evaluationSummaryList);
        }

        @Override
        public final Builder evaluationSummaryList(Collection<EvaluationSummary> evaluationSummaryList) {
            this.evaluationSummaryList = EvaluationSummaryListCopier.copy(evaluationSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationSummaryList(EvaluationSummary... evaluationSummaryList) {
            evaluationSummaryList(Arrays.asList(evaluationSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationSummaryList(Consumer<EvaluationSummary.Builder>... evaluationSummaryList) {
            evaluationSummaryList(Stream.of(evaluationSummaryList).map(c -> EvaluationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListContactEvaluationsResponse build() {
            return new ListContactEvaluationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
