/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHoursOfOperationOverridesResponse extends ConnectResponse implements
        ToCopyableBuilder<ListHoursOfOperationOverridesResponse.Builder, ListHoursOfOperationOverridesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListHoursOfOperationOverridesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<HoursOfOperationOverride>> HOURS_OF_OPERATION_OVERRIDE_LIST_FIELD = SdkField
            .<List<HoursOfOperationOverride>> builder(MarshallingType.LIST)
            .memberName("HoursOfOperationOverrideList")
            .getter(getter(ListHoursOfOperationOverridesResponse::hoursOfOperationOverrideList))
            .setter(setter(Builder::hoursOfOperationOverrideList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperationOverrideList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HoursOfOperationOverride> builder(MarshallingType.SDK_POJO)
                                            .constructor(HoursOfOperationOverride::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedRegion").getter(getter(ListHoursOfOperationOverridesResponse::lastModifiedRegion))
            .setter(setter(Builder::lastModifiedRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(ListHoursOfOperationOverridesResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            HOURS_OF_OPERATION_OVERRIDE_LIST_FIELD, LAST_MODIFIED_REGION_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<HoursOfOperationOverride> hoursOfOperationOverrideList;

    private final String lastModifiedRegion;

    private final Instant lastModifiedTime;

    private ListHoursOfOperationOverridesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.hoursOfOperationOverrideList = builder.hoursOfOperationOverrideList;
        this.lastModifiedRegion = builder.lastModifiedRegion;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the HoursOfOperationOverrideList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasHoursOfOperationOverrideList() {
        return hoursOfOperationOverrideList != null && !(hoursOfOperationOverrideList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the hours of operation override.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHoursOfOperationOverrideList} method.
     * </p>
     * 
     * @return Information about the hours of operation override.
     */
    public final List<HoursOfOperationOverride> hoursOfOperationOverrideList() {
        return hoursOfOperationOverrideList;
    }

    /**
     * <p>
     * The AWS Region where this resource was last modified.
     * </p>
     * 
     * @return The AWS Region where this resource was last modified.
     */
    public final String lastModifiedRegion() {
        return lastModifiedRegion;
    }

    /**
     * <p>
     * The timestamp when this resource was last modified.
     * </p>
     * 
     * @return The timestamp when this resource was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasHoursOfOperationOverrideList() ? hoursOfOperationOverrideList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedRegion());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHoursOfOperationOverridesResponse)) {
            return false;
        }
        ListHoursOfOperationOverridesResponse other = (ListHoursOfOperationOverridesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasHoursOfOperationOverrideList() == other.hasHoursOfOperationOverrideList()
                && Objects.equals(hoursOfOperationOverrideList(), other.hoursOfOperationOverrideList())
                && Objects.equals(lastModifiedRegion(), other.lastModifiedRegion())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListHoursOfOperationOverridesResponse").add("NextToken", nextToken())
                .add("HoursOfOperationOverrideList", hasHoursOfOperationOverrideList() ? hoursOfOperationOverrideList() : null)
                .add("LastModifiedRegion", lastModifiedRegion()).add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "HoursOfOperationOverrideList":
            return Optional.ofNullable(clazz.cast(hoursOfOperationOverrideList()));
        case "LastModifiedRegion":
            return Optional.ofNullable(clazz.cast(lastModifiedRegion()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("HoursOfOperationOverrideList", HOURS_OF_OPERATION_OVERRIDE_LIST_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListHoursOfOperationOverridesResponse, T> g) {
        return obj -> g.apply((ListHoursOfOperationOverridesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListHoursOfOperationOverridesResponse> {
        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the hours of operation override.
         * </p>
         * 
         * @param hoursOfOperationOverrideList
         *        Information about the hours of operation override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hoursOfOperationOverrideList(Collection<HoursOfOperationOverride> hoursOfOperationOverrideList);

        /**
         * <p>
         * Information about the hours of operation override.
         * </p>
         * 
         * @param hoursOfOperationOverrideList
         *        Information about the hours of operation override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hoursOfOperationOverrideList(HoursOfOperationOverride... hoursOfOperationOverrideList);

        /**
         * <p>
         * Information about the hours of operation override.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.HoursOfOperationOverride.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connect.model.HoursOfOperationOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.HoursOfOperationOverride.Builder#build()} is called
         * immediately and its result is passed to {@link #hoursOfOperationOverrideList(List<HoursOfOperationOverride>)}.
         * 
         * @param hoursOfOperationOverrideList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.HoursOfOperationOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hoursOfOperationOverrideList(java.util.Collection<HoursOfOperationOverride>)
         */
        Builder hoursOfOperationOverrideList(Consumer<HoursOfOperationOverride.Builder>... hoursOfOperationOverrideList);

        /**
         * <p>
         * The AWS Region where this resource was last modified.
         * </p>
         * 
         * @param lastModifiedRegion
         *        The AWS Region where this resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedRegion(String lastModifiedRegion);

        /**
         * <p>
         * The timestamp when this resource was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp when this resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<HoursOfOperationOverride> hoursOfOperationOverrideList = DefaultSdkAutoConstructList.getInstance();

        private String lastModifiedRegion;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHoursOfOperationOverridesResponse model) {
            super(model);
            nextToken(model.nextToken);
            hoursOfOperationOverrideList(model.hoursOfOperationOverrideList);
            lastModifiedRegion(model.lastModifiedRegion);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<HoursOfOperationOverride.Builder> getHoursOfOperationOverrideList() {
            List<HoursOfOperationOverride.Builder> result = HoursOfOperationOverrideListCopier
                    .copyToBuilder(this.hoursOfOperationOverrideList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHoursOfOperationOverrideList(
                Collection<HoursOfOperationOverride.BuilderImpl> hoursOfOperationOverrideList) {
            this.hoursOfOperationOverrideList = HoursOfOperationOverrideListCopier.copyFromBuilder(hoursOfOperationOverrideList);
        }

        @Override
        public final Builder hoursOfOperationOverrideList(Collection<HoursOfOperationOverride> hoursOfOperationOverrideList) {
            this.hoursOfOperationOverrideList = HoursOfOperationOverrideListCopier.copy(hoursOfOperationOverrideList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hoursOfOperationOverrideList(HoursOfOperationOverride... hoursOfOperationOverrideList) {
            hoursOfOperationOverrideList(Arrays.asList(hoursOfOperationOverrideList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hoursOfOperationOverrideList(
                Consumer<HoursOfOperationOverride.Builder>... hoursOfOperationOverrideList) {
            hoursOfOperationOverrideList(Stream.of(hoursOfOperationOverrideList)
                    .map(c -> HoursOfOperationOverride.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLastModifiedRegion() {
            return lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public ListHoursOfOperationOverridesResponse build() {
            return new ListHoursOfOperationOverridesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
