/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLambdaFunctionsResponse extends ConnectResponse implements
        ToCopyableBuilder<ListLambdaFunctionsResponse.Builder, ListLambdaFunctionsResponse> {
    private static final SdkField<List<String>> LAMBDA_FUNCTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LambdaFunctions")
            .getter(getter(ListLambdaFunctionsResponse::lambdaFunctions))
            .setter(setter(Builder::lambdaFunctions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLambdaFunctionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_FUNCTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> lambdaFunctions;

    private final String nextToken;

    private ListLambdaFunctionsResponse(BuilderImpl builder) {
        super(builder);
        this.lambdaFunctions = builder.lambdaFunctions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LambdaFunctions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLambdaFunctions() {
        return lambdaFunctions != null && !(lambdaFunctions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Lambdafunction ARNs associated with the specified instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLambdaFunctions} method.
     * </p>
     * 
     * @return The Lambdafunction ARNs associated with the specified instance.
     */
    public final List<String> lambdaFunctions() {
        return lambdaFunctions;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLambdaFunctions() ? lambdaFunctions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLambdaFunctionsResponse)) {
            return false;
        }
        ListLambdaFunctionsResponse other = (ListLambdaFunctionsResponse) obj;
        return hasLambdaFunctions() == other.hasLambdaFunctions() && Objects.equals(lambdaFunctions(), other.lambdaFunctions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLambdaFunctionsResponse")
                .add("LambdaFunctions", hasLambdaFunctions() ? lambdaFunctions() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LambdaFunctions":
            return Optional.ofNullable(clazz.cast(lambdaFunctions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LambdaFunctions", LAMBDA_FUNCTIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLambdaFunctionsResponse, T> g) {
        return obj -> g.apply((ListLambdaFunctionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLambdaFunctionsResponse> {
        /**
         * <p>
         * The Lambdafunction ARNs associated with the specified instance.
         * </p>
         * 
         * @param lambdaFunctions
         *        The Lambdafunction ARNs associated with the specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctions(Collection<String> lambdaFunctions);

        /**
         * <p>
         * The Lambdafunction ARNs associated with the specified instance.
         * </p>
         * 
         * @param lambdaFunctions
         *        The Lambdafunction ARNs associated with the specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctions(String... lambdaFunctions);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<String> lambdaFunctions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLambdaFunctionsResponse model) {
            super(model);
            lambdaFunctions(model.lambdaFunctions);
            nextToken(model.nextToken);
        }

        public final Collection<String> getLambdaFunctions() {
            if (lambdaFunctions instanceof SdkAutoConstructList) {
                return null;
            }
            return lambdaFunctions;
        }

        public final void setLambdaFunctions(Collection<String> lambdaFunctions) {
            this.lambdaFunctions = FunctionArnsListCopier.copy(lambdaFunctions);
        }

        @Override
        public final Builder lambdaFunctions(Collection<String> lambdaFunctions) {
            this.lambdaFunctions = FunctionArnsListCopier.copy(lambdaFunctions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctions(String... lambdaFunctions) {
            lambdaFunctions(Arrays.asList(lambdaFunctions));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLambdaFunctionsResponse build() {
            return new ListLambdaFunctionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
