/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPredefinedAttributesResponse extends ConnectResponse implements
        ToCopyableBuilder<ListPredefinedAttributesResponse.Builder, ListPredefinedAttributesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPredefinedAttributesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<PredefinedAttributeSummary>> PREDEFINED_ATTRIBUTE_SUMMARY_LIST_FIELD = SdkField
            .<List<PredefinedAttributeSummary>> builder(MarshallingType.LIST)
            .memberName("PredefinedAttributeSummaryList")
            .getter(getter(ListPredefinedAttributesResponse::predefinedAttributeSummaryList))
            .setter(setter(Builder::predefinedAttributeSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedAttributeSummaryList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PredefinedAttributeSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PredefinedAttributeSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PREDEFINED_ATTRIBUTE_SUMMARY_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<PredefinedAttributeSummary> predefinedAttributeSummaryList;

    private ListPredefinedAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.predefinedAttributeSummaryList = builder.predefinedAttributeSummaryList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PredefinedAttributeSummaryList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPredefinedAttributeSummaryList() {
        return predefinedAttributeSummaryList != null && !(predefinedAttributeSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary of the predefined attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPredefinedAttributeSummaryList} method.
     * </p>
     * 
     * @return Summary of the predefined attributes.
     */
    public final List<PredefinedAttributeSummary> predefinedAttributeSummaryList() {
        return predefinedAttributeSummaryList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasPredefinedAttributeSummaryList() ? predefinedAttributeSummaryList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPredefinedAttributesResponse)) {
            return false;
        }
        ListPredefinedAttributesResponse other = (ListPredefinedAttributesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasPredefinedAttributeSummaryList() == other.hasPredefinedAttributeSummaryList()
                && Objects.equals(predefinedAttributeSummaryList(), other.predefinedAttributeSummaryList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListPredefinedAttributesResponse")
                .add("NextToken", nextToken())
                .add("PredefinedAttributeSummaryList",
                        hasPredefinedAttributeSummaryList() ? predefinedAttributeSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PredefinedAttributeSummaryList":
            return Optional.ofNullable(clazz.cast(predefinedAttributeSummaryList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("PredefinedAttributeSummaryList", PREDEFINED_ATTRIBUTE_SUMMARY_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPredefinedAttributesResponse, T> g) {
        return obj -> g.apply((ListPredefinedAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPredefinedAttributesResponse> {
        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Summary of the predefined attributes.
         * </p>
         * 
         * @param predefinedAttributeSummaryList
         *        Summary of the predefined attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predefinedAttributeSummaryList(Collection<PredefinedAttributeSummary> predefinedAttributeSummaryList);

        /**
         * <p>
         * Summary of the predefined attributes.
         * </p>
         * 
         * @param predefinedAttributeSummaryList
         *        Summary of the predefined attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predefinedAttributeSummaryList(PredefinedAttributeSummary... predefinedAttributeSummaryList);

        /**
         * <p>
         * Summary of the predefined attributes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.PredefinedAttributeSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connect.model.PredefinedAttributeSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.PredefinedAttributeSummary.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #predefinedAttributeSummaryList(List<PredefinedAttributeSummary>)}.
         * 
         * @param predefinedAttributeSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.PredefinedAttributeSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predefinedAttributeSummaryList(java.util.Collection<PredefinedAttributeSummary>)
         */
        Builder predefinedAttributeSummaryList(Consumer<PredefinedAttributeSummary.Builder>... predefinedAttributeSummaryList);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<PredefinedAttributeSummary> predefinedAttributeSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPredefinedAttributesResponse model) {
            super(model);
            nextToken(model.nextToken);
            predefinedAttributeSummaryList(model.predefinedAttributeSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PredefinedAttributeSummary.Builder> getPredefinedAttributeSummaryList() {
            List<PredefinedAttributeSummary.Builder> result = PredefinedAttributeSummaryListCopier
                    .copyToBuilder(this.predefinedAttributeSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPredefinedAttributeSummaryList(
                Collection<PredefinedAttributeSummary.BuilderImpl> predefinedAttributeSummaryList) {
            this.predefinedAttributeSummaryList = PredefinedAttributeSummaryListCopier
                    .copyFromBuilder(predefinedAttributeSummaryList);
        }

        @Override
        public final Builder predefinedAttributeSummaryList(Collection<PredefinedAttributeSummary> predefinedAttributeSummaryList) {
            this.predefinedAttributeSummaryList = PredefinedAttributeSummaryListCopier.copy(predefinedAttributeSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predefinedAttributeSummaryList(PredefinedAttributeSummary... predefinedAttributeSummaryList) {
            predefinedAttributeSummaryList(Arrays.asList(predefinedAttributeSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predefinedAttributeSummaryList(
                Consumer<PredefinedAttributeSummary.Builder>... predefinedAttributeSummaryList) {
            predefinedAttributeSummaryList(Stream.of(predefinedAttributeSummaryList)
                    .map(c -> PredefinedAttributeSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPredefinedAttributesResponse build() {
            return new ListPredefinedAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
