/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRealtimeContactAnalysisSegmentsV2Request extends ConnectRequest implements
        ToCopyableBuilder<ListRealtimeContactAnalysisSegmentsV2Request.Builder, ListRealtimeContactAnalysisSegmentsV2Request> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(ListRealtimeContactAnalysisSegmentsV2Request::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(ListRealtimeContactAnalysisSegmentsV2Request::contactId))
            .setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListRealtimeContactAnalysisSegmentsV2Request::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRealtimeContactAnalysisSegmentsV2Request::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> OUTPUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputType").getter(getter(ListRealtimeContactAnalysisSegmentsV2Request::outputTypeAsString))
            .setter(setter(Builder::outputType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputType").build()).build();

    private static final SdkField<List<String>> SEGMENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SegmentTypes")
            .getter(getter(ListRealtimeContactAnalysisSegmentsV2Request::segmentTypesAsStrings))
            .setter(setter(Builder::segmentTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CONTACT_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, OUTPUT_TYPE_FIELD, SEGMENT_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String contactId;

    private final Integer maxResults;

    private final String nextToken;

    private final String outputType;

    private final List<String> segmentTypes;

    private ListRealtimeContactAnalysisSegmentsV2Request(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactId = builder.contactId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.outputType = builder.outputType;
        this.segmentTypes = builder.segmentTypes;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the contact in this instance of Amazon Connect.
     * </p>
     * 
     * @return The identifier of the contact in this instance of Amazon Connect.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Contact Lens output type to be returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputType} will
     * return {@link RealTimeContactAnalysisOutputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #outputTypeAsString}.
     * </p>
     * 
     * @return The Contact Lens output type to be returned.
     * @see RealTimeContactAnalysisOutputType
     */
    public final RealTimeContactAnalysisOutputType outputType() {
        return RealTimeContactAnalysisOutputType.fromValue(outputType);
    }

    /**
     * <p>
     * The Contact Lens output type to be returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputType} will
     * return {@link RealTimeContactAnalysisOutputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #outputTypeAsString}.
     * </p>
     * 
     * @return The Contact Lens output type to be returned.
     * @see RealTimeContactAnalysisOutputType
     */
    public final String outputTypeAsString() {
        return outputType;
    }

    /**
     * <p>
     * Enum with segment types . Each value corresponds to a segment type returned in the segments list of the API. Each
     * segment type has its own structure. Different channels may have different sets of supported segment types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSegmentTypes} method.
     * </p>
     * 
     * @return Enum with segment types . Each value corresponds to a segment type returned in the segments list of the
     *         API. Each segment type has its own structure. Different channels may have different sets of supported
     *         segment types.
     */
    public final List<RealTimeContactAnalysisSegmentType> segmentTypes() {
        return RealTimeContactAnalysisSegmentTypesCopier.copyStringToEnum(segmentTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the SegmentTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSegmentTypes() {
        return segmentTypes != null && !(segmentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Enum with segment types . Each value corresponds to a segment type returned in the segments list of the API. Each
     * segment type has its own structure. Different channels may have different sets of supported segment types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSegmentTypes} method.
     * </p>
     * 
     * @return Enum with segment types . Each value corresponds to a segment type returned in the segments list of the
     *         API. Each segment type has its own structure. Different channels may have different sets of supported
     *         segment types.
     */
    public final List<String> segmentTypesAsStrings() {
        return segmentTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(outputTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSegmentTypes() ? segmentTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRealtimeContactAnalysisSegmentsV2Request)) {
            return false;
        }
        ListRealtimeContactAnalysisSegmentsV2Request other = (ListRealtimeContactAnalysisSegmentsV2Request) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(contactId(), other.contactId())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(outputTypeAsString(), other.outputTypeAsString())
                && hasSegmentTypes() == other.hasSegmentTypes()
                && Objects.equals(segmentTypesAsStrings(), other.segmentTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRealtimeContactAnalysisSegmentsV2Request").add("InstanceId", instanceId())
                .add("ContactId", contactId()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("OutputType", outputTypeAsString()).add("SegmentTypes", hasSegmentTypes() ? segmentTypesAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "OutputType":
            return Optional.ofNullable(clazz.cast(outputTypeAsString()));
        case "SegmentTypes":
            return Optional.ofNullable(clazz.cast(segmentTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("OutputType", OUTPUT_TYPE_FIELD);
        map.put("SegmentTypes", SEGMENT_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRealtimeContactAnalysisSegmentsV2Request, T> g) {
        return obj -> g.apply((ListRealtimeContactAnalysisSegmentsV2Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRealtimeContactAnalysisSegmentsV2Request> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the contact in this instance of Amazon Connect.
         * </p>
         * 
         * @param contactId
         *        The identifier of the contact in this instance of Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Contact Lens output type to be returned.
         * </p>
         * 
         * @param outputType
         *        The Contact Lens output type to be returned.
         * @see RealTimeContactAnalysisOutputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RealTimeContactAnalysisOutputType
         */
        Builder outputType(String outputType);

        /**
         * <p>
         * The Contact Lens output type to be returned.
         * </p>
         * 
         * @param outputType
         *        The Contact Lens output type to be returned.
         * @see RealTimeContactAnalysisOutputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RealTimeContactAnalysisOutputType
         */
        Builder outputType(RealTimeContactAnalysisOutputType outputType);

        /**
         * <p>
         * Enum with segment types . Each value corresponds to a segment type returned in the segments list of the API.
         * Each segment type has its own structure. Different channels may have different sets of supported segment
         * types.
         * </p>
         * 
         * @param segmentTypes
         *        Enum with segment types . Each value corresponds to a segment type returned in the segments list of
         *        the API. Each segment type has its own structure. Different channels may have different sets of
         *        supported segment types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentTypesWithStrings(Collection<String> segmentTypes);

        /**
         * <p>
         * Enum with segment types . Each value corresponds to a segment type returned in the segments list of the API.
         * Each segment type has its own structure. Different channels may have different sets of supported segment
         * types.
         * </p>
         * 
         * @param segmentTypes
         *        Enum with segment types . Each value corresponds to a segment type returned in the segments list of
         *        the API. Each segment type has its own structure. Different channels may have different sets of
         *        supported segment types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentTypesWithStrings(String... segmentTypes);

        /**
         * <p>
         * Enum with segment types . Each value corresponds to a segment type returned in the segments list of the API.
         * Each segment type has its own structure. Different channels may have different sets of supported segment
         * types.
         * </p>
         * 
         * @param segmentTypes
         *        Enum with segment types . Each value corresponds to a segment type returned in the segments list of
         *        the API. Each segment type has its own structure. Different channels may have different sets of
         *        supported segment types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentTypes(Collection<RealTimeContactAnalysisSegmentType> segmentTypes);

        /**
         * <p>
         * Enum with segment types . Each value corresponds to a segment type returned in the segments list of the API.
         * Each segment type has its own structure. Different channels may have different sets of supported segment
         * types.
         * </p>
         * 
         * @param segmentTypes
         *        Enum with segment types . Each value corresponds to a segment type returned in the segments list of
         *        the API. Each segment type has its own structure. Different channels may have different sets of
         *        supported segment types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentTypes(RealTimeContactAnalysisSegmentType... segmentTypes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String contactId;

        private Integer maxResults;

        private String nextToken;

        private String outputType;

        private List<String> segmentTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRealtimeContactAnalysisSegmentsV2Request model) {
            super(model);
            instanceId(model.instanceId);
            contactId(model.contactId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            outputType(model.outputType);
            segmentTypesWithStrings(model.segmentTypes);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOutputType() {
            return outputType;
        }

        public final void setOutputType(String outputType) {
            this.outputType = outputType;
        }

        @Override
        public final Builder outputType(String outputType) {
            this.outputType = outputType;
            return this;
        }

        @Override
        public final Builder outputType(RealTimeContactAnalysisOutputType outputType) {
            this.outputType(outputType == null ? null : outputType.toString());
            return this;
        }

        public final Collection<String> getSegmentTypes() {
            if (segmentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return segmentTypes;
        }

        public final void setSegmentTypes(Collection<String> segmentTypes) {
            this.segmentTypes = RealTimeContactAnalysisSegmentTypesCopier.copy(segmentTypes);
        }

        @Override
        public final Builder segmentTypesWithStrings(Collection<String> segmentTypes) {
            this.segmentTypes = RealTimeContactAnalysisSegmentTypesCopier.copy(segmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentTypesWithStrings(String... segmentTypes) {
            segmentTypesWithStrings(Arrays.asList(segmentTypes));
            return this;
        }

        @Override
        public final Builder segmentTypes(Collection<RealTimeContactAnalysisSegmentType> segmentTypes) {
            this.segmentTypes = RealTimeContactAnalysisSegmentTypesCopier.copyEnumToString(segmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentTypes(RealTimeContactAnalysisSegmentType... segmentTypes) {
            segmentTypes(Arrays.asList(segmentTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRealtimeContactAnalysisSegmentsV2Request build() {
            return new ListRealtimeContactAnalysisSegmentsV2Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
