/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRulesResponse extends ConnectResponse implements
        ToCopyableBuilder<ListRulesResponse.Builder, ListRulesResponse> {
    private static final SdkField<List<RuleSummary>> RULE_SUMMARY_LIST_FIELD = SdkField
            .<List<RuleSummary>> builder(MarshallingType.LIST)
            .memberName("RuleSummaryList")
            .getter(getter(ListRulesResponse::ruleSummaryList))
            .setter(setter(Builder::ruleSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRulesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_SUMMARY_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<RuleSummary> ruleSummaryList;

    private final String nextToken;

    private ListRulesResponse(BuilderImpl builder) {
        super(builder);
        this.ruleSummaryList = builder.ruleSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleSummaryList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRuleSummaryList() {
        return ruleSummaryList != null && !(ruleSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information about a rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleSummaryList} method.
     * </p>
     * 
     * @return Summary information about a rule.
     */
    public final List<RuleSummary> ruleSummaryList() {
        return ruleSummaryList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleSummaryList() ? ruleSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRulesResponse)) {
            return false;
        }
        ListRulesResponse other = (ListRulesResponse) obj;
        return hasRuleSummaryList() == other.hasRuleSummaryList() && Objects.equals(ruleSummaryList(), other.ruleSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRulesResponse").add("RuleSummaryList", hasRuleSummaryList() ? ruleSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleSummaryList":
            return Optional.ofNullable(clazz.cast(ruleSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleSummaryList", RULE_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRulesResponse, T> g) {
        return obj -> g.apply((ListRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRulesResponse> {
        /**
         * <p>
         * Summary information about a rule.
         * </p>
         * 
         * @param ruleSummaryList
         *        Summary information about a rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSummaryList(Collection<RuleSummary> ruleSummaryList);

        /**
         * <p>
         * Summary information about a rule.
         * </p>
         * 
         * @param ruleSummaryList
         *        Summary information about a rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSummaryList(RuleSummary... ruleSummaryList);

        /**
         * <p>
         * Summary information about a rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.RuleSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.RuleSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.RuleSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #ruleSummaryList(List<RuleSummary>)}.
         * 
         * @param ruleSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.RuleSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleSummaryList(java.util.Collection<RuleSummary>)
         */
        Builder ruleSummaryList(Consumer<RuleSummary.Builder>... ruleSummaryList);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<RuleSummary> ruleSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRulesResponse model) {
            super(model);
            ruleSummaryList(model.ruleSummaryList);
            nextToken(model.nextToken);
        }

        public final List<RuleSummary.Builder> getRuleSummaryList() {
            List<RuleSummary.Builder> result = RuleSummaryListCopier.copyToBuilder(this.ruleSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleSummaryList(Collection<RuleSummary.BuilderImpl> ruleSummaryList) {
            this.ruleSummaryList = RuleSummaryListCopier.copyFromBuilder(ruleSummaryList);
        }

        @Override
        public final Builder ruleSummaryList(Collection<RuleSummary> ruleSummaryList) {
            this.ruleSummaryList = RuleSummaryListCopier.copy(ruleSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSummaryList(RuleSummary... ruleSummaryList) {
            ruleSummaryList(Arrays.asList(ruleSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSummaryList(Consumer<RuleSummary.Builder>... ruleSummaryList) {
            ruleSummaryList(Stream.of(ruleSummaryList).map(c -> RuleSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRulesResponse build() {
            return new ListRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
