/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The interval period with the start and end time for the metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricInterval implements SdkPojo, Serializable, ToCopyableBuilder<MetricInterval.Builder, MetricInterval> {
    private static final SdkField<String> INTERVAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Interval").getter(getter(MetricInterval::intervalAsString)).setter(setter(Builder::interval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(MetricInterval::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(MetricInterval::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERVAL_FIELD,
            START_TIME_FIELD, END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String interval;

    private final Instant startTime;

    private final Instant endTime;

    private MetricInterval(BuilderImpl builder) {
        this.interval = builder.interval;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The interval period provided in the API request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interval} will
     * return {@link IntervalPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #intervalAsString}.
     * </p>
     * 
     * @return The interval period provided in the API request.
     * @see IntervalPeriod
     */
    public final IntervalPeriod interval() {
        return IntervalPeriod.fromValue(interval);
    }

    /**
     * <p>
     * The interval period provided in the API request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interval} will
     * return {@link IntervalPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #intervalAsString}.
     * </p>
     * 
     * @return The interval period provided in the API request.
     * @see IntervalPeriod
     */
    public final String intervalAsString() {
        return interval;
    }

    /**
     * <p>
     * The timestamp, in UNIX Epoch time format. Start time is based on the interval period selected.
     * </p>
     * 
     * @return The timestamp, in UNIX Epoch time format. Start time is based on the interval period selected.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The timestamp, in UNIX Epoch time format. End time is based on the interval period selected. For example, If
     * <code>IntervalPeriod</code> is selected <code>THIRTY_MIN</code>, <code>StartTime</code> and <code>EndTime</code>
     * in the API request differs by 1 day, then 48 results are returned in the response. Each result is aggregated by
     * the 30 minutes period, with each <code>StartTime</code> and <code>EndTime</code> differing by 30 minutes.
     * </p>
     * 
     * @return The timestamp, in UNIX Epoch time format. End time is based on the interval period selected. For example,
     *         If <code>IntervalPeriod</code> is selected <code>THIRTY_MIN</code>, <code>StartTime</code> and
     *         <code>EndTime</code> in the API request differs by 1 day, then 48 results are returned in the response.
     *         Each result is aggregated by the 30 minutes period, with each <code>StartTime</code> and
     *         <code>EndTime</code> differing by 30 minutes.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intervalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricInterval)) {
            return false;
        }
        MetricInterval other = (MetricInterval) obj;
        return Objects.equals(intervalAsString(), other.intervalAsString()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricInterval").add("Interval", intervalAsString()).add("StartTime", startTime())
                .add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Interval":
            return Optional.ofNullable(clazz.cast(intervalAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Interval", INTERVAL_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricInterval, T> g) {
        return obj -> g.apply((MetricInterval) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricInterval> {
        /**
         * <p>
         * The interval period provided in the API request.
         * </p>
         * 
         * @param interval
         *        The interval period provided in the API request.
         * @see IntervalPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntervalPeriod
         */
        Builder interval(String interval);

        /**
         * <p>
         * The interval period provided in the API request.
         * </p>
         * 
         * @param interval
         *        The interval period provided in the API request.
         * @see IntervalPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntervalPeriod
         */
        Builder interval(IntervalPeriod interval);

        /**
         * <p>
         * The timestamp, in UNIX Epoch time format. Start time is based on the interval period selected.
         * </p>
         * 
         * @param startTime
         *        The timestamp, in UNIX Epoch time format. Start time is based on the interval period selected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The timestamp, in UNIX Epoch time format. End time is based on the interval period selected. For example, If
         * <code>IntervalPeriod</code> is selected <code>THIRTY_MIN</code>, <code>StartTime</code> and
         * <code>EndTime</code> in the API request differs by 1 day, then 48 results are returned in the response. Each
         * result is aggregated by the 30 minutes period, with each <code>StartTime</code> and <code>EndTime</code>
         * differing by 30 minutes.
         * </p>
         * 
         * @param endTime
         *        The timestamp, in UNIX Epoch time format. End time is based on the interval period selected. For
         *        example, If <code>IntervalPeriod</code> is selected <code>THIRTY_MIN</code>, <code>StartTime</code>
         *        and <code>EndTime</code> in the API request differs by 1 day, then 48 results are returned in the
         *        response. Each result is aggregated by the 30 minutes period, with each <code>StartTime</code> and
         *        <code>EndTime</code> differing by 30 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl implements Builder {
        private String interval;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricInterval model) {
            interval(model.interval);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getInterval() {
            return interval;
        }

        public final void setInterval(String interval) {
            this.interval = interval;
        }

        @Override
        public final Builder interval(String interval) {
            this.interval = interval;
            return this;
        }

        @Override
        public final Builder interval(IntervalPeriod interval) {
            this.interval(interval == null ? null : interval.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public MetricInterval build() {
            return new MetricInterval(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
