/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the metric results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricResultV2 implements SdkPojo, Serializable, ToCopyableBuilder<MetricResultV2.Builder, MetricResultV2> {
    private static final SdkField<Map<String, String>> DIMENSIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Dimensions")
            .getter(getter(MetricResultV2::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<MetricInterval> METRIC_INTERVAL_FIELD = SdkField
            .<MetricInterval> builder(MarshallingType.SDK_POJO).memberName("MetricInterval")
            .getter(getter(MetricResultV2::metricInterval)).setter(setter(Builder::metricInterval))
            .constructor(MetricInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricInterval").build()).build();

    private static final SdkField<List<MetricDataV2>> COLLECTIONS_FIELD = SdkField
            .<List<MetricDataV2>> builder(MarshallingType.LIST)
            .memberName("Collections")
            .getter(getter(MetricResultV2::collections))
            .setter(setter(Builder::collections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Collections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDataV2> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDataV2::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD,
            METRIC_INTERVAL_FIELD, COLLECTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> dimensions;

    private final MetricInterval metricInterval;

    private final List<MetricDataV2> collections;

    private MetricResultV2(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.metricInterval = builder.metricInterval;
        this.collections = builder.collections;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dimensions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDimensions() {
        return dimensions != null && !(dimensions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The dimension for the metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensions} method.
     * </p>
     * 
     * @return The dimension for the metrics.
     */
    public final Map<String, String> dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The interval period with the start and end time for the metrics.
     * </p>
     * 
     * @return The interval period with the start and end time for the metrics.
     */
    public final MetricInterval metricInterval() {
        return metricInterval;
    }

    /**
     * For responses, this returns true if the service returned a value for the Collections property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCollections() {
        return collections != null && !(collections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set of metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCollections} method.
     * </p>
     * 
     * @return The set of metrics.
     */
    public final List<MetricDataV2> collections() {
        return collections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensions() ? dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(metricInterval());
        hashCode = 31 * hashCode + Objects.hashCode(hasCollections() ? collections() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricResultV2)) {
            return false;
        }
        MetricResultV2 other = (MetricResultV2) obj;
        return hasDimensions() == other.hasDimensions() && Objects.equals(dimensions(), other.dimensions())
                && Objects.equals(metricInterval(), other.metricInterval()) && hasCollections() == other.hasCollections()
                && Objects.equals(collections(), other.collections());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricResultV2").add("Dimensions", hasDimensions() ? dimensions() : null)
                .add("MetricInterval", metricInterval()).add("Collections", hasCollections() ? collections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "MetricInterval":
            return Optional.ofNullable(clazz.cast(metricInterval()));
        case "Collections":
            return Optional.ofNullable(clazz.cast(collections()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Dimensions", DIMENSIONS_FIELD);
        map.put("MetricInterval", METRIC_INTERVAL_FIELD);
        map.put("Collections", COLLECTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricResultV2, T> g) {
        return obj -> g.apply((MetricResultV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricResultV2> {
        /**
         * <p>
         * The dimension for the metrics.
         * </p>
         * 
         * @param dimensions
         *        The dimension for the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Map<String, String> dimensions);

        /**
         * <p>
         * The interval period with the start and end time for the metrics.
         * </p>
         * 
         * @param metricInterval
         *        The interval period with the start and end time for the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricInterval(MetricInterval metricInterval);

        /**
         * <p>
         * The interval period with the start and end time for the metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricInterval.Builder} avoiding the need
         * to create one manually via {@link MetricInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #metricInterval(MetricInterval)}.
         * 
         * @param metricInterval
         *        a consumer that will call methods on {@link MetricInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricInterval(MetricInterval)
         */
        default Builder metricInterval(Consumer<MetricInterval.Builder> metricInterval) {
            return metricInterval(MetricInterval.builder().applyMutation(metricInterval).build());
        }

        /**
         * <p>
         * The set of metrics.
         * </p>
         * 
         * @param collections
         *        The set of metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collections(Collection<MetricDataV2> collections);

        /**
         * <p>
         * The set of metrics.
         * </p>
         * 
         * @param collections
         *        The set of metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collections(MetricDataV2... collections);

        /**
         * <p>
         * The set of metrics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.MetricDataV2.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.MetricDataV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.MetricDataV2.Builder#build()} is called immediately and
         * its result is passed to {@link #collections(List<MetricDataV2>)}.
         * 
         * @param collections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.MetricDataV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collections(java.util.Collection<MetricDataV2>)
         */
        Builder collections(Consumer<MetricDataV2.Builder>... collections);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> dimensions = DefaultSdkAutoConstructMap.getInstance();

        private MetricInterval metricInterval;

        private List<MetricDataV2> collections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricResultV2 model) {
            dimensions(model.dimensions);
            metricInterval(model.metricInterval);
            collections(model.collections);
        }

        public final Map<String, String> getDimensions() {
            if (dimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return dimensions;
        }

        public final void setDimensions(Map<String, String> dimensions) {
            this.dimensions = DimensionsV2MapCopier.copy(dimensions);
        }

        @Override
        public final Builder dimensions(Map<String, String> dimensions) {
            this.dimensions = DimensionsV2MapCopier.copy(dimensions);
            return this;
        }

        public final MetricInterval.Builder getMetricInterval() {
            return metricInterval != null ? metricInterval.toBuilder() : null;
        }

        public final void setMetricInterval(MetricInterval.BuilderImpl metricInterval) {
            this.metricInterval = metricInterval != null ? metricInterval.build() : null;
        }

        @Override
        public final Builder metricInterval(MetricInterval metricInterval) {
            this.metricInterval = metricInterval;
            return this;
        }

        public final List<MetricDataV2.Builder> getCollections() {
            List<MetricDataV2.Builder> result = MetricDataCollectionsV2Copier.copyToBuilder(this.collections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollections(Collection<MetricDataV2.BuilderImpl> collections) {
            this.collections = MetricDataCollectionsV2Copier.copyFromBuilder(collections);
        }

        @Override
        public final Builder collections(Collection<MetricDataV2> collections) {
            this.collections = MetricDataCollectionsV2Copier.copy(collections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collections(MetricDataV2... collections) {
            collections(Arrays.asList(collections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collections(Consumer<MetricDataV2.Builder>... collections) {
            collections(Stream.of(collections).map(c -> MetricDataV2.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public MetricResultV2 build() {
            return new MetricResultV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
