/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Payload of chat properties to apply when starting a new contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NewSessionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<NewSessionDetails.Builder, NewSessionDetails> {
    private static final SdkField<List<String>> SUPPORTED_MESSAGING_CONTENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedMessagingContentTypes")
            .getter(getter(NewSessionDetails::supportedMessagingContentTypes))
            .setter(setter(Builder::supportedMessagingContentTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedMessagingContentTypes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ParticipantDetails> PARTICIPANT_DETAILS_FIELD = SdkField
            .<ParticipantDetails> builder(MarshallingType.SDK_POJO).memberName("ParticipantDetails")
            .getter(getter(NewSessionDetails::participantDetails)).setter(setter(Builder::participantDetails))
            .constructor(ParticipantDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantDetails").build())
            .build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(NewSessionDetails::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ChatStreamingConfiguration> STREAMING_CONFIGURATION_FIELD = SdkField
            .<ChatStreamingConfiguration> builder(MarshallingType.SDK_POJO).memberName("StreamingConfiguration")
            .getter(getter(NewSessionDetails::streamingConfiguration)).setter(setter(Builder::streamingConfiguration))
            .constructor(ChatStreamingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SUPPORTED_MESSAGING_CONTENT_TYPES_FIELD, PARTICIPANT_DETAILS_FIELD, ATTRIBUTES_FIELD, STREAMING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> supportedMessagingContentTypes;

    private final ParticipantDetails participantDetails;

    private final Map<String, String> attributes;

    private final ChatStreamingConfiguration streamingConfiguration;

    private NewSessionDetails(BuilderImpl builder) {
        this.supportedMessagingContentTypes = builder.supportedMessagingContentTypes;
        this.participantDetails = builder.participantDetails;
        this.attributes = builder.attributes;
        this.streamingConfiguration = builder.streamingConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedMessagingContentTypes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedMessagingContentTypes() {
        return supportedMessagingContentTypes != null && !(supportedMessagingContentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported chat message content types. Supported types are <code>text/plain</code>, <code>text/markdown</code>, <code>application/json</code>, <code>application/vnd.amazonaws.connect.message.interactive</code>, and
     * <code>application/vnd.amazonaws.connect.message.interactive.response</code>.
     * </p>
     * <p>
     * Content types must always contain <code> text/plain</code>. You can then put any other supported type in the
     * list. For example, all the following lists are valid because they contain <code>text/plain</code>:
     * <code>[text/plain, text/markdown, application/json]</code>, <code> [text/markdown, text/plain]</code>,
     * <code>[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedMessagingContentTypes} method.
     * </p>
     * 
     * @return The supported chat message content types. Supported types are <code>text/plain</code>,
     *         <code>text/markdown</code>, <code>application/json</code>,
     *         <code>application/vnd.amazonaws.connect.message.interactive</code>, and
     *         <code>application/vnd.amazonaws.connect.message.interactive.response</code>. </p>
     *         <p>
     *         Content types must always contain <code> text/plain</code>. You can then put any other supported type in
     *         the list. For example, all the following lists are valid because they contain <code>text/plain</code>:
     *         <code>[text/plain, text/markdown, application/json]</code>, <code> [text/markdown, text/plain]</code>,
     *         <code>[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]</code>.
     */
    public final List<String> supportedMessagingContentTypes() {
        return supportedMessagingContentTypes;
    }

    /**
     * Returns the value of the ParticipantDetails property for this object.
     * 
     * @return The value of the ParticipantDetails property for this object.
     */
    public final ParticipantDetails participantDetails() {
        return participantDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes. They can
     * be accessed in flows just like any other contact attributes.
     * </p>
     * <p>
     * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only
     * alphanumeric, dash, and underscore characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes.
     *         They can be accessed in flows just like any other contact attributes. </p>
     *         <p>
     *         There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include
     *         only alphanumeric, dash, and underscore characters.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * Returns the value of the StreamingConfiguration property for this object.
     * 
     * @return The value of the StreamingConfiguration property for this object.
     */
    public final ChatStreamingConfiguration streamingConfiguration() {
        return streamingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSupportedMessagingContentTypes() ? supportedMessagingContentTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(participantDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(streamingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewSessionDetails)) {
            return false;
        }
        NewSessionDetails other = (NewSessionDetails) obj;
        return hasSupportedMessagingContentTypes() == other.hasSupportedMessagingContentTypes()
                && Objects.equals(supportedMessagingContentTypes(), other.supportedMessagingContentTypes())
                && Objects.equals(participantDetails(), other.participantDetails()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes())
                && Objects.equals(streamingConfiguration(), other.streamingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("NewSessionDetails")
                .add("SupportedMessagingContentTypes",
                        hasSupportedMessagingContentTypes() ? supportedMessagingContentTypes() : null)
                .add("ParticipantDetails", participantDetails()).add("Attributes", hasAttributes() ? attributes() : null)
                .add("StreamingConfiguration", streamingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SupportedMessagingContentTypes":
            return Optional.ofNullable(clazz.cast(supportedMessagingContentTypes()));
        case "ParticipantDetails":
            return Optional.ofNullable(clazz.cast(participantDetails()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "StreamingConfiguration":
            return Optional.ofNullable(clazz.cast(streamingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SupportedMessagingContentTypes", SUPPORTED_MESSAGING_CONTENT_TYPES_FIELD);
        map.put("ParticipantDetails", PARTICIPANT_DETAILS_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("StreamingConfiguration", STREAMING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NewSessionDetails, T> g) {
        return obj -> g.apply((NewSessionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NewSessionDetails> {
        /**
         * <p>
         * The supported chat message content types. Supported types are <code>text/plain</code>,
         * <code>text/markdown</code>, <code>application/json</code>,
         * <code>application/vnd.amazonaws.connect.message.interactive</code>, and
         * <code>application/vnd.amazonaws.connect.message.interactive.response</code>.
         * </p>
         * <p>
         * Content types must always contain <code> text/plain</code>. You can then put any other supported type in the
         * list. For example, all the following lists are valid because they contain <code>text/plain</code>:
         * <code>[text/plain, text/markdown, application/json]</code>, <code> [text/markdown, text/plain]</code>,
         * <code>[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]</code>.
         * </p>
         * 
         * @param supportedMessagingContentTypes
         *        The supported chat message content types. Supported types are <code>text/plain</code>,
         *        <code>text/markdown</code>, <code>application/json</code>,
         *        <code>application/vnd.amazonaws.connect.message.interactive</code>, and
         *        <code>application/vnd.amazonaws.connect.message.interactive.response</code>. </p>
         *        <p>
         *        Content types must always contain <code> text/plain</code>. You can then put any other supported type
         *        in the list. For example, all the following lists are valid because they contain
         *        <code>text/plain</code>: <code>[text/plain, text/markdown, application/json]</code>,
         *        <code> [text/markdown, text/plain]</code>,
         *        <code>[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedMessagingContentTypes(Collection<String> supportedMessagingContentTypes);

        /**
         * <p>
         * The supported chat message content types. Supported types are <code>text/plain</code>,
         * <code>text/markdown</code>, <code>application/json</code>,
         * <code>application/vnd.amazonaws.connect.message.interactive</code>, and
         * <code>application/vnd.amazonaws.connect.message.interactive.response</code>.
         * </p>
         * <p>
         * Content types must always contain <code> text/plain</code>. You can then put any other supported type in the
         * list. For example, all the following lists are valid because they contain <code>text/plain</code>:
         * <code>[text/plain, text/markdown, application/json]</code>, <code> [text/markdown, text/plain]</code>,
         * <code>[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]</code>.
         * </p>
         * 
         * @param supportedMessagingContentTypes
         *        The supported chat message content types. Supported types are <code>text/plain</code>,
         *        <code>text/markdown</code>, <code>application/json</code>,
         *        <code>application/vnd.amazonaws.connect.message.interactive</code>, and
         *        <code>application/vnd.amazonaws.connect.message.interactive.response</code>. </p>
         *        <p>
         *        Content types must always contain <code> text/plain</code>. You can then put any other supported type
         *        in the list. For example, all the following lists are valid because they contain
         *        <code>text/plain</code>: <code>[text/plain, text/markdown, application/json]</code>,
         *        <code> [text/markdown, text/plain]</code>,
         *        <code>[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedMessagingContentTypes(String... supportedMessagingContentTypes);

        /**
         * Sets the value of the ParticipantDetails property for this object.
         *
         * @param participantDetails
         *        The new value for the ParticipantDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantDetails(ParticipantDetails participantDetails);

        /**
         * Sets the value of the ParticipantDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ParticipantDetails.Builder} avoiding the
         * need to create one manually via {@link ParticipantDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParticipantDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #participantDetails(ParticipantDetails)}.
         * 
         * @param participantDetails
         *        a consumer that will call methods on {@link ParticipantDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #participantDetails(ParticipantDetails)
         */
        default Builder participantDetails(Consumer<ParticipantDetails.Builder> participantDetails) {
            return participantDetails(ParticipantDetails.builder().applyMutation(participantDetails).build());
        }

        /**
         * <p>
         * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes. They
         * can be accessed in flows just like any other contact attributes.
         * </p>
         * <p>
         * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only
         * alphanumeric, dash, and underscore characters.
         * </p>
         * 
         * @param attributes
         *        A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes.
         *        They can be accessed in flows just like any other contact attributes. </p>
         *        <p>
         *        There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can
         *        include only alphanumeric, dash, and underscore characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * Sets the value of the StreamingConfiguration property for this object.
         *
         * @param streamingConfiguration
         *        The new value for the StreamingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingConfiguration(ChatStreamingConfiguration streamingConfiguration);

        /**
         * Sets the value of the StreamingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ChatStreamingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ChatStreamingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChatStreamingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #streamingConfiguration(ChatStreamingConfiguration)}.
         * 
         * @param streamingConfiguration
         *        a consumer that will call methods on {@link ChatStreamingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingConfiguration(ChatStreamingConfiguration)
         */
        default Builder streamingConfiguration(Consumer<ChatStreamingConfiguration.Builder> streamingConfiguration) {
            return streamingConfiguration(ChatStreamingConfiguration.builder().applyMutation(streamingConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> supportedMessagingContentTypes = DefaultSdkAutoConstructList.getInstance();

        private ParticipantDetails participantDetails;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private ChatStreamingConfiguration streamingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(NewSessionDetails model) {
            supportedMessagingContentTypes(model.supportedMessagingContentTypes);
            participantDetails(model.participantDetails);
            attributes(model.attributes);
            streamingConfiguration(model.streamingConfiguration);
        }

        public final Collection<String> getSupportedMessagingContentTypes() {
            if (supportedMessagingContentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedMessagingContentTypes;
        }

        public final void setSupportedMessagingContentTypes(Collection<String> supportedMessagingContentTypes) {
            this.supportedMessagingContentTypes = SupportedMessagingContentTypesCopier.copy(supportedMessagingContentTypes);
        }

        @Override
        public final Builder supportedMessagingContentTypes(Collection<String> supportedMessagingContentTypes) {
            this.supportedMessagingContentTypes = SupportedMessagingContentTypesCopier.copy(supportedMessagingContentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedMessagingContentTypes(String... supportedMessagingContentTypes) {
            supportedMessagingContentTypes(Arrays.asList(supportedMessagingContentTypes));
            return this;
        }

        public final ParticipantDetails.Builder getParticipantDetails() {
            return participantDetails != null ? participantDetails.toBuilder() : null;
        }

        public final void setParticipantDetails(ParticipantDetails.BuilderImpl participantDetails) {
            this.participantDetails = participantDetails != null ? participantDetails.build() : null;
        }

        @Override
        public final Builder participantDetails(ParticipantDetails participantDetails) {
            this.participantDetails = participantDetails;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final ChatStreamingConfiguration.Builder getStreamingConfiguration() {
            return streamingConfiguration != null ? streamingConfiguration.toBuilder() : null;
        }

        public final void setStreamingConfiguration(ChatStreamingConfiguration.BuilderImpl streamingConfiguration) {
            this.streamingConfiguration = streamingConfiguration != null ? streamingConfiguration.build() : null;
        }

        @Override
        public final Builder streamingConfiguration(ChatStreamingConfiguration streamingConfiguration) {
            this.streamingConfiguration = streamingConfiguration;
            return this;
        }

        @Override
        public NewSessionDetails build() {
            return new NewSessionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
