/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A leaf node condition which can be used to specify a numeric condition.
 * </p>
 * <note>
 * <p>
 * The currently supported value for <code>FieldName</code> is <code>limit</code>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NumberCondition implements SdkPojo, Serializable, ToCopyableBuilder<NumberCondition.Builder, NumberCondition> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldName").getter(getter(NumberCondition::fieldName)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()).build();

    private static final SdkField<Integer> MIN_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinValue").getter(getter(NumberCondition::minValue)).setter(setter(Builder::minValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinValue").build()).build();

    private static final SdkField<Integer> MAX_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxValue").getter(getter(NumberCondition::maxValue)).setter(setter(Builder::maxValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxValue").build()).build();

    private static final SdkField<String> COMPARISON_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComparisonType").getter(getter(NumberCondition::comparisonTypeAsString))
            .setter(setter(Builder::comparisonType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD,
            MIN_VALUE_FIELD, MAX_VALUE_FIELD, COMPARISON_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldName;

    private final Integer minValue;

    private final Integer maxValue;

    private final String comparisonType;

    private NumberCondition(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.comparisonType = builder.comparisonType;
    }

    /**
     * <p>
     * The name of the field in the number condition.
     * </p>
     * 
     * @return The name of the field in the number condition.
     */
    public final String fieldName() {
        return fieldName;
    }

    /**
     * <p>
     * The minValue to be used while evaluating the number condition.
     * </p>
     * 
     * @return The minValue to be used while evaluating the number condition.
     */
    public final Integer minValue() {
        return minValue;
    }

    /**
     * <p>
     * The maxValue to be used while evaluating the number condition.
     * </p>
     * 
     * @return The maxValue to be used while evaluating the number condition.
     */
    public final Integer maxValue() {
        return maxValue;
    }

    /**
     * <p>
     * The type of comparison to be made when evaluating the number condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparisonType}
     * will return {@link NumberComparisonType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #comparisonTypeAsString}.
     * </p>
     * 
     * @return The type of comparison to be made when evaluating the number condition.
     * @see NumberComparisonType
     */
    public final NumberComparisonType comparisonType() {
        return NumberComparisonType.fromValue(comparisonType);
    }

    /**
     * <p>
     * The type of comparison to be made when evaluating the number condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparisonType}
     * will return {@link NumberComparisonType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #comparisonTypeAsString}.
     * </p>
     * 
     * @return The type of comparison to be made when evaluating the number condition.
     * @see NumberComparisonType
     */
    public final String comparisonTypeAsString() {
        return comparisonType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(minValue());
        hashCode = 31 * hashCode + Objects.hashCode(maxValue());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumberCondition)) {
            return false;
        }
        NumberCondition other = (NumberCondition) obj;
        return Objects.equals(fieldName(), other.fieldName()) && Objects.equals(minValue(), other.minValue())
                && Objects.equals(maxValue(), other.maxValue())
                && Objects.equals(comparisonTypeAsString(), other.comparisonTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NumberCondition").add("FieldName", fieldName()).add("MinValue", minValue())
                .add("MaxValue", maxValue()).add("ComparisonType", comparisonTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldName":
            return Optional.ofNullable(clazz.cast(fieldName()));
        case "MinValue":
            return Optional.ofNullable(clazz.cast(minValue()));
        case "MaxValue":
            return Optional.ofNullable(clazz.cast(maxValue()));
        case "ComparisonType":
            return Optional.ofNullable(clazz.cast(comparisonTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldName", FIELD_NAME_FIELD);
        map.put("MinValue", MIN_VALUE_FIELD);
        map.put("MaxValue", MAX_VALUE_FIELD);
        map.put("ComparisonType", COMPARISON_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NumberCondition, T> g) {
        return obj -> g.apply((NumberCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NumberCondition> {
        /**
         * <p>
         * The name of the field in the number condition.
         * </p>
         * 
         * @param fieldName
         *        The name of the field in the number condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * The minValue to be used while evaluating the number condition.
         * </p>
         * 
         * @param minValue
         *        The minValue to be used while evaluating the number condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minValue(Integer minValue);

        /**
         * <p>
         * The maxValue to be used while evaluating the number condition.
         * </p>
         * 
         * @param maxValue
         *        The maxValue to be used while evaluating the number condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxValue(Integer maxValue);

        /**
         * <p>
         * The type of comparison to be made when evaluating the number condition.
         * </p>
         * 
         * @param comparisonType
         *        The type of comparison to be made when evaluating the number condition.
         * @see NumberComparisonType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumberComparisonType
         */
        Builder comparisonType(String comparisonType);

        /**
         * <p>
         * The type of comparison to be made when evaluating the number condition.
         * </p>
         * 
         * @param comparisonType
         *        The type of comparison to be made when evaluating the number condition.
         * @see NumberComparisonType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumberComparisonType
         */
        Builder comparisonType(NumberComparisonType comparisonType);
    }

    static final class BuilderImpl implements Builder {
        private String fieldName;

        private Integer minValue;

        private Integer maxValue;

        private String comparisonType;

        private BuilderImpl() {
        }

        private BuilderImpl(NumberCondition model) {
            fieldName(model.fieldName);
            minValue(model.minValue);
            maxValue(model.maxValue);
            comparisonType(model.comparisonType);
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final Integer getMinValue() {
            return minValue;
        }

        public final void setMinValue(Integer minValue) {
            this.minValue = minValue;
        }

        @Override
        public final Builder minValue(Integer minValue) {
            this.minValue = minValue;
            return this;
        }

        public final Integer getMaxValue() {
            return maxValue;
        }

        public final void setMaxValue(Integer maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public final Builder maxValue(Integer maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final String getComparisonType() {
            return comparisonType;
        }

        public final void setComparisonType(String comparisonType) {
            this.comparisonType = comparisonType;
        }

        @Override
        public final Builder comparisonType(String comparisonType) {
            this.comparisonType = comparisonType;
            return this;
        }

        @Override
        public final Builder comparisonType(NumberComparisonType comparisonType) {
            this.comparisonType(comparisonType == null ? null : comparisonType.toString());
            return this;
        }

        @Override
        public NumberCondition build() {
            return new NumberCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
