/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The outbound caller ID name, number, and outbound whisper flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutboundCallerConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<OutboundCallerConfig.Builder, OutboundCallerConfig> {
    private static final SdkField<String> OUTBOUND_CALLER_ID_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutboundCallerIdName").getter(getter(OutboundCallerConfig::outboundCallerIdName))
            .setter(setter(Builder::outboundCallerIdName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundCallerIdName").build())
            .build();

    private static final SdkField<String> OUTBOUND_CALLER_ID_NUMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutboundCallerIdNumberId").getter(getter(OutboundCallerConfig::outboundCallerIdNumberId))
            .setter(setter(Builder::outboundCallerIdNumberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundCallerIdNumberId").build())
            .build();

    private static final SdkField<String> OUTBOUND_FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutboundFlowId").getter(getter(OutboundCallerConfig::outboundFlowId))
            .setter(setter(Builder::outboundFlowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundFlowId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTBOUND_CALLER_ID_NAME_FIELD,
            OUTBOUND_CALLER_ID_NUMBER_ID_FIELD, OUTBOUND_FLOW_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String outboundCallerIdName;

    private final String outboundCallerIdNumberId;

    private final String outboundFlowId;

    private OutboundCallerConfig(BuilderImpl builder) {
        this.outboundCallerIdName = builder.outboundCallerIdName;
        this.outboundCallerIdNumberId = builder.outboundCallerIdNumberId;
        this.outboundFlowId = builder.outboundFlowId;
    }

    /**
     * <p>
     * The caller ID name.
     * </p>
     * 
     * @return The caller ID name.
     */
    public final String outboundCallerIdName() {
        return outboundCallerIdName;
    }

    /**
     * <p>
     * The caller ID number.
     * </p>
     * 
     * @return The caller ID number.
     */
    public final String outboundCallerIdNumberId() {
        return outboundCallerIdNumberId;
    }

    /**
     * <p>
     * The outbound whisper flow to be used during an outbound call.
     * </p>
     * 
     * @return The outbound whisper flow to be used during an outbound call.
     */
    public final String outboundFlowId() {
        return outboundFlowId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outboundCallerIdName());
        hashCode = 31 * hashCode + Objects.hashCode(outboundCallerIdNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(outboundFlowId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutboundCallerConfig)) {
            return false;
        }
        OutboundCallerConfig other = (OutboundCallerConfig) obj;
        return Objects.equals(outboundCallerIdName(), other.outboundCallerIdName())
                && Objects.equals(outboundCallerIdNumberId(), other.outboundCallerIdNumberId())
                && Objects.equals(outboundFlowId(), other.outboundFlowId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutboundCallerConfig").add("OutboundCallerIdName", outboundCallerIdName())
                .add("OutboundCallerIdNumberId", outboundCallerIdNumberId()).add("OutboundFlowId", outboundFlowId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutboundCallerIdName":
            return Optional.ofNullable(clazz.cast(outboundCallerIdName()));
        case "OutboundCallerIdNumberId":
            return Optional.ofNullable(clazz.cast(outboundCallerIdNumberId()));
        case "OutboundFlowId":
            return Optional.ofNullable(clazz.cast(outboundFlowId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OutboundCallerIdName", OUTBOUND_CALLER_ID_NAME_FIELD);
        map.put("OutboundCallerIdNumberId", OUTBOUND_CALLER_ID_NUMBER_ID_FIELD);
        map.put("OutboundFlowId", OUTBOUND_FLOW_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutboundCallerConfig, T> g) {
        return obj -> g.apply((OutboundCallerConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutboundCallerConfig> {
        /**
         * <p>
         * The caller ID name.
         * </p>
         * 
         * @param outboundCallerIdName
         *        The caller ID name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundCallerIdName(String outboundCallerIdName);

        /**
         * <p>
         * The caller ID number.
         * </p>
         * 
         * @param outboundCallerIdNumberId
         *        The caller ID number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundCallerIdNumberId(String outboundCallerIdNumberId);

        /**
         * <p>
         * The outbound whisper flow to be used during an outbound call.
         * </p>
         * 
         * @param outboundFlowId
         *        The outbound whisper flow to be used during an outbound call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundFlowId(String outboundFlowId);
    }

    static final class BuilderImpl implements Builder {
        private String outboundCallerIdName;

        private String outboundCallerIdNumberId;

        private String outboundFlowId;

        private BuilderImpl() {
        }

        private BuilderImpl(OutboundCallerConfig model) {
            outboundCallerIdName(model.outboundCallerIdName);
            outboundCallerIdNumberId(model.outboundCallerIdNumberId);
            outboundFlowId(model.outboundFlowId);
        }

        public final String getOutboundCallerIdName() {
            return outboundCallerIdName;
        }

        public final void setOutboundCallerIdName(String outboundCallerIdName) {
            this.outboundCallerIdName = outboundCallerIdName;
        }

        @Override
        public final Builder outboundCallerIdName(String outboundCallerIdName) {
            this.outboundCallerIdName = outboundCallerIdName;
            return this;
        }

        public final String getOutboundCallerIdNumberId() {
            return outboundCallerIdNumberId;
        }

        public final void setOutboundCallerIdNumberId(String outboundCallerIdNumberId) {
            this.outboundCallerIdNumberId = outboundCallerIdNumberId;
        }

        @Override
        public final Builder outboundCallerIdNumberId(String outboundCallerIdNumberId) {
            this.outboundCallerIdNumberId = outboundCallerIdNumberId;
            return this;
        }

        public final String getOutboundFlowId() {
            return outboundFlowId;
        }

        public final void setOutboundFlowId(String outboundFlowId) {
            this.outboundFlowId = outboundFlowId;
        }

        @Override
        public final Builder outboundFlowId(String outboundFlowId) {
            this.outboundFlowId = outboundFlowId;
            return this;
        }

        @Override
        public OutboundCallerConfig build() {
            return new OutboundCallerConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
