/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the allowed video and screen sharing capabilities for participants present over the call. For
 * more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/inapp-calling.html">Set up
 * in-app, web, video calling, and screen sharing capabilities</a> in the <i>Amazon Connect Administrator Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParticipantCapabilities implements SdkPojo, Serializable,
        ToCopyableBuilder<ParticipantCapabilities.Builder, ParticipantCapabilities> {
    private static final SdkField<String> VIDEO_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Video")
            .getter(getter(ParticipantCapabilities::videoAsString)).setter(setter(Builder::video))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()).build();

    private static final SdkField<String> SCREEN_SHARE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScreenShare").getter(getter(ParticipantCapabilities::screenShareAsString))
            .setter(setter(Builder::screenShare))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScreenShare").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIDEO_FIELD,
            SCREEN_SHARE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String video;

    private final String screenShare;

    private ParticipantCapabilities(BuilderImpl builder) {
        this.video = builder.video;
        this.screenShare = builder.screenShare;
    }

    /**
     * <p>
     * The configuration having the video and screen sharing capabilities for participants over the call.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #video} will return
     * {@link VideoCapability#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #videoAsString}.
     * </p>
     * 
     * @return The configuration having the video and screen sharing capabilities for participants over the call.
     * @see VideoCapability
     */
    public final VideoCapability video() {
        return VideoCapability.fromValue(video);
    }

    /**
     * <p>
     * The configuration having the video and screen sharing capabilities for participants over the call.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #video} will return
     * {@link VideoCapability#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #videoAsString}.
     * </p>
     * 
     * @return The configuration having the video and screen sharing capabilities for participants over the call.
     * @see VideoCapability
     */
    public final String videoAsString() {
        return video;
    }

    /**
     * <p>
     * The screen sharing capability that is enabled for the participant. <code>SEND</code> indicates the participant
     * can share their screen.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #screenShare} will
     * return {@link ScreenShareCapability#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #screenShareAsString}.
     * </p>
     * 
     * @return The screen sharing capability that is enabled for the participant. <code>SEND</code> indicates the
     *         participant can share their screen.
     * @see ScreenShareCapability
     */
    public final ScreenShareCapability screenShare() {
        return ScreenShareCapability.fromValue(screenShare);
    }

    /**
     * <p>
     * The screen sharing capability that is enabled for the participant. <code>SEND</code> indicates the participant
     * can share their screen.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #screenShare} will
     * return {@link ScreenShareCapability#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #screenShareAsString}.
     * </p>
     * 
     * @return The screen sharing capability that is enabled for the participant. <code>SEND</code> indicates the
     *         participant can share their screen.
     * @see ScreenShareCapability
     */
    public final String screenShareAsString() {
        return screenShare;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(videoAsString());
        hashCode = 31 * hashCode + Objects.hashCode(screenShareAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipantCapabilities)) {
            return false;
        }
        ParticipantCapabilities other = (ParticipantCapabilities) obj;
        return Objects.equals(videoAsString(), other.videoAsString())
                && Objects.equals(screenShareAsString(), other.screenShareAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParticipantCapabilities").add("Video", videoAsString())
                .add("ScreenShare", screenShareAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Video":
            return Optional.ofNullable(clazz.cast(videoAsString()));
        case "ScreenShare":
            return Optional.ofNullable(clazz.cast(screenShareAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Video", VIDEO_FIELD);
        map.put("ScreenShare", SCREEN_SHARE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParticipantCapabilities, T> g) {
        return obj -> g.apply((ParticipantCapabilities) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParticipantCapabilities> {
        /**
         * <p>
         * The configuration having the video and screen sharing capabilities for participants over the call.
         * </p>
         * 
         * @param video
         *        The configuration having the video and screen sharing capabilities for participants over the call.
         * @see VideoCapability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoCapability
         */
        Builder video(String video);

        /**
         * <p>
         * The configuration having the video and screen sharing capabilities for participants over the call.
         * </p>
         * 
         * @param video
         *        The configuration having the video and screen sharing capabilities for participants over the call.
         * @see VideoCapability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoCapability
         */
        Builder video(VideoCapability video);

        /**
         * <p>
         * The screen sharing capability that is enabled for the participant. <code>SEND</code> indicates the
         * participant can share their screen.
         * </p>
         * 
         * @param screenShare
         *        The screen sharing capability that is enabled for the participant. <code>SEND</code> indicates the
         *        participant can share their screen.
         * @see ScreenShareCapability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScreenShareCapability
         */
        Builder screenShare(String screenShare);

        /**
         * <p>
         * The screen sharing capability that is enabled for the participant. <code>SEND</code> indicates the
         * participant can share their screen.
         * </p>
         * 
         * @param screenShare
         *        The screen sharing capability that is enabled for the participant. <code>SEND</code> indicates the
         *        participant can share their screen.
         * @see ScreenShareCapability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScreenShareCapability
         */
        Builder screenShare(ScreenShareCapability screenShare);
    }

    static final class BuilderImpl implements Builder {
        private String video;

        private String screenShare;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipantCapabilities model) {
            video(model.video);
            screenShare(model.screenShare);
        }

        public final String getVideo() {
            return video;
        }

        public final void setVideo(String video) {
            this.video = video;
        }

        @Override
        public final Builder video(String video) {
            this.video = video;
            return this;
        }

        @Override
        public final Builder video(VideoCapability video) {
            this.video(video == null ? null : video.toString());
            return this;
        }

        public final String getScreenShare() {
            return screenShare;
        }

        public final void setScreenShare(String screenShare) {
            this.screenShare = screenShare;
        }

        @Override
        public final Builder screenShare(String screenShare) {
            this.screenShare = screenShare;
            return this;
        }

        @Override
        public final Builder screenShare(ScreenShareCapability screenShare) {
            this.screenShare(screenShare == null ? null : screenShare.toString());
            return this;
        }

        @Override
        public ParticipantCapabilities build() {
            return new ParticipantCapabilities(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
