/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for the timer. After the timer configuration is set, it persists for the duration of the
 * chat. It persists across new contacts in the chain, for example, transfer contacts.
 * </p>
 * <p>
 * For more information about how chat timeouts work, see <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-chat-timeouts.html">Set up chat timeouts for human
 * participants</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParticipantTimerConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ParticipantTimerConfiguration.Builder, ParticipantTimerConfiguration> {
    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantRole").getter(getter(ParticipantTimerConfiguration::participantRoleAsString))
            .setter(setter(Builder::participantRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()).build();

    private static final SdkField<String> TIMER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimerType").getter(getter(ParticipantTimerConfiguration::timerTypeAsString))
            .setter(setter(Builder::timerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimerType").build()).build();

    private static final SdkField<ParticipantTimerValue> TIMER_VALUE_FIELD = SdkField
            .<ParticipantTimerValue> builder(MarshallingType.SDK_POJO).memberName("TimerValue")
            .getter(getter(ParticipantTimerConfiguration::timerValue)).setter(setter(Builder::timerValue))
            .constructor(ParticipantTimerValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimerValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTICIPANT_ROLE_FIELD,
            TIMER_TYPE_FIELD, TIMER_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String participantRole;

    private final String timerType;

    private final ParticipantTimerValue timerValue;

    private ParticipantTimerConfiguration(BuilderImpl builder) {
        this.participantRole = builder.participantRole;
        this.timerType = builder.timerType;
        this.timerValue = builder.timerValue;
    }

    /**
     * <p>
     * The role of the participant in the chat conversation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link TimerEligibleParticipantRoles#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return The role of the participant in the chat conversation.
     * @see TimerEligibleParticipantRoles
     */
    public final TimerEligibleParticipantRoles participantRole() {
        return TimerEligibleParticipantRoles.fromValue(participantRole);
    }

    /**
     * <p>
     * The role of the participant in the chat conversation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link TimerEligibleParticipantRoles#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return The role of the participant in the chat conversation.
     * @see TimerEligibleParticipantRoles
     */
    public final String participantRoleAsString() {
        return participantRole;
    }

    /**
     * <p>
     * The type of timer. <code>IDLE</code> indicates the timer applies for considering a human chat participant as
     * idle. <code>DISCONNECT_NONCUSTOMER</code> indicates the timer applies to automatically disconnecting a chat
     * participant due to idleness.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timerType} will
     * return {@link ParticipantTimerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timerTypeAsString}.
     * </p>
     * 
     * @return The type of timer. <code>IDLE</code> indicates the timer applies for considering a human chat participant
     *         as idle. <code>DISCONNECT_NONCUSTOMER</code> indicates the timer applies to automatically disconnecting a
     *         chat participant due to idleness.
     * @see ParticipantTimerType
     */
    public final ParticipantTimerType timerType() {
        return ParticipantTimerType.fromValue(timerType);
    }

    /**
     * <p>
     * The type of timer. <code>IDLE</code> indicates the timer applies for considering a human chat participant as
     * idle. <code>DISCONNECT_NONCUSTOMER</code> indicates the timer applies to automatically disconnecting a chat
     * participant due to idleness.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timerType} will
     * return {@link ParticipantTimerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timerTypeAsString}.
     * </p>
     * 
     * @return The type of timer. <code>IDLE</code> indicates the timer applies for considering a human chat participant
     *         as idle. <code>DISCONNECT_NONCUSTOMER</code> indicates the timer applies to automatically disconnecting a
     *         chat participant due to idleness.
     * @see ParticipantTimerType
     */
    public final String timerTypeAsString() {
        return timerType;
    }

    /**
     * <p>
     * The value of the timer. Either the timer action (Unset to delete the timer), or the duration of the timer in
     * minutes. Only one value can be set.
     * </p>
     * 
     * @return The value of the timer. Either the timer action (Unset to delete the timer), or the duration of the timer
     *         in minutes. Only one value can be set.
     */
    public final ParticipantTimerValue timerValue() {
        return timerValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(participantRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timerValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipantTimerConfiguration)) {
            return false;
        }
        ParticipantTimerConfiguration other = (ParticipantTimerConfiguration) obj;
        return Objects.equals(participantRoleAsString(), other.participantRoleAsString())
                && Objects.equals(timerTypeAsString(), other.timerTypeAsString())
                && Objects.equals(timerValue(), other.timerValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParticipantTimerConfiguration").add("ParticipantRole", participantRoleAsString())
                .add("TimerType", timerTypeAsString()).add("TimerValue", timerValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParticipantRole":
            return Optional.ofNullable(clazz.cast(participantRoleAsString()));
        case "TimerType":
            return Optional.ofNullable(clazz.cast(timerTypeAsString()));
        case "TimerValue":
            return Optional.ofNullable(clazz.cast(timerValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ParticipantRole", PARTICIPANT_ROLE_FIELD);
        map.put("TimerType", TIMER_TYPE_FIELD);
        map.put("TimerValue", TIMER_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParticipantTimerConfiguration, T> g) {
        return obj -> g.apply((ParticipantTimerConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParticipantTimerConfiguration> {
        /**
         * <p>
         * The role of the participant in the chat conversation.
         * </p>
         * 
         * @param participantRole
         *        The role of the participant in the chat conversation.
         * @see TimerEligibleParticipantRoles
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimerEligibleParticipantRoles
         */
        Builder participantRole(String participantRole);

        /**
         * <p>
         * The role of the participant in the chat conversation.
         * </p>
         * 
         * @param participantRole
         *        The role of the participant in the chat conversation.
         * @see TimerEligibleParticipantRoles
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimerEligibleParticipantRoles
         */
        Builder participantRole(TimerEligibleParticipantRoles participantRole);

        /**
         * <p>
         * The type of timer. <code>IDLE</code> indicates the timer applies for considering a human chat participant as
         * idle. <code>DISCONNECT_NONCUSTOMER</code> indicates the timer applies to automatically disconnecting a chat
         * participant due to idleness.
         * </p>
         * 
         * @param timerType
         *        The type of timer. <code>IDLE</code> indicates the timer applies for considering a human chat
         *        participant as idle. <code>DISCONNECT_NONCUSTOMER</code> indicates the timer applies to automatically
         *        disconnecting a chat participant due to idleness.
         * @see ParticipantTimerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantTimerType
         */
        Builder timerType(String timerType);

        /**
         * <p>
         * The type of timer. <code>IDLE</code> indicates the timer applies for considering a human chat participant as
         * idle. <code>DISCONNECT_NONCUSTOMER</code> indicates the timer applies to automatically disconnecting a chat
         * participant due to idleness.
         * </p>
         * 
         * @param timerType
         *        The type of timer. <code>IDLE</code> indicates the timer applies for considering a human chat
         *        participant as idle. <code>DISCONNECT_NONCUSTOMER</code> indicates the timer applies to automatically
         *        disconnecting a chat participant due to idleness.
         * @see ParticipantTimerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantTimerType
         */
        Builder timerType(ParticipantTimerType timerType);

        /**
         * <p>
         * The value of the timer. Either the timer action (Unset to delete the timer), or the duration of the timer in
         * minutes. Only one value can be set.
         * </p>
         * 
         * @param timerValue
         *        The value of the timer. Either the timer action (Unset to delete the timer), or the duration of the
         *        timer in minutes. Only one value can be set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timerValue(ParticipantTimerValue timerValue);

        /**
         * <p>
         * The value of the timer. Either the timer action (Unset to delete the timer), or the duration of the timer in
         * minutes. Only one value can be set.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParticipantTimerValue.Builder} avoiding
         * the need to create one manually via {@link ParticipantTimerValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParticipantTimerValue.Builder#build()} is called immediately and
         * its result is passed to {@link #timerValue(ParticipantTimerValue)}.
         * 
         * @param timerValue
         *        a consumer that will call methods on {@link ParticipantTimerValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timerValue(ParticipantTimerValue)
         */
        default Builder timerValue(Consumer<ParticipantTimerValue.Builder> timerValue) {
            return timerValue(ParticipantTimerValue.builder().applyMutation(timerValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String participantRole;

        private String timerType;

        private ParticipantTimerValue timerValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipantTimerConfiguration model) {
            participantRole(model.participantRole);
            timerType(model.timerType);
            timerValue(model.timerValue);
        }

        public final String getParticipantRole() {
            return participantRole;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        @Override
        public final Builder participantRole(TimerEligibleParticipantRoles participantRole) {
            this.participantRole(participantRole == null ? null : participantRole.toString());
            return this;
        }

        public final String getTimerType() {
            return timerType;
        }

        public final void setTimerType(String timerType) {
            this.timerType = timerType;
        }

        @Override
        public final Builder timerType(String timerType) {
            this.timerType = timerType;
            return this;
        }

        @Override
        public final Builder timerType(ParticipantTimerType timerType) {
            this.timerType(timerType == null ? null : timerType.toString());
            return this;
        }

        public final ParticipantTimerValue.Builder getTimerValue() {
            return timerValue != null ? timerValue.toBuilder() : null;
        }

        public final void setTimerValue(ParticipantTimerValue.BuilderImpl timerValue) {
            this.timerValue = timerValue != null ? timerValue.build() : null;
        }

        @Override
        public final Builder timerValue(ParticipantTimerValue timerValue) {
            this.timerValue = timerValue;
            return this;
        }

        @Override
        public ParticipantTimerConfiguration build() {
            return new ParticipantTimerConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
