/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value of the timer. Either the timer action (<code>Unset</code> to delete the timer), or the duration of the
 * timer in minutes. Only one value can be set.
 * </p>
 * <p>
 * For more information about how chat timeouts work, see <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-chat-timeouts.html">Set up chat timeouts for human
 * participants</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParticipantTimerValue implements SdkPojo, Serializable,
        ToCopyableBuilder<ParticipantTimerValue.Builder, ParticipantTimerValue> {
    private static final SdkField<String> PARTICIPANT_TIMER_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantTimerAction").getter(getter(ParticipantTimerValue::participantTimerActionAsString))
            .setter(setter(Builder::participantTimerAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantTimerAction").build())
            .build();

    private static final SdkField<Integer> PARTICIPANT_TIMER_DURATION_IN_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParticipantTimerDurationInMinutes")
            .getter(getter(ParticipantTimerValue::participantTimerDurationInMinutes))
            .setter(setter(Builder::participantTimerDurationInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantTimerDurationInMinutes")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PARTICIPANT_TIMER_ACTION_FIELD, PARTICIPANT_TIMER_DURATION_IN_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String participantTimerAction;

    private final Integer participantTimerDurationInMinutes;

    private final Type type;

    private ParticipantTimerValue(BuilderImpl builder) {
        this.participantTimerAction = builder.participantTimerAction;
        this.participantTimerDurationInMinutes = builder.participantTimerDurationInMinutes;
        this.type = builder.type;
    }

    /**
     * <p>
     * The timer action. Currently only one value is allowed: <code>Unset</code>. It deletes a timer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #participantTimerAction} will return {@link ParticipantTimerAction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #participantTimerActionAsString}.
     * </p>
     * 
     * @return The timer action. Currently only one value is allowed: <code>Unset</code>. It deletes a timer.
     * @see ParticipantTimerAction
     */
    public final ParticipantTimerAction participantTimerAction() {
        return ParticipantTimerAction.fromValue(participantTimerAction);
    }

    /**
     * <p>
     * The timer action. Currently only one value is allowed: <code>Unset</code>. It deletes a timer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #participantTimerAction} will return {@link ParticipantTimerAction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #participantTimerActionAsString}.
     * </p>
     * 
     * @return The timer action. Currently only one value is allowed: <code>Unset</code>. It deletes a timer.
     * @see ParticipantTimerAction
     */
    public final String participantTimerActionAsString() {
        return participantTimerAction;
    }

    /**
     * <p>
     * The duration of a timer, in minutes.
     * </p>
     * 
     * @return The duration of a timer, in minutes.
     */
    public final Integer participantTimerDurationInMinutes() {
        return participantTimerDurationInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(participantTimerActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(participantTimerDurationInMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipantTimerValue)) {
            return false;
        }
        ParticipantTimerValue other = (ParticipantTimerValue) obj;
        return Objects.equals(participantTimerActionAsString(), other.participantTimerActionAsString())
                && Objects.equals(participantTimerDurationInMinutes(), other.participantTimerDurationInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParticipantTimerValue").add("ParticipantTimerAction", participantTimerActionAsString())
                .add("ParticipantTimerDurationInMinutes", participantTimerDurationInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParticipantTimerAction":
            return Optional.ofNullable(clazz.cast(participantTimerActionAsString()));
        case "ParticipantTimerDurationInMinutes":
            return Optional.ofNullable(clazz.cast(participantTimerDurationInMinutes()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #participantTimerActionAsString()} initialized to the given value.
     *
     * <p>
     * The timer action. Currently only one value is allowed: <code>Unset</code>. It deletes a timer.
     * </p>
     * 
     * @param participantTimerAction
     *        The timer action. Currently only one value is allowed: <code>Unset</code>. It deletes a timer.
     * @see ParticipantTimerAction
     */
    public static ParticipantTimerValue fromParticipantTimerAction(String participantTimerAction) {
        return builder().participantTimerAction(participantTimerAction).build();
    }

    /**
     * Create an instance of this class with {@link #participantTimerActionAsString()} initialized to the given value.
     *
     * <p>
     * The timer action. Currently only one value is allowed: <code>Unset</code>. It deletes a timer.
     * </p>
     * 
     * @param participantTimerAction
     *        The timer action. Currently only one value is allowed: <code>Unset</code>. It deletes a timer.
     * @see ParticipantTimerAction
     */
    public static ParticipantTimerValue fromParticipantTimerAction(ParticipantTimerAction participantTimerAction) {
        return builder().participantTimerAction(participantTimerAction).build();
    }

    /**
     * Create an instance of this class with {@link #participantTimerDurationInMinutes()} initialized to the given
     * value.
     *
     * <p>
     * The duration of a timer, in minutes.
     * </p>
     * 
     * @param participantTimerDurationInMinutes
     *        The duration of a timer, in minutes.
     */
    public static ParticipantTimerValue fromParticipantTimerDurationInMinutes(Integer participantTimerDurationInMinutes) {
        return builder().participantTimerDurationInMinutes(participantTimerDurationInMinutes).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ParticipantTimerAction", PARTICIPANT_TIMER_ACTION_FIELD);
        map.put("ParticipantTimerDurationInMinutes", PARTICIPANT_TIMER_DURATION_IN_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParticipantTimerValue, T> g) {
        return obj -> g.apply((ParticipantTimerValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParticipantTimerValue> {
        /**
         * <p>
         * The timer action. Currently only one value is allowed: <code>Unset</code>. It deletes a timer.
         * </p>
         * 
         * @param participantTimerAction
         *        The timer action. Currently only one value is allowed: <code>Unset</code>. It deletes a timer.
         * @see ParticipantTimerAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantTimerAction
         */
        Builder participantTimerAction(String participantTimerAction);

        /**
         * <p>
         * The timer action. Currently only one value is allowed: <code>Unset</code>. It deletes a timer.
         * </p>
         * 
         * @param participantTimerAction
         *        The timer action. Currently only one value is allowed: <code>Unset</code>. It deletes a timer.
         * @see ParticipantTimerAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantTimerAction
         */
        Builder participantTimerAction(ParticipantTimerAction participantTimerAction);

        /**
         * <p>
         * The duration of a timer, in minutes.
         * </p>
         * 
         * @param participantTimerDurationInMinutes
         *        The duration of a timer, in minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantTimerDurationInMinutes(Integer participantTimerDurationInMinutes);
    }

    static final class BuilderImpl implements Builder {
        private String participantTimerAction;

        private Integer participantTimerDurationInMinutes;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipantTimerValue model) {
            participantTimerAction(model.participantTimerAction);
            participantTimerDurationInMinutes(model.participantTimerDurationInMinutes);
        }

        public final String getParticipantTimerAction() {
            return participantTimerAction;
        }

        public final void setParticipantTimerAction(String participantTimerAction) {
            Object oldValue = this.participantTimerAction;
            this.participantTimerAction = participantTimerAction;
            handleUnionValueChange(Type.PARTICIPANT_TIMER_ACTION, oldValue, this.participantTimerAction);
        }

        @Override
        public final Builder participantTimerAction(String participantTimerAction) {
            Object oldValue = this.participantTimerAction;
            this.participantTimerAction = participantTimerAction;
            handleUnionValueChange(Type.PARTICIPANT_TIMER_ACTION, oldValue, this.participantTimerAction);
            return this;
        }

        @Override
        public final Builder participantTimerAction(ParticipantTimerAction participantTimerAction) {
            this.participantTimerAction(participantTimerAction == null ? null : participantTimerAction.toString());
            return this;
        }

        public final Integer getParticipantTimerDurationInMinutes() {
            return participantTimerDurationInMinutes;
        }

        public final void setParticipantTimerDurationInMinutes(Integer participantTimerDurationInMinutes) {
            Object oldValue = this.participantTimerDurationInMinutes;
            this.participantTimerDurationInMinutes = participantTimerDurationInMinutes;
            handleUnionValueChange(Type.PARTICIPANT_TIMER_DURATION_IN_MINUTES, oldValue, this.participantTimerDurationInMinutes);
        }

        @Override
        public final Builder participantTimerDurationInMinutes(Integer participantTimerDurationInMinutes) {
            Object oldValue = this.participantTimerDurationInMinutes;
            this.participantTimerDurationInMinutes = participantTimerDurationInMinutes;
            handleUnionValueChange(Type.PARTICIPANT_TIMER_DURATION_IN_MINUTES, oldValue, this.participantTimerDurationInMinutes);
            return this;
        }

        @Override
        public ParticipantTimerValue build() {
            return new ParticipantTimerValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ParticipantTimerValue#type()
     */
    public enum Type {
        PARTICIPANT_TIMER_ACTION,

        PARTICIPANT_TIMER_DURATION_IN_MINUTES,

        UNKNOWN_TO_SDK_VERSION
    }
}
