/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about why a property is not valid.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertyValidationExceptionProperty implements SdkPojo, Serializable,
        ToCopyableBuilder<PropertyValidationExceptionProperty.Builder, PropertyValidationExceptionProperty> {
    private static final SdkField<String> PROPERTY_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PropertyPath").getter(getter(PropertyValidationExceptionProperty::propertyPath))
            .setter(setter(Builder::propertyPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyPath").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(PropertyValidationExceptionProperty::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(PropertyValidationExceptionProperty::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_PATH_FIELD,
            REASON_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String propertyPath;

    private final String reason;

    private final String message;

    private PropertyValidationExceptionProperty(BuilderImpl builder) {
        this.propertyPath = builder.propertyPath;
        this.reason = builder.reason;
        this.message = builder.message;
    }

    /**
     * <p>
     * The full property path.
     * </p>
     * 
     * @return The full property path.
     */
    public final String propertyPath() {
        return propertyPath;
    }

    /**
     * <p>
     * Why the property is not valid.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link PropertyValidationExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return Why the property is not valid.
     * @see PropertyValidationExceptionReason
     */
    public final PropertyValidationExceptionReason reason() {
        return PropertyValidationExceptionReason.fromValue(reason);
    }

    /**
     * <p>
     * Why the property is not valid.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link PropertyValidationExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return Why the property is not valid.
     * @see PropertyValidationExceptionReason
     */
    public final String reasonAsString() {
        return reason;
    }

    /**
     * <p>
     * A message describing why the property is not valid.
     * </p>
     * 
     * @return A message describing why the property is not valid.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(propertyPath());
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyValidationExceptionProperty)) {
            return false;
        }
        PropertyValidationExceptionProperty other = (PropertyValidationExceptionProperty) obj;
        return Objects.equals(propertyPath(), other.propertyPath()) && Objects.equals(reasonAsString(), other.reasonAsString())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PropertyValidationExceptionProperty").add("PropertyPath", propertyPath())
                .add("Reason", reasonAsString()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PropertyPath":
            return Optional.ofNullable(clazz.cast(propertyPath()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PropertyPath", PROPERTY_PATH_FIELD);
        map.put("Reason", REASON_FIELD);
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PropertyValidationExceptionProperty, T> g) {
        return obj -> g.apply((PropertyValidationExceptionProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertyValidationExceptionProperty> {
        /**
         * <p>
         * The full property path.
         * </p>
         * 
         * @param propertyPath
         *        The full property path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyPath(String propertyPath);

        /**
         * <p>
         * Why the property is not valid.
         * </p>
         * 
         * @param reason
         *        Why the property is not valid.
         * @see PropertyValidationExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyValidationExceptionReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * Why the property is not valid.
         * </p>
         * 
         * @param reason
         *        Why the property is not valid.
         * @see PropertyValidationExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyValidationExceptionReason
         */
        Builder reason(PropertyValidationExceptionReason reason);

        /**
         * <p>
         * A message describing why the property is not valid.
         * </p>
         * 
         * @param message
         *        A message describing why the property is not valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String propertyPath;

        private String reason;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyValidationExceptionProperty model) {
            propertyPath(model.propertyPath);
            reason(model.reason);
            message(model.message);
        }

        public final String getPropertyPath() {
            return propertyPath;
        }

        public final void setPropertyPath(String propertyPath) {
            this.propertyPath = propertyPath;
        }

        @Override
        public final Builder propertyPath(String propertyPath) {
            this.propertyPath = propertyPath;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(PropertyValidationExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public PropertyValidationExceptionProperty build() {
            return new PropertyValidationExceptionProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
