/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The search criteria to be used to return queues.
 * </p>
 * <note>
 * <p>
 * The <code>name</code> and <code>description</code> fields support "contains" queries with a minimum of 2 characters
 * and a maximum of 25 characters. Any queries with character lengths outside of this range will throw invalid results.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueueSearchCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<QueueSearchCriteria.Builder, QueueSearchCriteria> {
    private static final SdkField<List<QueueSearchCriteria>> OR_CONDITIONS_FIELD = SdkField
            .<List<QueueSearchCriteria>> builder(MarshallingType.LIST)
            .memberName("OrConditions")
            .getter(getter(QueueSearchCriteria::orConditions))
            .setter(setter(Builder::orConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueueSearchCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueueSearchCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<QueueSearchCriteria>> AND_CONDITIONS_FIELD = SdkField
            .<List<QueueSearchCriteria>> builder(MarshallingType.LIST)
            .memberName("AndConditions")
            .getter(getter(QueueSearchCriteria::andConditions))
            .setter(setter(Builder::andConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueueSearchCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueueSearchCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StringCondition> STRING_CONDITION_FIELD = SdkField
            .<StringCondition> builder(MarshallingType.SDK_POJO).memberName("StringCondition")
            .getter(getter(QueueSearchCriteria::stringCondition)).setter(setter(Builder::stringCondition))
            .constructor(StringCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringCondition").build()).build();

    private static final SdkField<String> QUEUE_TYPE_CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueueTypeCondition").getter(getter(QueueSearchCriteria::queueTypeConditionAsString))
            .setter(setter(Builder::queueTypeCondition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueTypeCondition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_CONDITIONS_FIELD,
            AND_CONDITIONS_FIELD, STRING_CONDITION_FIELD, QUEUE_TYPE_CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<QueueSearchCriteria> orConditions;

    private final List<QueueSearchCriteria> andConditions;

    private final StringCondition stringCondition;

    private final String queueTypeCondition;

    private QueueSearchCriteria(BuilderImpl builder) {
        this.orConditions = builder.orConditions;
        this.andConditions = builder.andConditions;
        this.stringCondition = builder.stringCondition;
        this.queueTypeCondition = builder.queueTypeCondition;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrConditions() {
        return orConditions != null && !(orConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions which would be applied together with an OR condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrConditions} method.
     * </p>
     * 
     * @return A list of conditions which would be applied together with an OR condition.
     */
    public final List<QueueSearchCriteria> orConditions() {
        return orConditions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AndConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAndConditions() {
        return andConditions != null && !(andConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions which would be applied together with an AND condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAndConditions} method.
     * </p>
     * 
     * @return A list of conditions which would be applied together with an AND condition.
     */
    public final List<QueueSearchCriteria> andConditions() {
        return andConditions;
    }

    /**
     * <p>
     * A leaf node condition which can be used to specify a string condition.
     * </p>
     * <note>
     * <p>
     * The currently supported values for <code>FieldName</code> are <code>name</code>, <code>description</code>, and
     * <code>resourceID</code>.
     * </p>
     * </note>
     * 
     * @return A leaf node condition which can be used to specify a string condition.</p> <note>
     *         <p>
     *         The currently supported values for <code>FieldName</code> are <code>name</code>, <code>description</code>
     *         , and <code>resourceID</code>.
     *         </p>
     */
    public final StringCondition stringCondition() {
        return stringCondition;
    }

    /**
     * <p>
     * The type of queue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #queueTypeCondition} will return {@link SearchableQueueType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #queueTypeConditionAsString}.
     * </p>
     * 
     * @return The type of queue.
     * @see SearchableQueueType
     */
    public final SearchableQueueType queueTypeCondition() {
        return SearchableQueueType.fromValue(queueTypeCondition);
    }

    /**
     * <p>
     * The type of queue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #queueTypeCondition} will return {@link SearchableQueueType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #queueTypeConditionAsString}.
     * </p>
     * 
     * @return The type of queue.
     * @see SearchableQueueType
     */
    public final String queueTypeConditionAsString() {
        return queueTypeCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOrConditions() ? orConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAndConditions() ? andConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stringCondition());
        hashCode = 31 * hashCode + Objects.hashCode(queueTypeConditionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueSearchCriteria)) {
            return false;
        }
        QueueSearchCriteria other = (QueueSearchCriteria) obj;
        return hasOrConditions() == other.hasOrConditions() && Objects.equals(orConditions(), other.orConditions())
                && hasAndConditions() == other.hasAndConditions() && Objects.equals(andConditions(), other.andConditions())
                && Objects.equals(stringCondition(), other.stringCondition())
                && Objects.equals(queueTypeConditionAsString(), other.queueTypeConditionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueueSearchCriteria").add("OrConditions", hasOrConditions() ? orConditions() : null)
                .add("AndConditions", hasAndConditions() ? andConditions() : null).add("StringCondition", stringCondition())
                .add("QueueTypeCondition", queueTypeConditionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrConditions":
            return Optional.ofNullable(clazz.cast(orConditions()));
        case "AndConditions":
            return Optional.ofNullable(clazz.cast(andConditions()));
        case "StringCondition":
            return Optional.ofNullable(clazz.cast(stringCondition()));
        case "QueueTypeCondition":
            return Optional.ofNullable(clazz.cast(queueTypeConditionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrConditions", OR_CONDITIONS_FIELD);
        map.put("AndConditions", AND_CONDITIONS_FIELD);
        map.put("StringCondition", STRING_CONDITION_FIELD);
        map.put("QueueTypeCondition", QUEUE_TYPE_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueueSearchCriteria, T> g) {
        return obj -> g.apply((QueueSearchCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueueSearchCriteria> {
        /**
         * <p>
         * A list of conditions which would be applied together with an OR condition.
         * </p>
         * 
         * @param orConditions
         *        A list of conditions which would be applied together with an OR condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orConditions(Collection<QueueSearchCriteria> orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an OR condition.
         * </p>
         * 
         * @param orConditions
         *        A list of conditions which would be applied together with an OR condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orConditions(QueueSearchCriteria... orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an OR condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.QueueSearchCriteria.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.QueueSearchCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.QueueSearchCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #orConditions(List<QueueSearchCriteria>)}.
         * 
         * @param orConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.QueueSearchCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orConditions(java.util.Collection<QueueSearchCriteria>)
         */
        Builder orConditions(Consumer<Builder>... orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an AND condition.
         * </p>
         * 
         * @param andConditions
         *        A list of conditions which would be applied together with an AND condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andConditions(Collection<QueueSearchCriteria> andConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an AND condition.
         * </p>
         * 
         * @param andConditions
         *        A list of conditions which would be applied together with an AND condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andConditions(QueueSearchCriteria... andConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an AND condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.QueueSearchCriteria.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.QueueSearchCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.QueueSearchCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #andConditions(List<QueueSearchCriteria>)}.
         * 
         * @param andConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.QueueSearchCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #andConditions(java.util.Collection<QueueSearchCriteria>)
         */
        Builder andConditions(Consumer<Builder>... andConditions);

        /**
         * <p>
         * A leaf node condition which can be used to specify a string condition.
         * </p>
         * <note>
         * <p>
         * The currently supported values for <code>FieldName</code> are <code>name</code>, <code>description</code>,
         * and <code>resourceID</code>.
         * </p>
         * </note>
         * 
         * @param stringCondition
         *        A leaf node condition which can be used to specify a string condition.</p> <note>
         *        <p>
         *        The currently supported values for <code>FieldName</code> are <code>name</code>,
         *        <code>description</code>, and <code>resourceID</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringCondition(StringCondition stringCondition);

        /**
         * <p>
         * A leaf node condition which can be used to specify a string condition.
         * </p>
         * <note>
         * <p>
         * The currently supported values for <code>FieldName</code> are <code>name</code>, <code>description</code>,
         * and <code>resourceID</code>.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link StringCondition.Builder} avoiding
         * the need to create one manually via {@link StringCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #stringCondition(StringCondition)}.
         * 
         * @param stringCondition
         *        a consumer that will call methods on {@link StringCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringCondition(StringCondition)
         */
        default Builder stringCondition(Consumer<StringCondition.Builder> stringCondition) {
            return stringCondition(StringCondition.builder().applyMutation(stringCondition).build());
        }

        /**
         * <p>
         * The type of queue.
         * </p>
         * 
         * @param queueTypeCondition
         *        The type of queue.
         * @see SearchableQueueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchableQueueType
         */
        Builder queueTypeCondition(String queueTypeCondition);

        /**
         * <p>
         * The type of queue.
         * </p>
         * 
         * @param queueTypeCondition
         *        The type of queue.
         * @see SearchableQueueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchableQueueType
         */
        Builder queueTypeCondition(SearchableQueueType queueTypeCondition);
    }

    static final class BuilderImpl implements Builder {
        private List<QueueSearchCriteria> orConditions = DefaultSdkAutoConstructList.getInstance();

        private List<QueueSearchCriteria> andConditions = DefaultSdkAutoConstructList.getInstance();

        private StringCondition stringCondition;

        private String queueTypeCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueSearchCriteria model) {
            orConditions(model.orConditions);
            andConditions(model.andConditions);
            stringCondition(model.stringCondition);
            queueTypeCondition(model.queueTypeCondition);
        }

        public final List<Builder> getOrConditions() {
            List<Builder> result = QueueSearchConditionListCopier.copyToBuilder(this.orConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrConditions(Collection<BuilderImpl> orConditions) {
            this.orConditions = QueueSearchConditionListCopier.copyFromBuilder(orConditions);
        }

        @Override
        public final Builder orConditions(Collection<QueueSearchCriteria> orConditions) {
            this.orConditions = QueueSearchConditionListCopier.copy(orConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(QueueSearchCriteria... orConditions) {
            orConditions(Arrays.asList(orConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(Consumer<Builder>... orConditions) {
            orConditions(Stream.of(orConditions).map(c -> QueueSearchCriteria.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getAndConditions() {
            List<Builder> result = QueueSearchConditionListCopier.copyToBuilder(this.andConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndConditions(Collection<BuilderImpl> andConditions) {
            this.andConditions = QueueSearchConditionListCopier.copyFromBuilder(andConditions);
        }

        @Override
        public final Builder andConditions(Collection<QueueSearchCriteria> andConditions) {
            this.andConditions = QueueSearchConditionListCopier.copy(andConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(QueueSearchCriteria... andConditions) {
            andConditions(Arrays.asList(andConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(Consumer<Builder>... andConditions) {
            andConditions(Stream.of(andConditions).map(c -> QueueSearchCriteria.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final StringCondition.Builder getStringCondition() {
            return stringCondition != null ? stringCondition.toBuilder() : null;
        }

        public final void setStringCondition(StringCondition.BuilderImpl stringCondition) {
            this.stringCondition = stringCondition != null ? stringCondition.build() : null;
        }

        @Override
        public final Builder stringCondition(StringCondition stringCondition) {
            this.stringCondition = stringCondition;
            return this;
        }

        public final String getQueueTypeCondition() {
            return queueTypeCondition;
        }

        public final void setQueueTypeCondition(String queueTypeCondition) {
            this.queueTypeCondition = queueTypeCondition;
        }

        @Override
        public final Builder queueTypeCondition(String queueTypeCondition) {
            this.queueTypeCondition = queueTypeCondition;
            return this;
        }

        @Override
        public final Builder queueTypeCondition(SearchableQueueType queueTypeCondition) {
            this.queueTypeCondition(queueTypeCondition == null ? null : queueTypeCondition.toString());
            return this;
        }

        @Override
        public QueueSearchCriteria build() {
            return new QueueSearchCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
