/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Object to define the minimum and maximum proficiency levels.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Range implements SdkPojo, Serializable, ToCopyableBuilder<Range.Builder, Range> {
    private static final SdkField<Float> MIN_PROFICIENCY_LEVEL_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("MinProficiencyLevel").getter(getter(Range::minProficiencyLevel))
            .setter(setter(Builder::minProficiencyLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinProficiencyLevel").build())
            .build();

    private static final SdkField<Float> MAX_PROFICIENCY_LEVEL_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("MaxProficiencyLevel").getter(getter(Range::maxProficiencyLevel))
            .setter(setter(Builder::maxProficiencyLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxProficiencyLevel").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_PROFICIENCY_LEVEL_FIELD,
            MAX_PROFICIENCY_LEVEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Float minProficiencyLevel;

    private final Float maxProficiencyLevel;

    private Range(BuilderImpl builder) {
        this.minProficiencyLevel = builder.minProficiencyLevel;
        this.maxProficiencyLevel = builder.maxProficiencyLevel;
    }

    /**
     * <p>
     * The minimum proficiency level of the range.
     * </p>
     * 
     * @return The minimum proficiency level of the range.
     */
    public final Float minProficiencyLevel() {
        return minProficiencyLevel;
    }

    /**
     * <p>
     * The maximum proficiency level of the range.
     * </p>
     * 
     * @return The maximum proficiency level of the range.
     */
    public final Float maxProficiencyLevel() {
        return maxProficiencyLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minProficiencyLevel());
        hashCode = 31 * hashCode + Objects.hashCode(maxProficiencyLevel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range) obj;
        return Objects.equals(minProficiencyLevel(), other.minProficiencyLevel())
                && Objects.equals(maxProficiencyLevel(), other.maxProficiencyLevel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Range").add("MinProficiencyLevel", minProficiencyLevel())
                .add("MaxProficiencyLevel", maxProficiencyLevel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinProficiencyLevel":
            return Optional.ofNullable(clazz.cast(minProficiencyLevel()));
        case "MaxProficiencyLevel":
            return Optional.ofNullable(clazz.cast(maxProficiencyLevel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MinProficiencyLevel", MIN_PROFICIENCY_LEVEL_FIELD);
        map.put("MaxProficiencyLevel", MAX_PROFICIENCY_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Range, T> g) {
        return obj -> g.apply((Range) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Range> {
        /**
         * <p>
         * The minimum proficiency level of the range.
         * </p>
         * 
         * @param minProficiencyLevel
         *        The minimum proficiency level of the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minProficiencyLevel(Float minProficiencyLevel);

        /**
         * <p>
         * The maximum proficiency level of the range.
         * </p>
         * 
         * @param maxProficiencyLevel
         *        The maximum proficiency level of the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxProficiencyLevel(Float maxProficiencyLevel);
    }

    static final class BuilderImpl implements Builder {
        private Float minProficiencyLevel;

        private Float maxProficiencyLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(Range model) {
            minProficiencyLevel(model.minProficiencyLevel);
            maxProficiencyLevel(model.maxProficiencyLevel);
        }

        public final Float getMinProficiencyLevel() {
            return minProficiencyLevel;
        }

        public final void setMinProficiencyLevel(Float minProficiencyLevel) {
            this.minProficiencyLevel = minProficiencyLevel;
        }

        @Override
        public final Builder minProficiencyLevel(Float minProficiencyLevel) {
            this.minProficiencyLevel = minProficiencyLevel;
            return this;
        }

        public final Float getMaxProficiencyLevel() {
            return maxProficiencyLevel;
        }

        public final void setMaxProficiencyLevel(Float maxProficiencyLevel) {
            this.maxProficiencyLevel = maxProficiencyLevel;
        }

        @Override
        public final Builder maxProficiencyLevel(Float maxProficiencyLevel) {
            this.maxProficiencyLevel = maxProficiencyLevel;
            return this;
        }

        @Override
        public Range build() {
            return new Range(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
