/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Segment type describing a contact event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RealTimeContactAnalysisSegmentEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<RealTimeContactAnalysisSegmentEvent.Builder, RealTimeContactAnalysisSegmentEvent> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(RealTimeContactAnalysisSegmentEvent::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantId").getter(getter(RealTimeContactAnalysisSegmentEvent::participantId))
            .setter(setter(Builder::participantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantId").build()).build();

    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantRole").getter(getter(RealTimeContactAnalysisSegmentEvent::participantRoleAsString))
            .setter(setter(Builder::participantRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(RealTimeContactAnalysisSegmentEvent::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventType").getter(getter(RealTimeContactAnalysisSegmentEvent::eventType))
            .setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()).build();

    private static final SdkField<RealTimeContactAnalysisTimeData> TIME_FIELD = SdkField
            .<RealTimeContactAnalysisTimeData> builder(MarshallingType.SDK_POJO).memberName("Time")
            .getter(getter(RealTimeContactAnalysisSegmentEvent::time)).setter(setter(Builder::time))
            .constructor(RealTimeContactAnalysisTimeData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            PARTICIPANT_ID_FIELD, PARTICIPANT_ROLE_FIELD, DISPLAY_NAME_FIELD, EVENT_TYPE_FIELD, TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String participantId;

    private final String participantRole;

    private final String displayName;

    private final String eventType;

    private final RealTimeContactAnalysisTimeData time;

    private RealTimeContactAnalysisSegmentEvent(BuilderImpl builder) {
        this.id = builder.id;
        this.participantId = builder.participantId;
        this.participantRole = builder.participantRole;
        this.displayName = builder.displayName;
        this.eventType = builder.eventType;
        this.time = builder.time;
    }

    /**
     * <p>
     * The identifier of the contact event.
     * </p>
     * 
     * @return The identifier of the contact event.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The identifier of the participant.
     * </p>
     * 
     * @return The identifier of the participant.
     */
    public final String participantId() {
        return participantId;
    }

    /**
     * <p>
     * The role of the participant. For example, is it a customer, agent, or system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link ParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return The role of the participant. For example, is it a customer, agent, or system.
     * @see ParticipantRole
     */
    public final ParticipantRole participantRole() {
        return ParticipantRole.fromValue(participantRole);
    }

    /**
     * <p>
     * The role of the participant. For example, is it a customer, agent, or system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link ParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return The role of the participant. For example, is it a customer, agent, or system.
     * @see ParticipantRole
     */
    public final String participantRoleAsString() {
        return participantRole;
    }

    /**
     * <p>
     * The display name of the participant. Can be redacted.
     * </p>
     * 
     * @return The display name of the participant. Can be redacted.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * Type of the event. For example, <code>application/vnd.amazonaws.connect.event.participant.left</code>.
     * </p>
     * 
     * @return Type of the event. For example, <code>application/vnd.amazonaws.connect.event.participant.left</code>.
     */
    public final String eventType() {
        return eventType;
    }

    /**
     * <p>
     * Field describing the time of the event. It can have different representations of time.
     * </p>
     * 
     * @return Field describing the time of the event. It can have different representations of time.
     */
    public final RealTimeContactAnalysisTimeData time() {
        return time;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(participantId());
        hashCode = 31 * hashCode + Objects.hashCode(participantRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(eventType());
        hashCode = 31 * hashCode + Objects.hashCode(time());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealTimeContactAnalysisSegmentEvent)) {
            return false;
        }
        RealTimeContactAnalysisSegmentEvent other = (RealTimeContactAnalysisSegmentEvent) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(participantId(), other.participantId())
                && Objects.equals(participantRoleAsString(), other.participantRoleAsString())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(eventType(), other.eventType())
                && Objects.equals(time(), other.time());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RealTimeContactAnalysisSegmentEvent").add("Id", id()).add("ParticipantId", participantId())
                .add("ParticipantRole", participantRoleAsString()).add("DisplayName", displayName())
                .add("EventType", eventType()).add("Time", time()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ParticipantId":
            return Optional.ofNullable(clazz.cast(participantId()));
        case "ParticipantRole":
            return Optional.ofNullable(clazz.cast(participantRoleAsString()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "EventType":
            return Optional.ofNullable(clazz.cast(eventType()));
        case "Time":
            return Optional.ofNullable(clazz.cast(time()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("ParticipantId", PARTICIPANT_ID_FIELD);
        map.put("ParticipantRole", PARTICIPANT_ROLE_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("EventType", EVENT_TYPE_FIELD);
        map.put("Time", TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RealTimeContactAnalysisSegmentEvent, T> g) {
        return obj -> g.apply((RealTimeContactAnalysisSegmentEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RealTimeContactAnalysisSegmentEvent> {
        /**
         * <p>
         * The identifier of the contact event.
         * </p>
         * 
         * @param id
         *        The identifier of the contact event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The identifier of the participant.
         * </p>
         * 
         * @param participantId
         *        The identifier of the participant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantId(String participantId);

        /**
         * <p>
         * The role of the participant. For example, is it a customer, agent, or system.
         * </p>
         * 
         * @param participantRole
         *        The role of the participant. For example, is it a customer, agent, or system.
         * @see ParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRole
         */
        Builder participantRole(String participantRole);

        /**
         * <p>
         * The role of the participant. For example, is it a customer, agent, or system.
         * </p>
         * 
         * @param participantRole
         *        The role of the participant. For example, is it a customer, agent, or system.
         * @see ParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRole
         */
        Builder participantRole(ParticipantRole participantRole);

        /**
         * <p>
         * The display name of the participant. Can be redacted.
         * </p>
         * 
         * @param displayName
         *        The display name of the participant. Can be redacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * Type of the event. For example, <code>application/vnd.amazonaws.connect.event.participant.left</code>.
         * </p>
         * 
         * @param eventType
         *        Type of the event. For example, <code>application/vnd.amazonaws.connect.event.participant.left</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * Field describing the time of the event. It can have different representations of time.
         * </p>
         * 
         * @param time
         *        Field describing the time of the event. It can have different representations of time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder time(RealTimeContactAnalysisTimeData time);

        /**
         * <p>
         * Field describing the time of the event. It can have different representations of time.
         * </p>
         * This is a convenience method that creates an instance of the {@link RealTimeContactAnalysisTimeData.Builder}
         * avoiding the need to create one manually via {@link RealTimeContactAnalysisTimeData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RealTimeContactAnalysisTimeData.Builder#build()} is called
         * immediately and its result is passed to {@link #time(RealTimeContactAnalysisTimeData)}.
         * 
         * @param time
         *        a consumer that will call methods on {@link RealTimeContactAnalysisTimeData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #time(RealTimeContactAnalysisTimeData)
         */
        default Builder time(Consumer<RealTimeContactAnalysisTimeData.Builder> time) {
            return time(RealTimeContactAnalysisTimeData.builder().applyMutation(time).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String participantId;

        private String participantRole;

        private String displayName;

        private String eventType;

        private RealTimeContactAnalysisTimeData time;

        private BuilderImpl() {
        }

        private BuilderImpl(RealTimeContactAnalysisSegmentEvent model) {
            id(model.id);
            participantId(model.participantId);
            participantRole(model.participantRole);
            displayName(model.displayName);
            eventType(model.eventType);
            time(model.time);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getParticipantId() {
            return participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getParticipantRole() {
            return participantRole;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        @Override
        public final Builder participantRole(ParticipantRole participantRole) {
            this.participantRole(participantRole == null ? null : participantRole.toString());
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final RealTimeContactAnalysisTimeData.Builder getTime() {
            return time != null ? time.toBuilder() : null;
        }

        public final void setTime(RealTimeContactAnalysisTimeData.BuilderImpl time) {
            this.time = time != null ? time.build() : null;
        }

        @Override
        public final Builder time(RealTimeContactAnalysisTimeData time) {
            this.time = time;
            return this;
        }

        @Override
        public RealTimeContactAnalysisSegmentEvent build() {
            return new RealTimeContactAnalysisSegmentEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
